/*
 * TEXTWIN.H - Text-windowing system header
 * (c)opyright Andrew Scott 1993
 *
 * Turbo C 2.0
 *
 * Author: Andrew Scott (Adrenalin Software)
 *
 * Date: 14/3/1993 ver 0.1
 *       17/4/1993 ver 0.1a
 */

extern void MainWindow(char *title, int n, ...);
/* Post: Screen is set up with a nice title and n menus */

extern void SetMenu(int menu, int n, ...);
/* Post: n commands has been set in menu #menu (0 = 1st) */

extern int Choice();
/*
 * Returns: a function reference number corresponding to a chosen command,
 *   but returns -1 on an error.
 */

extern int ScrollChoice(char *title, char **sp, int w);
/*
 * Returns: The offset of the string from s which is chosen, -1 on none
 *    s points to the start of a list of strings, max length w, NULL term.
 */

extern void ClearWin();
/* Post: Area below command and title bars is clear */

extern void DrawBox(char **sp);
/* Post: The NULL-terminated array of strings pointed to by sp is printed */

extern char InfoBox(char **sp);
/*
 * Returns: The key pressed after the NULL-terminated array of strings
 *    pointed to by sp is printed.
 */

extern char *DialogBox(char **sp, char *def);
/*
 * Returns: The string entered (or def if none entered), after printing
 *    box filled with NULL-terminated strings sp.
 */

extern void EndWindows();
/* Post: Windows are freed up */
