// Block header file (BLOCK.H)
//
// Written 1996, 1997 by Roland Acton - public domain.
//
// This file is part of the Game Music System 1.1 distribution.

// Things relating to the block class.

#ifndef INCLUDED_BLOCK
#define INCLUDED_BLOCK

class block {
public:
  unsigned int highest_line;
  unsigned char *track_pointer[MAX_TRACKS];
  
  block(unsigned int lines);
  ~block();
  static unsigned char *make_blank_track(unsigned int lines,
    unsigned int num_effects = 0);
  unsigned char *swap_track(unsigned char *new_track,
    unsigned int old_track_number);
#ifdef EDITOR_HOOKS
  void change_length(unsigned int new_length);   // Must resync position
                                                 // pointers after this.
  unsigned char *find_note(unsigned int track, unsigned int line);
  unsigned int find_track_bytes(unsigned int track_number);
  static unsigned int find_track_bytes(unsigned char *first_note,
    unsigned int num_lines);
  unsigned char *compress_track(unsigned int track_number);
  static unsigned char *compress_track(unsigned char *first_note,
    unsigned int num_lines);
  void change_num_effects(unsigned int new_num_effects);
  void change_num_tracks(unsigned int new_num_tracks);
/* Position pointers must be resynced after changing the number of effects
   or tracks. */
  gms_function_return_codes add_effect(unsigned int track_number,
    unsigned int line_number, unsigned char effect_byte,
    unsigned char data_byte);
  static gms_function_return_codes add_effect(unsigned char *note,
    unsigned char effect_byte, unsigned char data_byte);
  void remove_effect(unsigned int track_number, unsigned int line_number,
    unsigned int effect_position);
  static void remove_effect(unsigned char *note, unsigned int effect_position);
  static unsigned int determine_num_effects(unsigned char *note);
#endif
};

#endif   // #ifndef INCLUDED_BLOCK
