;  XPC-Mouse:  POSITION CURSOR, COPY and PASTE in Dos Text Mode
;
;  Copyright (c) 1994-1997 by Jrgen G. Weber and Grant B. Gustafson.
;  ALL RIGHTS RESERVED
;  Free for personal use under the Gnu Public License agreement. See the
;  end of this file for a copy of the License Agreement and documentation.
;
PVERSION equ '1.3: 10 Aug 1997'
TRUE equ -1
FALSE equ not TRUE
;
; Compile Time switches that change the final EXE size. Help text
; is not resident, nor is any code after "pastebuf equ $" (see below).
;
;  Paste only:   Set ENABLEPASTE, ENABLEFILEAPPEND TRUE. Comment ENABLECURSOR
;                 Resident size 4.1k (2.1k plus 2k buffer). xpcpaste.exe
;  Cursor only:  Set ENABLECURSOR TRUE. Comment ENABLEPASTE, ENABLEFILEAPPEND
;                 Resident size 1.6k (all code, no buffer). xpcarrow.exe
;  Paste+Cursor: Set ENABLECURSOR, ENABLEPASTE, ENABLEFILEAPPEND TRUE
;                 Resident size 4.9k (2.9k plus 2k buffer). xpcmouse.exe
;
NOWARN PDC
ENABLECURSOR     equ TRUE  ;TRUE to compile with cursor key code
ENABLEPASTE      equ TRUE  ;TRUE to compile with paste key code
ENABLEFILEAPPEND equ TRUE  ;TRUE for file append, windows clipboard

IFNDEF ENABLEPASTE
 ENABLEPASTE equ FALSE
 %OUT  ENABLEPASTE == FALSE. (Paste functions)
ENDIF
IFNDEF ENABLEFILEAPPEND
 ENABLEFILEAPPEND equ FALSE
 %OUT  ENABLEFILEAPPEND == FALSE. (File append, Win clipboard)
ENDIF
IFNDEF ENABLECURSOR
 ENABLECURSOR equ FALSE
 %OUT  ENABLECURSOR == FALSE. (Cursor functions)
ENDIF

;  Append file:  Requires ENABLEFILEAPPEND TRUE and ENABLEPASTE TRUE
;                Append pastebuf to file on receipt of CTRL-LSHIFT-MOUSE2.
IF ENABLEFILEAPPEND and (not ENABLEPASTE)
 %OUT Bad definitions for ENABLEFILEAPPEND and ENABLEPASTE.
 .ERR
ENDIF

;XT equ TRUE             ; TRUE for PC or XT 8086/8088 cpu
XT equ FALSE            ; FALSE for 80188+ cpu and 286 opcodes.
IF XT
 %OUT XT == TRUE. (Assuming PC-XT 8086/8088 cpu)
ELSE
 %OUT XT == FALSE. (Assuming 80286+ cpu)
ENDIF

if ENABLEPASTE
BUFFERLEN EQU 4096      ; Max buffer size for copying text and attributes.
                        ; Enough for a full screen. Blanks are compressed.
                        ; 1024 is enough for 1/2 of screen. Use /Bddd
                        ; option to set runtime buffer size (can be zero).
                        ; Code actually uses "BUFLEN" variable.

BUFLENDEFAULT EQU 2048  ; Default buffer size if /B not used on command line.
                        ; Must be less than or equal to BUFFERLEN
if  BUFFERLEN lt BUFLENDEFAULT
 %OUT  Inequality BUFLENDEFAULT <= BUFFERLEN violated.
 .ERR
endif
else
if ENABLECURSOR
BUFFERLEN EQU 0         ; Max buffer size for copying text and attributes.
BUFLENDEFAULT EQU 0     ; Default buffer size if /B not used on command line.
endif ;ENABLECURSOR
endif ;ENABLEPASTE
;
; Masks for mouse events
;
M_MOVED       EQU 1B       ;bit 0   mouse movement
M_LT_PRESSED  EQU 10B      ;bit 1   left button pressed (button1)
M_LT_RELEASED EQU 100B     ;bit 2   left button released
M_RT_PRESSED  EQU 1000B    ;bit 3   right button pressed (button2)
M_RT_RELEASED EQU 10000B   ;bit 4   right button released
M_MI_PRESSED  EQU 100000B  ;bit 5   middle button pressed (Mouse Systems)
M_MI_RELEASED EQU 1000000B ;bit 6   middle button released (Mouse Systems)
XPCMOUSEMASK  EQU (M_MOVED or M_LT_PRESSED or M_LT_RELEASED or M_RT_PRESSED or M_RT_RELEASED or M_MI_PRESSED or M_MI_RELEASED)

if not XT
 .286  ; the times, they're a-changing ...  memento mori 808[6|8]
endif

locals                  ; makes the local @@Label possible

; Useful macros
;
PUSHR macro regs   ;; eg: PUSHR <bx,ax,cx>
local reg
   irp reg,<regs>
     push reg
   endm
endm

POPR  macro regs   ;; eg: POPR  <cx,ax,bx>
local reg
   irp reg,<regs>
     pop  reg
   endm
endm

 XPUSHA macro
if XT
        PUSHR <AX,BX,CX,DX,BP,SI,DI>
else
        pusha
endif
 endm

 XPOPA macro
if XT
        POPR <DI,SI,BP,DX,CX,BX,AX>
else
        popa
endif
 endm

code segment
assume cs:code

begin_resident equ $    ; All resident code starts here

XPC_pspadr dw 0              ; psp address of installed XPC-mouse
BUFLEN  dw BUFLENDEFAULT     ; Buffer size in bytes, /B command line switch
biosSEG dw 40h               ; Bios variables segment address
flag_reinstall_exec db FALSE ; TRUE to reinstall mouse handler before exec
flag_reinstall_exit db TRUE  ; TRUE to reinstall mouse handler after exit
flag_busy_stuffing db 0      ; TRUE if stuffing keys (see new int 08h)
FlagREINSTALL  equ 00010000B ; Re-install the mouse handler
FlagFILEAPPEND equ 00100000B ; Write paste buffer to TMP file
FlagWINCLIP    equ 01000000B ; Write paste buffer to Win 3.1/95 clipboard
FlagPASTE      equ 00000001B ; Pasting the buffer currently active
FlagCURSOR     equ 00000010B ; Stuffing cursor keys is active
flag_event db 00000000B      ; Data byte for above bit flags
counter_int10 dw 0           ; Incremented at each call of int 10h
flag_Left db FALSE           ; TRUE if left button was pressed.
flag_Right db FALSE          ; TRUE when right button pressed.
flag_MouseOn db FALSE        ; TRUE if mouse cursor is on.
flag_swapbuttons db FALSE    ; TRUE if buttons are swapped by user
button_1fix db 1             ; Shift amt button 1 in NewButtonOrder
button_2fix db 3             ; Shift amt button 2 in NewButtonOrder
button_3fix db 5             ; Shift amt button 3 in NewButtonOrder
lineSize dw 0                ; Characters per line on screen
lasttime dw 0,0              ; System time at last left click
PositionLeft dw 0            ; Position of mouse at left click
NextPositionLeft dw 0        ; Position of mouse at a later left click
EndOfBuffer dw pastebuf+BUFFERLEN-1     ; Address of end of paste buffer

if ENABLEPASTE
lastChar db 0                ; Saved character from failed key-stuff.
flag_Highlight db FALSE      ; TRUE if an area is highlighted on screen.
flag_CtrlRight db FALSE      ; TRUE if last click was ctrl-right
xor_mask db 01010000b        ; XOR mask for selected screen area
videosegment  dw 0           ; Segment of screen memory
videoOffset dw 0             ; Offset into video page
;counter_blanks db 0          ; Counter for blanks yet to be stuffed.
nextpair dw offset pastebuf  ; Pointer to next character pair in paste buffer.
lastpair dw offset pastebuf  ; Pointer to end of text in paste buffer.

flag_pastebuffer db TRUE     ; Pastebuffer initially ON
flag_double  db FALSE        ; TRUE if left button was double-clicked

; Xterm-style char classes for double-click
; Inequality a<=x<=b coded as "db a,b" below.
;
unix_pairs db 9         ; Number of active pairs below
unix_ranges db 35,35    ; # (pound)
            db 45,58    ; -./0123456789:
            db 64,90    ; @ABCDEFGHIJKLMNOPQRSTUVWXYZ
            db 92,92    ; \ (backslash)
            db 95,95    ; _ (underline)
            db 97,122   ; abcdefghijklmnopqrstuvwxyz
            db 126,126  ; ~ (tilde)
            db 128,165  ; European letters
            db 224,238  ; Greek letters and infinity
            db 0,0      ; extra space for more combos
            db 0,0      ; This table can be changed dynamically
            db 0,0      ; on program load or restart (not implemented).
;            db 0,0      ; If you change this, also change
;            db 0,0      ; variable "unix_pairs" above!
MAX_unix_pairs equ  ($-unix_pairs)/2
SPEED_LDC equ 9       ; Double click threshold 9/18.2 seconds

marginleft dw 0         ; Min col used in highlight
marginright dw 0        ; Max col used in highlight
dolimits db TRUE        ;TRUE to do limits, else FALSE

if ENABLEFILEAPPEND
stringf db 0,0                  ;data area for file write
filen   db 'c:\tmp\'
        db 'xpcm####.tmp',0     ;fixed file name for the write
endif ;ENABLEFILEAPPEND
endif ;ENABLEPASTE

if ENABLECURSOR         ;=========Cursor Key code ==========;
flag_arrowkeys   db TRUE     ; Arrowkeys initially ON
flag_editor  db 1            ; 1=emacs/vi/jove/jed, 2=matrix, 3=Xterm,
current_X        dw 0        ; Current mouse X coordinate (transient)
current_Y        dw 0        ; Current mouse Y coordinate (transient)
FlagButton13   equ 00001000B ; Flag for button1+button3 combo
FlagButton3    equ 00000100B ; Flag for button3
FlagButton2    equ 00000010B ; Flag for button2
FlagButton1    equ 00000001B ; Flag for button1
FlagButtonCR   equ 00010000B ; Flag for CR addon but not /A3
FlagButtonsOFF equ 00010000B ; Turn off everything but CR flag
flag_doButtons  db 00000000B ; Set button flags
MAX_of_A equ 3               ; max number of /A options (1,2,3)
SPEED_LC equ 3               ; About 3/18.2 sec left button press required.
col_present  db 0            ; col for text cursor (not mouse cursor!)
row_present  db 0            ; row for text cursor
col_target   db 0            ; col where left button was pressed
row_target   db 0            ; row where left button was pressed
;
; Xterm escapes for buttons 1,2,3 are in format ASCII,SCANCODE
; because they are to be stuffed directly into the keybuffer.
;
; Escape sequence for button 1
Button1_ESC db 1bh, 01h ; ESC
            db '[',1ah  ; [
            db 'M',32h  ; M
            db 20h,39h  ; SPACE
Button1_COL db 00h,00h  ; Column position
            db 00h,00h  ; Row position
Button1_LEN equ 6       ; Number of pairs in sequence
; Escape sequence for button 2
Button2_ESC db 1bh, 01h ; ESC
            db '[',1ah  ; [
            db 'M',32h  ; M
            db 21h,02h  ; SPACE+1
Button2_COL db 00h,00h  ; Column position
            db 00h,00h  ; Row position
Button2_LEN equ 6       ; Number of pairs in sequence
; Escape sequence for button 3
Button3_ESC db 1bh, 01h ; ESC
            db '[',1ah  ; [
            db 'M',32h  ; M
            db 22h,28h  ; SPACE+2
Button3_COL db 00h,00h  ; Column position
            db 00h,00h  ; Row position
Button3_LEN equ 6       ; Number of pairs in sequence
CR_ESC      db 0dh,1ch  ; Carriage return
CR_LEN      equ 1       ; Number of pairs in sequence
;
Xterm_PAD equ ' '+1     ; Offset for Xterm escapes row,col
;
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;

;
; The MOUSE HANDLER is called by the mouse driver
; if an event occurs which matches the CX mask
; that was supplied at the time of installation.
; ENTRY:  The mouse device driver supplies this info:
; AX=Mouse event bits
; BX=button state: bit0=left, bit1=right, bit2=center
; CX=current X pixel coordinate, DX=current Y pixel coordinate
; SI=raw Y mickeys, DI=raw X mickeys
; DS=driver's data segment
;
MouseHandler proc far        ; Handler ends with far ret
      XPUSHA                 ; handler can't modify registers
      push ds                ; can't call DOS or BIOS
;
; Do not let mouse routines happen if interrupt 10h is active
; or is there is no text mode active (eg, graphics modes ==> no mouse)
;
      cmp counter_int10,0    ; Int 10h interrupted?
        jne short @@exit1    ; Yes, then get out of here.

@@not_in10:

if ENABLECURSOR         ;=========Cursor Key code ==========;
      mov current_X,cx       ; Save button X and Y coordinates
      mov current_Y,dx       ; from this call.
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;

      cmp flag_swapbuttons,TRUE ; Swapping button order?
       jnz @@swap_done
      call NewButtonOrder    ; October 1995, swap buttons
@@swap_done:
      push ax
      mov ds,biosSEG         ; Use DS to read bios variables.
      mov al,byte ptr [ds:49h] ; BIOS current video mode
      cmp al,3
        jna short @@test_events
      cmp al,7  ; BIOS current video mode
        jz  short @@test_events
      cmp al,13h ; Other video modes are graphics
        jna short @@exit0
     cmp word ptr [ds:4ch],0800h ; Assume text mode if video memory
        jbe short @@test_events  ; size is 4096k bytes or less.
@@exit0:
      pop ax
      jmp short @@exit1
@@test_events:
      pop ax
;
; TEST button event flags passed to handler in register AX
; In: AX=mouse event bits from device driver
;
@@tst_moved:
      test ax,M_MOVED           ; mouse was moved
        jz short @@tst_released
      jmp @@mouse_moved
@@tst_released:
      test ax,M_LT_RELEASED     ; a button was released
        jnz short @@left_released
@@tst_right:
      test ax,M_RT_PRESSED      ; button2 (right on 2-button mouse)
        jnz short @@test_button2_shifts
@@tst_left:
      test ax,M_LT_PRESSED      ; button1 (left button)
        jz short @@tst_button3
        jmp  @@test_button1_shifts
@@tst_button3:

if ENABLECURSOR         ;=========Cursor Key code ==========;
      test ax,M_MI_PRESSED      ; button3 (middle on mouse systems)
        jz short @@tst_exit
        jmp @@exit_button3
@@tst_exit:
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;

@@exit1:
      jmp @@exit
;
; END of TEST button events using ax. Below we can use ax.
;

; ======================================================================
; Target of initial look at release of button 1
; ======================================================================
@@left_released:
      cmp flag_Left,FALSE        ; If left not pressed, then hide mouse.
        je short @@skip_cursor
if ENABLEPASTE
      cmp flag_double,TRUE
       je @@copy_region1
      mov ax,NextPositionLeft
      cmp ax,PositionLeft
        jz  short @@no_selection ; nothing at all marked
@@copy_region1:
      mov flag_double,FALSE      ; Otherwise, copy screen text to
      mov flag_Highlight,TRUE    ; the pastebuffer.
      mov flag_Left,FALSE
      call Fill_pastebuffer      ; Returns carry if chars to paste
       jnc short @@skip_cursor   ;  Got chars, then hide mouse.
@@copy_region2:
if ENABLECURSOR         ;=========Cursor Key code ==========;
      or flag_doButtons,FlagButton13  ; Send button1+button3 info
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;
      jmp short @@skip_cursor
endif ;ENABLEPASTE

@@no_selection:

if ENABLECURSOR         ;=========Cursor Key code ==========;
; Mouse was released at same location. Test if enough time has
; elapsed to call it a cursor positioning click. If so, then
; set the cursor.
      call ClickTimeCursor      ; Calls set_cursor
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;

@@skip_cursor:
      mov flag_Left,FALSE
      call HIDE_MOUSE        ; Two cursors are confusing, turn it off
@@exit2:
      jmp short @@exit1

; ======================================================================
; Target of initial look at press of button 2
; ======================================================================
@@test_button2_shifts:
      mov al,byte ptr ds:[17h]
      and al,00001111B
        jnz short @@rt_shifts
      cmp flag_Left,TRUE
        jz short @@exit2     ; both buttons simultaneously pressed
if ENABLECURSOR
      or flag_doButtons,FlagButton2   ; Send button2 info later on
endif ;ENABLECURSOR
@@test_paste:
if ENABLEPASTE
; Mouse-2 ................ Paste Text
; CTRL-Mouse 2 ........... Paste text + ENTER
      test flag_event,FlagPASTE   ; Paste in progress?
       jnz short @@test_paste_exit ; Yes, then quit
      mov flag_Right,TRUE       ;Mark Mouse2 pressed
      mov nextpair,offset pastebuf
      or flag_event,FlagPASTE   ; Signal to process paste
@@test_paste_exit:
endif ;ENABLEPASTE
      jmp short @@exit2
@@rt_shifts:                    ; Get here by shift/alt/ctrl keys
if ENABLEPASTE
      cmp al,00000100B          ;Bit 2 is CTRL
        jne short @@test_ctrl_exit
      mov  flag_CtrlRight,TRUE  ; Means: Add CR to end of paste output
      jmp short @@test_paste
@@test_ctrl_exit:
; RSHIFT-Mouse 2 ......... Paste feature on/off
; LSHIFT-CTRL-Mouse 2 .... Append text to TMP file
      cmp al,00000001B                  ;Right Shift?
        jne short @@endtest_Rshift
        not flag_pastebuffer            ; Flip bits
        jmp short @@exit2
@@endtest_Rshift:
if ENABLEFILEAPPEND
      cmp al,00000110B                  ;Ctrl Left Shift?
        jne short @@endtest_LshiftCtrl
        or flag_event,FlagFILEAPPEND
@@endtest_LshiftCtrl:
      cmp al,00001010B                  ; Alt Left Shift?
        jne short @@endtest_LshiftAlt
        or flag_event,FlagWINCLIP       ; Request write to clipboard
@@endtest_LshiftAlt:
endif ;ENABLEFILEAPPEND
endif ;ENABLEPASTE

if ENABLECURSOR         ;=========Cursor Key code ==========;
; Mouse 3 ................ Carriage return (except /A3)
; ALT-Mouse 2 ............ Mouse 3 duplicate
;
; If ALT-button2, then simulate button 3 on 3-button mouse
      cmp al,00001000B          ; Is ALT depressed?
       jne short @@exit3
@@exit_button3:
      or flag_doButtons,FlagButton3+FlagButtonCR  ; Send button3 info
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;
      jmp short @@exit3

; ======================================================================
; Target of initial look at mouse movement
; ======================================================================
@@mouse_moved:
      call SHOW_MOUSE           ; switch on cursor after first movement
if ENABLEPASTE
      test ax,M_LT_RELEASED     ; a button was released
        jz short @@noleftrelease
        jmp @@left_released
@@noleftrelease:
      cmp flag_Left,FALSE
        je short @@mouse_moved_exit ; highlight if left button still pressed
      call highlight_text       ; In: cx,dx = mouse X,Y
@@mouse_moved_exit:
endif ;ENABLEPASTE              ; Updates NextPositionLeft.
@@exit3:
      jmp @@exit
;
; ======================================================================
; Target of initial look at press of button 1
; ======================================================================
@@test_button1_shifts:          ; Test keyboard flag byte

if ENABLECURSOR         ;=========Cursor Key code ==========;
; Mouse 1 ... ............ Position cursor (hold 1/6 sec)
; LSHIFT-Mouse 1 ......... Cursor feature on/off
; LSHIFT-ALT-Mouse 1 ..... Toggle methods /A1-/A3
      mov al,byte ptr [ds:17h]
      and al,00001111B          ; Test alt, ctrl, Lshift, Rshift
        jz @@test_button1_exit  ; no modifiers were pressed
      cmp al,00001010B          ; ALT, LSHIFT
        je short @@do_cursormethod
      cmp al,00000010B
        jne short @@leftshift_exit
        not flag_arrowkeys      ; Toggle the flag on/off (-1 or 0)
      jmp  short @@leftshift_exit
@@do_cursormethod:
      mov al,flag_editor
      cmp al,MAX_of_A           ; Toggle the cursor positioning method
        jb short @@do_cursormethod_exit
        xor al,al               ; Flag will be 1,2,..,(MAX_of_A)
@@do_cursormethod_exit:
      inc al
      mov flag_editor,al
@@leftshift_exit:
      jmp short @@exit           ; finished
@@test_button1_exit:
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;

; ======================================================================
; Target of button 1 press without key modifiers
; ======================================================================
@@left_pressed:                 ; get screen data after left click
      mov ax,[ds:4ah]
      mov lineSize,ax           ; Characters per row for this video mode
if ENABLEPASTE
      mov ax,word ptr ds:[4eh]
      mov videoOffset,ax        ; Offset for current video page
      cmp word ptr ds:[63h],3B4h          ; Mono/Color BIOS word
      mov videosegment,0b000h ; mono address
        jz short @@left_pressed1
      mov videosegment,0b800h ; color address
@@left_pressed1:
endif ;ENABLEPASTE
      mov flag_Left,TRUE        ; Mark Mouse1 pressed
if ENABLECURSOR
      or flag_doButtons,FlagButton1
endif ;ENABLECURSOR
if ENABLEPASTE
      call unhighlight_text     ; remove previous highlighting
      mov flag_Right,FALSE     ; why remove mark?
;      mov counter_blanks,0
      call xy2offs              ; In: cx,dx   Out: ax
      mov PositionLeft,ax       ; Save mouse position and reset both
      mov NextPositionLeft,ax   ; because selected text was trashed.
      call setLimits            ; In: AX

;
; SPEED_LDC is the number of ticks of the system clock, 18.2 per
; second, in which a left double-click must occur. Shorter times
; are not considered double-click candidates.
      mov flag_double,FALSE  ; Assume not a double-click.
      call ClickTimeDouble   ; Uses: AX
        jz short @@exit      ; Not enough time.
; double click
      mov flag_double,TRUE
      call highlight_word
if ENABLECURSOR
      and flag_doButtons,(not FlagButton1)
endif ;ENABLECURSOR
endif ;ENABLEPASTE
@@exit:
if ENABLECURSOR
      cmp flag_doButtons,0
        jz @@@exit
        or flag_event,FlagCursor
@@@exit:
endif ;ENABLECURSOR
      pop ds
      XPOPA
      ret
MouseHandler endp

SHOW_MOUSE proc
    push ax
    cmp flag_MouseOn,TRUE
     jz  short @@is_on
    mov ax,1                ; Function show mouse
    int 33h
    mov flag_MouseOn,TRUE
@@is_on:
    pop ax
    ret
SHOW_MOUSE endp

HIDE_MOUSE proc
    push ax
    cmp flag_MouseOn,FALSE
     jz short @@no_hide
    mov ax,2
    int 33h
    mov flag_MouseOn,FALSE
@@no_hide:
    pop ax
    ret
HIDE_MOUSE endp

; Entry: AX = button bits from Mouse Device Driver
; Exit:  AX = button bits for swapped button order
;        Uses AX and flags

NewButtonOrder proc
     push cx
     push bx
     mov bl,al          ; bits to fix
     xor bh,bh          ; accumulator
     shl bl,1           ; fix up for BitBuster routine
     mov cl,button_1fix ; shift amount for button 1
     call BitBuster     ; gather the bits
     mov cl,button_2fix ; shift amount for button 2
     call BitBuster     ; gather the bits
     mov cl,button_3fix ; shift amount for button 3
     call BitBuster     ; gather the bits
     and al,10000001B   ; strip relevant bits
     or al,bh           ; insert new bits
     pop bx
     pop cx
     ret
NewButtonOrder endp

; Twiddle bits in the button word to get new order

BitBuster proc
     shr bl,1           ; move over 2 bits
     shr bl,1
     mov ch,bl
     and ch,00000011B   ; get lower two bits
     shl ch,cl          ; shift proper amount
     or bh,ch           ; add to accumulator
     ret
BitBuster endp

; install mouse handler

killed_flg db FALSE

InstallMouseHandler proc far
      XPUSHA
      cmp killed_flg,TRUE    ; /U in the mean time ?
       je short @@exit       ; we are in process of uninstall /U
      push es
       push cs
       pop es
       mov dx,offset MouseHandler
       mov cx,XPCMOUSEMASK
       mov ax,14h             ; Swap Interrupt Subroutines
       int 33h
       and flag_event,(not FlagREINSTALL)
      pop es
@@exit:
      XPOPA
      ret
InstallMouseHandler endp

; Patch for EXEC Function
; Fixed by GBG October 1995. See notes at top of file.
; Fixed again 2 Feb 1997 GBG.
new_21h proc far
      pushf
      cmp flag_reinstall_exit,FALSE
       je short @@test_exec     ; don't install mouse handler after exit
      cmp ah,4ch                ; Exit program
       je short @@reinstall
      cmp ah,00h                ; Exit program
       je short @@reinstall
@@test_exec:
      cmp flag_reinstall_exec,FALSE
       je short @@do_old_21h    ; don't install mouse handler before exec

@@test_exec_x:
      cmp ax,4b00h              ; exec program
       jne short @@do_old_21h   ; nothing special
@@reinstall:
      or flag_event,FlagREINSTALL

@@do_old_21h:
      popf
      db 0eah                ; Code for jmp far
old_21h dw 0,0
new_21h endp

; Patch for Interrupt 10h

old_10h dw 0,0

new_10h proc far
      pushf                     ; simulate int
      call dword ptr cs:[old_10h]
      pushf
      cmp counter_int10,0
       jne @@exit
      inc counter_int10         ; Mark int 10h active
      call HIDE_MOUSE           ; Video use hides the mouse
if ENABLEPASTE
      cmp flag_Highlight,FALSE
        je short @@no_unselect
      call unhighlight_text     ; Uses no registers
;      mov flag_Left,FALSE      ; why unmark a left press?
@@no_unselect:
endif ;ENABLEPASTE
      dec counter_int10         ; Mark int 10h inactive
@@exit:
      popf
      iret
new_10h endp

; BIOD data segment equates
;
biosdata segment at 40h
org 1ah
headptr dw (?)  ; pointer to next key entry to read
tailptr dw (?)  ; pointer to last read key entry
org 80h
bufstrt dw (?)  ; pointer to start keyboard buffer
bufend  dw (?)  ; pointer to end keyboard buffer
biosdata ends

stuffkeyCX proc
; substitute for Int 16h, function 5
; in:  ch=scan code
;      cl=ascii
; out: al=0 success
;      al=1 buffer full
; USES: ax,cx
;
   push ds
   push bx
    cli
    mov ax,biosdata
    mov ds,ax
    mov ax,ds:tailptr
    inc ax
    inc ax            ; ax += 2
    xor bl,bl
    inc bl            ; bl == 1
    cmp ax,ds:headptr ; don't want tailptr == headptr after exit
    jz  short @@full  ; because it means buffer is empty!
    cmp ax,ds:bufend  ; Ringbuffer, may need to bump pointer
    jnz short @@no_wrap
    mov ax,ds:bufstrt ; wrap around was required
@@no_wrap:            ; AX == new tailptr position
    cmp ax,ds:headptr ; don't want tailptr == headptr after exit
    jz  short @@full  ; because it means buffer is empty!
@@go_ahead:
    mov bx,ds:tailptr ; old tailpointer
    mov [ds:bx],cx    ; store scan+ascii
    mov ds:tailptr,ax
    xor bl,bl
@@full:
    mov al,bl
   pop bx
   pop ds
   or  al,al              ; 0 == save was successful
   ret                    ; sti not appropriate here
stuffkeyCX endp

count_08h db 0
count_waitkey db 0
;
; Patch for int 08h basic timer interrupt
; Logic: Calls old 08h, including user timer 1c, then does
;        duties related to xpcmouse.
; Needs a rewrite with bit operations so that the overhead is lower.
; Example: all bits in one byte, test for bits with 1 instruction, not 10.
;
new_08h proc far
      pushf
      call dword ptr cs:[old_08h]
      pushf
      cmp count_08h,0
       jne @@exit1
      inc count_08h
      cmp counter_int10,0       ; Get out now if int 10h active
       jne @@exit1
      push ax
      cmp flag_event,0
       jz @@getshiftstatus
       call HouseKeeping        ;Uses AX
@@getshiftstatus:
      push ds
       mov ds,biosSEG
       mov al,byte ptr ds:[17h]
      pop ds
      test al,00000001B         ;Right shift depressed?
      jz   @@keyloop_exit
      mov ah,00001111B
      and ah,al
      cmp ah,00000111B          ;Right shift, Left shift and ctrl?
      jne @@wait_exit
      inc count_waitkey
      cmp count_waitkey,20
       jb @@keyloop_exit
       or flag_event,FlagREINSTALL
@@wait_exit:
      mov count_waitkey,0
@@keyloop_exit:
      pop ax

@@exit:
      dec count_08h
@@exit1:
      popf
      iret
old_08h dw 0,0
new_08h endp

HouseKeeping proc near
; Efficiency measure for the int 08h code, caller of HouseKeeping.
;  Ring the bell when we hit this routine to measure frequency.
;   push ax
;        mov ax,0E07h
;        int 10h
;   pop ax
      mov al,flag_event
      test al,FlagPASTE+FlagCURSOR
       jz @@stuff2key_exit
       call stuff2keybuffer
       ret
@@stuff2key_exit:
      test al,FlagREINSTALL   ; Is he dead, Jim?
       jz @@install_exit
       call InstallMouseHandler ; Blood transfusion.
       ret
@@install_exit:
if ENABLEFILEAPPEND
      test al,FlagFILEAPPEND ; Write the pastebuffer to a file?
       jz @@fileappend_exit
       call appendPaste2File     ; May not work because the disk is busy
       ret
@@fileappend_exit:
      test al,FlagWINCLIP       ; Write pastebuffer to win clipboard
       jz @@winclip_exit
       call appendPaste2Windows  ; Write to windows clipboard
@@winclip_exit:
endif ;ENABLEFILEAPPEND
      ret
HouseKeeping endp

; Patch for int 16h
MOUSE_FN      equ 8080h ; new function of int 16h that detects
                        ; previous installation of the program
MOUSE_FNDEC   equ 7f80h ; Second detector
IDENTCODE     equ 16879 ; A 16-bit number used to test validity of /U
                        ; and /R options.

new_16h         proc    far
      cmp  ax,MOUSE_FN       ; New function for int 16h
        jnz  short @@skip1
      dec  ah                ; AH unchanged by normal bios call
      mov  cx,IDENTCODE      ; Return identity code
      push cs                ; and far address of the pastebuffer
      pop  es                ; es:bx := buffer address
      mov  bx,offset pastebuf
      iret
@@skip1:
      pushf
      call stuff2keybuffer
      popf
      db 0eah                ; Code for jmp far
old_16h dw 0,0
new_16h endp

;
; stuff2keybuffer --- Write characters into keyboard buffer
;
stuff2keybuffer proc               ; stuff to keyboard buffer
      cmp flag_busy_stuffing,1  ; In routine "stuff2keybuffer"?
        je @@exitfast           ; wait until next timer tick
      mov flag_busy_stuffing,1  ; Don't let the timer interrupt
                                ; re-enter this routine!
      XPUSHA

if ENABLEPASTE
      xor cx,cx
      xchg cl,lastChar       ; character left from last attempt
      or cl,cl               ; 0 == nothing left
        jnz short @@after_rd ; save character from last trial
@@loop:
      call GetPastebuffer2AL ; Nothing returned if flag_pastebuffer == 0
      mov cl,al              ; else AL == char found in pastebuffer
        jc short @@@exit     ; nothing to stuff into keybuffer
@@after_rd:
      push cx
      xor ch,ch              ; default scancode 0; ENTER is trouble
      cmp cl,13              ; cl==13 is end of line
       jne @@scan_code       ; Potential trouble: wrong scan codes!
      mov ch,1ch             ; scancode for ENTER
@@scan_code:
      call stuffkeyCX        ; stuff CX to keyboard buffer, uses ax,cx
      pop cx
        jz  short @@loop     ; 0 == save was successful
      mov lastChar,cl        ; save for next time
      jmp short @@exit

@@@exit:                     ; Get here because pasting is finished.
      mov lastChar,0
      and flag_event,(not FlagPASTE)  ; Mask off event, Paste Done!
endif ;ENABLEPASTE

if ENABLECURSOR         ;=========Cursor Key code ==========;
      call StuffArrows       ; Stuff arrow keys and Xterm sequences
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;

@@exit:
      XPOPA
      mov flag_busy_stuffing,0  ; Let the timer interrupt
@@exitfast:                     ; re-enter this routine!
      ret
stuff2keybuffer endp


if ENABLEPASTE
; calculate video offset from x and y
; The x and y are in pixel counts, not Mickeys.
;     (the Mouse unit is named after Mickey Mouse).
; In:  x=cx, y=dx ; Left upper corner of screen is x=0, y=0.
;      These values of x,y are Bios cursor locations.
;      We must convert to screen coordinates. In 40-col mode,
;      there are 16 pixels per char. In 80-col mode, 8 pixels per
;      char. In 132-col mode there are 4 pixels per char, but no mouse
;      device drivers are known to operate in 132 cols: they only know
;      about 40-col and 80-col bios modes 0 to 13h.
; Out: ax := offs = (y*lineSize)/8 + (x/8 or x/16)
; USES: ax
xy2offs proc
      PUSHR <dx,cx>
      shr cx,1
      shr cx,1
      shr cx,1
      cmp lineSize,40
      jnz short @@no_40
      shr cx,1         ; divide by 16 if there are 40 columns per line
    @@no_40:
      shr dx,1
      shr dx,1
      shr dx,1
      mov ax,dx
      mul lineSize
      add ax,cx        ; +=x
      add ax,ax        ; 2 bytes per character
      add ax,videoOffset
;      inc ax           ; -> attribute
      POPR <cx,dx>
      ret
xy2offs endp

; show or hide mark on screen
; In: AX=characters*2 for XOR operation
; USES: AX
xor_screen proc
      PUSHR <bx,cx,dx,ds>
      call HIDE_MOUSE        ; in order not to destroy the mouse cursor
      mov ds,videosegment
      mov dolimits,TRUE
      mov cx,PositionLeft
      mov bx,NextPositionLeft
      cmp cx,bx
      je @@exit
      jb @@doswap
        mov ax,cx
        call findColumn
        cmp dx,marginleft
        je short @@dolimits
        jmp short @@normal     ; Matrix box highlighting
@@doswap:
        xchg cx,bx             ; switch 'em
@@dolimits:
        mov ax,lineSize        ; Set for Xterm highlighting
        dec ax
        add ax,ax
        mov marginright,ax
        mov marginleft,0
        mov dolimits,FALSE
@@normal:
      mov dl,xor_mask
@@loop:
        mov ax,bx
        inc bx
        call column_test
         jnz @@failed
        xor byte ptr [ds:bx],dl ; xor_mask applied to attribute byte
@@failed:
      inc bx
      cmp bx,cx
      jbe short @@loop
@@exit:
;      call SHOW_MOUSE
      POPR <ds,dx,cx,bx>     ;PUSHR <bx,cx,dx,ds>
    ret
xor_screen endp

; Check for pointer inside column boundaries
; In: AX == screen offest
; Out: NZ if outside, Carry set if hit right margin
; Uses: AX, FLAGS
column_test proc near
        push ax
        push dx
         call findColumn        ;In: ax, Out: dx=col
        cmp marginleft,dx
          ja @@failed
        cmp dx,marginright
          ja @@failed
          je @@failedright
        xor ax,ax               ; set Z flag and no Carry
@@exit:
        pop dx
        pop ax
         ret
@@failedright:
        xor ax,ax               ; Z set
        stc                     ; Carry set
        jmp short @@exit
@@failed:
        xor ax,ax
        inc ax                  ; No carry, NZ set
        jmp short @@exit
column_test endp

; In: ax==screen offset
; Out: dx==column
; Uses: dx
findColumn proc near
         push ax
         push cx
          xor dx,dx
          mov cx,lineSize
          add cx,cx
          div cx                ; quotient ==> AX, Remainder ==> DX
         pop cx
         pop ax
         ret
findColumn endp

; Determine matrix boundaries with max/min method
; In: Nothing
; Out: marginright, marginleft reset
setLimits proc near
      cmp dolimits,FALSE
        je @@quit
      push dx
      push cx
      push ax

      mov ax,NextPositionLeft
      call findColumn
      mov cx,dx                 ;cx == current corner column

      mov ax,PositionLeft
      call findColumn           ;dx == first corner column

      cmp dx,cx                 ;Is dx < cx?
       jb @@next
      xchg cx,dx                ;switch 'em
@@next:
       mov marginleft,dx
       mov marginright,cx
       pop ax
       pop cx
       pop dx
@@quit:
       ret
setLimits endp

; Highlight single word chosen by double click
; USES: AX
highlight_word proc
      PUSHR <bx,ds>
      xor bx,bx
      mov lasttime,bx
      mov lasttime+2,bx        ; prevent Triple click
      mov ds,videosegment
      mov bx,PositionLeft      ; point to letter
      call @@tst_letter
      jc @@exit                ; clicked to void
  @@go_left:                   ; search for word begin
      call @@tst_letter
      dec bx
      dec bx
      jnc  @@go_left
      add bx,4                 ; points to letter again
      mov  PositionLeft,bx
  @@go_right:                  ; search for word end
      inc bx
      inc bx
      call @@tst_letter
      jnc @@go_right
      dec bx
      dec bx
      mov NextPositionLeft,bx
      call setLimits
      call xor_screen          ; Uses ax
  @@exit:
      POPR <ds,bx>
      ret

; @@tst_letter --- Test character classes.
; Do this like Xterm, with a string of data pairs:
; 35:35,45:57,64:90,95:95,97:122,128:165
; USES: AX
;
  @@tst_letter:
      push si
      mov si,offset unix_ranges
      xor ah,ah
      mov al,[ds:bx]
  @@tst_loop:
      cmp ah,unix_pairs
      je @@tst_failed
      inc ah
      cmp byte ptr [cs:si],al
      jbe short @@tst_1
      inc si
      inc si
      jmp short @@tst_loop
  @@tst_1:
      inc si
      cmp al,byte ptr [cs:si]
      jbe short @@tst_worked
      inc si
      jmp short @@tst_loop
  @@tst_worked:
      clc
      jmp short @@tst_exit
  @@tst_failed:
      stc
  @@tst_exit:
      pop si
      ret
highlight_word endp
;
; Highlight screen area that was traversed during mouse motion.
; In: cx,dx = mouse X,Y
; USES: AX
highlight_text proc
      push bx
      call xy2offs            ; In: cx,dx   Out: ax
      push ax                 ; New left mouse position
      sub ax,NextPositionLeft ; ax/2 == number of positions traversed
      pop bx
      jz short @@exit         ; too little mouse motion
      call unhighlight_text   ; Turn off highlighting
      mov NextPositionLeft,bx ; update new mouse position
      call setLimits          ; Find matrix width
      call xor_screen         ; In: AX=number positions times 2
      mov flag_Highlight,TRUE
    @@exit:
      pop bx
      ret
highlight_text endp

; Remove highlight from screen area.
; Uses: none
unhighlight_text proc
    push ax
      cmp flag_Highlight,FALSE
        je short @@exit     ; Highlighting was already undone.
      call xor_screen        ; Unhighlight. Uses: AX
      mov flag_Highlight,FALSE
   @@exit:
   pop ax
   ret
unhighlight_text endp

;
; Fill_pastebuffer: Read the selected characters into pastebuffer.
; Called after double click or left selection.
; Return: Carry not set if pasting and PositionLeft==NextPositionLeft
Fill_pastebuffer proc
;      PUSHR <bx,cx,dx,si,di,es,ds>
      XPUSHA
      PUSHR <es,ds>
      cmp flag_pastebuffer,FALSE ; Are we supposed to paste?
        stc
        je short @@quit          ; No, then exit with carry set
      push cs                   ; Yes, then fool with pastebuffer
      pop es                    ; store chars to es:di
      mov bx,PositionLeft
      mov cx,NextPositionLeft
      cmp cx,bx
        ja  short @@set_loop ; not marked from right to left
      xchg bx,cx             ; now from left to right
        jnz  short @@set_loop ; nothing at all marked
@@exit_nochars:              ; Nothing marked
      clc
      jmp short @@@exit

@@set_loop:
      mov di,offset pastebuf ; Start at top of paste buffer
      mov nextpair,di        ; di == offset into buffer
      cld
      mov ds,videosegment
      dec bx
      dec bx                 ; back up to get started
      xor dl,dl              ; initialize end of line markers
@@loop:
      cmp di,EndOfBuffer
        ja short @@OutofRoom  ; Buffer is full
      or dl,dl
        jnz short @@trim
      cmp bx,cx
        jz short @@OutofData
      inc bx
      inc bx                 ; next char on screen
       mov ax,bx
      call column_test ;NZ if outside, Carry set if hit right margin
        jc short @@fixEOL       ; Hit the right edge
        jnz short @@loop        ; Outside margins
@@regularData:
      mov al,[ds:bx]
      cmp al,' '                ; Skip unprintable characters
        jb short @@loop
@@SaveCodedByte:
      stosb                     ; Otherwise, store coded byte
      jmp short @@loop
@@fixEOL:
      inc dl                    ; Mark the problem
      jmp short @@regularData   ; Stuff the character
@@trim:                         ; discard blanks until end of line
      call @@trimFunction
      jmp short @@SaveCodedByte

@@OutofRoom:
@@OutofData:
      mov lastpair,di        ; pointer to end of used buffer area
      dec di
      cmp byte ptr [es:di],10   ; End with LF?
       jne short @@quit
      dec di
      mov lastpair,di        ; pointer to end of used buffer area
@@quit:
      stc                    ; Carry set if something in buffer

@@@exit:
      POPR <ds,es>                 ; PUSHR <es,ds>
      XPOPA
;      POPR <ds,es,di,si,dx,cx,bx>  ; PUSHR <bx,cx,dx,si,di,es,ds>
      ret
; Trim spaces on end and add CR/LF pair into buffer
@@trimFunction:
      cmp dl,2                  ; Second time?
       jne @@trimLoop
       xor dl,dl                ; Last time here
       mov al,10                ; Insert linefeed
       ret
@@trimLoop:
      dec di
      cmp byte ptr [es:di],' '  ; Expunge unprintables
        ja  short @@trimDone
      cmp byte ptr [es:di],10   ; end of previous line ?
        jne short @@trimLoop
@@trimDone:
      inc di
      mov al,13                 ; 13 to mark end of line
      inc dl                    ; Mark it done
      ret
Fill_pastebuffer endp

; ClickTimeDouble --- Return Z if time since last left click too short.
; Uses: AX
ClickTimeDouble proc
      PUSHR <cx,dx>
      xor ah,ah
      int 1ah                ; read system clock counter
      xor ax,ax              ; Return AX==0 in Z flag
      push cx                ; high word
      push dx                ; low word
      sub  dx,lasttime
      sbb  cx,lasttime+2     ; cx:dx = ticks since last click
      pop  cs:lasttime
      pop  cs:lasttime+2     ; save new clock time
      or cx,cx
        jnz short @@exit     ; Exceeded 65535/18.2 seconds
      cmp dx,SPEED_LDC
        ja short @@exit      ; Exceeded SPEED_LDC seconds
      inc ax                 ; Was a double-click.
@@exit:
     or ax,ax
     POPR <dx,cx>
     ret
ClickTimeDouble endp

; Get characters from the paste buffer
; Characters are 33 to 255
; A character nnn less than 33 represents nnn Blanks
; End of line is marked with 0
;
; In: Nothing
; Out: ZF flag == buffer empty else AL == char found
; Uses: AX, flags, es
;
GetPastebuffer2AL proc
      push es
      cmp flag_pastebuffer,FALSE        ;Pasting enabled? (-1=enabled)
        je short @@buf_empty
      cmp flag_Right,FALSE              ;Buffer defined? (-1=Yes)
        je  short @@buf_empty
      push cs
      pop es
@@loop:
      call GetPasteBuf                  ; Grab char to AL
       jc @@buf_empty                   ; Exit with carry set
      cmp al,10                         ; Purge linefeeds
       je short @@loop
      clc
      jmp short @@exit
@@buf_empty:
      stc
@@exit:
      pop es
      ret
GetPastebuffer2AL endp

; In: es==segment of pastebuffer
; Out: ZF flag == buffer empty else AL == char found
; Uses: AX, flags, es
;
GetPasteBuf proc
      push bx
      mov bx,nextpair
      cmp bx,lastpair
        jnz short @@not_empty
      cmp flag_CtrlRight,TRUE     ; append CR, too ?
        jne short @@buf_empty
      mov flag_CtrlRight,FALSE    ; Mark that we did it.
      mov al,13                   ; return CR
      jmp short @@char_found

@@not_empty:
      mov al,[es:bx]              ; get next character
      inc nextpair
@@char_found:
      clc
@@exit:
      pop bx
      ret
@@buf_empty:
      stc
      jmp short @@exit
GetPasteBuf endp

if ENABLEFILEAPPEND
; These routines append active paste buffer to a file.
; by GBG February 1997

; Entry: fileappend==file name
; Exit:  paste buffer appended to file.
; Uses: ax
appendPaste2File proc
      PUSHR <bx,cx,dx,ds,es>
      cmp cs:counter_int13,0
       jnz @@done               ;disk busy, don't try it
      mov ax,cs
      mov ds,ax
      mov es,ax
      mov nextpair,offset pastebuf
      mov flag_CtrlRight,FALSE          ; Don't append CR
;      mov counter_blanks,0
; Open the file
        mov     ax,3d02h                ;open file read and write
        mov     dx,offset filen         ;file name 0 terminated
        int     21h
        jnc     @@goodopen
        xor     cx,cx                   ;file attributes zero
        mov     ah,03ch                 ;create file
        int     21h
        jnc     @@goodopen              ;carry flag means bad open
@@bad_open:
          call bell                     ;send terminal bell as a signal
          jmp short @@finished          ;for bad open
@@goodopen:
        mov     bx,ax                   ;bx=filehandle
@@seek:                                 ; Seek to the end of the file
        xor     cx,cx                   ;cx=high word=0
        mov     dx,cx                   ;dx=low word of seek amount=0
        mov     ax,4202h                ;seek end of file, handle==bx
        int     21h
@@loop:
      call GetPasteBuf                  ; AL == char found in pastebuffer
        jc short @@@exit                ; nothing left in pastebuffer
      call @@writeByte
      jmp short @@loop
@@@exit:
      mov al,13
      call @@writeByte
      mov al,10
      call @@writeByte
        mov     ah,3eh
        int     21h                     ;close file, handle==bx
@@finished:
        and flag_event,(not FlagFILEAPPEND)   ;Mark it done. Don't do it again!
@@done:
        POPR <es,ds,dx,cx,bx>              ;PUSHR <bx,cx,dx,ds,es>
        ret
@@writeByte:
        mov     byte ptr cs:stringf,al
        mov     cx,1
        mov     dx,offset stringf       ; String location for write
        mov     ah,40h
        int     21h                     ;write string to file, handle==bx
        ret
appendPaste2File endp

count_winclip db 0
; Entry: Nothing
; Exit:  paste buffer appended to windows clipboard, if it exists
; Uses: ax, flags
appendPaste2Windows proc
;      PUSHR <bx,cx,dx,es,si,di>
      XPUSHA
      push es
      mov     ax,1600h                ;See if Enhanced mode windows
      int     2fh
      or      al,al
      je      @@finished              ; Not enhanced mode, so quit

; Open the file
        mov     di,1
        mov     ax,1700h                ;Check API
        int     2fh
        or      ax,ax                   ;no API
        je      @@exit_error
        mov     ax,1701h                ;Open Windows Clipboard
        int     2fh
        or      ax,ax
        je      @@exit_error
        mov     ax,1702h                ;Clear Windows Clipboard
        int     2fh
        or      ax,ax
        je      @@closeClip             ;Error, exit
        xor     di,di
        push    cs
        pop     es
        mov     bx,offset pastebuf      ;ES:BX ptr to data
        mov     cx,lastpair
        sub     cx,bx                   ; CX == byte count
        mov     ax,1703h                ;Set clipboard data
        xor     si,si                   ;SI,CX = data size
        mov     dx,7                    ;Data format is OEM text
        int     2fh
@@closeClip:
        mov     ax,1708h                ;Close Clipboard
        int     2fh
        or      di,di
         jnz    @@exit_error
@@finished:
        mov     count_winclip,0          ; Reset counter
        and flag_event,(not FlagWINCLIP) ;Mark it done. Don't do it again!
@@done:
        pop es
        XPOPA
;        POPR <di,si,es,dx,cx,bx>        ;PUSHR <bx,cx,dx,es,si,di>
        ret
@@exit_error:
        inc count_winclip
        cmp count_winclip,18
         jb short @@done                ;try again later
        call bell                       ;send terminal bell as a signal
        jmp short @@finished            ;for any error
appendPaste2Windows endp


bell    proc near                       ;Sound the terminal bell
        mov ax,0E07h
        int 10h
        ret
bell    endp


; Patch for Interrupt 13h, disk

old_13h dw 0,0
counter_int13 db 0

new_13h proc far
      inc cs:counter_int13
      pushf                     ; simulate int
      call dword ptr cs:[old_13h]
      pushf
      dec cs:counter_int13
      popf
      ret     2                 ;Preserve flags
new_13h endp

; Has to be hooked into code during init and exit

endif ;ENABLEFILEAPPEND

endif ;ENABLEPASTE

;; ========ENABLECURSOR: Begin cursor handling routines.===========

if ENABLECURSOR         ;=========Cursor Key code ==========;

; ClickTimeCursor --- Return Z if time since last left-click was short.
; Uses: AX
ClickTimeCursor proc
      PUSHR <cx,dx>
      xor ah,ah
      int 1ah                ; read system clock counter
if ENABLEPASTE
      sub  dx,lasttime
      sbb  cx,lasttime+2     ; cx:dx = ticks since last left press
      or cx,cx
        jnz short @@setcursor; Exceeds 65535/18.2 seconds
      cmp dx,SPEED_LC
        jb short @@exit      ; Less than 3/18.2 seconds
endif ;ENABLEPASTE
@@setcursor:
        call set_cursor      ; set text cursor position
@@exit:
     POPR <dx,cx>
     ret
ClickTimeCursor endp

;
; Arrow key routines, does not depend on Xterm standard.
;
LeftArrow proc
      mov cx,4b00h      ;cl=0, ch=4bh Left arrow key
      call stuffkeyCX   ; uses ax,cx
      ret
LeftArrow endp
DownArrow proc
      mov cx,5000h      ;cl=0, ch=50h Down arrow key
      call stuffkeyCX   ; uses ax,cx
      ret
DownArrow endp
UpArrow proc
      mov cx,4800h      ;cl=0, ch=48h Up arrow key
      call stuffkeyCX   ; uses ax,cx
      ret
UpArrow endp
RightArrow proc
      mov cx,4d00h      ;cl=0, ch=4dh Right arrow key
      call stuffkeyCX   ; uses ax,cx
      ret
RightArrow endp
;
; Test keyboard buffer for room to copy scan codes
; In: AL == # scan codes
; Out: NZ flag set if no room exists
; Uses: AX, FLAGS
Check4Room proc
   PUSHR <ds,bx,ax>
    mov bl,al           ; Number of pairs required
    mov ax,biosdata
    mov ds,ax
    mov ax,ds:tailptr
@@loop:
    add ax,2
    cmp ax,ds:bufend  ; Ringbuffer, may need to bump pointer
      jnz short @@no_wrap
    mov ax,ds:bufstrt ; wrap around was required
@@no_wrap:            ; AX == new tailptr position
    cmp ax,ds:headptr ; don't want tailptr == headptr after exit
    jz  short @@full  ; because it means buffer is empty!
@@go_ahead:
    dec bl
    or bl,bl
    jnz short @@loop
@@full:
   or  bl,bl              ; 0 == it worked, NZ == failed
   POPR <ax,bx,ds>
   ret
Check4Room endp
;
; Xterm standard uses the sequence "ESC [ M cb cx cy" where
; cb=32 for press button1, cb=34 for press button3, cb=33 for
; press button2, cb=35 for release (any) button, cx=32+1+col,
; cy=32+1+row where (0,0) is upper left corner of screen
;
; Stuff a string of scan code data into the keyboard buffer
;
; In: bx=offset to string, al=number of pairs
; Uses: ax,bx
;
; The string must fit all at once for this procedure to succeed.
; We test the keyboard buffer to see if there is room to do the copy.
; If not enough room, then the call fails!
;
StuffCodes2keybuffer proc
      push cx
      cmp flag_arrowkeys,FALSE  ; Arrow and Xterm stuffing disabled?
        je short @@exit         ; Yes, then quit fast.
; Test for room to do the copy
      call Check4Room           ; Does the keyboard buffer have room
        jnz short @@exit        ; for AL pairs? NZ flag == NO ROOM, Exit!
@@loop:
      cmp al,0
      je @@exit
      dec al
      mov cl,byte ptr [cs:bx]      ; ASCII value
      inc bx
      mov ch,byte ptr [cs:bx]      ; Scan code
      inc bx
      push ax
      call stuffkeyCX              ; uses ax,cx
      pop ax
      jmp short @@loop
@@exit:
      pop cx
      ret
StuffCodes2keybuffer endp

; Stuff cursor location into data area using Xterm codes
; In: al=Y=row, ah=Y=col, the cursor location in PC terms.
;     bx=offset to data area
; Uses: ax,bx
; Xterm codes are ROW=X+' '+1, COL=Y+' '+1.
; Xterm_PAD==' '+1. Assume fake scan codes.
;
StuffLoc2buffer proc
      add ah,Xterm_PAD          ; coded col for Xterm
      mov byte ptr [cs:bx],ah
      inc bx
      inc bx
      add al,Xterm_PAD          ; coded row for Xterm
      mov byte ptr [cs:bx],al
      ret
StuffLoc2buffer endp

; Stuff left button info into keyboard buffer
; In: al=row, ah=column
; Uses: ax
;
StuffButton1 proc
      push bx
      mov bx,offset Button1_COL ; Offset to data area
      call StuffLoc2buffer      ; Stuff cursor location into buffer
      mov bx,offset Button1_ESC ; Escape sequence for button 1
      mov al,Button1_LEN        ; Number of pairs in button 1 escape.
      call StuffCodes2keybuffer ; Stuff escape seq into key buffer
      pop bx
      ret
StuffButton1 endp

; Simulate press of button 3 on any mouse. Left release is mapped to
; the press of button three which normally follows button one. This button
; ends the marking of a region and maybe it copies it too, depending on the
; client program at the remote host end.
;
StuffButton3 proc
; In: al=row, ah=column
; Uses: ax
; We assume the keyboard buffer empty!
; Simplifies logic, but may fail.
      push bx
      mov bx,offset Button3_COL ; Data area pointer
      call StuffLoc2buffer      ; Stuff cursor location into buffer
      mov bx,offset Button3_ESC ; Escape sequence for button 3
      mov al,Button3_LEN        ; Number of pairs in button 3 escape.
      call StuffCodes2keybuffer ; Stuff escape seq into key buffer
      pop bx
      ret
StuffButton3 endp

StuffCR proc
; Uses: ax
; We assume the keyboard buffer empty!
; Simplifies logic, but may fail.
      push bx
      mov bx,offset CR_ESC ; Escape sequence for carriage return
      mov al,CR_LEN        ; Number of pairs in cr escape.
      call StuffCodes2keybuffer ; Stuff escape seq into key buffer
      pop bx
      ret
StuffCR endp
;
; Simulate button2 press on any mouse.
;
StuffButton2 proc
; In: al=row, ah=column
; Uses: ax
; We assume the keyboard buffer empty!
; Simplifies logic, but may fail.
      push bx
      mov bx,offset Button2_COL ; Data area pointer
      call StuffLoc2buffer      ; Stuff cursor location into buffer
      mov bx,offset Button2_ESC ; Escape sequence for button 2
      mov al,Button2_LEN        ; Number of pairs in button 1 escape.
      call StuffCodes2keybuffer ; Stuff escape seq into key buffer
      pop bx
      ret
StuffButton2 endp
;
; Get mouse position from handler's last call
; OUT: al=row, ah=col
; USES: AX
GetMousePosition proc
      PUSHR <dx,cx>
      mov cx,current_X
      shr cx,1          ; Get target column position in cl
      shr cx,1
      shr cx,1
      cmp lineSize,40
      jnz short @@not_40
      shr cx,1         ; divide by 16 if there are 40 columns per line
    @@not_40:
      mov dx,current_Y
      shr dx,1          ; Get target row position in dl
      shr dx,1
      shr dx,1
      mov al,dl
      mov ah,cl
      POPR <cx,dx>
      ret
GetMousePosition endp
;
; Calculate from offset into screen memory the screen row, col
; Left upper corner of screen is row=0, col=0 [rows 0..59, cols 0..131]
; In: ax=offset into screen memory (includes attribute counts).
; Out: ah := col, al = row
offs2xy proc
      push bx
      shr ax,1               ; divide numerator AX by 2
      mov bx,lineSize        ; bl=denominator
      idiv bl                ; AX/bl --> al=quotient, ah=remainder
      pop bx
      ret
offs2xy endp
;
; Do Xterm selection by stuffing escapes into the keyboard buffer
; Return no carry bit when processing is over
DoXtermButtons proc
      and flag_doButtons,(not FlagButtonCR)     ; Disallowed for /A3
@@top:
      mov al,flag_doButtons
      test al,FlagButton1
        jz short @@Button1_exit
@@do_xterm3:
      mov ah,col_target
      mov al,row_target
      cmp ah,col_present
        jne short @@do_xterma
      cmp al,row_present
        je short @@do_xterm_exit
@@do_xterma:                    ; We assume the keyboard buffer empty!
                                ; Simplifies logic, but may fail.
      mov col_present,ah
      mov row_present,al        ; AX=Where to report cursor
      call StuffButton1         ; Stuff Xterm escape into keybuffer
@@do_xterm_exit:
      and flag_doButtons,(not FlagButton1)
      jmp short @@top
@@Button1_exit:
      test al,FlagButton13
        jz short @@Button13_exit
; Our selection here maps a button1 drag into "press left", "move"
; and "press right", which is the 3-button Xterm standard for marking
; a region.
      push cx
      mov ax,PositionLeft
      mov cx,NextPositionLeft
      cmp ax,cx
        jc  short @@no_swap  ; not marked from right to left
      xchg ax,cx             ; now from left to right
@@no_swap:
; Send left button info
      push cx
      call offs2xy           ; AX/lineSize --> al=quotient, ah=remainder
      call StuffButton1      ; stuff Xterm escape for button 1
; Send right button info, to simulate button3 on a 2-button mouse.
      pop ax                 ; prep for integer division, AX=top
      call offs2xy           ; AX/lineSize --> al=quotient, ah=remainder
      call StuffButton3      ; stuff Xterm escape for button 3
      pop cx
      and flag_doButtons,(not FlagButton13)
      jmp short @@top
@@Button13_exit:
;
; Stuff button 2 (see unix figure) info into the keyboard buffer
; This button normally causes the remote client to insert the
; local pastebuffer (unix Xterm standard).
;
      test al,FlagButton2
        jz short @@Button2_exit
      call GetMousePosition  ;al=row, ah=col
      call StuffButton2
      and flag_doButtons,(not FlagButton2)
      jmp short @@top
@@Button2_exit:
; Stuff right button (button 3) info into the keyboard buffer
; This button normally causes the remote client to define the
; region after a left button was received (Xterm standard).
; This is the extra button on a PC 3-button mouse.
;
      test al,FlagButton3
        jz short @@exit
      call GetMousePosition  ;al=row, ah=col
      call StuffButton3
      and flag_doButtons,(not FlagButton3)
@@exit:
      ret
DoXtermButtons endp

;
; Move cursor by stuffing keyboard buffer with escapes or arrow keys.
;
StuffArrows proc
;
@@arrows:
;
; emacs/vi: If the target row is not equal to the present row, then move
;           the cursor to column one of the same line before doing any
;           further cursor motion. Logic from emacs/vi/jed/jove.
; matrix:   Move to row first, then to column, no tricky cursor moves.
; xterm:    Use the escape sequence \033 [ M cb cx cy
;           for left button press.
;
      cmp flag_arrowkeys,FALSE       ; Arrow keys on?
        je short @@test_editor_exit  ; No, then get out of here fast.
@@test_editor:
      mov al,flag_editor
      cmp al,1        ; Using a method suitable for emacs/vi?
        je short @@do_emacs_vi
      cmp al,2        ; Using a method suitable for matrix editor?
        je short @@do_matrix   ; Do matrix method
      cmp al,3        ; Method for X10/xterm?
        jne short @@kill_allflag
      call DoXtermButtons
@@test_editor_exit:
      jmp short @@kill_eventflag
;
@@do_emacs_vi:
      mov al,row_present
      cmp row_target,al
      je short @@downarrow      ; row_target == row_present
@@arrow_loop:
      cmp col_present,0
      je short  @@downarrow     ; col_present == 0
      call LeftArrow
        jnz short @@exit        ; it failed, keybuffer full
      dec col_present           ; move one left
      jmp short @@arrow_loop
;
@@do_matrix:
@@downarrow:
      mov al,row_present
      cmp row_target,al
      je short @@rightarrow     ;row_target == row_present
      jl short @@uparrow        ;row_target < row_present
;
; row_target > row_present
;
      call DownArrow
        jnz short @@exit        ; failed, keybuffer full
      inc row_present           ; move one row down
      jmp short @@downarrow
;
; row_target < row_present
;
@@uparrow:                      ;row_target < row_present
      call UpArrow
        jnz short @@exit        ; failed, keybuffer full
      dec row_present           ; move one up
      jmp short @@downarrow
@@rightarrow:
      mov al,col_present
      cmp col_target,al
      je short @@kill_allflag   ; col_target == col_present
      jl short @@leftarrow      ; col_target < col_present
;
; col_target > col_present
;
      call RightArrow
        jnz short @@exit        ; failed, keybuffer full
      inc col_present           ; move one right
      jmp short @@rightarrow
;
; col_target < col_present
;
@@leftarrow:
      call LeftArrow
        jnz short @@exit        ; failed, keybuffer full
      dec col_present           ; move one left
      jmp short @@rightarrow
@@kill_allflag:
      and flag_doButtons,FlagButtonsOFF ; Leave FlagButtonCR on
@@kill_eventflag:
      and flag_event,(not FlagCURSOR) ; Cursor bits reset, nothing to do.
@@exit:
      test flag_doButtons,FlagButtonCR
        jz short @@@exit
      call StuffCR              ; stuff CR into keybuffer
        jnz short @@@exit       ; keybuffer full, failed
      and flag_doButtons,(not FlagButtonCR)
@@@exit:
      ret
StuffArrows endp
;
; Set cursor position. Later, the keyboard buffer is stuffed by "stuff2keybuffer".
; Uses: AX
set_cursor proc
      PUSHR <bx,ds>
      call GetMousePosition  ;al=row, ah=col
      mov col_target,ah
      mov row_target,al
      ; Get current text cursor position from BIOS variable
      mov ds,biosSEG
      xor ah,ah
      mov al,byte ptr [ds:62h]   ;Get current video page number
      add al,al         ; AL=2*AL
      add al,50h        ; 50h=cursor position bios data (8 16-bit words)
      mov bx,ax         ; BX=offset in segment 40h
      mov ax,[ds:bx]    ;Get cursor position for current page
      mov row_present,ah
      mov col_present,al
      xor bx,bx
      mov lasttime,bx
      mov lasttime+2,bx ; shut off click timing
@@exit:
      POPR <ds,bx>      ; PUSHR <bx,ds>
      or flag_event,FlagCURSOR
      ret
set_cursor endp

endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;

; Paste buffer for copied screen characters,
; Can overwrite initialization code.

guardbyte db 0  ; Guard byte for backward search in the paste buffer
pastebuf equ $

;; Begin non-resident code. This code is transient, used during install.

DE_INSTALL    equ 2     ; See option /U, procedure "get_opt" below.
REACTIVATE    equ 3     ; See option /R
if ENABLEPASTE
APPENDPASTE   equ 4     ; See option /F=X
SHOWXTCLASS   equ 5     ; See option /D
SETXTCLASS    equ 6     ; See option /D
SETTMP        equ 7     ; See option /F:X
endif ;ENABLEPASTE

NOT_INSTALLED equ 40h   ; FLAG for driver not installed.
ALL_OK        equ 41h   ; FLAG for all go.
WRO_VEC       equ 42h   ; FLAG for wrong vector detected.

 TESTCPU macro
; Test for 80188 cpu or later. See startup code. Not used for XT.
if not XT
      mov cl,33       ; Test for 80188 or successor
      shl ax,cl
      or  cl,cl       ; 188+ maximally shift 32 positions
      jnz @@TESTCPU_exit
      mov dx,offset wro_cpu_str
      call messageAlways
      jmp @@errexit
@@TESTCPU_exit:
endif ; not XT
 endm

 TESTBIOS macro
if not XT
; Test for modern Bios with int 16,5. See startup code. Not used for XT.
; Equipment check for enhanced keyboard.
      mov es,biosSEG
      test byte ptr [es:96h],10000b ; enhanced keyboard installed ?
      jz @@errexit
endif ; not XT
 endm

; Local variables used to parse command line. These get wiped out by
; the paste buffer, which writes over this area.
;
quiet_flag db FALSE          ; TRUE to display everything, FALSE defeats
copying_flag db FALSE        ; TRUE to display copying info
counter_Xoption db 0         ; Counter for number of /M and /X options.
how_to_flag db FALSE         ; TRUE if to display only How-To string
ExecExit_flag db FALSE       ; TRUE if /N on command line
settmpname_flag db FALSE     ; TRUE if changing name c:\tmp\xpcm####.tmp

; change interrupts and install mouse handler
;
; GET OPTIONS. Returns special options in ah.
;
get_opt proc
        mov si,80h            ; si => command line parameters
        seges
        lodsb                 ; count
        mov bh,0
        mov bl,al
        mov es:[si+bx],bh        ; 0
        or  al,al
        jnz  @@findslash
@@@parm_done:
        jmp  @@parm_done        ; Exit ah == 1
@@findslash:
        seges
        lodsb                   ; Using register CX!
        or al,al
        jz  @@@parm_done        ; Exit ah==1
        cmp al," "
        jz short @@findslash
        cmp al,"/"
        jz  short @@good_sep
        cmp al,"-"
        jz short @@good_sep
@@@parm_err:
        jmp @@parm_err
@@good_sep:
;  Valid options to return in register ah:
;  DE_INSTALL, REACTIVATE, APPENDPASTE, SHOWXTCLASS, SETXTCLASS
;  SETTMP
@@loop:                       ; Added some documentation of steps
        seges                 ; on 1-Nov-1994
        lodsb
@@HELP_setup:
        cmp al,'?'            ; Got /? or ? on command line
          jz short @@@parm_err

        and al,not ('a'-'A')  ; toupper

        cmp al,'H'            ; Got /H on command line
          jnz @@HELP_setup_exit
          mov how_to_flag,TRUE
          jz short @@@parm_err
@@HELP_setup_exit:
@@U_setup:
        cmp al,'U'            ; Got /U for uninstall
          jnz short @@U_setup_exit
        mov ah,DE_INSTALL
        jmp @@exit
@@U_setup_exit:
@@R_setup:
        cmp al,'R'            ; Got /R for reactivate driver
          jnz short @@R_setup_exit
        mov ah,REACTIVATE
        jmp @@exit
@@R_setup_exit:
if ENABLEPASTE
@@D_setup:
        cmp al,'D'           ; Got /d for show or set Xterm Classes
         jnz short @@D_setup_exit
        cmp     byte ptr es:[si],'='
          je @@D_setup1
        mov ah,SHOWXTCLASS
        call showXtermClasses
        jmp @@exit
@@D_setup1:
        inc si                  ; Point to file name
        mov di,offset fileappend
@@D_nameloop:
        mov al,es:[si]
        mov byte ptr cs:[di],al
        inc si
        inc di
        cmp al,0
        je @@D_nameloop_exit
        cmp al,' '
        jne @@D_nameloop
@@D_nameloop_exit:
        mov byte ptr cs:[di],0
        call setXtermClasses
        mov ah,SETXTCLASS
@@D_setup2:
        jmp @@findslash
@@D_setup_exit:
@@F_setup:
        cmp al,'F'           ; Got /f for append active paste buffer to file
         jnz short @@F_setup_exit
        mov ah,byte ptr es:[si]
        cmp ah,'='              ;Set name for append now
         je short @@F_setup_getname
        cmp ah,':'              ;Set default name hot button append
         jne short @@F_setup_exit
@@F_setup_getname:
        inc si                  ; Point to file name
        mov di,offset fileappend; 128 byte maximum
        mov settmpname_flag,ah
        xor ah,ah               ;counter
@@nameloop:
        mov al,es:[si]
        mov byte ptr cs:[di],al
        cmp ah,128
        jb @@nameloop_go
         mov dx,offset MSGfilesize
         call messageAlways
         jmp @@parm_err
@@nameloop_go:
        cmp al,' '
        je @@nameloop_exit
        cmp al,0
        jz @@nameloop_exit
        inc si
        inc di
        inc ah
        jmp short @@nameloop
@@nameloop_exit:
         mov byte ptr cs:[di],0
         cmp settmpname_flag,':'
         mov settmpname_flag,TRUE       ;We were here!
         je @@F_setup_setname
; Append the file now and quit.
        call appendfile
        mov ah,APPENDPASTE      ; Get out without install
        jmp @@exit
; Change the name c:\tmp\xpcm####.tmp
@@F_setup_setname:
if ENABLEFILEAPPEND
        mov al,ah               ;send it the string length
        call ChangeTmpName
        jc short @@parm_err
endif ;ENABLEFILEAPPEND
        jmp @@findslash
@@F_setup_exit:
endif ;ENABLEPASTE
;
; Loop on the other command line options
;
@@N_setup:
        cmp al,'N'            ; Got /N for mouse handler re-install
          jnz short @@N_setup_exit
        mov ExecExit_flag,TRUE
        call parse_num        ; 0=defeat, 1=on exec, 2=on exit, 3=both
        mov flag_reinstall_exec,FALSE
        mov flag_reinstall_exit,FALSE
        test ax,1
          jz @@N_1
        mov flag_reinstall_exec,TRUE
@@N_1:
        test ax,2
          jz @@N_2
        mov flag_reinstall_exit,TRUE
@@N_2:
        jmp @@findslash
@@N_setup_exit:
@@S_setup:
        cmp al,'S'           ; Got /S for button swap order
         jnz short @@S_setup_exit
        call parse_num        ; Get number nnn after '/S'
        call setbuttonswap
        jmp @@findslash
@@S_setup_exit:
@@C_setup:
        cmp al,'C'            ; Got /C, display copying info
        jne short @@C_setup_exit
        mov copying_flag,1
        jmp @@findslash
@@C_setup_exit:
@@Q_setup:
        cmp al,'Q'            ; Got /Q for quiet startup mode
        jnz short @@Q_setup_exit
        mov cs:quiet_flag,TRUE
        jmp @@findslash
@@Q_setup_exit:
        jmp short @@parm_done_exit

@@parm_err:
        mov ah,FALSE
        jmp short @@exit
@@parm_done:
        mov ah,TRUE
        jmp short @@exit

@@parm_done_exit:

if ENABLEPASTE
@@P_setup:
        cmp al,'P'            ; Got /P, defeat pastebuffer
        jne short @@P_setup_exit
        mov flag_pastebuffer,FALSE
        jmp @@findslash
@@P_setup_exit:
@@M_setup:
        cmp al,'M'            ; Got /M for monochrome video mode
          jnz short @@M_setup_exit
        mov al,119            ; XOR byte mask for monochrome == /X119
        jmp short @@X_setup1
@@M_setup_exit:
@@X_setup:
        cmp al,'X'            ; Got /X for XOR mask ddd
        jnz short @@X_setup_exit
        call parse_num        ; Get number nnn after '/X'
        cmp ax,255            ; Value ddd==119 for monochrome
        ja @@parm_err
        cmp ax,0
        jb short @@parm_err
@@X_setup1:
        mov xor_mask,al
        inc counter_Xoption
        jmp @@findslash
@@X_setup_exit:
@@B_setup:
        cmp al,'B'            ; Got /B for new buffer size in bytes
        jnz short @@B_setup1_exit
        call parse_num        ; Get number nnn after '/B'
        cmp ax,BUFFERLEN      ; Don't let it get bigger than BUFFERLEN
        ja @@parm_err         ; But ZERO is OK!
        add ax,15             ; Round up to next paragraph
        mov cl,4
        shr ax,cl
        mov cl,4
        shl ax,cl             ; ax == byte count for buffer size
        mov cs:BUFLEN,ax
        jmp @@findslash
@@B_setup1_exit:
endif ;ENABLEPASTE

if ENABLECURSOR         ;=========Cursor Key code ==========;
@@K_setup:
        cmp al,'K'            ; Got /K, defeat arrow keys
          jne short @@K_setup_exit
        mov flag_arrowkeys,FALSE
        jmp @@findslash
@@K_setup_exit:
@@A_setup:
        cmp al,'A'            ; Got /A, set emacs, matrix, xterm modes
        jnz short @@A_setup_exit
        call parse_num        ; Get number nnn after '/A'
        cmp ax,MAX_of_A       ; Valid options are 1,2,...,(MAX_of_A)
        ja short @@A_setup1
        cmp ax,1
        jb short @@A_setup1
        mov flag_editor,al
@@A_setup1:
        jmp @@findslash
@@A_setup_exit:
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;
        jmp @@findslash
@@exit:
        ret
get_opt endp

SwapButtonTable dw  123      ; 123 ==> 123
                db 1,3,5     ; shift factors for bit pattern
                dw 132
                db 1,5,3
                dw 213       ; Example: Button order 123 ==> 312
                db 3,1,5     ; Extra bytes are shift factors into
                dw 231       ; new position, eg, 00000110 are bits for
                db 3,5,1     ; for button 1, and we shift it to
                dw 312       ; 00000011 to normalize, then shift
                db 5,1,3     ; by 5 left to make it into button3
                dw 321       ; bits of 01100000
                db 5,3,1
                dw 0
                db 0,0,0
;
; Entry: ax == permutation of 123
;        Table determines allowed values (SwapButtonTable).
; Exit: Updated variables button_1fix, button_2fix, button_3fix
;
setbuttonswap proc
        push si
        push bx
        mov si,offset SwapButtonTable
@@S_loop:
        cmp ax,word ptr [si]
         jne @@S_loopexit
        inc si
        inc si
        mov bl,byte ptr [si]
        mov button_1fix,bl
        inc si
        mov bl,byte ptr [si]
        mov button_2fix,bl
        inc si
        mov bl,byte ptr [si]
        mov button_3fix,bl
        jmp short @@S_exit
@@S_loopexit:
        add si,5
        cmp word ptr [si],0
         jnz @@S_loop
        jmp short @@S_exit1
@@S_exit:
        mov flag_swapbuttons,TRUE
@@S_exit1:
        pop bx
        pop si
        ret
setbuttonswap endp


parse_num proc
        push    bx
        mov bx,10
        mov ax,0
        mov dh,0
@@addloop:
        seges
        mov dl,[si]
        or dl,dl
        jz  short @@done
        sub dl,'0'
        jc short @@done
        cmp dl,9
        ja short @@done
        inc si
        push dx
        mul bx
        pop dx
        add ax,dx
        jmp short @@addloop
@@done:
        pop     bx
        ret
parse_num endp

if ENABLEPASTE
; These routines set and display the Xterm character classes.
; by GBG January 1997

stringone   db 0,0
notopened   db 'Cannot open file','$'
filehandle  dw 0
pasteseg    dw 0
DisplayXtermClasses db 'Xterm Classes',13,10
fileappend  db 128 dup (?)
SIZEfileappend equ $-fileappend
            db '$'
hundredsplace   db      0
tensplace       db      0
onesplace       db      0


; Entry: al=byte to convert
; Exit: Writes answers to hundredsplace, tensplace, onesplace.
;       Uses ax,bx,dx.
convertBase10 proc near
        mov     ah,0            ;byte data
        mov     bx,100
        push    ax
        cwd
        idiv    bx
        mov     hundredsplace,al
        mov     dx,100
        mul     dx
        mov     bx,ax
        pop     ax
        sub     ax,bx
        push    ax
        mov     bx,10
        cwd
        idiv    bx
        mov    tensplace,al
        mov     dx,10
        mul     dx
        mov     bx,ax
        pop     ax
        sub     ax,bx
        mov     onesplace,al
        ret
convertBase10 endp

; Entry: ds:di points to place to write the string
;        al=byte to convert
; Exit: di updated. Uses ax,di
byteToString10 proc near

        push     bx
        push     dx
        call    convertBase10
;; put digits into string
        mov     al,hundredsplace
        cmp     al,0
        jz      @@tens
        add     al,'0'          ;100's digit
        mov     byte ptr ds:[di],al
        inc di
@@tens:
        mov     al,tensplace
        cmp     al,0
        jnz     @@tens_ok
        cmp     hundredsplace,0
        jz      @@ones
@@tens_ok:
        add     al,'0'          ;10's digit
        mov     byte ptr ds:[di],al
        inc di
@@ones:
        mov     al,onesplace
        add     al,'0'          ;1's digit
        mov     byte ptr ds:[di],al
        inc di
        pop     dx
        pop     bx
        ret
byteToString10 endp

showXtermClasses proc near
      XPUSHA
      call inst_tst     ; exits with es:bx == far address of pastebuffer
       mov dx,es
       mov pasteseg,dx  ; save segment
       cmp al,NOT_INSTALLED
       jne @@getclasses
         push cs
         pop es
@@getclasses:
      mov bx,offset unix_pairs
      mov al,byte ptr es:[bx]
      mov unix_pairs,al

      mov di,offset fileappend          ;place to put char classes
      mov bx,offset unix_ranges         ;source data in other segment

@@loop:
      mov al,unix_pairs
      cmp al,0
      jz @@loop_exit
      dec unix_pairs
      mov al,byte ptr es:[bx]           ;first of pair
      inc bx
      call byteToString10
      mov byte ptr ds:[di],'-'
      inc di
      mov al,byte ptr es:[bx]           ;second of pair
      inc bx
      call byteToString10
      mov byte ptr ds:[di],':'
      inc di
      jmp short @@loop
@@loop_exit:
      mov byte ptr ds:[di],13
      inc di
      mov byte ptr ds:[di],10
      inc di
      mov byte ptr ds:[di],'$'
      mov dx,offset DisplayXtermClasses
      call messageAlways
@@done:
        XPOPA
        ret
showXtermClasses endp

get_num proc
        push    bx
        mov bx,10
        mov ax,0
        mov dh,0
@@addloop:
        mov dl,byte ptr cs:[si]
        or dl,dl
        jz  short @@done
        sub dl,'0'
        jc short @@done
        cmp dl,9
        ja short @@done
        inc si
        push dx
        mul bx
        pop dx
        add ax,dx
        jmp short @@addloop
@@done:
        pop     bx
        ret
get_num endp


; Entry: fileappend == ASCIIZ file name
setXtermClasses proc near
        XPUSHA
      call inst_tst     ; exits with es:bx == far address of pastebuffer
       mov dx,es
       mov pasteseg,dx  ; save segment
       cmp al,NOT_INSTALLED
      jne @@setclasses
      jmp @@exit
@@setclasses:
; Open file. Abort if missing.
        mov     al,0            ;read only
        mov     ah,3dh          ;open file
        mov     dx,offset fileappend      ;file name 0 terminated
        int     21h
        mov     filehandle,ax
        jnc     @@goodopen
        mov dx,offset notopened
        call messageAlways
        jmp     short @@exit            ;no such file, just quit
@@goodopen:
        mov     bx,filehandle
        mov     cx,SIZEfileappend
        mov     dx,offset fileappend    ; String location for read
        mov     ah,3Fh
        int     21h                     ;read file into buffer loc
        mov     bx,ax
        mov     ax,offset fileappend
        add     bx,ax                   ;end of data
        mov     byte ptr ds:[bx],0      ;mark end of data with NULL
        mov     ah,3eh
        mov     bx,filehandle
        int     21h                     ;close file handle
        mov     si,offset fileappend
        mov     unix_pairs,0
        mov     bx,offset unix_ranges
        mov     es,pasteseg             ;where to put the answers
@@parsestring:                          ;decode string
        call    get_num                 ;ans in ax
        cmp     ax,0
        je      @@parsestring_exit
        mov     byte ptr es:[bx],al
        inc     bx
        cmp     byte ptr cs:[si],0
        je     @@parsestring_exit
        inc     si
        call    get_num                 ;ans in ax
        cmp     ax,0
        je      @@parsestring_exit
        mov     byte ptr es:[bx],al
        inc     bx
        inc     unix_pairs
        mov     al,unix_pairs
        cmp     al,MAX_unix_pairs
        je      @@parsestring_exit
        cmp     byte ptr cs:[si],0      ;expect colon (:) or null (\0).
        je      @@parsestring_exit      ;was a null
        inc     si                      ;was a colon, maybe
        jmp short @@parsestring
@@parsestring_exit:
        mov     bx,offset unix_pairs
        mov     al,unix_pairs
        mov     byte ptr es:[bx],al
@@exit:
        XPOPA
        ret
setXtermClasses endp
endif ;ENABLEPASTE

if ENABLEPASTE
; These routines append active paste buffer to a file.
; by GBG January 1997

; Entry: cs:si=ASCIIZ path and file name
; Exit: bx=file handle, ax=0 for bad open
; Uses: ax,bx
openfile proc near
; Open file. Create it if missing.
        push    dx
        push    ds
        push    cs
        pop     ds
        mov     al,2            ;read and write
        mov     ah,3dh          ;open file
        mov     dx,si           ;file name 0 terminated
        int     21h
        mov     bx,ax           ;bx=file handle
        mov     ax,1            ;ax==1 means good open
        jnc     @@goodopen
        mov     cx,0                    ;file attributes
        mov     dx,si                   ;full path name to create in ds:dx
        mov     ah,03ch                 ;create file
        int     21h
        mov     bx,ax                   ;return bx=handle
        mov     ax,1
        jnc     @@goodopen
        mov     ax,0            ;ax==0 means bad open
@@goodopen:
        pop     ds
        pop     dx
        ret
openfile endp

; Entry: bx=file handle
; Exit: seek end of file, uses ax
seekend proc near
        push    bx
        push    cx
        push    dx
        push    es
;       mov     bx,file handle
        mov     cx,0                    ;cx=high word
        mov     dx,0                    ;dx=low word of seek amount
        mov     al,2                    ;seek end of file
        mov     ah,42h                  ;set file pointer
        int     21h
        pop     es
        pop     dx
        pop     cx
        pop     bx
        ret
seekend endp

; Entry: fileappend==file name
; Exit:  paste buffer appended to file.
; Uses: ax, es, bx, si
appendfile proc
        push ds
      call inst_tst     ; exits with es:bx == far address of pastebuffer
       mov pasteseg,es  ;save segment
       cmp al,NOT_INSTALLED
       je @@done
; Store into local variables the offsets into the active pastebuffer.
@@getlocals:
      push cs
      pop ds
      mov nextpair,offset pastebuf
      mov bx,offset lastpair
      mov ax,word ptr es:[bx]
      mov lastpair,ax

; Mark data in this program to keep GetPasteBuf under control.
      mov flag_CtrlRight,TRUE     ; append CR
;      mov counter_blanks,0
; Open the file in cs:si
      mov si,offset fileappend  ; file name to open
      call openfile             ; bx = file handle on success
        mov filehandle,bx       ; save handle
        cmp ax,0                ; 0==failure to open file
      jne @@seek
      mov dx,offset notopened
      call messageAlways
      jmp short @@done
; Seek to the end of the file
@@seek:
      mov bx,filehandle
      call seekend
      mov       es,pasteseg             ; Segment of active pastebuffer
      mov       si,offset stringone     ; String location for write
@@loop:
      call GetPasteBuf                  ; AL == char found in pastebuffer
        jc short @@@exit                ; nothing left in pastebuffer
@@@loop:
        mov     byte ptr ds:[si],al
        mov     bx,filehandle
        mov     cx,1
        mov     dx,offset stringone     ; String location for write
        mov     ah,40h
        int     21h                     ;write string to file
        cmp     byte ptr ds:[si],13        ;was it a CR?
        jne @@loop
        mov     al,10     ;add linefeed
        jmp short @@@loop
@@@exit:
        cmp     byte ptr ds:[si],10        ;was it a LF?
        mov     al,13
        jne     @@@loop                 ;then add extra crlf
        mov     ah,3eh
        mov     bx,filehandle
        int     21h                     ;close file handle
@@done:
        pop ds
        ret
appendfile endp


if ENABLEFILEAPPEND
MSGfilesize db '/F:X error: Name X has a 20 character maximum.'
else
MSGfilesize db '/F=X error.'
endif ;ENABLEFILEAPPEND
            db 13,10
            db '/F=X allows name X with 128 character maximum.'
            db 13,10,'$'

if ENABLEFILEAPPEND
; Entry: al == string length
; Uses: AX, FLAGS
ChangeTmpName proc
        push es
        push ds
        push si
        push di
        cmp al,21
        jb @@change
          mov dx,offset MSGfilesize
          call messageAlways
          stc
          jmp short @@exit
@@change:
        call inst_tst     ; exits with es:bx == far address of pastebuffer
         mov di,offset filen
         mov si,offset fileappend
         cmp al,NOT_INSTALLED
          push cs
          pop ds
         je @@loop
          push es
          pop ds
@@loop:                                 ; Move file name
         mov al,byte ptr cs:[si]        ; Copy string with
         mov byte ptr ds:[di],al        ; null terminator
         or al,al
         jz @@loopexit
         inc si
         inc di
         jmp short @@loop
@@loopexit:
        clc
@@exit:
      pop di
      pop si
      pop ds
      pop es
      ret
ChangeTmpName endp
endif ;ENABLEFILEAPPEND
endif ;ENABLEPASTE

; Entry: None
; Exit:  al=ALL_OK, es:bx == pointer to pastebuf
;        Else al==NOT_INSTALLED
; Uses: ax, es, bx; ah unchanged
inst_tst proc
        push cx
        push ax
        mov ax,MOUSE_FN         ; test for installed
        int 16h
        cmp ax,MOUSE_FNDEC      ; must pass two tests, ah changed
         jnz short @@failed
        cmp cx,IDENTCODE        ; and proper code in cx; see new_16h
         je @@worked
@@failed:
        mov al,NOT_INSTALLED
         jmp short @@exit
@@worked:
        mov al,ALL_OK           ; es:bx points to pastebuf
@@exit:
        pop cx
        mov ah,ch
        pop cx
        ret
inst_tst endp

cmp_fptr proc ; cmp ax:bx and cx:dx
        XPUSHA
        mov si,0
        mov di,0

; si:ax *= 16
        rept 4
          shl ax,1
          rcl si,1
        endm
        add ax,bx
        adc si,0

; di:cx *= 16
        rept 4
          shl cx,1
          rcl di,1
        endm
        add cx,dx
        adc di,0

        cmp cx,ax
        jnz short @@exit
        cmp si,di
@@exit:
        XPOPA
        ret
cmp_fptr endp

      ms_hnd_ptr dw 0,0

re_activate proc
LOCAL  hndadr:DWORD = AUTO_SIZE
       push bp
       mov  bp,sp
       sub  sp,AUTO_SIZE
      PUSHR <ds,es>
      call inst_tst             ; es:bx == far address of pastebuffer
      cmp al,NOT_INSTALLED
      je short @@exit

      push bx                   ; bx == & InstallMouseHandler
      push es
      sub bx,pastebuf-InstallMouseHandler
      mov word ptr hndadr,bx
      mov bx,es
      mov word ptr hndadr+2,bx
      call dword ptr [hndadr]           ; call InstallMouseHandler
      pop es
      pop bx
      cmp ExecExit_flag,FALSE           ; Process /N options?
       je @@exit
      push bx
      sub bx,pastebuf-flag_reinstall_exec
      mov al,flag_reinstall_exec
      mov byte ptr es:[bx],al
      pop bx
      sub bx,pastebuf-flag_reinstall_exit
      mov al,flag_reinstall_exit
      mov byte ptr es:[bx],al
      mov al,ALL_OK

@@exit:
      POPR <es,ds>
       add  sp,AUTO_SIZE
       pop bp
      ret
re_activate endp

RSTVEC macro vec,old_vec_dist
      mov bx,pcmoffs
      sub bx,old_vec_dist
      lds dx,[es:bx]
      mov ax,(25h shl 8) + vec           ; set vector
      int 21h
endm

CMPVEC macro vec,new_vec_dist
      mov ax,(35h shl 8) + vec           ; get vector
      int 21h                            ; to es:bx

      mov ax,es
      mov cx,pcmseg
      mov dx,pcmoffs
      sub dx,new_vec_dist
      call cmp_fptr      ; cmp ax:bx and cx:dx
      jnz @@wrong_vec
endm

; Do soft reset on Mouse driver

SoftMouseReset proc
; Software Reset, to put handler into defined state
      mov ax,21h        ;soft reset
;;;      mov ax,00h        ;hard reset
      int 33h
      ret
SoftMouseReset endp

de_inst proc
LOCAL  pcmoffs,pcmseg:WORD,tckflg:BYTE = AUTO_SIZE
       push bp
       mov  bp,sp
       sub  sp,AUTO_SIZE
       PUSHR <ds,es>
      call inst_tst
      cmp al,ALL_OK             ; Then es:bx == pastebuf address
        je short @@cont_de_inst
      jmp short @@goexit
@@cont_de_inst:
; now test for all patched vectors, if they point to xpcmouse
; We have now es:bx == pastebuf of in-memory copy of xpcmouse
;
      mov pcmoffs,bx  ; Offset to pastebuf in segment es
      mov ax,es
      mov pcmseg,ax   ; Segment of installed xpc-mouse

; We always patch 21h, 16h, 10h, 08h.

      CMPVEC 21h,pastebuf-new_21h
      CMPVEC 16h,pastebuf-new_16h
      CMPVEC 10h,pastebuf-new_10h
      CMPVEC 08h,pastebuf-new_08h
if ENABLEFILEAPPEND
      CMPVEC 13h,pastebuf-new_13h
endif ;ENABLEFILEAPPEND

        jmp short @@de_inst

@@wrong_vec:
        mov al,WRO_VEC
@@goexit:
        jmp short @@exit

@@de_inst:

        RSTVEC 21h,pastebuf-old_21h
        RSTVEC 16h,pastebuf-old_16h
        RSTVEC 10h,pastebuf-old_10h
        RSTVEC 08h,pastebuf-old_08h
if ENABLEFILEAPPEND
        RSTVEC 13h,pastebuf-old_13h
endif ;ENABLEFILEAPPEND

; reset driver is done at end of last exec, too
        call SoftMouseReset        ; reset mouse driver & interrupt handler
        mov es,pcmseg              ; segment of installed xpc-mouse
        mov bx,pcmoffs             ; offset into that segment
        sub bx,pastebuf-killed_flg ; get offset to killed_flg in "new_21h"
        mov byte ptr [es:bx],TRUE  ; Prevent re-entry of "new_21h"
        mov bx,pcmoffs             ; offset to pastebuf
        sub bx,pastebuf-XPC_pspadr ; offset to storage word
        mov es,[es:bx]             ; Get psp address word
        mov ah,49h ; free memory
        int 21h

        mov al,ALL_OK
        jmp short @@exit

@@exit:
       POPR <es,ds>
       add  sp,AUTO_SIZE
       pop bp
       ret
de_inst endp

messages proc near
        push    ax
        cmp cs:quiet_flag,TRUE
         jz short @@exit
        mov     ah,9
        int     21h
@@exit:
        pop     ax
        ret
messages endp

messageAlways proc near
        push    ax
        mov     ah,9
        int     21h
        pop     ax
        ret
messageAlways endp

init proc
      mov ax,es
      mov cs:XPC_pspadr,ax      ; Save a copy in resident code
      mov ax,cs
      mov ds,ax
      call get_opt

; Output copying message and quit?
      cmp cs:copying_flag,FALSE
        jz short @@no_copying
      mov dx,offset copying
      jmp @@do_exit

@@no_copying:
      mov dx,offset onsign
      call messages

@@no_onsign:
      cmp cs:how_to_flag,FALSE
        jz short @@no_onsign1
        jmp @@do_how_to_exit
@@no_onsign1:
      cmp ah,TRUE
        jz short @@cont_inst
      cmp ah,FALSE
        mov dx,offset help_str
        jz @@do_exit

if ENABLEPASTE
@@tst_showxtclass:
      cmp ah,SHOWXTCLASS
        jnz short @@tst_appendpaste
        jmp short @@do_exit_raw
@@tst_appendpaste:
      cmp ah,APPENDPASTE
        jnz short @@tst_reactivate
        mov dx,offset appendf_str
        jmp @@do_message_exit
endif ;ENABLEPASTE

@@tst_reactivate:
      cmp ah,REACTIVATE
        jnz short @@tst_de_inst
@@do_reactivate:
      call re_activate
        cmp al,NOT_INSTALLED
        jz short @@not_yet1
        mov dx,offset re_inst_str
        jmp short @@do_exit

@@tst_de_inst:
      cmp ah,DE_INSTALL
        jnz short @@cont_inst
      call de_inst
        cmp al,NOT_INSTALLED
@@not_yet1:
        mov dx,offset not_yet_str
         jz @@do_exit
        cmp al,ALL_OK
        mov dx,offset ok_de_inst
         jz @@do_exit
        mov dx,offset wro_de_inst
         jmp short @@do_exit

@@cont_inst:

      TESTCPU         ; Test for 80188 cpu or later. See macro above.
;      TESTBIOS        ; Test for modern bios. See macro above.
                      ; We don't use int 16 function 5 in 1997


; use function 21h (instead of 0) to ensure that new
; mouse driver is installed

      mov ax,21h             ; Test, if mouse driver installed
      int 33h
      inc ax                 ; installed => 0
        jz short @@mouse_there
      mov dx,offset nomouse_str
      call messageAlways
@@errexit:
      mov  dx,offset noins_str
      call messageAlways
      jmp short @@do_exit_raw
@@do_exit:
if ENABLEPASTE
         cmp settmpname_flag,TRUE
           je @@do_exit_raw
endif  ;ENABLEPASTE
      call messages
@@do_exit_raw:
      mov  ax,4c01h          ; errorlevel 1 == no mouse driver
      int  21h

@@mouse_there:
      call inst_tst
      jnz short @@install
      cmp ExecExit_flag,FALSE   ; Any /N requests?
       je @@mouse_there_exit
       jmp @@do_reactivate      ; /N implies /R if already installed
@@mouse_there_exit:

@@do_how_to_exit:
      mov dx,offset help_switches
      call messages

      cmp cs:how_to_flag,FALSE
        je @@exit02

      mov dx,offset how_to

@@do_message_exit:
      call messages

      mov  ax,4c03h          ; errorlevel 3 == message exit
      int  21h

@@exit02:
      mov dx,offset msgstr
      call messages
@@exit02_nomsg:
      mov  ax,4c02h          ; errorlevel 2 == re-installed
      int  21h

@@install:

; Set buffer length variable

      mov ax,cs:BUFLEN          ; Get ending address of the
      add ax,offset pastebuf-1  ; Paste Buffer
      mov cs:EndOfBuffer,ax     ; and save it

if ENABLEPASTE
; See if the video mode is appropriate for the /Xddd mask
      cmp cs:counter_Xoption,0  ; Over-ride on command line?
        jnz short @@video_OK
      ;   Option /M for monochrome Video mode (/M==/X119).
      push ds
       mov ds,biosSEG
       cmp byte ptr [ds:49h],7   ; BIOS current video mode mono?
      pop ds
       jnz short @@video_OK
      mov xor_mask,119          ; Use /X119 for mono
@@video_OK:
endif ;ENABLEPASTE

; free environment
; Space managed by DOS can be re-used.
;
      mov es,cs:XPC_pspadr
      mov es,[es:2ch]   ; segment address of environment
      mov ah,49h        ; free memory
      int 21h

      mov ax,3516h
      int 21h           ; get vector
      mov word ptr old_16h,bx
      mov word ptr cs:[old_16h+2],es

      mov ax,3510h
      int 21h
      mov word ptr cs:[old_10h],bx
      mov word ptr cs:[old_10h+2],es

      mov ax,3521h
      int 21h
      mov word ptr cs:[old_21h],bx
      mov word ptr cs:[old_21h+2],es

      mov ax,3508h
      int 21h                ; get vector
      mov word ptr old_08h,bx
      mov word ptr cs:[old_08h+2],es

if ENABLEFILEAPPEND
      mov ax,3513h
      int 21h                ; get vector
      mov word ptr old_13h,bx
      mov word ptr cs:[old_13h+2],es
endif ;ENABLEFILEAPPEND

if ENABLEFILEAPPEND
      mov dx,offset new_13h
      mov ax,2513h           ; set vect
      int 21h
endif ;ENABLEFILEAPPEND

      mov dx,offset new_10h
      mov ax,2510h           ; set vect
      int 21h

      mov dx,offset new_16h
      mov ax,2516h           ; set vect
      int 21h

      mov dx,offset new_08h
      mov ax,2508h           ; set vect
      int 21h

      mov dx,offset new_21h
      mov ax,2521h           ; set vect
      int 21h

      call SoftMouseReset
      call InstallMouseHandler

      mov dx,offset how_to
      call messages
      mov dx,offset worked
      call messages

@@terminate:
      ; Compute how many paragraphs are to be resident.
      ; This count adds is code length plus paste buffer length. The
      ; paste buffer has by design a maximum length of BUFFERLEN bytes.
      ;
      mov dx,cs:BUFLEN          ; Desired buffer length
      add dx,offset pastebuf    ; resident code len + BUFLEN
      add dx,15+256             ; Roundup + EXE header size
      shr dx,1                  ; dx --> (end_mouse - begin_resident+15+256)/2
      shr dx,1                  ; dx --> (end_mouse - begin_resident+15+256)/4
      shr dx,1                  ; dx --> (end_mouse - begin_resident+15+256)/8
      shr dx,1                  ; dx --> (end_mouse - begin_resident+15+256)/16
      mov ax,3100h
      int 21h                ; terminate stay resident

init endp

copying:
       db 'Copyright (c) 1994-1997 Jrgen G. Weber and G.B. Gustafson',13,10
       db 'xPC-Mouse is free software, distributed under the terms of the',13,10
       db 'GNU General Public License. For details, see the file COPYING.',13,10
       db 10
       db 'Jrgen G. Weber',13,10
       db 'Wiesentalstrae 1',13,10
       db 'D-74523 Schwbisch Hall',13,10
       db 'Germany',13,10
       db 'email: weberj@dia.informatik.uni-stuttgart.de',13,10
       db 10
       db 'Grant B. Gustafson',13,10
       db '113 JWB Math Dept Univ Utah',13,10
       db 'Salt Lake City, UT 84112  USA',13,10
       db 'email: gustafson@math.utah.edu',13,10
       db '$'

if ENABLEPASTE and ENABLECURSOR
MOUSEPROG equ 'xPCmouse'
endif ;ENABLEPASTE and ENABLECURSOR

if ENABLEPASTE and (not ENABLECURSOR)
MOUSEPROG equ 'xPCpaste'
endif ;ENABLEPASTE and (not ENABLECURSOR)

if (not ENABLEPASTE) and ENABLECURSOR
MOUSEPROG equ 'xPCarrow'
endif ;(not ENABLEPASTE) and ENABLECURSOR

onsign db 13,10,MOUSEPROG,' version ',PVERSION,13,10
       db 'Copyright (c) 1994-1997 Jrgen G. Weber and G.B. Gustafson',13,10
       db 'Free for personal use under the Gnu license agreement.',13,10
       db '$'

how_to:
       db 13,10
       db 'KEYS and BUTTONS         FUNCTION',13,10
if ENABLEPASTE
       db 'Drag Mouse 1 ........... Copy text',13,10
       db 'Double-click Mouse 1 ... Copy word',13,10
       db 'Mouse 2 ................ Paste text',13,10
       db 'CTRL-Mouse 2 ........... Paste text + ENTER',13,10
       db 'RSHIFT-Mouse 2 ......... Paste feature on/off',13,10
       db 'LSHIFT-CTRL-Mouse 2 .... Append text to TMP file',13,10
       db 'LSHIFT-ALT-Mouse 2 ..... Paste into Windows clipboard',13,10
endif ;ENABLEPASTE
if ENABLECURSOR
       db 'Mouse 1 ... ............ Position cursor (hold 1/6 sec)',13,10
       db 'Mouse 3 ................ Carriage return (except /A3)',13,10
       db 'ALT-Mouse 2 ............ Mouse 3 duplicate',13,10
       db 'LSHIFT-Mouse 1 ......... Cursor feature on/off ',13,10
       db 'LSHIFT-ALT-Mouse 1 ..... Toggle methods /A1-/A3',13,10
endif ;ENABLECURSOR
       db 'CTRL-LSHIFT-RSHIFT ..... Re-install (hold 1 sec)',13,10
       db '$'

worked db 13,10
       db MOUSEPROG,' is installed. Use "',MOUSEPROG
       db ' /U" to un-install.'
       db 13,10,'$'
msgstr db 13,10
       db 'xPC-Mouse was already installed.',13,10,'$'
not_yet_str db 13,10,  MOUSEPROG,' was not installed yet.',13,10,'$'
ok_de_inst  db 13,10,  MOUSEPROG,' is un-installed.',13,10,'$'
re_inst_str db 13,10,  MOUSEPROG,' is re-activated.',13,10,'$'
wro_de_inst db 13,10,  'Could not un-install ',MOUSEPROG,'.',13,10,'$'
nomouse_str db 13,10,7,'No mouse driver found or driver too old.',13,10,'$'
noins_str   db         MOUSEPROG,' not installed.',13,10,'$'
if not XT
wro_cpu_str db         MOUSEPROG,' needs at least an 80286 cpu.',13,10,'$'
endif

if ENABLEPASTE
appendf_str db 13,10,  'Paste buffer appended to file.',13,10,'$'
endif ;ENABLEPASTE

help_str db 13,10,'Options: /Q    : Quiet, no messages',13,10
               db '         /R    : Re-activate xPC-Mouse',13,10
               db '         /Sabc : Swap buttons 123 to order abc',13,10
;               db '         /T    : Enable timer int 08h patch',13,10
               db '         /N0   : Defeat mouse handler re-install',13,10
               db '         /N1   : Re-install mouse handler before exec',13,10
               db '         /N2   : Re-install after exit (default)',13,10
               db '         /N3   : Re-install before exec and after exit',13,10
if ENABLECURSOR         ;=========Cursor Key code ==========;
               db '         /K    : Defeat arrow key emulation',13,10
               db '         /A1   : Emacs/vi arrow key method (default)',13,10
               db '         /A2   : Matrix arrow key method',13,10
               db '         /A3   : Xterm escape sequence method',13,10
endif   ;end ENABLECURSOR ;=========Cursor Key code ==========;
if ENABLEPASTE
               db '         /M    : Monochrome video mode (equals /X119)',13,10
               db '         /Xddd : Highlight XOR mask ddd (default /X80)',13,10
               db '         /Bdddd: Buffer size dddd bytes',13,10
               db '         /P    : Defeat pastebuffer use',13,10
               db '         /D=X  : Set Xterm character classes from file X',13,10
               db '         /F=X  : Append active paste buffer to file X',13,10
               db '         /F:X  : Change TMP name c:\tmp\xpcm####.tmp to X',13,10
endif ;ENABLEPASTE
help_switches:
               db 'Info:    /C    : Show copyright information',13,10
if ENABLEPASTE
               db '         /D    : Show Xterm character classes',13,10
endif ;ENABLEPASTE
               db '         /?    : Show command switches',13,10
               db '         /H    : Show key and button assignments',13,10
               db '         /U    : Uninstall',13,10
               db '$'

if ENABLEPASTE
; Insure source file is long enough when loaded into memory
; so that the pastebuffer is the proper size.
;
if  ($-pastebuf) lt BUFFERLEN
        db  BUFFERLEN-($-pastebuf) dup (?)
endif

end_mouse equ pastebuf+BUFFERLEN
endif ;ENABLEPASTE
code ends

; Stack segment is only used during initialization

stck segment para stack 'stack'
  db 256 dup (?)
stck ends

end init

comment *

  XPC-Mouse:  POSITION CURSOR, COPY and PASTE in Dos Text Mode

  Copyright (c) 1994-1997 by Jrgen G. Weber and Grant B. Gustafson.
  ALL RIGHTS RESERVED

  Free for personal use under the Gnu Public License agreement, which is
  distributed with this source. See the end of this file for a copy of
  the License Agreement.

  CREDITS
  ----------------------------------------------------------------------
  Portions of this code originated with and were extracted from
  PCMOUSE  (c) 1992,1994 by  Jrgen G. Weber
                             Wiesentalstrae 1
                             D-74523 Schwbisch Hall
                             Germany - European Union

  This ASM source written by GB Gustafson
                             113 JWB Math Dept Univ Utah
                             Salt Lake City, UT 84112
                             USA
  in collaboration with Jrgen G. Weber to create this new product.
  Portions of this ASM code also appeared in MOUSE2G, copyright (c)
  1991, 1992 by GB Gustafson. Finally, credits are due to Al Williams,
  for solid advice about TSRs, in his book "DOS 5: A Developers Guide",
  M&T Press, 1991, and to Dave Williams, for his electronic reference on
  DOS, especially the mouse information and interrupt details.
  ----------------------------------------------------------------------

  XPC-Mouse
  POSITION CURSOR, COPY and PASTE in Dos Text Mode

  Function: Highlight text while left button is pressed. Left release
            causes the selected text to be copied from the screen into
            an internal pastebuffer. The right button pastes the
            pastebuffer at the text cursor position. Left button press
            of 1/6 second positions the text cursor [defeatable]. Middle
            button press emits a carriage return (except in Xterm mode).
            Emacs/vi, matrix and Xterm style mouse action methods. See
            the HELP at the end of the file for more.

  MAKE:     tasm xpcmouse
            tlink xpcmouse

  COMMAND LINE OPTIONS: /U /T /Q /N0 /N1 /N2 /N3 /R /Xddd /Bddd
                        /M /K /P /A1 /A2 /A3 /C /H /F=X /D /D=X
                        See help text at the end of the file.
  STARTUP DEFAULTS:
            Auto default for video XOR highlight mask
               /X80 for color modes (xor mask == 64+16 )
               /M for mono modes (/M==/X119, xor mask == 64+32+16+4+2+1)
            /A1 for Emacs/jed/vi arrow keys
            /N2 for auto re-install of mouse handler
            /U, /Q,  /R, /T, /C, /?, /A2, /A3 defeated
            /K and /P toggles are ON
            /B2048 is the default paste buffer size 2048 bytes

  VERSIONS:
  1.0  First public release. 1-Dec-1994
  1.1  Second release (maintenance). 17-Oct-1995
  1.2  Third release (new features). 25-Jan-1997
  1.3  Fourth release (maintenance). 10-Aug-1997

  Features of 1.0 inherited from Jrgen G. Weber's PC-Mouse versions 1.0-1.5:
          Option /T, enable stuffing the paste buffer into the
            keyboard buffer at every timer (int 1ch) tick.
          Un-install Option /U. Mouse hardware reset after de-install.
          8088 Version. Support mono, color, ega, vga text modes.
          Option /Xddd for XOR mask
          Option /Q for quiet start up
          Option /N to defeat int 21h patch (obsolete in ver 1.1)
          Option /R to reactivate TSR.
          Pastebuffer compression and interrupt logic.
          Install and de-install routines.

  Features of 1.0 originating with this ASM source written by GB Gustafson:
          Pressing the left button for 1/6 second positions the cursor.
          Default /A1 for emacs/vi/jove/jed/epsilon mouse action.
          Option /A2 is matrix mouse action, qedit/pi editors.
          Option /A3 is for Xterm X10/X11 style escapes \033[M cb cx cy.
            Works with remote jed/emacs/pi and extensible editors.
          Toggle /A state dynamically using SHIFT-ALT-buttonleft
            with ring selection /A1 --> /A2 --> /A3 --> /A1.
          Option /K defeats arrow keys and Xterm sequences.
          Option /P defeats the pastebuffer.
          ALT-buttonright duplicates buttonmiddle (for 2-button mouse).
          SHIFT-buttonleft toggles arrow keys on/off (see /K).
          SHIFT-buttonright toggles the pastebuffer on/off (see /P).
          Option /M for monochrome Video mode (/M==/X119).
          Unix file name selection on double-click using the idea
            of the X11R5 Xterm character classes.
          Hide mouse cursor after highlighting.
          Auto default for video XOR highlight mask
               /X80 for color modes (xor mask == 64+16 )
               /M for mono modes (/M==/X119, xor mask == 64+32+16+4+2+1)
          Help file dump /? gives switch information.
          Author, copying and copyright switch /C for shorter signon.
          Help file dump /H gives How-To information on mouse actions.
          Dynamic buffer size up to max size compiled into program.
          GNU license agreement.

  Features of 1.1 (by GBG 10-Oct-95):
          Fixed 40-col mode bug. Supports video modes 0-13h only.
          Add support for 3-button mouse systems PC mouse.
          Add carriage return function on button3 (==ALT-button2)
          Corrected documentation on DOS 6.2+Windows 3.1 and fixed a
           nasty Win 3.1 bug present in xpcmouse 1.0 and PCmouse
           versions to 1.6.
          Added swapping of mouse buttons, because most mouse device
           drivers don't do it.
          Option /N0 to defeat mouse handler re-install
          Options /N1, /N2, /N3 to set mouse handler re-install method.
           These work on the fly by re-running xpcmouse.

  Features of 1.2 (by GBG 25-Jan-97):
          Advice from Howard Schwartz, theo@ccnet3.ccnet.com.
          Added colons as valid file separators for double click. This
           is needed for grabbing URLs like http://www.yahoo.com/.
          Added command line switch for appending the active paste
           buffer to a file (given on the command line).
          Added command line switch for setting and displaying character
           classes.
          Hot button combination RSHIFT then CTRL-LSHIFT-RSHIFT for 1
           second re-installs xpcmouse.
          Mouse click CTRL-LSHIFT-MOUSE 2 appends paste text to file
           c:\tmp\xpcm####.tmp. Added command line support for it.
          Re-worked interrupt handlers so that int 21h only sets flags
           and the actual work happens in int 08h.
          Removed /T switch.
          Mouse click ALT-LSHIFT-MOUSE 2 copys paste text to the windows
           clipboard (if windows is running).
          Mouse highlight API changed so a drag from lower right to
           upper left defines a box (matrix). Other drags unchanged.
          Paste buffer no longer compressed, so that windows paste is
           possible directly without conversions and without additional
           buffer space.
          Set /N2 as default re-install method, based upon Win 95
           experiments.
          Redid the code churning in the mouse handler and interrupt
           routines to minimize system impact.

  Features of 1.3 (by GBG 10-Aug-97):
          Fixed highlighting problem for paste functions. Used to
          go crazy during a drag+release. Howard Schwartz aso reported
          this and said that the paste to file feature fails on his
          machine. Could not reproduce it on mine. Conjecture that the
          failure is related to false highlighting of text.

 Bug fixes:
          /T was always ON. Reset to initially OFF. 1-Dec-94

          /T ASM code caused characters to be lost on paste, traced to
          recursive call of interrupt 1ch. Fixed by setting a flag to
          bypass the second call (until the first one finished). This
          bug was also in PCMOUSE 1.5, as observed under SunPC and sun4
          OS. 1-Dec-94

          /T off worked with paste, but not with arrow keys. Traced to
          convoluted code which bypassed a call to stuff the keybuffer.
          Fixed by having a central place where the mouse handler calls
          the stuffer routines (near the exit). 1-Dec-94

          Procedure "GetMousePosition" did not test for 40-col. 1-Oct-95

          The int 21h patch caused windows to crash when DOS apps
          exited, because of "call dword ptr cs:[old_21h]", which
          corrupted the system stack. But "jmp dword ptr cs:[old_21h]"
          seems to be just fine. Now, InstallMouseHandler gets called
          before each program load and after each program exit. We will
          miss a CPM-style jump to address zero, but the /R switch will
          restart xPC-Mouse in this unlikely event. 10-Oct-95

          Documentation 1.0 claimed xpcmouse did not work in Win
          3.1. This is true for certain mouse device drivers and
          Win3.1 video drivers, especially those produced by
          hardware manufacturers before Win3.1 was released. 13-Oct-95

            For example, all DOS windows in Win3.1 get xPC-Mouse, for
            configuration DOS 6.2 + Win 3.1 + Genius mouse driver
            gmouse.com + 1994 Microsoft SVGA 256 video driver. In this
            example, xpcmouse.exe is installed in DOS 6.2 before running
            Win3.1. It fails for "gmouse.com" replaced by "mouse.com"
            obtained from the Win3.1 distribution disk!

          Buffer size was given in paragraphs in version 1.0, which is
          confusing. Changed to bytes in 1.1, with code to bump the byte
          count to full paragraphs. Default compile size changed to
          4096 maximum buffer size (BUFFERLEN variable is 4096) and
          default buffer size 2048 (no /B on command line). The choice
          of BUFFERLEN affects "loadhigh", because code+data must load
          entirely before we can shrink the package to its runtime size.

  BUTTON CONVENTIONS.
          A 2-button mouse (Microsoft) has a Left button and a Right
          button. A 3-button mouse (PC Mouse Systems) has a Left button,
          Right button and Middle button. The physical layout is not
          important, because most mouse drivers allow the buttons to be
          swapped. Our discussion here assumes a right-handed mouse
          (otherwise it would be completely confusing to read) and the
          configuration below for a unix workstation using Xterm
          conventions for the mouse buttons. To understand "button1" and
          "button3", consult the ++second++ diagram, not the first!

                              Ŀ    Ŀ
           Mouse button                               
           configuration       L   R       L   M   R  
           for the PC          1   2       1   2   3  
                                  
                              Ŀ    Ŀ
           Mouse button                               
           configuration       L   R       L   R   M  
           for unix console    1   2       1   2   3  
                                  
          If you work at a unix console, then consider remapping the
          mouse keys from order 123 to 132 (3-button PC Mouse Systems
          only). Do this via the mouse device driver that comes on a
          disk with the Mouse hardware. If you are left-handed, then
          swapping buttons is not a new idea.

 CONFIGURATION FOR 3-BUTTON MOUSE.
 Most of the cheap mice with 3 buttons are just fine. I bought one for
 $9.95. It came with a diskette of software and documentation. It is
 installed in autoexec.bat with a line like

        loadhigh c:\mouse\mouse.com /c2

 which specifies COM2 for the port. Everything else is configured by the
 driver and I needed to do NOTHING. When first installed it came up as
 "Microsoft Mouse". And it worked fine as a 2-button mouse. Following
 the instructions with the mouse, I pulled the mouse connector from the
 computer, then held down the left mouse button and plugged it back in,
 then released the button. After the machine rebooted, the screen said
 "Mouse Systems Mouse" installed.

 In short, there are no mouse driver switches to set in order to get the
 3-button mouse to act like one. No changes are made to the device
 driver command line.

 1997 update. The linux documentation project has a mouse page in which
   they describe how to make hardware modifications to certain mice so
   they will always wake up in Mouse Systems mode. Search for "mouse" on
   http://sunsite.unc.edu/pub/Linux/.

 But Microsoft windows 3.1 already had its mind made up that the mouse
 was a "Microsoft Mouse". So I had to run the Win 3.1 SETUP program
 (from inside Windows). The same thing can be accomplished by editing
 the SYSTEM.INI and WIN.INI sources in the windows directory, if you
 know how to do that.

 TESTING:
 The TSR was tested on about 6 different PC machines dating from 1984 to
 1996 manufacture. CPU's tested: 80286, 80386SX, 80386DX, 80486SX,
 80486DX, 80486DX2, 586-P75-133, P133. No workable XT 8088 could be
 found for testing! However, an XT style non-extended keyboard was used
 and found to work.

 Tested with XT turned off in the ASM code for 80386, 486DX120 and
 586-P75-133 cpu. It will probably not affect the TSR to do so, but the
 code by default does not make use of 80286+ opcodes or special features
 of int 16h. Some mouse drivers and BIOS combinations disable the TSR
 unless it is compiled with the 8088 code control symbol "XT", because
 the nonresident CPU and mouse BIOS tests cause the TSR to fail it's
 initial load. However, the failure is superficial: it may only affect
 de-install /U on most machines.

 Loads high with devices "HIMEM.SYS" and "EMM386.EXE noems" /w control
 "DOS=HIGH,UMB" under DOS 5.0 and 6.2. Loaded low with 386max, did not
 test loaded into high umb's under 386max.

 SUNPC EMULATOR. Works with DOS 4.01 under SoftPC version 3 (1992) for
  SUN4 OS (SunPC, DOS emulator from Sun Microsystems, standard
  configuration). This is the only mouse TSR known to work for DOS
  copy/paste/position in a unix environment (X-windows, DOS emulator).
  Used with COMMANDO TSR, no conflicts loaded low. Also works with WCED
  loaded high or low. In both, the arrow key feature allows positioning
  on the command line.

 DOSEMU EMULATOR. This driver can be installed as a replacement for the
  Linux programs "gpm" and "selection" under the DOS emulator called
  "dosemu", versions 0.60.4 and later (August 1995) for the Linux
  operating system (386/486 unix).

 MEMORY USAGE:
 Complaints about the TSR's resident size should take note that it will
 reside in high memory and eat about 5k of upper memory. By cutting
 out the pastebuffer, using option "/B0 /P", usage can be reduced to
 3k. A recompile, removing the arrow key code or the pastebuffer code
 will cause correspondingly significant code size reductions. Resident
 code size of 1.7k is possible, with cursor keys only, or 2.2k with
 paste buffer only (add 1k to 2k buffer).

 Vincent Penquerc'h (penquerc@merlin.enssat.fr) has a product called
 "CutPaste", which controls a paste buffer, plus a separate TSR
 called "Mousekey" which stuffs cursor keys into the keyboard buffer.
 Vincent's CutPaste product is shareware with a charge of 10
 dollars; his Mousekey is freeware, no charge. No sources are supplied.
 The claim is that "CutPaste" uses 1.9kb plus buffer space, or
 approximately 3952 bytes. Vincent's Mousekey uses 464 bytes (see also
 mouse02g.asm with about the same size). The total usage is 4416 bytes,
 smaller than xPCmouse. Vincent's package has the advantage of splitting
 the two functions into neat containers. Be aware that Vincent's
 Mousekey operates differently than xPCmouse: in his, the mouse cursor
 and text cursor are the same.

 Jrgen G. Weber still distributes the original incarnation of PCmouse
 which does copy and paste only (no cursor positioning), hence Vincent's
 CutPaste program has a competitor (PCmouse 1.6). These two programs are
 different: one may work for you and the other one not.

 Sources to Vincent's Mousekey may not be available; see instead
 Mouse2g.asm, mentioned above, and available from http://www.coast.net/.

 EDITORS TESTED:
 Remote over modem line: Emacs, vi, jed, jove, pi, joe, ce.
 Local PC: epsilon, pi, qedit, jed, csed.

 Special interfaces tested: emacs, jed, pi.
   For these, we had to write extension code for the editor involved, or
   else modify the sources. The standard "mousex.sl" in the JED library
   works as written. PI needed the unix Xterm mouse code enabled for
   compilation under DOS. EMACS needed a special LISP function for the
   mouse motions.

* ; End comment

comment *
GNU PUBLIC LICENSE.
   This software is released as copyrighted material under the GNU PUBLIC
   LICENSE:

                           NO WARRANTY

   Because xPC-Mouse is licensed free of charge, absolutely no warranty
   is provided, to the extent permitted by applicable state law.  Except
   when otherwise stated in writing, Jrgen G. Weber and Grant B.
   Gustafson provides xPC-Mouse "as is" without warranty of any kind,
   either expressed or implied, including, but not limited to, the
   implied warranties of merchantability and fitness for a particular
   purpose. The entire risk as to the quality and performance of the
   program is with you. Should the xPC-Mouse program prove defective,
   you assume the cost of all necessary servicing, repair or correction.

   In no event unless required by applicable law will Grant B. Gustafson
   and Jrgen G. Weber and/or any other party who may modify and
   redistribute xPC-Mouse be liable to you for damages, including any
   lost profits, lost monies, or other special, incidental or
   consequential damages arising out of the use or inability to use
   (including but not limited to loss of data or data being rendered
   inaccurate or losses sustained by third parties or a failure of the
   program to operate with programs not distributed by Grant B.
   Gustafson and Jrgen G. Weber) the program, even if you have been
   advised of the possibility of such damages, or for any claim by any
   other party.

NO COST?
   This software is provided free of charge to individuals and educational
   institutions. Money is not requested.

POSTCARDS?
   Postcards and comments are welcome!

   Jrgen G. Weber               GB Gustafson
   Wiesentalstrae 1             113 JWB Math Dept Univ Utah
   D-74523 Schwbisch Hall       Salt Lake City, UT 84112
   Germany - European Union      USA

* ; End comment
