Program gmice;

   { Illustrates the four graphics mouse cursors from gmouscur.inc, }
   {    plus the default graphics cursor.                           }

Uses mouse, graph;

{$i gmouscur.inc}

CONST  eventMask = $54;       { mask to trip event handler when any
                                           mouse button is released }

VAR    theMouse     : resetRec;
       driver, mode : INTEGER;
{ ----------------------------------------------------------------- }

PROCEDURE Identify (title : string);

    { Write name of cursor near top of screen }

VAR    x : INTEGER;

BEGIN
  SetViewPort (0, 0, GetMaxX, 30, TRUE);
  ClearViewPort;
  SetTextStyle (DefaultFont, HorizDir, 1);
  x := (GetMaxX - TextWidth (title)) DIV 2;
  OutTextXY (x, 20, title);
  SetViewPort (0, 0, GetMaxX, GetMaxY, TRUE);
END;
{ --------------------------- }

PROCEDURE GraphicScreen (title : string);

    { Creates a graphics screen and shows the title }

VAR    x, y   : INTEGER;
       prompt : string [30];

BEGIN
  InitGraph (driver, mode, '\DRIVERS');         { set graphics mode }
  IF GraphResult = grOk THEN BEGIN
    Identify (title);
    Prompt := 'Click any button to continue';
    x := (GetMaxX - TextWidth (prompt)) DIV 2;    { start of prompt }
    OutTextXY (x, GetMaxY - 20, prompt);

  { Prepare to draw a rectangle as a lighted backdrop for cursor }
    SetFillStyle (SolidFill, 1);
    SetColor (1);
    x := (GetMaxX DIV 2) - 50;
    y := (GetMaxY DIV 2) - 50;                        { set corners }
    Rectangle (x, y, x+100, y+100);                          { draw }
    FloodFill (GetMaxX DIV 2, GetMaxY DIV 2, 1);             { fill }
  END;
END;
{ --------------------------- }

PROCEDURE demo (cursor : gCursRec; title : STRING);

    { Show the indicated graphics cursor }

BEGIN
  Identify (title);
  mGraphCursor (cursor.hotX, cursor.hotY,
                seg (cursor.image^), ofs (cursor.image^));
  theEvents.flag := 0;
  REPEAT UNTIL theEvents.flag <> 0;
END;
{ --------------------------- }

BEGIN
{ Set up for run }
  Driver := CGA;
  Mode :=   CGAhi;
  InitGCurs;                         { initialize the cursor images }
  mReset (theMouse);
  IF theMouse.exists THEN BEGIN
    mInstTask (eventMask, seg (EventHandler), ofs (EventHandler));

{ Show default cursor }
    GraphicScreen ('Default cursor');
    mShow;
    theEvents.flag := 0;
    REPEAT UNTIL theEvents.flag <> 0;
  END;

{ Show the custom cursors }
  Demo (check, 'Check cursor');
  Demo (arrow, 'Left arrow cursor');
  Demo (cross, 'Cross cursor');
  Demo (hand,  'Pointing hand');
  Demo (iBeam, 'I-Beam cursor');
  mReset (theMouse);
  CloseGraph;
END.
