! Draw a Mandelbrot Set using ASCII characters. Resolution = 79x49.
! Compile with 'tx apfel.t'

const	SCALE = 100;	! try 10000 on 32bit systems

! const	FULL = 219, UPPER = 223, LOWER = 220, EMPTY = '\s';	! IBM PC
const	FULL = 'M', UPPER = '"', LOWER = 'm', EMPTY = '\s';	! ASCII


f(x, y) do
	var	cr, ci, zr, zi, ir;
	var	i;

	zr := 0;
	zi := 0;
	cr := x*SCALE/25;
	ci := y*SCALE/20;
	for (i=0, 100) do
		ir := zr*zr/SCALE - zi*zi/SCALE;
		zi := zr*zi/SCALE + zi*zr/SCALE + ci;
		zr := ir + cr;
		if (	zi > 2*SCALE \/ zr > 2*SCALE \/
			zi < %2*SCALE\/ zr < %2*SCALE
		)
			return 1;
	end
	return 0;
end


do
	var	x, y, r;
	var	line[80];
	var	even;

	even := 0;
	for (y=%24, 25) do
		for (x=-59, 20) do
			r := f(x,y);
			ie (even)
				line[x+59] := line[x+59]->
					r-> FULL: UPPER:
					r-> LOWER: EMPTY;
			else
				line[x+59] := r;
		end
		line[79] := 0;
		if (even) do writes(line); newline(); end
		even := \even;
	end
end

