Unit Compilify;
{* S Compiler, ver 1.00.
   Copyright (C) 1994, Henri LESOURD.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This compiler is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  *}

Interface

Uses
    Crt,
    Errorify,
    Symbolize,
    Lexify,
    Writify,
    Assemblify,
    Addressify,
    Expressify;

Procedure CompileInLine(B : BoxPtr);

{ ************
  CompileBlock
  ************ }
Var
   OpBox : Box;
   LPtr : LiNodePtr;

Procedure CompileBlock(B : BoxPtr);

{ *****************************
  Masquage des symboles globaux
  ***************************** }
Var
   SwappedSymbs : MaskedSymbPtr;

Procedure MaskSymb(S : SymbPtr);

{ ***************
  Alloc variables
  *************** }
Procedure CompileVarLocDec(A,TA : BoxPtr);
Procedure CompileVarGlobDec(A,TA : BoxPtr);
Procedure CompileVar(B,T : BoxPtr);
Procedure CompileParmDec(A,TA : BoxPtr);
Function CLP0(LP { ListParms },
              BT { BoxType },
              FA { FirstAs } : BoxPtr) : BoxPtr;
Function CLPN(LP { ListParms },
              BT { BoxType },
              AR { ARaccrocher },
              OUR { OURaccrocher },
              FA { FirstAs } : BoxPtr) : BoxPtr;
Procedure CompileListParms(Var B : BoxPtr);

{ ***********
  CompileBody
  *********** }
Var
   EnterLab : TypedAddress;
   WhereToPokeLenCS : Word;

Procedure CompileBody(B : BoxPtr);

{ **************
  CompilePackage
  ************** }
Procedure CompilePackage(B : BoxPtr);

{ ****
  Init
  **** }
Procedure Init;

Implementation

Procedure SetNbCR(W : Word);
Begin
  NbCR:=W;
  CallBackCR(W);
End;

Procedure CompileInLine(B : BoxPtr);
Var
   Fini : Boolean;
Begin
  Fini:=False;
  While Not Fini Do
    If B^.Nature=(Operator Or OpVirg) Then
      Begin
        If B^.Gauche=Nil Then Error('CompileInLine : syntax error');
        If (Nature(B^.Gauche^.Nature)=Constant) Or
           (Nature(B^.Gauche^.Nature)=Symbol)
        Then
          CompileInLine(B^.Gauche)
        Else
          Error('CompileInLine : syntax error');

        B:=B^.Droite;
      End
    Else
    If Nature(B^.Nature)=Constant Then
      Case B^.Nature And 3 Of
        ConstNum:
          Case NumLength(B^.Nature) Of
            Length8:
              Begin
                PokeB(ByteBoxPtr(B)^.Value);
                Fini:=True;
              End;
            Length16:
              Begin
                PokeW(WordBoxPtr(B)^.Value);
                Fini:=True;
              End;
            Else
              Error('Constant type ! recognized');
          End;
        Else
          Error('Constant type ! recognized');
      End
    Else
    If Nature(B^.Nature)=Symbol Then
    Begin
      Case SymbPtr(B)^.Addr.C Of
        Immediate:
          Case GetTypeSize(BoxPtr(SymbPtr(B)^.Addr.SType)) Of
            1: PokeB(Byte(SymbPtr(B)^.Addr.Value));
            2: PokeW(Word(SymbPtr(B)^.Addr.Value));
            4: Begin
                 PokeW(LoWord(SymbPtr(B)^.Addr.Value));
                 PokeW(HiWord(SymbPtr(B)^.Addr.Value));
               End;
            Else
              Error('InLine Symb Const : size=1|2|4 expected');
          End;
        CS,DS,SS: PokeW(Word(SymbPtr(B)^.Addr.Value));
        Else
          Error('InLine Symb : Imm, CS, DS, SS expected');
      End;
      Fini:=True;
    End
    Else
      Error('CompileInLine : syntax error');
End;

{ ***********
  CompileCase
  *********** }
Type
    BurstElemPtr=^BurstElem;
    BurstElem=Record
      Val : Word;
      Suiv : BurstElemPtr;
    End;
Var
   MinBu,MaxBu : Word;

Procedure PrintBurst(Bu : BurstElemPtr);
Begin
  Write('<');
  While Bu<>Nil Do
  Begin
    Write(Bu^.Val,' ');
    Bu:=Bu^.Suiv;
  End;
  Write('>');
End;

Procedure DropBurst(Bu : BurstElemPtr);
Var
   OldBu : BurstElemPtr;
Begin
  While Bu<>Nil Do
  Begin
    OldBu:=Bu;
    Bu:=Bu^.Suiv;
    Dispose(OldBu);
  End;
End;

Procedure PutBurst(Var Bu : BurstElemPtr; Val : Word);
Var
   CourBu,PrecBu,NewBu : BurstElemPtr;
Begin
  CourBu:=Bu;
  PrecBu:=Nil;
  While (CourBu<>Nil) And (CourBu^.Val<Val) Do
  Begin
    PrecBu:=CourBu;
    CourBu:=CourBu^.Suiv;
  End;
  If (CourBu<>Nil) And (CourBu^.Val=Val) Then Error('PutBurst');
  New(NewBu);
  NewBu^.Val:=Val;
  If PrecBu=Nil Then
    Begin
      NewBu^.Suiv:=Bu;
      Bu:=NewBu;
      MinBu:=Val;
    End
  Else
    Begin
      NewBu^.Suiv:=CourBu;
      PrecBu^.Suiv:=NewBu;
    End
    ;
  If CourBu=Nil Then MaxBu:=Val;
End;

Procedure EnterSymbols(B : BoxPtr; Var Bu : BurstElemPtr);
Var
   TA : TypedAddress;
Begin
  If B^.Nature<>Operator Or OpVirg Then
    Begin
      CalcConst(TA,B);
      If (TA.SType<>@SymbByte) And (TA.SType<>@SymbWord) Then Error('EnterSymbols : unsigned types exp');
      PutBurst(Bu,Word(TA.Value));
    End
  Else
    Begin
      EnterSymbols(B^.Gauche,Bu);
      EnterSymbols(B^.Droite,Bu);
    End;
End;

Procedure EnterLabels(B : BoxPtr; OfsBurst,MinBurst : Word);
Var
   TA : TypedAddress;
Begin
  If B^.Nature<>Operator Or OpVirg Then
    Begin
      CalcConst(TA,B);
      PokeWAt(OfsBurst+(Word(TA.Value)-MinBurst)*2,GetBPtr);
    End
  Else
    Begin
      EnterLabels(B^.Gauche,OfsBurst,MinBurst);
      EnterLabels(B^.Droite,OfsBurst,MinBurst);
    End;
End;

Procedure CompileCase(B : BoxPtr);
Var
   ElsePart,Current,Current0 : BoxPtr;
   TACond,LabelElse,LabelEnd : TypedAddress;
   Burst : BurstElemPtr;
   MinBurst,MaxBurst,W,OfsBurst,OfsElse : Word;
Begin
  Burst:=Nil;
  NewLabel(LabelElse);
  NewLabel(LabelEnd);
  If (B^.Droite^.Nature=(KeyWord Or KeyElse)) Then
    Begin
      ElsePart:=B^.Droite^.Droite;
      Current:=B^.Droite^.Gauche;
    End
  Else
    Begin
      ElsePart:=Nil;
      Current:=B^.Droite;
    End
    ;
  Current0:=Current;
  While Current<>Nil Do
  Begin
    EnterSymbols(Current^.Droite^.Gauche,Burst); { Condition }
    Current:=Current^.Gauche;
  End;
  MinBurst:=MinBu;
  MaxBurst:=MaxBu;
  DropBurst(Burst);
{ Check largeur de table }
  If MaxBurst-MinBurst+1>256 Then Error('Case : burst too large');
{ Condition }
  CompileExpr(TACond,B^.Gauche);
  LoadIt(TACond,TACond,DefaultMode);
  If (TACond.SType<>@SymbByte) And (TACond.SType<>@SymbWord) Then Error('Case : unsigned <16b types exp');
  If TACond.SType=@SymbByte Then CastIt(TACond,@SymbWord);
  ImmAddr.Value:=MinBurst;
  ImmAddr.SType:=@SymbWord;
  Assemble(CMP,TACond,ImmAddr);
  Assemble(JL,LabelElse,NullAddr);
  ImmAddr.Value:=MaxBurst;
  ImmAddr.SType:=@SymbWord;
  Assemble(CMP,TACond,ImmAddr);
  Assemble(JG,LabelElse,NullAddr);
  GetAddrReg16(TACond,TACond,True);
  Assemble(cSHL,TACond,ImmOne);
  PokeB($2E);
  TACond.C:=CS;
  TACond.M:=IndRegOfs;
  W:=GetBPtr;
  SetHiWord(TACond.Value,Integer(W)+3-2*MinBurst);
  TACond.SType:=@SymbLabel;
  Assemble(JMP,TACond,NullAddr);
  Case GetBPtr-W Of
    3:;
    4: PokeWAt(W+2,GetWAt(W+2)+1);
    Else
      Error('Euuhmaurrme khouill !!!!!!');
  End;
  OfsBurst:=GetBPtr;
{ Fill Burst First }
  For W:=MinBurst To MaxBurst Do PokeW(0);
{ Compile cases }
  Current:=Current0;
  While Current<>Nil Do
  Begin
    EnterLabels(Current^.Droite^.Gauche,OfsBurst,MinBurst); { Condition }
    CompileBlock(Current^.Droite^.Droite);
    Assemble(JMP,LabelEnd,NullAddr);
    Current:=Current^.Gauche;
  End;
{ Else }
  OfsElse:=GetBPtr;
  PutLabel(LabelElse);
  If ElsePart<>Nil Then CompileBlock(ElsePart);
{ Fill holes }
  For W:=MinBurst To MaxBurst Do
    If GetWAt(OfsBurst+(W-MinBurst)*2)=0 Then
      PokeWAt(OfsBurst+(W-MinBurst)*2,OfsElse)
      ;
{ Fini }
  PutLabel(LabelEnd);
End;

{ ************
  CompileBlock
  ************ }
Procedure CompileBlock(B : BoxPtr);
Var
   Fini : Boolean;
   AlwaysPart : BoxPtr;
   A1,A2,A3,TA0 : TypedAddress;
Begin
  Fini:=False;
  AlwaysPart:=Nil;
  If B=Nil Then Exit;
  While Not Fini Do
    Case (B^.Nature) Of
      KeyWord Or KeyCarriage,
      KeyWord Or KeyDeuxPoints:
        Begin
          CompileBlock(B^.Gauche);
          LPtr:=@B^;
          B:=B^.Droite;
          SetNbCR(LPtr^.NbCR);
        End;
      KeyWord Or KeyInLine:
        Begin
          CompileInLine(B^.Gauche);
          Fini:=True;
        End;
      KeyWord Or KeyLabel:
        Begin
          LPtr:=@B^;SetNbCR(LPtr^.NbCR);
          If SymbPtr(B^.Gauche)^.Addr.C<>Null Then
            Begin
            { Verifier isa(label de jump) et isnot(deja ete putte) }
              If (SymbPtr(B^.Gauche)^.Addr.SType<>@SymbLabel) Or
                 (SymbPtr(B^.Gauche)^.Addr.Value<$10000)
              Then
                Error('CompileBlock : Label Goto : redeclaration')
              ;
            End
          Else
            Begin
              MaskSymb(SymbPtr(B^.Gauche));
              NewLabel(SymbPtr(B^.Gauche)^.Addr);
            End
            ;
          PutLabel(SymbPtr(B^.Gauche)^.Addr);
          Fini:=True;
        End;
      KeyWord Or KeyGoto:
        Begin
          If SymbPtr(B^.Gauche)^.Addr.C<>Null Then
            Begin
            { Verifier isa(label de jump) }
              If (SymbPtr(B^.Gauche)^.Addr.SType<>@SymbLabel)
              Then
                Error('CompileBlock : Goto : bad label idf')
              ;
            End
          Else
            Begin
              MaskSymb(SymbPtr(B^.Gauche));
              NewLabel(SymbPtr(B^.Gauche)^.Addr);
            End
            ;
          Assemble(JMP,SymbPtr(B^.Gauche)^.Addr,NullAddr);
          Fini:=True;
        End;
      KeyWord Or KeyCase:
        Begin
          CompileCase(B);
          Fini:=True;
        End;
      KeyWord Or KeyIf:
        Begin
          If (B^.Gauche=Nil) Or (B^.Droite=Nil) Then Error('If : missing parts');
          A2:=CurLabel;
          NewLabel(CurLabel);
          InvCondJump:=True;
        { Il manque le cas If Idf Then. Id. While }
          CompileExpr(TA0,B^.Gauche);
          A3:=CurLabel;
          Case TA0.C Of
            Null:;
            Else
              Begin
                LoadIt(TA0,TA0,DefaultMode);
                ByteAddr:=GetTypeSize(BoxPtr(TA0.SType))=1;
                Assemble(CMP,TA0,ImmZero);
                ByteAddr:=False;
                Assemble(JZ,A3,NullAddr);
              End;
          End;
          If Not IsScalaire(TA0.SType){Boolean} Then Error('If : bad condition type');
          If B^.Droite^.Nature=KeyElse Then
            Begin
              If (B^.Droite^.Gauche=Nil) Or (B^.Droite^.Droite=Nil) Then Error('If : missing parts(2)');
              CompileBlock(B^.Droite^.Gauche);
              NewLabel(A1);
              Assemble(JMP,A1,NullAddr);
              PutLabel(A3);
              CompileBlock(B^.Droite^.Droite);
              PutLabel(A1);
            End
          Else
            Begin
              CompileBlock(B^.Droite);
              PutLabel(A3);
            End;

          CurLabel:=A2;
          Fini:=True;
        End;
      KeyWord Or KeyWhile,KeyWord Or KeyAlways:
        Begin
          If B^.Nature=Keyword Or KeyAlways Then
          Begin
            AlwaysPart:=B^.Gauche;
            B:=B^.Droite;
          End;
          NewLabel(A2);
          Assemble(JMP,A2,NullAddr);
          NewLabel(A1);
          PutLabel(A1);
          CompileBlock(B^.Droite);
          PutLabel(A2);
          If AlwaysPart<>Nil Then
          Begin
            CompileBlock(AlwaysPart);
            AlwaysPart:=Nil;
          End;
          CurLabel:=A1;
          InvCondJump:=False;
          CompileExpr(TA0,B^.Gauche);
          Case TA0.C Of
            Null:;
            Else
              Begin
                LoadIt(TA0,TA0,DefaultMode);
                ByteAddr:=GetTypeSize(BoxPtr(TA0.SType))=1;
                Assemble(CMP,TA0,ImmZero);
                ByteAddr:=False;
                Assemble(JNZ,A1,NullAddr);
              End;
          End;
          If Not IsScalaire(TA0.SType){Boolean} Then Error('While : bad condition type');
          CurLabel.C:=Null;
          Fini:=True;
        End;
      KeyWord Or KeyFor:
        Begin
        { Tests }
          If (B^.Gauche=Nil) Or
             ((B^.Gauche^.Nature<>KeyWord Or KeyTo) And
              (B^.Gauche^.Nature<>KeyWord Or KeyDownTo)
             )
           Or
             (B^.Gauche^.Gauche=Nil) Or
             (B^.Gauche^.Droite=Nil) Or
             (B^.Gauche^.Gauche^.Nature<>Operator Or OpLet) Or
             (B^.Gauche^.Gauche^.Gauche=Nil) Or
             (B^.Gauche^.Gauche^.Droite=Nil)
          Then
            Error('CompileBlock : For : bad B');

        { Init }
          CompileExpr(TA0,B^.Gauche^.Gauche);

        { La boucle }
          NewLabel(A2);
          Assemble(JMP,A2,NullAddr);
          NewLabel(A1);
          PutLabel(A1);
          CompileBlock(B^.Droite);

        { Incrmentation ou dcrmentation de la variable du For }
          CompileExpr(TA0,B^.Gauche^.Gauche^.Gauche);
          Case B^.Gauche^.Nature Of
            KeyWord Or KeyTo:     Assemble(CINC,TA0,NullAddr);
            KeyWord Or KeyDownTo: Assemble(CDEC,TA0,NullAddr);
            Else
              Error('CompileFor(2)');
          End;

        { Condition }
          PutLabel(A2);
          CurLabel:=A1;
          InvCondJump:=False;
          Case B^.Gauche^.Nature Of
            KeyWord Or KeyTo:     OpBox.Nature:=Operator Or OpInfEq;
            KeyWord Or KeyDownTo: OpBox.Nature:=Operator Or OpSupEq;
            Else
              Error('CompileFor(2)');
          End;
          OpBox.Gauche:=B^.Gauche^.Gauche^.Gauche;
          OpBox.Droite:=B^.Gauche^.Droite;
          CompileExpr(TA0,@OpBox);
          If TA0.SType<>@SymbInt{Boolean} Then Error('For : bad condition type');
          CurLabel.C:=Null;
          Fini:=True;
        End;
      Operator Or OpPouvr:
        Begin
          CompileCall(B^.Gauche,B^.Droite);
          Fini:=True;
        End;
      Else
        Begin
          If Nature(B^.Nature)=Symbol Then
            Begin
              If (SymbPtr(B)^.Addr.SType^.Nature=KeySub) Or
                 (SymbPtr(B)^.Addr.SType^.Nature=KeyDef)
              Then
                CompileCall(B,Nil)
              Else
                CompileExpr(TA0,B);
            End
          Else
            CompileExpr(TA0,B);

          Fini:=True;
        End;
    End;
End;

{ *****************************
  Masquage des symboles globaux
  ***************************** }
Procedure MaskSymb(S : SymbPtr);
Var
   M : MaskedSymbPtr;
Begin
  New(M);
  M^.Old:=S;
  M^.Addr:=S^.Addr;
  M^.Suiv:=SwappedSymbs;
  SwappedSymbs:=M;
End;

Procedure UnMaskSymbs;
Var
   OSS : MaskedSymbPtr;
Begin
  While SwappedSymbs<>Nil Do
  Begin
    OSS:=SwappedSymbs;
    SwappedSymbs:=SwappedSymbs^.Suiv;
    If (OSS^.Old^.Addr.SType=@SymbLabel) And (OSS^.Old^.Addr.Value>$FFFF)
    Then
      Error('Undeclared label')
      ;
    OSS^.Old^.Addr:=OSS^.Addr;
    Dispose(OSS);
  End;
End;

{ ******************
  Constantes nommes
  ****************** }
Var
   CurConstVal : TypedAddress;

Procedure CompileConstLocDec(A,VA : BoxPtr);
Begin
  If (A=Nil) Or (Nature(A^.Nature)<>Symbol) Then Error('CompileConstLocDec : Symbol expected');
  If SymbPtr(A)^.Addr.C=SS Then Error('CompileConstLoc : Redeclaration');
  MaskSymb(SymbPtr(A));
  If VA=Nil Then SymbPtr(A)^.Addr:=CurConstVal
  Else
    Begin
      CalcConst(SymbPtr(A)^.Addr,VA);
      CurConstVal:=SymbPtr(A)^.Addr;
    End
  ;
  Inc(CurConstVal.Value);
End;

Var
   CP : ConsPtr;
   InTheInterfax : Boolean;
Var
   NbExt : Integer; { TEST }

Procedure CompileConstGlobDec(A,VA : BoxPtr);
Begin
  If (A=Nil) Or (Nature(A^.Nature)<>Symbol) Then Error('CompileConstGlobDec : Symbol expected');
  If SymbPtr(A)^.Addr.C<>Null Then Error('CompileConstGlob : Redeclaration');
  If VA=Nil Then SymbPtr(A)^.Addr:=CurConstVal
  Else
    Begin
      CalcConst(SymbPtr(A)^.Addr,VA);
      CurConstVal:=SymbPtr(A)^.Addr;
    End
  ;
  Inc(CurConstVal.Value);
  If InTheInterfax Then
  { Conser le VarName si InTheInterfax }
    Begin
      New(CP);
      CP^.Car:=SymbPtr(A);
      CP^.Cdr:=Exports;
      Exports:=CP;
    End;
End;

Procedure CompileConst(B : BoxPtr);
Var
   Fini : Boolean;
Begin
  Fini:=False;
  While Not Fini Do
    If B^.Nature=(Operator Or OpVirg) Then
      Begin
        If B^.Gauche=Nil Then Error('CompileConst : syntax error');
        CompileConst(B^.Gauche);
        B:=B^.Droite;
      End
    Else
    If B^.Nature=Operator Or OpLet Then
      Begin
        If Imbricated Then CompileConstLocDec(B^.Gauche,B^.Droite)
                      Else CompileConstGlobDec(B^.Gauche,B^.Droite);
        Fini:=True;
      End
    Else
    If Nature(B^.Nature)=Symbol Then
      Begin
        If Not IsScalaire(CurConstVal.SType) Then Error('CompileConst : enum : last=scalar expected');
        If Imbricated Then CompileConstLocDec(B,Nil)
                      Else CompileConstGlobDec(B,Nil);
        Fini:=True;
      End
    Else
      Error('CompileConst : syntax error');
End;

Procedure CompileConstBlock(B : BoxPtr);
Var
   T : BoxPtr;
Begin
  If B=Nil Then Error('CompileConstBlock : Nil B');
  While (B^.Nature=KeyWord Or KeyCarriage) Or
        (B^.Nature=KeyWord Or KeyDeuxPoints) Do
  Begin
    T:=B^.Gauche;
    If T=Nil Then Error('CompileConstBlock.T=Nil');
    If Nature(T^.Nature)<>Symbol Then
    Begin
      If Nature(T^.Nature)<>Operator Then Error('CompileConstBlock.T^.Nature(1)');
      If (T^.Gauche=Nil) Or (T^.Droite=Nil) Then Error('CompileConstBlock.Nil(s)');
    End;
    CurConstVal:=ImmZero;
    CompileConst(T);
    LPtr:=@B^;
    SetNbCR(LPtr^.NbCR);
    B:=B^.Droite;
  End;
  T:=B; If T=Nil Then Error('CompileConstBlock.T=Nil');
  If Nature(T^.Nature)<>Symbol Then
  Begin
    If Nature(T^.Nature)<>Operator Then Error('CompileConstBlock.T^.Nature(1)');
    If (T^.Gauche=Nil) Or (T^.Droite=Nil) Then Error('CompileConstBlock.Nil(s)');
  End;
  CurConstVal:=ImmZero;
  CompileConst(T);
End;

{ *****************
  Types utilisateur
  ***************** }
Procedure CompileTypeLocDec(A,TA : BoxPtr);
Begin
  If (A=Nil) Or (Nature(A^.Nature)<>Symbol) Then Error('CompileTypeLocDec : Symbol expected');
  If SymbPtr(A)^.Addr.C=SS Then Error('CompileTypeLoc : Redeclaration');
  MaskSymb(SymbPtr(A));
  SymbPtr(A)^.Addr.C:=CType;
  BoxPtr(SymbPtr(A)^.Addr.Value):=TA;
End;

Procedure CompileTypeGlobDec(A,TA : BoxPtr);
Begin
  If (A=Nil) Or (Nature(A^.Nature)<>Symbol) Then Error('CompileTypeGlobDec : Symbol expected');
  If SymbPtr(A)^.Addr.C<>Null Then Error('CompileTypeGlobDec : Redeclaration');
  SymbPtr(A)^.Addr.C:=CType;
  BoxPtr(SymbPtr(A)^.Addr.Value):=TA;
  If InTheInterfax Then
  { Conser le VarName si InTheInterfax }
    Begin
      New(CP);
      CP^.Car:=SymbPtr(A);
      CP^.Cdr:=Exports;
      Exports:=CP;
    End;
End;

Procedure CompileRecord(B,T : BoxPtr);
Begin
  If Nature(B^.Nature)=Symbol Then
    Begin
      If Imbricated Then CompileTypeLocDec(B,T)
                    Else CompileTypeGlobDec(B,T);
    End
  Else
    Error('CompileRecord : SYMB is (ExprType) expected')
  ;
  CalcRecordType(BoxPtr(SymbPtr(B)^.Addr.Value));
End;

Procedure CompileType(B,T : BoxPtr);
Begin
  CalcType(T);
  If Nature(B^.Nature)=Symbol Then
    Begin
      If Imbricated Then CompileTypeLocDec(B,T)
                    Else CompileTypeGlobDec(B,T);
    End
  Else
    Error('CompileType : SYMB is (ExprType) expected');
End;

Procedure CompileTypeBlock(B : BoxPtr);
Var
   T : BoxPtr;
Begin
  If B=Nil Then Error('CompileTypeBlock : Nil B');
  While (B^.Nature=KeyWord Or KeyCarriage) Or
        (B^.Nature=KeyWord Or KeyDeuxPoints) Do
  Begin
    T:=B^.Gauche;
    If T=Nil Then Error('CompileTypeBlock.T=Nil');
    If (T^.Nature<>KeyWord Or KeyRecord) And
       (T^.Nature<>Operator Or OpIs)
    Then
      Error('CompileTypeBlock : RECORD or IS expected')
    ;
    If (T^.Gauche=Nil) Or (T^.Droite=Nil) Then Error('CompileTypeBlock.Nil(s)');
    If (T^.Nature=KeyWord Or KeyRecord) Then CompileRecord(T^.Gauche,T^.Droite)
                                        Else CompileType(T^.Gauche,T^.Droite);
    SetNbCR(LiNodePtr(B)^.NbCR);
    B:=B^.Droite;
  End;
  T:=B; If T=Nil Then Error('CompileTypeBlock.T=Nil');
  If (T^.Nature<>KeyWord Or KeyRecord) And
     (T^.Nature<>Operator Or OpIs)
  Then
    Error('CompileTypeBlock : RECORD or IS expected (2)')
  ;
  If (T^.Gauche=Nil) Or (T^.Droite=Nil) Then Error('CompileTypeBlock.Nil(s)');
  If (T^.Nature=KeyWord Or KeyRecord) Then CompileRecord(T^.Gauche,T^.Droite)
                                      Else CompileType(T^.Gauche,T^.Droite);
End;

{ ***************
  Alloc variables
  *************** }
Var
   StaticAted : Boolean;

Procedure CompileVarLocDec(A,TA : BoxPtr);
Begin
  If (A=Nil) Or (Nature(A^.Nature)<>Symbol) Then Error('CompileVarLocDec : Symbol expected');
  If SymbPtr(A)^.Addr.C=SS Then Error('CompileVarLoc : Redeclaration');
  MaskSymb(SymbPtr(A));
  If StaticAted Then
    Begin
      SymbPtr(A)^.Addr.C:=DS;
      SymbPtr(A)^.Addr.M:=IndOfs;
      SymbPtr(A)^.Addr.Value:=SizVarStat;
      Inc(SizVarStat,GetTypeSize(TA));
      SymbPtr(A)^.Addr.SType:=SymbPtr(TA);
    { Alignement }
      If SizVarStat Mod 2=1 Then Inc(SizVarStat,1);
    End
  Else
    Begin
      SymbPtr(A)^.Addr.C:=SS;
      SymbPtr(A)^.Addr.M:=IndOfs;
      Inc(SizVarLoc,GetTypeSize(TA));
    { Alignement }
      If SizVarLoc Mod 2=1 Then Inc(SizVarLoc,1);
      SymbPtr(A)^.Addr.Value:=-SizVarLoc;
      SymbPtr(A)^.Addr.SType:=SymbPtr(TA);
    End;
End;

Procedure CompileVarGlobDec(A,TA : BoxPtr);
Begin
  If (A=Nil) Or (Nature(A^.Nature)<>Symbol) Then Error('CompileVarGlobDec : Symbol expected');
  If SymbPtr(A)^.Addr.C<>Null Then Error('CompileVarGlob : Redeclaration');
  If NbExt=2 Then SymbPtr(A)^.Addr.C:=DS
             Else
             { TEST }
               Begin
                 Inc(NbExt);
                 SymbPtr(A)^.Addr.C:=Extern;
               End;
  SymbPtr(A)^.Addr.M:=IndOfs;
  SymbPtr(A)^.Addr.Value:=SizVarStat;
  Inc(SizVarStat,GetTypeSize(TA));
  SymbPtr(A)^.Addr.SType:=SymbPtr(TA);
  If InTheInterfax Then
  { Conser le VarName si InTheInterfax }
    Begin
      New(CP);
      CP^.Car:=SymbPtr(A);
      CP^.Cdr:=Exports;
      Exports:=CP;
    End;
{ Alignement }
  If SizVarStat Mod 2=1 Then Inc(SizVarStat,1);
End;

Procedure CompileVar(B,T : BoxPtr);
Var
   Fini : Boolean;
Begin
  Fini:=False;
  CalcType(T);
  While Not Fini Do
    If B^.Nature=(Operator Or OpVirg) Then
      Begin
        If B^.Gauche=Nil Then Error('CompileVar : syntax error');
        If Nature(B^.Gauche^.Nature)=Symbol Then
          CompileVar(B^.Gauche,T)
        Else
          Error('CompileVar : syntax error');

        B:=B^.Droite;
      End
    Else
    If Nature(B^.Nature)=Symbol Then
      Begin
        If Imbricated Then CompileVarLocDec(B,T)
                      Else CompileVarGlobDec(B,T);
        Fini:=True;
      End
    Else
      Error('CompileVar : syntax error');
End;

Procedure CompileParmDec(A,TA : BoxPtr);
Begin
  If (A=Nil) Or (Nature(A^.Nature)<>Symbol) Then Error('CompileParmDec : Symbol expected')
  Else
    Begin
      If SymbPtr(A)^.Addr.C=SS Then Error('CompileParm : Redeclaration');
      MaskSymb(SymbPtr(A));
      SymbPtr(A)^.Addr.C:=SS;
      SymbPtr(A)^.Addr.M:=IndOfs;
      SymbPtr(A)^.Addr.Value:=SizParms+SizBindings;
      Inc(SizParms,GetTypeSize(TA));
      SymbPtr(A)^.Addr.SType:=SymbPtr(TA);
    End;

{ Alignement }
  If SizParms Mod 2=1 Then Inc(SizParms,1);
End;

Function CLP0(LP { ListParms },
              BT { BoxType },
              FA { FirstAs } : BoxPtr) : BoxPtr;
Var
   AR { ARaccrocher } : BoxPtr;
Begin
  CalcType(BT);
  If (LP<>Nil) And (LP^.Nature=Operator Or OpVirg) Then
    Begin
      FA^.Gauche:=LP^.Gauche;
      FA^.Droite:=BT;
      CompileParmDec(LP^.Gauche,BT);
      LP^.Gauche:=FA;
      AR:=LP;
      LP:=LP^.Droite;
      While (LP<>Nil) And (LP^.Nature=Operator Or OpVirg) Do
      Begin
        FA:=NewBox(Operator Or OpAs);
        FA^.Gauche:=LP^.Gauche;
        FA^.Droite:=BT;
        CompileParmDec(LP^.Gauche,BT);
        AR^.Droite:=FA;
        LP^.Gauche:=AR;
        AR:=LP;
        LP:=LP^.Droite;
      End;
      FA:=NewBox(Operator Or OpAs);
      FA^.Gauche:=LP;
      FA^.Droite:=BT;
      CompileParmDec(LP,BT);
      AR^.Droite:=FA;
      CLP0:=AR;
    End
  Else
    Begin
      FA^.Gauche:=LP;
      FA^.Droite:=BT;
      CompileParmDec(LP,BT);
      CLP0:=FA;
    End;
End;

Function CLPN(LP { ListParms },
              BT { BoxType },
              AR { ARaccrocher },
              OUR { OURaccrocher },
              FA { FirstAs } : BoxPtr) : BoxPtr;
Begin
  CalcType(BT);
  While (LP<>Nil) And (LP^.Nature=Operator Or OpVirg) Do
  Begin
    FA^.Gauche:=LP^.Gauche;
    FA^.Droite:=BT;
    CompileParmDec(LP^.Gauche,BT);
    LP^.Gauche:=AR;
    AR:=LP;
    LP:=LP^.Droite;
    AR^.Droite:=FA;
    FA:=NewBox(Operator Or OpAs);
  End;
  FA^.Gauche:=LP;
  FA^.Droite:=BT;
  CompileParmDec(LP,BT);
  OUR^.Nature:=Operator Or OpVirg;
  OUR^.Gauche:=AR;
  OUR^.Droite:=FA;
  CLPN:=OUR;
End;

Procedure CompileListParms(Var B : BoxPtr);
Var
   BOld,ARaccrocher : BoxPtr;
Begin
  If (B=Nil) Or (B^.Gauche=Nil) Or (B^.Droite=Nil) Then Error('CompileListParms : Missing elements');
  If (B^.Nature<>Operator Or OpAs) Then Error('CompileListParms : As expected');
  BOld:=B;B:=B^.Droite;
  If B^.Nature=Operator Or OpAs Then
    Begin
      If (B^.Gauche=Nil) Or (B^.Droite=Nil) Or
         (B^.Gauche^.Gauche=Nil) Or (B^.Gauche^.Droite=Nil) Then Error('CompileListParms(2) : Missing elements');

      If BOld^.Gauche^.Nature=Operator Or OpVirg Then
        Begin
          If B^.Gauche^.Nature<>Operator Or OpPVirg Then Error('";" expected(1)');
        End
      Else
        If B^.Gauche^.Droite^.Nature<>Operator Or OpVirg Then
          Begin
            If B^.Gauche^.Nature<>Operator Or OpVirg Then Error('"," expected(2)');
          End
        Else
          If B^.Gauche^.Nature<>Operator Or OpPVirg Then Error('";" expected(3)');

      ARaccrocher:=CLP0(BOld^.Gauche,B^.Gauche^.Gauche,BOld);
      While B^.Droite^.Nature=Operator Or OpAs Do
      Begin
        BOld:=B;B:=B^.Droite;
        If (B^.Gauche=Nil) Or (B^.Droite=Nil) Or
           (B^.Gauche^.Gauche=Nil) Or (B^.Gauche^.Droite=Nil) Then Error('CompileListParms(3) : Missing elements');

        If BOld^.Gauche^.Droite^.Nature=Operator Or OpVirg Then
          Begin
            If B^.Gauche^.Nature<>Operator Or OpPVirg Then Error('";" expected(4)');
          End
        Else
          If B^.Gauche^.Droite^.Nature<>Operator Or OpVirg Then
            Begin
              If B^.Gauche^.Nature<>Operator Or OpVirg Then Error('"," expected(5)');
            End
          Else
            If B^.Gauche^.Nature<>Operator Or OpPVirg Then Error('";" expected(6)');

        ARaccrocher:=CLPN(BOld^.Gauche^.Droite,
                          B^.Gauche^.Gauche,
                          ARaccrocher,
                          BOld^.Gauche,
                          BOld);
      End;
      ARaccrocher:=CLPN(B^.Gauche^.Droite,
                        B^.Droite,
                        ARaccrocher,
                        B^.Gauche,
                        B);
    End
  Else
    ARaccrocher:=CLP0(BOld^.Gauche,B,BOld);

  B:=ARaccrocher;
End;

Procedure CompileVarBlock(B : BoxPtr);
Var
   T : BoxPtr;
Begin
  If B=Nil Then Error('CompileVarBlock : Nil B');
  While (B^.Nature=KeyWord Or KeyCarriage) Or
        (B^.Nature=KeyWord Or KeyDeuxPoints) Do
  Begin
    T:=B^.Gauche;
    If T=Nil Then Error('CompileVarBlock.T=Nil');
    If T^.Nature<>(Operator Or OpAs) Then Error('CompileVarBlock : AS expected');
    If (T^.Gauche=Nil) Or (T^.Droite=Nil) Then Error('CompileVarBlock.Nil(s)');
    CompileVar(T^.Gauche,T^.Droite);
    LPtr:=@B^;
    SetNbCR(LPtr^.NbCR);
    B:=B^.Droite;
  End;
  T:=B; If T=Nil Then Error('CompileVarBlock.T=Nil');
  If T^.Nature<>(Operator Or OpAs) Then Error('CompileVarBlock : AS expected');
  If (T^.Gauche=Nil) Or (T^.Droite=Nil) Then Error('CompileVarBlock.Nil(s)');
  CompileVar(T^.Gauche,T^.Droite);
End;

{ ***********
  CompileBody
  *********** }
Function TreeEQ(A,B : BoxPtr) : Boolean;
Var
   SA,SB : Symb;
Begin
  If A=B Then TreeEQ:=True
  Else
    If (A=Nil) Or (B=Nil) Then TreeEQ:=False
    Else
      If A^.Nature<>B^.Nature Then TreeEQ:=False
      Else
        Case Nature(A^.Nature) Of
          KeyWord,Operator: TreeEQ:=TreeEQ(A^.Gauche,B^.Gauche) And
                                    TreeEQ(A^.Droite,B^.Droite);
          Symbol:   TreeEQ:=SymbPtr(A)^.Name=SymbPtr(B)^.Name;
          Constant:
            Case A^.Nature And 3 Of
              ConstChar:   TreeEQ:=CharBoxPtr(A)^.Value=CharBoxPtr(B)^.Value;
              ConstString: TreeEQ:=StringBoxPtr(A)^.Value=StringBoxPtr(B)^.Value;
              ConstNum:
                Case NumLength(A^.Nature) Of
                  Length8:  TreeEQ:=ByteBoxPtr(A)^.Value=ByteBoxPtr(B)^.Value;
                  Length16: TreeEQ:=WordBoxPtr(A)^.Value=WordBoxPtr(B)^.Value;
                  Length32: TreeEQ:=LongBoxPtr(A)^.Value=LongBoxPtr(B)^.Value;
                  Else
                    Error('TreeEQ : Bad NumLength');
                End;
              Else
                Error('TreeEQ : Bad const');
            End;
          Else
            Error('TreeEQ : Bad nat');
        End;
End;

Var
   Right : BoxPtr;
   FName : SymbPtr;
   OldFName : Symb;
   FarFunc : Boolean;

Function CalcFuncType(B : BoxPtr) : BoxPtr;
Var
   T : BoxPtr;
   SPtr : SymbPtr;
Begin
{ Lecture TyResult => T }
  If B^.Nature=KeyWord Or KeyDef Then
    Begin
      If (B^.Gauche^.Nature<>Operator Or OpAs) Or
         (B^.Gauche^.Gauche=Nil) Or
         (B^.Gauche^.Droite=Nil)
      Then
        Error('Def : bad proto');

      T:=B^.Gauche;
      B^.Gauche:=B^.Gauche^.Gauche;
    End;

{ Check syntaxe proto Symb|Symb(Proto) }
  If Nature(B^.Gauche^.Nature)<>Symbol Then
    Begin
      If B^.Gauche^.Nature<>Operator Or OpPouvr Then Error('Sub/def declaration syntax error');
      If (B^.Gauche^.Gauche=Nil) Or
         (Nature(B^.Gauche^.Gauche^.Nature)<>Symbol) Then Error('Sub/def : func name : symbol expected');
    End;

{ Affecter la valeur du symbole fn }
  If Nature(B^.Gauche^.Nature)<>Symbol Then FName:=SymbPtr(B^.Gauche^.Gauche)
                                       Else FName:=SymbPtr(B^.Gauche);
{ Compil ListParms }
  OldFName:=FName^;
  SizParms:=0;
  If (FName^.Addr.C<>Null) Or FarFunc Then SizBindings:=6
  Else
    Begin
      FName^.Addr.C:=CS;
      SizBindings:=4;
    End;

  If Nature(B^.Gauche^.Nature)<>Symbol Then CompileListParms(B^.Gauche^.Droite);

{ Set Right }
  Right:=B^.Droite;

  SizVarLoc:=0;

{ Maj Result si def }
  If B^.Nature=KeyDef Then
    Begin
      CalcType(T^.Droite);
      CompileVarLocDec(@SymbResult,T^.Droite);
      New(SPtr);
      SPtr^:=SymbResult;
      GetRegisterResultLocation(SPtr^.Addr,T^.Droite);
      T^.Gauche:=BoxPtr(SPtr);
      B^.Droite:=T;
    End
  Else
    B^.Droite:=Nil;

  CalcFuncType:=B;
End;

Var
   H : Header;
   TA1 : TypedAddress;

Procedure CompileBody(B : BoxPtr);
Label
     InTheSubDef;
Var
   TA0 : TypedAddress;
   PasFini : Boolean;
   NewB : BoxPtr;
   W : Word;
Begin
  PasFini:=True;

  While PasFini Do
  Begin
    If Nature(B^.Nature)=KeyWord Then
      Begin
        LPtr:=@B^;
        SetNbCR(LPtr^.NbCR);
      End;

    Case B^.Nature Of
      KeyWord Or KeyConst:
        Begin
          CompileConstBlock(B^.Gauche);
          B:=B^.Droite;
        End;
      KeyWord Or KeyType:
        Begin
          CompileTypeBlock(B^.Gauche);
          B:=B^.Droite;
        End;
      KeyWord Or KeyVar:
        Begin
          CompileVarBlock(B^.Gauche);
          B:=B^.Droite;
        End;
      KeyWord Or KeyStatic:
        Begin
          If Not Imbricated Then Error('CompileBody : Static : Imbricated expected');
          StaticAted:=True;
          CompileVarBlock(B^.Gauche);
          StaticAted:=False;
          B:=B^.Droite;
        End;
      KeyWord Or KeyFar,
      KeyWord Or KeyDef,
      KeyWord Or KeySub:
        Begin
          If Imbricated Then Error('Imbricated subs ! Yet');
          NewB:=B;
          If NewB^.Nature=KeyWord Or KeyFar Then FarFunc:=True;
          B:=CalcFuncType(B^.Gauche);
          FarFunc:=False;

        { Fns Export : comparer les protos donns ds fax et Impl. }
          If FName^.Addr.C=NullExport Then
            If Not TreeEQ(B,BoxPtr(FName^.Addr.SType))
            Then
              Error('CompileBody : Export proto doesnt match');

        { Check redeclare }
          If (OldFName.Addr.C<>Null) And
             ((OldFName.Addr.C<>NullExport) Or
              (OldFName.Addr.SType=Nil) Or
              ((OldFName.Addr.SType^.Nature<>KeyWord Or KeySub) And
               (OldFName.Addr.SType^.Nature<>KeyWord Or KeyDef)
              )
             )
          Then
            Error('CompileBody : Sub/def : redeclaration');

        { NullExport }
          If FName^.Addr.C=NullExport Then
          Begin
            FName^.Addr.C:=Export;
            FName^.Addr.M:=IndOfs;
          End;

          Imbricated:=True;

        { Compil Enter(Func) }
          If FName^.Addr.C<>Export Then NewLabel(FName^.Addr);
          If NewB^.Nature=KeyWord Or KeyFar Then FName^.Addr.C:=Export;
          FName^.Addr.M:=IndOfs;
          FName^.Addr.SType:=SymbPtr(B);
          PutLabel(FName^.Addr);

          If FName^.Addr.C=Export Then
            Begin
              W:=GetBPtr;
              ImmAddr.Value:=H.DS;
              Assemble(MOV,Reg[AX],ImmAddr);
              H.DS:=GetBPtr-2;
              Assemble(MOV,Reg[rDS],Reg[AX]);
              SizHeadFarFuncs:=GetBPtr-W;
            End;

        { Compilation corps de la fn }
          SetNbCR(NbCR+1);
          CompileBody(Right);
        { Enreg. le type et faire generer le code pour Return(Result) si def }
          If NewB^.Nature=KeyDef Then
            Begin
              FreeAllRegs;
              Compile(TA0,@SymbResult);
              LoadIt(TA1,TA0,DefaultMode);
            End;

        { MOV SP,BP; POP BP; RETN SizParms }
          Assemble(MOV,Reg[SP],Reg[BP]);
          Assemble(POP,Reg[BP],NullAddr);
          If SizParms<>0 Then
            Begin
              ImmAddr.Value:=SizParms;
              If FName^.Addr.C=CS Then Assemble(RETN,ImmAddr,NullAddr)
                                  Else Assemble(RETF,ImmAddr,NullAddr);
            End
          Else
            If FName^.Addr.C=CS Then Assemble(RETN,NullAddr,NullAddr)
                                Else Assemble(RETF,NullAddr,NullAddr);

        { Demasquer }
          UnMaskSymbs;
          Imbricated:=False;
          B:=NewB^.Droite;
        End;
      KeyWord Or KeyEnter:
        Begin
          If B^.Gauche<>Nil Then Error('CompileBody : Enter');
          B:=B^.Droite;
          If Imbricated Then
            Begin
            { PUSH BP; MOV BP,SP; SUB SP,SizVarLoc }
              Assemble(PUSH,Reg[BP],NullAddr);
              Assemble(MOV,Reg[BP],Reg[SP]);
              ImmAddr.Value:=SizVarLoc; { ???? }
              If SizVarLoc<>0 Then Assemble(SUB,Reg[SP],ImmAddr);
              CompileBlock(B);
              PasFini:=False;
            End
          Else
            Begin
            { En-tte }
              PutLabel(EnterLab);
              SizVarLoc:=0;
              SizParms:=0;
              Case FT Of
                COM,BOOT:
                  Begin
                  { MOV BX,CS }
                    PokeW($CB8C);
                  { Si COM ADD BX,(BPtr+16)/16+$100
                    Sinon  ADD BX,(BPtr+16)/16 }
                    PokeW($C381);
                    WhereToPokeLenCS:=GetBPtr;
                    PokeW($ABCD);
                  { MOV DS,BX }
                    PokeW($DB8E);
                  { ADD BX,(SizVarStat+16)/16 }
                    ImmAddr.Value:=(SizVarStat+16) div 16;
                    Assemble(ADD,Reg[BX],ImmAddr);
                  { MOV SS,BX }
                    PokeW($D38E);
                  { MOV SP,FFFE }
                    ImmAddr.Value:=$FFFE;
                    Assemble(MOV,Reg[SP],ImmAddr);
                  { COM => MOV BP,SP }
                    If FT=COM Then Assemble(MOV,Reg[BP],Reg[SP]);
                  End;
                OBJ:
                  Begin
                    Assemble(PUSH,Reg[BP],NullAddr);
                    Assemble(MOV,Reg[BP],Reg[SP]);
                  End;
              End;
              CompileBlock(B);
            { MOV AH,4C; INT 21 }
              Case FT Of
                BOOT: Begin
                  PokeW($FEEB);
                End;
                COM: Begin
                  PokeW($4CB4);
                  PokeW($21CD);
                End;
                OBJ: Begin
                  Assemble(MOV,Reg[SP],Reg[BP]);
                  Assemble(POP,Reg[BP],NullAddr);
                { RETF }
                  PokeB($CB);
                End;
              End;
              Case FT Of
                BOOT,COM: PokeWAt(WhereToPokeLenCS,(GetBPtr+16) div 16);
              End;
              UnMaskSymbs;
              PasFini:=False;
            End;
        End;
      Else
        Error('CompileBody : Else');
    End;
  End;
End;

{ **************************************
  Affichage des types unpacked  l'cran
  ************************************** }
Procedure PutTypeAtScreen(T : TVArrayPtr);
Var
   S : SymbPtr;
Begin
  While IsValTV(Name(T^.Nature)) Do
  Begin
    If Not Nature(T^.Nature)=Symbol Then Error('PutType : Nat(T)=Symb expected');
    Case Name(T^.Nature) Of
      ValTVPtr:
        Write('(',Name(T^.Nature),' ',T^.Size,')');
      ValTVArray:
        Write('(',Name(T^.Nature),' ',T^.Size,' ',T^.NbElems,' ',T^.FirstInd,')');
      Else
        Error('PutType : Bad ValTV');
    End;
    T:=T^.Next;
  End;
  S:=@T^;
  If S^.Addr.C<>CType Then Error('PutType : Type val exp.');
  Write('(',Name(S^.Nature),' ',S^.Addr.Value,')');
End;

Procedure PutSigmaAtScreen(S : SymbPtr);
Begin
  WriteString(S^.Name);
  Write(',');
  PutTypeAtScreen(@S^.Addr.SType^);
  Write(',');
  WriteInt(LoWord(S^.Addr.Value),16);
  Writeln('');
End;

{ **************************
  Unpacking des uses headers
  ************************** }
Procedure WriteHeader(Var H : Header);
Var
   SP : ^String;
Begin
  Writeln('C0=',H.C0);
  Writeln('#CS=',H.SizCode);
  Writeln('Ofs(Start)=',H.OfsStart);
  Writeln('#DS=',H.SizData);
  Writeln('#Imports=',H.SizImports);
  SP:=@H;SP:=@SP^[SizeOf(H)];
  Writeln('Name=',SP^);
End;

Type
    WString=Array[0..$7000] Of Word;
    LString=Array[0..$FFEF] Of Char;
    LStringPtr=^LString;
    StringPtr=^String;
    WordPtr=^Word;

Function UnPackType(B : LStringPtr; Self : TVRecordPtr) : TVArrayPtr;
Var
   WPtr : ^WString;
   Fini : Boolean;
   Result,Last,Current : TVArrayPtr;
   TVPPtr : TVPtrPtr;
   LenType : Word;
   BPtr : BoxPtr;
   LastInTheTree : ^BoxPtr;
   TheEndPtr : LStringPtr;
   TVRPtr : TVRecordPtr;
   RE1,RE2 : TVRecElemPtr;
   S : SymbPtr;
   N : Word;
Begin
  Fini:=False;
  Last:=Nil;
  Result:=Nil;
  LenType:=WordPtr(@B^[0])^;
  B:=@B^[2];
  If (Ord(B^[0])=ValTVSub) Or (Ord(B^[0])=ValTVDef) Then
    Begin
    { Init EndPtr }
      TheEndPtr:=@B^[LenType];
    { UnPack Result Def }
      If Ord(B^[0])=ValTVSub Then
        Begin
          BPtr:=NewBox(KeyWord Or KeySub);
          B:=@B^[1];
        End
      Else
        Begin
          BPtr:=NewBox(KeyWord Or KeyDef);
        { Def : Unpack resu, sans calcul d'@ de Result }
          BPtr^.Droite:=NewBox(Operator Or OpAs);
          B:=@B^[1];
          BPtr^.Droite^.Droite:=BoxPtr(UnPackType(B,Self));
          New(SymbPtr(BPtr^.Droite^.Gauche));
          SymbResult.Addr.SType:=SymbPtr(BPtr^.Droite^.Droite);
          GetRegisterResultLocation(SymbResult.Addr,BoxPtr(SymbResult.Addr.SType));
          SymbPtr(BPtr^.Droite^.Gauche)^:=SymbResult;
          B:=@B^[WordPtr(@B^[0])^+2];
        End;

    { UnPack Parms, le champ NAME de la fn n'y est pas, son
      setting se trouve ds UnpackSigma }
      Result:=TVArrayPtr(BPtr);
      LastInTheTree:=@BPtr^.Gauche;
      While B<>TheEndPtr Do
      Begin
        BPtr:=NewBox(Operator Or OpAs);
        BPtr^.Droite:=BoxPtr(UnPackType(B,Self));
        B:=@B^[WordPtr(@B^[0])^+2];
        If B=TheEndPtr Then
          Begin
            LastInTheTree^:=BPtr;
          End
        Else
          Begin
            LastInTheTree^:=NewBox(Operator Or OpVirg);
            LastInTheTree^^.Droite:=BPtr;
            LastInTheTree:=@LastInTheTree^^.Gauche;
          End;
      End;
    End
  Else
    While Not Fini Do
    Begin
    { Ord(B^[0])=Name(Nature) }
      WPtr:=@B^[1];
    { WPtr^[0]=Size }
      Case Ord(B^[0]) Of
        ValTVArray:
          Begin
          { WPtr^[1]=NbElems
            WPtr^[2]=FirstInd }
            New(Current);
            Current^.Nature:=Symbol Or ValTVArray;
            Current^.Size:=WPtr^[0];
            Current^.NbElems:=WPtr^[1];
            Current^.FirstInd:=WPtr^[2];
            B:=@WPtr^[3];
          End;
        ValTVRecord:
          Begin
          { WPtr^[1]=#Champs }
            New(TVRPtr);
            TVRPtr^.Nature:=Symbol Or ValTVRecord;
            TVRPtr^.Size:=WPtr^[0];
            N:=WPtr^[1];
            B:=@WPtr^[2];
            If N=0 Then Error('UnPackType : Record : #Fields<>0 expected');
            New(TVRPtr^.First);
            RE1:=TVRPtr^.First;
            Repeat
              S:=FindSymb(StringPtr(B)^);
              If S=Nil Then S:=NewSymb(StringPtr(B)^);
              RE1^.Name:=S;
              B:=@B^[Ord(B^[0])+1];
              RE1^.SType:=SymbPtr(UnPackType(B,TVRPtr));
              B:=@B^[WordPtr(@B^[0])^+2];
              Dec(N);
              If N=0 Then RE1^.Next:=Nil Else
              Begin
                New(RE1^.Next);
                RE1:=RE1^.Next;
              End;
            Until N=0;
            Fini:=True;
            Current:=Pointer(TVRPtr);
          End;
        ValTVPtr:
          Begin
            New(TVPPtr);
            Current:=TVArrayPtr(TVPPtr);
            Current^.Nature:=Symbol Or ValTVPtr;
            Current^.Size:=WPtr^[0];
            B:=@WPtr^[1];
          End;
        ValTVRef:
          Begin
            New(TVPPtr);
            Current:=TVArrayPtr(TVPPtr);
            Current^.Nature:=Symbol Or ValTVRef;
            Current^.Size:=WPtr^[0];
            B:=@WPtr^[1];
          End;
        PredByte:
          Begin
            Current:=@SymbByte;
            Fini:=True;
          End;
        PredShortInt:
          Begin
            Current:=@SymbShortInt;
            Fini:=True;
          End;
        PredWord:
          Begin
            Current:=@SymbWord;
            Fini:=True;
          End;
        PredLongWord:
          Begin
            Current:=@SymbLongWord;
            Fini:=True;
          End;
        PredInt:
          Begin
            Current:=@SymbInt;
            Fini:=True;
          End;
        PredLongInt:
          Begin
            Current:=@SymbLongInt;
            Fini:=True;
          End;
        PredPointer:
          Begin
            Current:=@SymbPointer;
            Fini:=True;
          End;
        PredReference:
          Begin
            Current:=@SymbReference;
            Fini:=True;
          End;
        PredSelf:
          Begin
            If Self=Nil Then Error('UnPackType : Self');
            Current:=TVArrayPtr(Self);
            Fini:=True;
          End;
        Else
          Error('UnPackType : Bad type val');
      End;
      If Result=Nil Then Result:=Current;
      If Last<>Nil Then Last^.Next:=Pointer(Current);
      Last:=Current;
    End;

  UnPackType:=Result;
End;

Function UnPackSigma(Var S : SymbPtr; B : LStringPtr) : Pointer;
Var
   LenT : Word;
   WP : ^Word;
   LP : ^LongInt;
   Typ : Pointer;
Begin
{ B^=Name }
{ Recherche du symbole }
  S:=FindSymb(StringPtr(B)^);
  If S=Nil Then S:=NewSymb(StringPtr(B)^)
  Else
    If S^.Addr.C<>Null Then Error('UnpackSigma : Redeclaration');

  B:=@B^[Ord(B^[0])+1];
  If Ord(B^[2])=ValTVType Then
  Begin
    S^.Addr.C:=CType;
    B:=@B^[3];
    Pointer(S^.Addr.Value):=UnPackType(B,Nil);
    WP:=@B^[WordPtr(@B^[0])^+2];
    UnPackSigma:=Pointer(WP);
  End
  Else
  If Ord(B^[2])=ValTVConst Then
  Begin
    S^.Addr.C:=Immediate;
    B:=@B^[3];
    Pointer(S^.Addr.SType):=UnPackType(B,Nil);
    B:=@B^[WordPtr(@B^[0])^+2];
    WP:=Pointer(B);LP:=Pointer(B);
    Case GetTypeSize(BoxPtr(S^.Addr.SType)) Of
      2: Begin
           S^.Addr.Value:=WP^;
           WP:=@B^[2];
         End;
      4: Begin
           S^.Addr.Value:=LP^;
           WP:=@B^[4];
         End;
      Else
        Error('UnPackSigma : Imm : bad type size');
    End;
    UnPackSigma:=Pointer(WP);
  End
  Else
  Begin
    LenT:=WordPtr(@B^[0])^;
    Typ:=UnPackType(B,Nil);
  { Typ=Type }
  { PutTypeAtScreen(Typ); }
    WP:=@B^[LenT+2];
  { WP^=Offset }
  { WriteInt(WP^,16); }
  { Settings S }
    S^.Addr.C:=Extern;
    S^.Addr.M:=IndOfs;
    SetHiWord(S^.Addr.Value,Integer($FFFF));
    SetLoWord(S^.Addr.Value,Integer(WP^));
    If (BoxPtr(Typ)^.Nature=KeyWord Or KeySub) Or
       (BoxPtr(Typ)^.Nature=KeyWord Or KeyDef)
    Then
      If BoxPtr(Typ)^.Gauche=Nil Then
        Begin
          BoxPtr(Typ)^.Gauche:=BoxPtr(S);
        End
      Else
        Begin
          S^.Addr.SType:=SymbPtr(BoxPtr(Typ)^.Gauche);
          BoxPtr(Typ)^.Gauche:=NewBox(Operator Or OpPouvr);
          BoxPtr(Typ)^.Gauche^.Gauche:=BoxPtr(S);
          BoxPtr(Typ)^.Gauche^.Droite:=BoxPtr(S^.Addr.SType);
        End;

  { Set SType }
    S^.Addr.SType:=Typ;

  { Result }
    B:=Pointer(WP);
    UnPackSigma:=@B^[SizeOf(WP^)];
  End;
End;

Function GetPakHeader(B : SymbPtr) : ConsPtr;
Type
    Segment=Array[0..$FFFE] Of Byte;
Var
   SP : StringPtr;
   S : String;
   F : File;
   H : HeaderPtr;
   Buf : ^Segment;
   TheEndPtr : Pointer;
   CS : ^Segment;
   C0,Ptr : Word;
   US : SymbPtr; { UnpackedSymb }
   Result,CP : ConsPtr;
Begin
  If Nature(B^.Nature)<>Symbol Then Error('GetPakHeader : Symbol expected');
  SP:=GetStringAddr(B^.Name);
  S:=SP^;
  S:=Concat(S,'.Pak');
  If Not FileExists(S) Then Error('GetPakHeader : File not found');
{ Init result }
  New(Result);
  Result^.Car:=B;
  Result^.Cdr:=Nil;
{ Open }
  Assign(F,S);
  S[0]:=Chr(Ord(S[0])-4);
  Reset(F,1);
{ C0,Header }
  BlockRead(F,C0,SizeOf(C0));
{ Alloc Buf }
  GetMem(Buf,C0+2);
  If Buf=Nil Then Error('GetPakHeader::AllocBuf : out of memory');
  H:=Pointer(Buf);
  H^.C0:=C0;
  SP:=@Buf^[SizeOf(H^.C0)];
  BlockRead(F,SP^,H^.C0);
  SP:=Pointer(H);SP:=@SP^[SizeOf(H^)];
  If SP^<>S Then Error('GetPakHeader : File name and package name doesnt match');
{ WriteHeader(H^); }
{ Exports }
  TheEndPtr:=@Buf^[H^.C0+2];
  SP:=@Buf^[SizeOf(H^)];
  SP:=@SP^[Ord(SP^[0])+1];
  While SP<>TheEndPtr Do
  Begin
    SP:=UnPackSigma(US,LStringPtr(SP));
    New(CP);
    CP^.Car:=US;
    CP^.Cdr:=Result^.Cdr;
    Result^.Cdr:=CP;
  { Writeln; }
  End;
{ Close }
  Close(F);
{ Result }
  GetPakHeader:=Result;
  FreeMem(Buf,C0+2);
End;

Procedure CompileUses(B : BoxPtr);
Var
   LI,CP : ConsPtr;
Begin
  While B^.Nature=Operator Or OpVirg Do
  Begin
    LI:=GetPakHeader(SymbPtr(B^.Gauche));
    New(CP);
    CP^.Car:=SymbPtr(LI);
    CP^.Cdr:=Imports;
    Imports:=CP;
    B:=B^.Droite;
  End;
  LI:=GetPakHeader(SymbPtr(B));
  New(CP);
  CP^.Car:=SymbPtr(LI);
  CP^.Cdr:=Imports;
  Imports:=CP;
End;

{ **************
  CompilePackage
  ************** }
Var
   PackageName : SymbPtr;
   StrPtr : ^String;

Procedure CompilePackage(B : BoxPtr);
Type
    ByteBuf=Array[0..$FFFE] Of Byte;
    ByteBufPtr=^ByteBuf;
Var
   PasFini : Boolean;
   SPtr : SymbPtr;
   Last,NewB : BoxPtr;
   CP : ConsPtr;
   I : Integer;
   OfsH : Word;
Begin
{ Inits }
  InTheInterfax:=True;
  Exports:=Nil;
  Imports:=Nil;
  Last:=Nil;
  H.DS:=$FFFF;
{ Check "Package Name", avec Name corresp. au filename }
  If Name(B^.Nature)<>KeyWord Or KeyPackage Then Error('CompilePackage : Bad Tree : "Package" Expected');
  PackageName:=@B^.Gauche^;
  If Nature(PackageName^.Nature)<>Symbol Then Error('CompilePackage : PackageName : Symbol expected');
  B:=B^.Droite;
{ Uses : 1 seul authoryzhed }
  If B^.Nature=KeyWord Or KeyUses Then
    Begin
      CompileUses(B^.Gauche);
      B:=B^.Droite;
    End;
{ fax }
  If B^.Nature=KeyWord Or KeyInterface Then
  Begin
    Last:=B;B:=B^.Droite;
    While PasFini Do
      Case Name(B^.Nature) Of
        KeyWord Or KeyConst:
          Begin
            CompileConstBlock(B^.Gauche);
            B:=B^.Droite;
          End;
        KeyWord Or KeyType:
          Begin
            CompileTypeBlock(B^.Gauche);
            B:=B^.Droite;
          End;
        KeyWord Or KeyVar:
          Begin
            CompileVarBlock(B^.Gauche);
            B:=B^.Droite;
          End;
        KeyDef,KeySub:
          Begin
            If B^.Gauche=Nil Then Error('CompilePackage : syntax error (1)');

            B:=CalcFuncType(B);
            SizParms:=0;
            SizVarLoc:=0;
            UnMaskSymbs;
            If OldFName.Addr.C<>Null Then Error('Interface (func) : redeclaration');

            NewLabel(FName^.Addr);
            FName^.Addr.C:=NullExport;
            FName^.Addr.SType:=SymbPtr(B);

          { Foutre le symbole ds les exports }
            New(CP);
            CP^.Car:=FName;
            CP^.Cdr:=Exports;
            Exports:=CP;

          { Passer  la suite }
            B:=Right;
          End;
        Else
          Begin
            PasFini:=False;
          End;
      End;
    { Implm. }
      If B^.Nature=KeyWord Or KeyImplementation Then B:=B^.Droite
      Else
        Error('CompilePackage : "Implementation" expected');
  End;

{ Body }
  InTheInterfax:=False;
  CompileBody(B);

{ ******************************************************
  Pourrait tre entirement foutu ds RecordObjFile, sous
  rserve de transmettre les infos ncssaires.
  ****************************************************** }
  H.SizCode:=GetBPtr;

{ Padding 16b }
  While GetBPtr And $0F<>0 Do PokeB($AA);
  OfsH:=GetBPtr;
{ Rservation place pour le header }
  For I:=1 To SizeOf(Header) Do PokeB(0);
  PokeStr(PackageName^.Name);

{ Record exports }
  While Exports<>Nil Do
  Begin
    If Exports^.Car^.Addr.C=Null Then Error('CompilePackage : Big couille (Put exports sigmas : Null addr)');
    If Exports^.Car^.Addr.C=NullExport Then Error('CompilePackage : Interface Def/Sub without body');
    PutSigma(Exports^.Car);
    Exports:=Exports^.Cdr;
  End;

{ Record header + imports }
  StrPtr:=GetStringAddr(PackageName^.Name);
  H.C0:=GetBPtr-OfsH-2;
  H.OfsStart:=LoWord(EnterLab.Value);
  H.SizData:=SizVarStat;
  H.SizImports:=$FFFF;
  H.CS:=$FFFF;
  HeaderPtr(@ByteBufPtr(GetByteCode)^[OfsH])^:=H;
  RecordObjFile(HeaderPtr(@ByteBufPtr(GetByteCode)^[OfsH])^,PackageName^.Name);
End;

{ ***************
  Initialisations
  *************** }
Procedure Init;
Var
   I : Integer;
Begin
{ Init Addressify }
  StartAddressify;
{ NbCR }
  NbCR:=0;
{ Predef }
  NullAddr.C:=Null;
  ImmAddr.C:=Immediate;
  ImmOne.C:=Immediate;
  ImmOne.Value:=1;
  ImmOne.SType:=@SymbWord;
  ImmZero.C:=Immediate;
  ImmZero.Value:=0;
  ImmZero.SType:=@SymbWord;
{ Registres }
  Reg[AX].C:=Register;Reg[BX].C:=Register;
  Reg[CX].C:=Register;Reg[DX].C:=Register;
  Reg[SP].C:=Register;Reg[BP].C:=Register;
  Reg[SI].C:=Register;Reg[DI].C:=Register;
  Reg[rCS].C:=Register;Reg[rDS].C:=Register;
  Reg[rSS].C:=Register;Reg[rES].C:=Register;
  Reg[AX].Value:=AX;Reg[BX].Value:=BX;
  Reg[CX].Value:=CX;Reg[DX].Value:=DX;
  Reg[SP].Value:=SP;Reg[BP].Value:=BP;
  Reg[SI].Value:=SI;Reg[DI].Value:=DI;
  Reg[rCS].Value:=rCS;Reg[rDS].Value:=rDS;
  Reg[rSS].Value:=rSS;Reg[rES].Value:=rES;
  Reg[AX].SType:=@SymbInt;Reg[BX].SType:=@SymbInt;
  Reg[CX].SType:=@SymbInt;Reg[DX].SType:=@SymbInt;
  Reg[SP].SType:=@SymbInt;Reg[BP].SType:=@SymbInt;
  Reg[SI].SType:=@SymbInt;Reg[DI].SType:=@SymbInt;
  Reg[rCS].SType:=@SymbInt;Reg[rDS].SType:=@SymbInt;
  Reg[rSS].SType:=@SymbInt;Reg[rES].SType:=@SymbInt;
{ RegContains,DontUse }
  DontUseThisAddr:=Reg[AX];
  RegContains[AX]:=@DontUseThisAddr;
  RegContains[BX]:=@DontUseThisAddr;
  RegContains[CX]:=@DontUseThisAddr;
  RegContains[DX]:=@DontUseThisAddr;
  RegContains[SI]:=@DontUseThisAddr;
  RegContains[DI]:=@DontUseThisAddr;
  RegContains[rCS]:=@DontUseThisAddr;
  RegContains[rDS]:=@DontUseThisAddr;
  RegContains[rSS]:=@DontUseThisAddr;
  RegContains[rES]:=@DontUseThisAddr;
{ Compile }
  SizVarStat:=0;
  SwappedSymbs:=Nil;
  Imbricated:=False;
  CurLabel.C:=Null;
  InTheInterfax:=False;
{ StaticAted }
  StaticAted:=False;
{ FarFunc }
  FarFunc:=False;
{ ****
  TEST
  **** }
  NbExt:=2;
End;

Begin
End.