{$N+}
Program fitit;

{Fitit Version 1.1 Compilable in Turbo Pascal 7.0 and higher.
 Needs units Fhrpr10.pas (included)
         and InvUse10.pas (included)
         and GraphApp.pas (A "Turbo Vision Demo"-unit).

 This program is working, but that's all it does. Don't rely on the outcomes
 just yet. :-)
 Please give me suggestions how to improve this program on these points:
 - How can I get better(more accurate than 3 decimals) Student t values?
 - How do you calculate Standard Deveations in functions with Powers higher
   than 1?
 - How can I calculate WITH weighting factors, without getting a illegal
   floating point operation?
 - How can I improve the user-friendlyness of this programme?
 - How can you print graphical on other printers than EPSON and STAR printers?

 These or any other remarks (hopefully good ones), please send to:
 f.h.reincke@chemail.chem.ruu.nl
}

Uses App,Dialogs,Drivers,Menus,MsgBox,Objects,Printer,StdDlg,Views,Graphapp,crt,graph
     ,FHRPr10,InvUse10;

Type pPoint2 = ^tPoint2;
     tPoint2 = record
                x,y,dy:extended;
               end;
     tProg   = object(tapplication)
                Constructor Init;
                Procedure InitMenubar; virtual;
                Procedure InitStatusLine; virtual;
                Procedure HandleEvent(var Event: tEvent); virtual;
               end;
     pOptions = ^tOptions;
     tOptions = object(tdialog)
                pStanddev : pCheckBoxes;
                pXLine : pInputLine;
                pYLine : pInputLine;
                Constructor Init(var Bounds:tRect;ATitle:tTitleStr);
                Procedure HandleEvent(var Event:tEvent); virtual;
                Function StDevToo:boolean;
               end;
     pPointCollection = ^TPointCollection;
     tPointCollection = object(tSortedCollection)
                        Constructor Init;
                        Function Compare(Key1,Key2:pointer):integer; virtual;
                       end;
     pPointList = ^tPointList;
     tPointList = object(tListViewer)
                  pList : pPointCollection;
                  Constructor Init(var Bounds:tRect;AScrollBar:pScrollBar;AList:pPointCollection);
                  Function GetText(Item,MaxLen:Integer):string; virtual;
                 end;
     pLine = ^tLine;
     tLine = object(tView)
              Procedure Draw; virtual;
              Procedure SetState(AState:word;Enable:Boolean);virtual;
             end;
     pPointHolder = ^tPointHolder;
     tPointHolder = object(tDialog)
                    pList : pPointCollection;
                    pViewList : pPointList;
                    pScrl : pScrollBar;
                    Constructor Init(var Bounds:tRect);
                    Procedure AddPoint;
                    Procedure CalcSums;
                    Procedure HandleEvent(var Event:tEvent); virtual;
                    Procedure GetExtremes(var min,max:extended);
                    Function GetNrOfPoints:word;
                   end;
     pPointDial = ^tPointDial;
     tPointDial = object(tDialog)
                   pX  : pInputLine;
                   pY  : pInputline;
                   pdY : pInputline;
                   ViaKey : boolean;
                   Constructor Init(Item:Integer;StartCar:Char);
                   Procedure HandleEvent(var Event:tEvent); virtual;
                  end;
     pOrder     = ^tOrder;
     tOrder     = object(tRadiobuttons)
                   Procedure Press(Item:Integer); virtual;
                   Procedure MovedTo(Item:Integer); virtual;
                  end;
     pFit       = ^tFit;
     tFit       = object(tDialog)
                   pBut : pOrder;
                   pBox : pResultView;
                   pRow : array[1..10] of pCollection;
                   k0,k1,k2,k3,k4,k5,k6,k7,k8,k9,k10 : extended;
                   s0,s1,s2,s3,s4,s5,s6,s7,s8,s9,s10 : extended;
                   cc,D,E :extended;
                   Constructor Init(NrPoints:integer;List:pPointCollection);
                   Procedure HandleEvent(var Event:tEvent); virtual;
                   Procedure Calculate1stDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure Calculate2ndDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure Calculate3rdDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure Calculate4thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure Calculate5thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure Calculate6thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure Calculate7thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure Calculate8thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure Calculate9thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure Calculate10thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);
                   Procedure InvertCalc(Power:byte;NrPoint:integer;WriteIt:boolean);
                   Procedure Entertext(Nr:byte;txt:string);
                   Procedure ShowGraph(Mode:word);
                  end;
     Stelsel = array[1..12,1..11] of extended;

Const cmNames   = 100; hcList = 1000;
      cmAdd     = 101; hcEditPoint = 1001;
      cmDel     = 102; hlLoad = 1;
      cmEnter   = 103; hlSave = 2;
      cmError   = 104; hcInvList = 1002;
      cmAccept  = 105;
      cmCalc    = 106;
      cmLoad    = 107;
      cmGraph   = 108;
      cmPrint   = 109;
      cmOrderChanged = 110;
      cmInvEnter= 110;
      cmInvDel  = 111;

Var naam:string;
    pOpt : pOptions;
    pHolder : pPointHolder;
    MainPoint : tPoint2;
    BestFit : extended;
    Best    : byte;
    pFitit : pFit;
    pInvert : pInverted;
    Ex,Ex2,Ex3,Ex4,Ex5,Ex6,Ex7,Ex8,Ex9,Ex10,Ex11,Ex12,Ex13,Ex14,Ex15,Ex16,Ex17,Ex18,Ex19,Ex20,
    Ey,Exy,Ex2y,Ex3y,Ex4y,Ex5y,Ex6y,Ex7y,Ex8y,Ex9y,Ex10y,
    Ext2,Ey2,MainInvert :extended;
    TextX,TextY : string;

Function t(aa : extended;b:word):string;

Var txt : string;
    tel : word;
    Power : extended;

begin
 Power := 1;
 for tel := 1 to b do
  Power := Power*10;

 if ((Abs(aa) <= Power/100) and (Abs(aa) >= 100/Power)) or (aa=0) then
   str(aa:15:20,txt)
 else
   str(aa:b-1,txt);
 if aa >= 0 then
  txt := ' '+txt;
 t := copy(txt,1,b);
end;

Function Macht(aa:extended;times:word):extended;

var bb : extended;
    count: word;

begin
 bb := aa;
 for count := 2 to times do
 begin
  bb := bb*aa;
 end;
 Macht := bb;
end;

Function GetT(nu:integer):extended;

begin
 case nu of
  1 : GetT := 12.706;
  2 : GetT := 4.303;
  3 : GetT := 3.182;
  4 : GetT := 2.776;
  5 : GetT := 2.571;
  6 : GetT := 2.447;
  7 : GetT := 2.365;
  8 : GetT := 2.306;
  9 : GetT := 2.262;
  10 : GetT := 2.228;
  11 : GetT := 2.201;
  12 : GetT := 2.179;
  13 : GetT := 2.160;
  14 : GetT := 2.145;
  15 : GetT := 2.131;
  16 : GetT := 2.120;
  17 : GetT := 2.110;
  18 : GetT := 2.101;
  19 : GetT := 2.093;
  20 : GetT := 2.086;
  21 : GetT := 2.080;
  22 : GetT := 2.074;
  23 : GetT := 2.069;
  24 : GetT := 2.064;
  25 : GetT := 2.060;
  26 : GetT := 2.056;
  27 : GetT := 2.052;
  28 : GetT := 2.048;
  29 : GetT := 2.045;
  30 : GetT := 2.042;
 else
  begin
   if (nu > 30) and (nu <= 40) then GetT := 2.042-(0.0021*(nu-30));
   if (nu > 40) and (nu <= 60) then GetT := 2.021-(0.0021*(nu-40)/2);
   if (nu > 60) and (nu <= 120) then GetT := 2.000-(0.020/60*(nu-60));
   if nu > 120 then GetT := 1.960
  end;
 end;
end;

Procedure SolveEq(var field:Stelsel;W:byte);

var Na,Nb : byte;
    a,b   : byte;

begin
 Na := 11-W+1;
 Nb := 12-W;
 if W > 1 then
 begin
  for a := Na to 11 do
   for b := 12 downto Nb do
    Field[b,a] := Field[b,a]/Field[Nb,a];
  for a := Na+1 to 11 do
   for b := Nb to 12 do
    Field[b,a] := Field[b,a]-Field[b,Na];
 end;
 if W = 1 then
 begin
  Field[12,11] := Field[12,11]/Field[11,11];
 end;
 if W > 1 then
  SolveEq(Field,W-1);
end;

Constructor tProg.Init;

var R : tRect;
    gd,gm : integer;

 Procedure Intro;

 var pIntro : pDialog;

 begin
  R.assign(1,1,50,22);
  pIntro := new(pDialog,init(R,'Welcome'));
  with pIntro^ do
  begin
   Options := Options or ofCentered;
   R.assign(1,3,48,15);
   Insert(new(pStaticText,init(R,
    ^C'F I T  I T'^M^M^M+
    ^C'A polynomal fitting program'^M+
    ^C'Handles polynomes up to the 10th power'^M^M+
    ^C'Version 1.00'^M^M+
    ^C'Programming by:'^M+
    ^C'Franois Henri Reincke'^M^M+
    ^C'ShareWare 1996')));
   R.assign(20,17,30,19);
   Insert(new(pButton,init(R,'~O~k',cmCancel,bfDefault)));
  end;
  Executedialog(pIntro,nil);
 end;

begin
 inherited Init;
 TextX := 'X-axis';TextY := 'Y-axis';

 R.assign(42,0,80,12);
 pOpt := new(pOptions,init(R,'Options'));
 InsertWindow(pOpt);
 R.assign(42,13,80,23);
 pInvert := new(pInverted,init(R));
 InsertWindow(pInvert);
 R.assign(0,0,40,23);
 pHolder := new(pPointHolder,init(R));
 InsertWindow(pHolder);

 Intro;

 Detectgraph(gd,gm);
 if gd <> grNotDetected then
 begin
  if not GraphAppInit(gd,gm,nil,true) then
  begin
   MessageBox(^C'Fatal Error:'^M^C'Can''t load graphics driver',nil,mfError+mfOkbutton);
   ShowCursor;
   Halt(1);
  end;
 end
 else
 begin
  MessageBox(^C'Fatal Error:'^M^C'Can''t load graphics driver',nil,mfError+mfOkbutton);
  ShowCursor;
  Halt(1);
 end;

 naam := '';
 Message(@Self,evCommand,cmNames,nil);
 if naam = '' then
 begin
  MessageBox(^C'"No User specified" passed as Name',nil,mfOkButton+mfInformation);
  Naam := 'No User specified.';
 end;
end;

Procedure tProg.InitMenuBar;

var R : tRect;

begin
 GetExtent(R);
 R.B.Y := R.A.Y+1;
 MenuBar := new(pMenuBar,Init(R,NewMenu(
             NewSubMenu('~F~ile',hcNoContext,NewMenu(
              NewItem('~N~ew','',kbNoKey,cmNew,hcNoContext,
              NewItem('~L~oad...','F2',kbF2,cmLoad,hcNoContext,
              NewItem('~S~ave...','F3',kbF3,cmSave,hcNoContext,
              NewLine(
              NewItem('E~x~it','ALT-X',kbAltX,cmQuit,hcNoContext,
              nil)))))),
             NewSubMenu('~L~ist',hcNoContext,NewMenu(
              NewItem('~E~dit/Add','Enter',kbNokey,cmListItemSelected, hcNoContext,
              NewItem('~A~dd "New Point..."','Ctrl-Ins',kbCtrlIns,cmAdd, hcNoContext,
              NewItem('~D~elete','Delete',kbNokey,cmDel, hcNoContext,
              nil)))),
             NewSubmenu('~P~rogram',hcNoContext,NewMenu(
              NewItem('~C~hange Operator Name','',kbNokey,cmNames, hcNoCOntext,
              NewItem('~S~tart Calculation','F4',kbF4,cmCalc, hcNoContext,
              nil))),
             nil))))));
end;

Procedure tProg.InitStatusLine;

var R : tRect;

begin
 GetExtent(R);
 R.A.Y := R.B.Y-1;
 StatusLine := new(pStatusLine,Init(R,
                NewStatusDef(hcNoContext,hcNoContext,
                 NewStatuskey('~F2~ Load',kbF2,cmLoad,
                 NewStatusKey('~F3~ Save',kbF3,cmSave,
                 NewStatusKey('~F4~ Calculate',kbF4,cmCalc,
                 NewStatuskey('~F9~ Swap',kbF9,cmNext,
                 NewStatuskey('~F10~ Menu',kbF10,cmMenu,
                 NewStatusKey('~ALT-X~ Exit',kbALTX,cmQuit,
                 nil)))))),
                NewStatusDef(hcList,hcList,
                 NewStatusKey('~Enter~ Edit/Add',kbNoKey,cmEnter,
                 NewStatusKey('~Delete~ Remove',kbDel,cmDel,
                 NewStatuskey('~F4~ Calculate',kbF4,cmCalc,
                 NewStatuskey('~F9~ Swap',kbF9,cmNext,
                 NewStatuskey('~F10~ Menu',kbF10,cmMenu,
                 NewStatusKey('~ALT-X~ Exit',kbAltX,cmQuit,
                 nil)))))),
                NewStatusDef(hcInvList,hcInvList,
                 NewStatusKey('~Enter~ Edit/Add',kbNoKey,cmInvEnter,
                 NewStatusKey('~Delete~ Remove',kbDel,cmInvDel,
                 NewStatuskey('~F4~ Calculate',kbF4,cmCalc,
                 NewStatuskey('~F9~ Swap',kbF9,cmNext,
                 NewStatuskey('~F10~ Menu',kbF10,cmMenu,
                 NewStatusKey('~ALT-X~ Exit',kbAltX,cmQuit,
                 nil)))))),
                nil)))));
end;

Procedure tProg.HandleEvent(Var Event:tEvent);

 Procedure Calculate;

 var R : tRect;
     PointNr : integer;
     pD : pDialog;

 begin
  PointNr := pHolder^.GetNrOfPoints;
  if PointNr <= 2 then
  begin
   Messagebox(^C'There must at least be 3 data given.',nil,mfInformation+mfOkbutton);
   exit;
  end;
  pHolder^.CalcSums;

  BestFit := 1.7e38;
  if pFitit^.Getstate(sfExposed) then
   dispose(pFitit,done);
  R.assign(1,1,30,7);
  pD := new(pDialog,init(R,'Information'));
  pD^.OPtions := pD^.OPtions or ofCentered;
  pD^.Flags := 0;
  R.assign(2,2,28,5);
  pd^.Insert(new(pStatictext,init(R,^C'Now Calculating...'^M^C'Please Wait...')));
  InsertWindow(pD);
  R.assign(5,2,70,17);
  pFitit := new(pFit,init(PointNr,pHolder^.pList));
  dispose(pD,done);
  Desktop^.Redraw;
  ExecuteDialog(pFitit,nil);
 end;

 Procedure Newx;

 begin
  if pHolder^.GetNrOfPoints > 0 then
  begin
   if MessageBox(^C'Clear Current List?',nil,mfConfirmation+mfYesButton+mfNoButton)
     = cmYes then
   begin
    pHolder^.pList^.DeleteAll;
   end;
  end;
  pHolder^.AddPoint;
 end;

 Procedure Loadx;

 var f : file of extended;
     FN: string;
     pFN: pString;
     pPEx: pPoint2;

 begin
  FN := '*.FIT';
  if ExecuteDialog(new(pFiledialog,init(FN,'Load Information','Enter Filename:',fdOpenButton,hlLoad)),@FN)
   = cmCancel then
   Exit;
  {$I-}
  assign(f,FN);
  reset(f);
  {$I+}
  new(pFN);
  pFN^ := FN;
  if IOResult <> 0 then
  begin
   MessageBox(^C'File %s Not Found.',@pFN,mfError+mfOkButton);
   Exit;
  end;
  if pHolder^.GetNrOfPoints > 0 then
  begin
   case MessageBox(^C'Clear Current List?',nil,mfYesNoCancel) of
    cmYes   : pHolder^.pList^.DeleteAll;
    cmCancel: exit;
   end;
  end;
  while not(eof(f)) do
  begin
   new(pPEx);
   read(f,pPEx^.X,pPEx^.Y,pPEx^.dY);
   pHolder^.pList^.Insert(pPEx);
  end;
  pHolder^.pViewList^.SetRange(pHolder^.pList^.count);
  pHolder^.AddPoint;
 end;

 Procedure Savex;

 var f : file of extended;
     FN : string;
     pFN: pString;
     pEx: pPoint2;
     tel: integer;

 begin
  FN := '*.FIT';
  if Executedialog(New(pFileDialog,init(FN,'Save Information','Enter Filename:',fdOkButton,hlSave)),@FN)
   = cmCancel then
    Exit;
  new(pFN);
  pFN^ := FN;
  new(pEx);
  {$I-}
  assign(f,FN);
  rewrite(f);
  {$I+}
  if IOResult <> 0 then
  begin
   MessageBox(^C'Error While Saving %s. File NOT Saved.',@pFN,mfError+mfOkButton);
   exit;
  end;
  for tel := 1 to pHolder^.GetNrOfPoints do
  begin
   pEx := pHolder^.pList^.At(tel-1);
   Write(f,pEx^.X,pEx^.Y,pEx^.dy);
  end;
  MessageBox(^C'File %s Saved Succesfully.',@pFN,mfInformation+MfOkButton);
 end;

begin
 inherited HandleEvent(Event);
 if Event.What = evCommand then
 begin
  Case Event.Command of
   cmNames  : InputBox('Give name(s) of Operators:','Name(s):',naam,80);
   cmAdd    : begin pHolder^.AddPoint; pInvert^.AddNew; end;
   cmEnter  : Message(pHolder,evBroadCast,cmListItemSelected,nil);
   cmInvEnter:Message(pInvert,evBroadCast,cmListItemSelected,nil);
   cmInvDel : Message(pInvert,evCommand,cmInvDelOld,nil);
   cmCalc   : Calculate;
   cmNew    : Newx;
   cmLoad   : Loadx;
   cmSave   : Savex;
  else
   exit;
  end;
  ClearEvent(Event);
 end;
end;

Constructor tOptions.Init(var Bounds:tRect;ATitle:tTitleStr);

var tel : byte;
    R   : tRect;

begin
 inherited Init(Bounds,ATitle);
 Flags := wfMove;
 Options := Options or ofFirstClick;

 R.Assign(1,2,Size.X-1,4);
 pStandDev := new(pCheckBoxes,Init(R,
                        NewSItem('Enter ~S~tandard Deviation of Y',
                        NewSItem('~M~ove to Y when suggesting X',
                        nil))));
 Insert(pStandDev);
 R.assign(1,1,22,2);
 Insert(new(pLabel,init(R,'~O~ptions:',pStandDev)));

 R.assign(18,6,Size.X-1,7);
 pXLine := new(pInputLine,init(R,80));
 pXLine^.SetData(TextX);
 Insert(pXLine);
 R.assign(1,6,18,7);
 Insert(new(pLabel,init(R,'Text of ~X~-axis:',pXLine)));

 R.assign(18,7,Size.X-1,8);
 pYLine := new(pInputLine,init(R,80));
 pYLine^.SetData(TextY);
 Insert(pYLine);
 R.assign(1,7,18,8);
 Insert(new(pLabel,init(R,'Text of ~Y~-axis:',pYLine)));
 R.assign(1,5,Size.X-1,6);
 Insert(new(pLabel,init(R,'~G~raph Options:',nil)));

 R.assign(10,Size.Y-3,30,Size.Y-1);
 Insert(new(pButton,init(R,'~C~alculate',cmCalc,bfNormal)));

 SelectNext(False);
end;

Procedure tOptions.HandleEvent(var Event:tEvent);

begin
 inherited HandleEvent(Event);
 if Event.What = evBroadCast then
 begin
  if (Event.Command = cmDefault) and
     ((pXLine^.GetState(sfActive)) or
      (pYLine^.GetState(sfActive))) then
   SelectNext(False);
 end;
end;

Function tOptions.StDevToo:boolean;

begin
 StDevToo := pStandDev^.Mark(0);
end;

Constructor tPointCollection.Init;

begin
 inherited Init(100,1);
 Duplicates := true;
end;

Function tPointCollection.Compare(Key1,Key2:Pointer):integer;

begin
 if pPoint2(Key1)^.x < pPoint2(Key2)^.x then
  Compare := -1;
 if pPoint2(Key1)^.X = pPoint2(Key2)^.X then
 begin
  if pPoint2(Key1)^.Y < pPoint2(Key2)^.Y then
   Compare := -1;
  if pPoint2(Key1)^.Y = pPoint2(Key2)^.Y then
   Compare := 0;
  if pPoint2(Key1)^.Y = pPoint2(Key2)^.Y then
   Compare := 1;
 end;
 if pPoint2(Key1)^.X > pPoint2(Key2)^.X then
  Compare := 1;
end;

Constructor tPointList.Init(var Bounds:tRect;AScrollBar:pScrollBar;AList:pPointCollection);

begin
 inherited Init(Bounds,1,nil,AScrollBar);
 pList := AList;
end;

Function tPointList.GetText(Item,MaxLen:Integer):string;

var txt,txt2 : string;

begin
 if pPoint2(pList^.At(Item))^.X < 1.7e38 then
 begin
  if pOpt^.StDevToo then
  begin
   str((Item+1):2,txt2);
   txt := txt2+' '+
          t(pPoint2(pList^.At(Item))^.X,9)+' '+
          t(pPoint2(pList^.At(Item))^.Y,9)+' '+
          t(pPoint2(pList^.At(Item))^.dy,9);
  end
  else
  begin
   str((Item+1):2,txt2);
   txt := txt2+' '+
          t(pPoint2(pList^.At(Item))^.X,15)+' '+
          t(pPoint2(pList^.At(Item))^.Y,15);
  end;
 end
 else
  txt := 'New Item...';
 GetText := copy(txt,1,MaxLen);
end;

Procedure tLine.Draw;

var tDraw : tDrawbuffer;

begin
 if pOpt^.StDevToo then
 begin
  MoveStr(tDraw,' nr.    X         Y      St.Dev Y  ',63);
  WriteBuf(0,0,Size.X,1,tDraw);
 end
 else
 begin
  MoveStr(tDraw,' nr.       X               Y        ',63);
  WriteBuf(0,0,Size.X,1,tDraw);
 end;
end;

Procedure tLine.SetState(AState:word;Enable:boolean);

begin
 inherited Setstate(Astate,enable);
 if ASTate = sfActive then DrawView;
end;

Constructor tPointHolder.Init(var Bounds:tRect);

var R : tRect;

begin
 inherited Init(Bounds,'Table of Points');
 Flags := wfMove;
 pList := New(pPointCollection,Init);
 R.assign(Bounds.B.X-1,Bounds.A.Y+1,Bounds.B.X,Bounds.B.Y-1);
 pScrl := new(pScrollBar,init(R));
 R.assign(1,2,Bounds.B.X-1,Bounds.B.Y-1);
 pViewList := new(pPointList,Init(R,pScrl,pList));
 Insert(pScrl);
 Insert(pViewList);
 R.assign(1,1,Bounds.B.X-1,2);
 Insert(new(pLine,Init(R)));
 AddPoint;
 HelpCtx := hcList;
end;

Procedure tPointHolder.AddPoint;

var exPoint: pPoint2;
    WhereIns : integer;

begin
 if pList^.Count = 0 then
 begin
  new(exPoint);
  exPoint^.X := 1.7e38;
  exPoint^.Y := 0;
  exPoint^.dy := 1;
  pList^.Insert(exPoint);
  pViewList^.SetRange(1);
  pViewList^.DrawView;
 end
 else
 begin
  if (pPoint2(pList^.At(pList^.count-1))^.X < 1.7e38) then
  begin
   new(exPoint);
   exPoint^.X := 1.7e38;
   exPoint^.Y := 0;
   exPoint^.dY := 1;
   pList^.Insert(exPoint);
   pViewList^.SetRange(pList^.Count);
   pList^.Search(exPoint,WhereIns);
   pViewList^.FocusItem(WhereIns);
   pViewList^.DrawView;
  end
  else
  begin
   pViewList^.FocusItem(pList^.Count-1);
   pVIewList^.Drawview;
  end;
 end;
end;

Procedure tPointHolder.CalcSums;

var Nr : integer;
    count : integer;
    P  : tPoint2;
    Dytoo : boolean;
    Wi,EWi: extended;

begin
 Nr := GetNrOfPoints;

 Ex := 0;Ex2 := 0;Ex3 := 0;Ex4 := 0;Ex5:=0;Ex6:=0;Ex7:=0;Ex8:=0;Ex9:=0;Ex10:=0;
 Ex11:=0;Ex12:=0;Ex13:=0;Ex14:=0;Ex15:=0;Ex16:=0;Ex17:=0;Ex18:=0;Ex19:=0;Ex20:=0;
 Exy := 0;Ex2y := 0;Ex3y:=0;Ex4y:=0;Ex5y:=0;Ex6y:=0;Ex7y:=0;Ex8y:=0;Ex9y:=0;Ex10y:=0;
 Ey := 0;Ey2 := 0;

 if pOpt^.Stdevtoo then
 begin
  DyToo := true;
  EWi := 0;
  for count := 1 to Nr do
  begin
   P := pPoint2(pList^.At(count-1))^;
   EWi := EWi + P.dy*P.dy;
  end;
 end
 else
  DyToo := false;

 for count := 1 to Nr do
 begin
  P := pPoint2(pList^.At(count-1))^;
  if not(DyToo) then
   Wi := 1
  else
   Wi := (1/(P.dy*P.dy))/EWi;
  Ey := Ey + Wi*P.Y;
  Ex := Ex + Wi*P.X;
  Ex2 := Ex2 + Wi*P.X*P.X;
  Ex3 := Ex3 + Wi*P.X*P.X*P.X;
  Ex4 := Ex4 + Wi*P.X*P.X*P.X*P.X;
  Ex5 := Ex5 + Wi*Macht(P.X,5);
  Ex6 := Ex6 + Wi*Macht(P.X,6);
  Ex7 := Ex7 + Wi*Macht(P.X,7);
  Ex8 := Ex8 + Wi*Macht(P.X,8);
  Ex9 := Ex9 + Wi*Macht(P.X,9);
  Ex10 := Ex10 + Wi*Macht(P.X,10);
  Ex11 := Ex11 + Wi*Macht(P.X,11);
  Ex12 := Ex12 + Wi*Macht(P.X,12);
  Ex13 := Ex13 + Wi*Macht(P.X,13);
  Ex14 := Ex14 + Wi*Macht(P.X,14);
  Ex15 := Ex15 + Wi*Macht(P.X,15);
  Ex16 := Ex16 + Wi*Macht(P.X,16);
  Ex17 := Ex17 + Wi*Macht(P.X,17);
  Ex18 := Ex18 + Wi*Macht(P.X,18);
  Ex19 := Ex19 + Wi*Macht(P.X,19);
  Ex20 := Ex20 + Wi*Macht(P.X,20);
  Exy := Exy + Wi*P.X*P.Y;
  Ex2y:= Ex2y+ Wi*P.X*P.X*P.Y;
  Ex3y:= Ex3y+ Wi*Macht(P.X,3)*P.Y;
  Ex4y:= Ex4y+ Wi*Macht(P.X,4)*P.Y;
  Ex5y:= Ex5y+ Wi*Macht(P.X,5)*P.Y;
  Ex6y:= Ex6y+ Wi*Macht(P.X,6)*P.Y;
  Ex7y:= Ex7y+ Wi*Macht(P.X,7)*P.Y;
  Ex8y:= Ex8y+ Wi*Macht(P.X,8)*P.Y;
  Ex9y:= Ex9y+ Wi*Macht(P.X,9)*P.Y;
  Ex10y:= Ex10y+ Wi*Macht(P.X,10)*P.Y;
  Ey2 := Ey2 + Wi*P.Y*P.Y;
 end;
 Ext2 := Ex*Ex;

 if pInvert^.GetNrOfPoints > 0 then
 begin
  MainInvert := 0;
  for count := 1 to pInvert^.GetNrOfPoints do
   MainInvert := MainInvert + Extended(pInvert^.pInvList^.At(count-1)^);
  MainInvert := MainInvert/pInvert^.GetNrOfPoints;
 end;
end;

Procedure tPointHolder.HandleEvent(var Event:tEvent);

var CurSel,err,Out : integer;
    txt    : string;
    rPoint  : extended;
    pexPoint : pPoint2;
    pInput : pPointDial;

begin
 inherited HandleEvent(Event);
 if Event.What = evBroadcast then
 begin
  if (Event.Command = cmListItemSelected) and GetState(sfActive) then
  begin
   CurSel := pViewList^.Focused;
   txt := string(Event.InfoPtr^);
   if copy(txt,1,9) = 'StartWith' then
    pInput := new(pPointDial,init(CurSel,txt[10]))
   else
    pInput := new(pPointDial,init(CurSel,' '));
   Out := Desktop^.ExecView(pInput);
   if Out <> cmCancel then
   begin
    if Out <> cmError then
    begin
     pList^.AtDelete(CurSel);
     new(pExPoint);
     pExPoint^ := MainPoint;
     pList^.Insert(pExPoint);
     pViewList^.SetRange(pList^.Count);
     pViewList^.DrawView;
     ClearEvent(Event);
     Event.What := evCommand;
     Event.Command := cmAdd;
     Event.InfoPtr := nil;
     PutEvent(Event);
    end
    else
    begin
     MessageBox(^C'Invalid nummeric format.'^M^C'Input Ignored.',nil,mfOkButton+mfError);
     ClearEvent(Event);
    end;
   end
   else
    ClearEvent(Event);
  end;
  if (Event.Command = cmDefault) and GetState(sfActive) then
  begin
   CurSel := pViewList^.Focused;
   pViewList^.SelectItem(CurSel);
  end;
 end;
 if Event.What = evCommand then
 begin
  if Event.Command = cmDel then
  begin
   CurSel := pViewList^.Focused;
   dispose(pList^.At(CurSel));
   pList^.AtDelete(CurSel);
   pViewList^.SetRange(pList^.count);
   pViewList^.DrawView;
   ClearEvent(Event);
   Event.What := evCommand;
   Event.Command := cmAdd;
   Event.InfoPtr := nil;
   PutEvent(Event);
  end;
 end;
 if (Event.What = evCommand) and (Event.Command = cmListItemSelected) and GetState(sfActive) then
 begin
  Message(pHolder,evBroadcast,cmListItemSelected,nil);
  ClearEvent(Event);
 end;
 if (Event.What = evKeyDown) and GetSTate(sfActive) then
 begin
  if Event.CharCode in ['-','+','0'..'9'] then
  begin
   txt := 'StartWith'+Event.CharCode;
   message(pHolder,evBroadcast,cmListItemSelected,@txt);
  end;
 end;
end;

Procedure tPointHolder.GetExtremes(var min,max:extended);

var i: integer;
    low,High : extended;

begin
 Low := 1.7e38;
 High := -1.7e38;
 for i := 0 to GetNrOfPoints-1 do
 begin
  if pPoint2(pList^.At(i))^.Y < Low then
   Low := pPoint2(pList^.At(i))^.Y;
  if pPoint2(pList^.At(i))^.Y > High then
   High := pPoint2(pList^.At(i))^.Y;
 end;
 Min := Low;
 Max := High;
end;

Function tPointHolder.GetNrOfPoints:word;

begin
 if pPoint2(pList^.At(pList^.Count-1))^.X < 1.7E38 then
  GetNrOfPoints := pList^.Count
 else
  GetNrOfPoints := pList^.Count-1;
end;

Constructor tPointDial.Init(Item:Integer;StartCar:Char);

var R     : tRect;
    temp   : string;
    ptxt   : pstring;
    temp2  : word;
    pEx,pEx2,pEx3: tPoint2;
    Event  : tevent;

begin
 R.assign(0,0,30,11);
 inherited Init(R,'Give Point');
 Options := Options or ofCentered;
 ViaKey := False;

 pEx := tPoint2(pHolder^.pList^.At(Item)^);

 R.assign(5,3,28,4);
 pY := New(pInputLine,Init(R,20));
 Insert(pY);
 temp := t(pEx.Y,15);
 pY^.SetData(temp);
 R.Assign(1,3,5,4);
 Insert(new(pLabel,Init(R,'Y:',pY)));

 if pOpt^.StDevToo then
 begin
  R.assign(2,6,28,7);
  pdY := New(pInputLine,Init(R,20));
  Insert(pdY);
  temp := t(pEx.dY,15);
  pdY^.SetData(temp);
  R.Assign(1,5,28,6);
  Insert(new(pLabel,Init(R,'Standard Deviation in Y:',pdY)));
 end;

 R.assign(4,8,14,10);
 Insert(new(pButton,Init(R,'~A~ccept',cmAccept,bfNormal)));

 R.assign(16,8,26,10);
 Insert(new(pButton,init(R,'~C~ancel',cmCancel,bfNormal)));

 R.assign(5,2,28,3);
 pX := New(pInputLine,Init(R,20));
 Insert(pX);
 if pEx.X = 1.7e38 then
 begin
  if Item < 2 then
   pEx.X := 0
  else
  begin
   pEx.X := pPoint2(pHolder^.pList^.At(Item-1))^.X-pPoint2(pHolder^.pList^.At(Item-2))^.X
            +pPoint2(pHolder^.pList^.At(Item-1))^.X;
   if (pOpt^.pStandDev^.Mark(1)) and (StartCar = ' ') then
    SelectNext(False);
  end;
 end;
 temp := t(pEx.X,15);
 if StartCar = ' ' then
  pX^.SetData(temp)
 else
 begin
  temp := StartCar;
  pX^.SetData(temp);
  ViaKey := true;
 end;
 R.assign(1,2,5,3);
 Insert(new(pLabel,Init(R,'X:',pX)));

end;

Procedure tPointDial.HandleEvent(var Event:tEvent);

 Function NumbersOk:boolean;

 var error : word;
     txt   : string;

 begin
  pX^.GetData(txt);
  Val(txt,MainPoint.X,error);
  if error <> 0 then
  begin
   NumbersOk := false;
   Exit;
  end;
  pY^.GetData(txt);
  Val(txt,MainPoint.Y,error);
  if error <> 0 then
  begin
   NumbersOk := false;
   Exit;
  end;
  if pOpt^.stDevToo then
  begin
   pdY^.GetData(txt);
   Val(txt,MainPoint.dY,error);
   if error <> 0 then
   begin
    NumbersOk := false;
    Exit;
   end;
  end
  else
   MainPoint.dy := 0;
  NumbersOk := true;
 end;

begin
 inherited HandleEvent(Event);
 if Event.What = evBroadCast then
 begin
  if Event.Command = cmDefault then
  begin
   if pOpt^.stDevToo then
   begin
    if pX^.GetState(sfFocused) or
       pY^.GetState(sfFocused) then
    begin
     SelectNext(False);
     ClearEvent(Event);
    end
    else
    begin
     ClearEvent(Event);
     Event.What := evCommand;
     Event.COmmand := cmAccept;
     Event.InfoPtr := nil;
     PutEvent(Event);
    end;
   end
   else
   begin
    if pX^.GetState(sfFocused) then
    begin
     SelectNext(False);
     ClearEvent(Event);
    end
    else
    begin
     ClearEvent(Event);
     Event.What := evCommand;
     Event.Command := cmAccept;
     Event.InfoPtr := nil;
     PutEvent(Event);
    end;
   end;
  end;
  if (Event.Command = 52) and ViaKey then
  begin
   pX^.SelectAll(False);
   pX^.CurPos := 1;
   pX^.DrawView;
  end;
 end;
 if Event.What = evCommand then
 begin
  if Event.Command = cmAccept then
  begin
   if numbersOk then
    EndModal(cmAccept)
   else
    EndModal(cmError);
  end
  else
   exit;
  ClearEvent(Event);
 end;
end;

Procedure tOrder.Press(Item : Integer);

begin
 inherited Press(Item);
 Message(pFitit,evCommand,cmOrderChanged,nil);
end;

Procedure tOrder.MovedTo(Item : Integer);

begin
 inherited MovedTo(Item);
 Message(pFitit,evCommand,cmOrderChanged,nil);
end;

Constructor tFit.Init(NrPoints:integer;List:pPointCollection);

var r,r2  : trect;
    count : INTEGER;
    pScr : pScrollBar;
    pScr2 : pMyScroll;

begin
 R.Assign(0,0,75,20);
 inherited init(R,'Results of Polynomal Fit');
 Palette := wpBlueWindow;
 Options := Options or ofCentered;

 R.assign(2,3,18,13);
 pBut := New(pOrder,init(R,
          NewSItem('~1~st Order',
          NewSItem('~2~nd Order',
          NewSItem('~3~rd Order',
          NewSItem('~4~th Order',
          NewSItem('~5~th Order',
          NewSItem('~6~th Order',
          NewSItem('~7~th Order',
          NewSItem('~8~th Order',
          NewSItem('~9~th Order',
          NewSItem('1~0~th Order',
         nil))))))))))));
 Insert(pBut);
 R.assign(1,2,18,3);
 Insert(new(pLabel,init(R,'~S~elect Order:',pBut)));
 R2.assign(73,3,74,15);
 pScr := new(pScrollBar,init(R2));
 R2.assign(20,15,73,16);
 pScr2 := new(pMyScroll,init(R2));
 R.assign(20,3,73,15);
 pBox := new(pResultView,init(R,1,pScr2,pScr));
 pBox^.Options := pBox^.Options or ofFramed;
 Insert(pBox);
 Insert(pScr);
 Insert(pScr2); pBox^.pScrl := pScr2;
 R2.assign(20,2,29,3);
 Insert(new(pLabel,init(R2,'~R~esults:',pBox)));

 for count := 1 to 10 do
  pRow[count] := new(pCollection,init(10,1));

 pBut^.SetButtonstate(2147483647,false);

 Calculate1stDeg(NrPoints,List,true);
 if NrPoints >= 4 then Calculate2ndDeg(NrPoints,List,true);
 if NrPoints >= 5 then Calculate3rdDeg(NrPoints,List,true);
 if NrPoints >= 6 then Calculate4thDeg(NrPoints,List,true);
 if NrPoints >= 7 then Calculate5thDeg(NrPoints,List,true);
 if NrPoints >= 8 then Calculate6thDeg(NrPoints,List,true);
 if NrPoints >= 9 then Calculate7thDeg(NrPoints,List,true);
 if NrPoints >= 10 then Calculate8thDeg(NrPoints,List,true);
 if NrPoints >= 11 then Calculate9thDeg(NrPoints,List,true);
 if NrPoints >= 12 then Calculate10thDeg(NrPoints,List,true);

 R.assign(10,Size.Y-3,25,Size.Y-1);
 Insert(new(pButton,init(R,'~G~raph',cmGraph,bfNormal)));
 R.assign(30,Size.Y-3,45,Size.Y-1);
 Insert(new(pButton,init(R,'~P~rint',cmPrint,bfNormal)));
 R.assign(50,Size.Y-3,65,Size.Y-1);
 Insert(new(pButton,init(R,'~C~ancel',cmCancel,bfDefault)));
end;

Procedure tFit.HandleEvent(var Event:tEvent);

 Procedure SwapIt;

 var Order : byte;

 begin
  Order := pBut^.Value+1;
  pBox^.List := pRow[Order];
  pBox^.SetRange(pRow[Order]^.Count);
  pBox^.DrawView;
 end;

 Procedure GraphIt(Print:boolean);

 var Order : byte;
     NrPoints : integer;

 begin
  Order := pBut^.Value+1;
  NrPoints := pHolder^.GetNrOfPoints;
  case Order of
   1 : Calculate1stDeg(NrPoints,pHolder^.pList,false);
   2 : Calculate2ndDeg(NrPoints,pHolder^.pList,false);
   3 : Calculate3rdDeg(NrPoints,pHolder^.pList,false);
   4 : Calculate4thDeg(NrPoints,pHolder^.pList,false);
   5 : Calculate5thDeg(NrPoints,pHolder^.pList,false);
   6 : Calculate6thDeg(NrPoints,pHolder^.pList,false);
   7 : Calculate7thDeg(NrPoints,pHolder^.pList,false);
   8 : Calculate8thDeg(NrPoints,pHolder^.pList,false);
   9 : Calculate9thDeg(NrPoints,pHolder^.pList,false);
   10: Calculate10thDeg(NrPoints,pHolder^.pList,false);
  end;
  if Print then
   ShowGraph(Order+100)
  else
   ShowGraph(Order);
 end;

 Procedure PrintIt;

 var Order : byte;
     C : integer;

 begin
  Order := pBut^.Value+1;
  Writeln(lst,'                                  F I T  I T');
  Writeln(lst,'                         A polynomal fitting program');
  Writeln(lst,'                    Handles polynomes up to the 10th power');
  Writeln(lst,' ');
  Writeln(lst,'                    Programming by: Franois Henri Reincke');
  Writeln(lst,'                    Version 1.00, 1996, ShareWare Version');
  Writeln(lst,' ');
  Writeln(lst,'Name of User: ',naam);
  GraphIt(true);
  Writeln(lst,'');
  if pOpt^.StDevToo then
  begin
   Writeln(lst,'       X       |       Y       |Stand.Dev. of Y');
   Writeln(lst,'---------------|---------------|---------------');
   for c := 1 to pHolder^.GetNrOfPoints do
   begin
    Writeln(lst,t(pPoint2(pHolder^.pList^.At(c-1))^.X,15),'|',
                t(pPoint2(pHolder^.pList^.At(c-1))^.Y,15),'|',
                t(pPoint2(pHolder^.pList^.At(c-1))^.dy,15));
   end;
  end
  else
  begin
   Writeln(lst,'       X       |       Y       ');
   Writeln(lst,'---------------|---------------');
   for c := 1 to pHolder^.GetNrOfPoints do
   begin
    Writeln(lst,t(pPoint2(pHolder^.pList^.At(c-1))^.X,15),'|',
                t(pPoint2(pHolder^.pList^.At(c-1))^.Y,15));
   end;
  end;
  writeln(lst,'');
  for C := 1 to pRow[Order]^.Count do
  begin
   Writeln(lst,pstring(pRow[Order]^.At(C-1))^);
  end;
  Writeln(lst,chr(12));
 end;

begin
 inherited HandleEvent(Event);
 if Event.What = evCommand then
 begin
  case Event.Command of
   cmOrderChanged : SwapIt;
   cmGraph        : GraphIt(False);
   cmPrint        : PrintIt;
  else
   exit
  end;
  ClearEvent(Event);
 end;
 if Event.What = evBroadcast then
 begin
  if Event.Command = 52 then
  begin
   pBut^.Press(Best-1);
   Redraw;
  end;
 end;
end;

Procedure tFit.Calculate1stDeg(NrPoints:integer;List:pPointCollection;WriteIt:boolean);

var count : INTEGER;
    txt  : String;
    CalcX,istd : extended;

begin
 pBut^.SetButtonstate(1,true);
 k1 := ((NrPoints*Exy)-(Ex*Ey))/((NrPoints*Ex2)-Ext2);
 k0 := ((Ex2*Ey)-(Ex*Exy))/((NrPoints*Ex2)-Ext2);
 cc := ((NrPoints*Exy)-(Ex*Ey))/Sqrt((NrPoints*Ex2-Ext2)*(NrPoints*Ey2-Ey*Ey));

 D:= 0;
 for count := 1 to NrPoints do
 begin
  E := k1*pPoint2(pHolder^.pList^.At(count-1))^.X+k0-pPoint2(pHolder^.pList^.At(count-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 1;
 end;
 S1 := Sqrt( (d/(NrPoints-2)*NrPoints)/(NrPoints*Ex2-Ext2));
 S0 := Sqrt( (d/(NrPoints-2)*Ex2)/(NrPoints*Ex2-Ext2));

 if WriteIt then
 begin
  Entertext(1,'First Order Polynome:');
  EnterText(1,'Y = k0 + k1*X');
  EnterText(1,'');
  EnterText(1,'           Value       Standard Dev.  Minimum Limit Maximum Limit');
  EnterText(1,' k0 = '+t(k0,15)+' '+t(S0,15)+' '+t(k0-GetT(NrPoints-1)*s0,13)+' '+t(k0+GetT(NrPoints-1)*s0,13));
  EnterText(1,' k1 = '+t(k1,15)+' '+t(S1,15)+' '+t(k1-GetT(NrPoints-1)*s1,13)+' '+t(k1+GetT(NrPoints-1)*s1,13));
  EnterText(1,'');
  EnterText(1,'Correllation Cofficint:'+t(cc,15));
  EnterText(1,'Variance Y, S^2 = '+t(D,10));
 end;

 {Now the inverted part:}
 if pInvert^.GetNrOfPoints > 0 then
 begin
  if WriteIt then
  begin
   str(pInvert^.GetNrOfPoints,txt);
   EnterText(1,'');
   EnterText(1,'Inverted use based on '+txt+' points:');
   for count := 1 to pInvert^.GetNrOfPoints do
   begin
    str(count:5,txt);
    EnterText(1,txt+' : '+t(Extended(pInvert^.pInvList^.At(count-1)^),15));
   end;
   CalcX := (MainInvert-k0)/k1;
   E := 0;
   For count := 1 to NrPoints do
   begin
    E := Sqr(Extended(List^.At(count-1)^)-(Ex/NrPoints));
   end;
   E := Sqr(CalcX-(Ex/NrPoints))/E;
   Istd := Sqrt(D/(NrPoints-2))*(1/k1)*Sqrt((1/NrPoints)+(1/pInvert^.GetNrOfPoints)+E);
   EnterText(1,'    Mean Y     X at Mean Y  Stand.dev. X  minimum lim.X maximum lim.Y');
      EnterText(1,t(MainInvert,13)+' '+t(CalcX,13)+' '+t(Istd,13)+
                  t(CalcX-(GetT(NrPoints+pInvert^.GetNrOfPoints-3)*Istd),13)+
                  t(CalcX+(GetT(NrPoints+pInvert^.GetNrOfPoints-3)*Istd),13));
  end;
 end;
end;

Procedure tFit.Calculate2ndDeg(NrPoints:integer;List:pPointCollection;WriteIt:boolean);

var Eq : Stelsel;
    n : integer;

begin
 pBut^.SetButtonState(2,true);
 n := NrPoints;
 Eq[9,9]:=n;   Eq[10,9]:=Ex;  Eq[11,9]:=Ex2; Eq[12,9]:=Ey;
 Eq[9,10]:=Ex; Eq[10,10]:=Ex2;Eq[11,10]:=Ex3;Eq[12,10]:=Exy;
 Eq[9,11]:=Ex2;Eq[10,11]:=Ex3;Eq[11,11]:=Ex4;Eq[12,11]:=Ex2y;
 SolveEq(Eq,3);
 k2 := Eq[12,11];
 k1 := Eq[12,10]-Eq[11,10]*k2;
 k0 := Eq[12,9]-Eq[11,9]*k2-Eq[10,9]*k1;

 D:= 0;
 for n := 1 to NrPoints do
 begin
  E := k2*pPoint2(List^.At(n-1))^.X*pPoint2(List^.At(n-1))^.X
       +k1*pPoint2(List^.At(n-1))^.X
       +k0
       -pPoint2(List^.At(n-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 2;
 end;

 if WriteIt then
 begin
  Entertext(2,'Second Order Polynome:');
  EnterText(2,'Y = k0 + k1*X + k2*X^2');
  EnterText(2,'');
  EnterText(2,'          Value     Std.Dev.  Min.Limit   Max.Limit');
  EnterText(2,' k0 = '+t(k0,11){+' '+t(S0,11)+' '+t(k0-2*s0,10)+' '+t(k0+2*s0,10)});
  EnterText(2,' k1 = '+t(k1,11){+' '+t(S1,11)+' '+t(k1-2*s1,10)+' '+t(k1+2*s1,10)});
  EnterText(2,' k2 = '+t(k2,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(2,'');
  EnterText(2,'Variance Y, S^2 = '+t(D,10));
 end;
 InvertCalc(2,NrPoints,WriteIt);
end;

Procedure tFit.Calculate3rdDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);

var Eq : Stelsel;
    n : integer;

begin
 pBut^.SetButtonState(4,true);
 n := NrPoints;
 Eq[8,8]:=n;   Eq[9,8]:=Ex;  Eq[10,8]:=Ex2; Eq[11,8]:=Ex3; Eq[12,8]:=Ey;
 Eq[8,9]:=Ex;  Eq[9,9]:=Ex2; Eq[10,9]:=Ex3; Eq[11,9]:=Ex4; Eq[12,9]:=Exy;
 Eq[8,10]:=Ex2;Eq[9,10]:=Ex3;Eq[10,10]:=Ex4;Eq[11,10]:=Ex5;Eq[12,10]:=Ex2y;
 Eq[8,11]:=Ex3;Eq[9,11]:=Ex4;Eq[10,11]:=Ex5;Eq[11,11]:=Ex6;Eq[12,11]:=Ex3y;
 SolveEq(Eq,4);
 k3 := Eq[12,11];
 k2 := Eq[12,10]-Eq[11,10]*k3;
 k1 := Eq[12,9]-Eq[11,9]*k3-Eq[10,9]*k2;
 k0 := Eq[12,8]-Eq[11,8]*k3-Eq[10,8]*k2-Eq[9,8]*k1;

 D:= 0;
 for n := 1 to NrPoints do
 begin
  E := k3*Macht(pPoint2(List^.At(n-1))^.X,3)
       +k2*pPoint2(List^.At(n-1))^.X*pPoint2(List^.At(n-1))^.X
       +k1*pPoint2(List^.At(n-1))^.X
       +k0
       -pPoint2(List^.At(n-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 3;
 end;

 if WriteIt then
 begin
  Entertext(3,'Third Order Polynome:');
  EnterText(3,'Y = k0 + k1*X + k2*X^2 + k3*X^3');
  EnterText(3,'');
  EnterText(3,'          Value     Std.Dev.  Min.Limit   Max.Limit');
  EnterText(3,' k0 = '+t(k0,11){+' '+t(S0,11)+' '+t(k0-2*s0,10)+' '+t(k0+2*s0,10)});
  EnterText(3,' k1 = '+t(k1,11){+' '+t(S1,11)+' '+t(k1-2*s1,10)+' '+t(k1+2*s1,10)});
  EnterText(3,' k2 = '+t(k2,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(3,' k3 = '+t(k3,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(3,'');
  EnterText(3,'Variance Y, S^2 = '+t(D,10));
 end;
 InvertCalc(3,NrPoints,WriteIt);
end;

Procedure tFit.Calculate4thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);

var Eq : Stelsel;
    n : integer;

begin
 pBut^.SetButtonState(8,true);
 n := NrPoints;
 Eq[7,7]:=n;   Eq[8,7]:=Ex;  Eq[9,7]:=Ex2; Eq[10,7]:=Ex3; Eq[11,7]:=Ex4; Eq[12,7]:=Ey;
 Eq[7,8]:=Ex;  Eq[8,8]:=Ex2; Eq[9,8]:=Ex3; Eq[10,8]:=Ex4; Eq[11,8]:=Ex5; Eq[12,8]:=Exy;
 Eq[7,9]:=Ex2; Eq[8,9]:=Ex3; Eq[9,9]:=Ex4; Eq[10,9]:=Ex5; Eq[11,9]:=Ex6; Eq[12,9]:=Ex2y;
 Eq[7,10]:=Ex3;Eq[8,10]:=Ex4;Eq[9,10]:=Ex5;Eq[10,10]:=Ex6;Eq[11,10]:=Ex7;Eq[12,10]:=Ex3y;
 Eq[7,11]:=Ex4;Eq[8,11]:=Ex5;Eq[9,11]:=Ex6;Eq[10,11]:=Ex7;Eq[11,11]:=Ex8;Eq[12,11]:=Ex4y;
 SolveEq(Eq,5);
 k4 := Eq[12,11];
 k3 := Eq[12,10]-Eq[11,10]*k4;
 k2 := Eq[12,9]-Eq[11,9]*k4-Eq[10,9]*k3;
 k1 := Eq[12,8]-Eq[11,8]*k4-Eq[10,8]*k3-Eq[9,8]*k2;
 k0 := Eq[12,7]-Eq[11,7]*k4-Eq[10,7]*k3-Eq[9,7]*k2-Eq[8,7]*k1;

 D:= 0;
 for n := 1 to NrPoints do
 begin
  E := k4*Macht(pPoint2(List^.At(n-1))^.X,4)
       +k3*Macht(pPoint2(List^.At(n-1))^.X,3)
       +k2*pPoint2(List^.At(n-1))^.X*pPoint2(List^.At(n-1))^.X
       +k1*pPoint2(List^.At(n-1))^.X
       +k0
       -pPoint2(List^.At(n-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 4;
 end;

 if WriteIt then
 begin
  Entertext(4,'Fourth Order Polynome:');
  EnterText(4,'Y = k0 + k1*X + k2*X^2 + k3*X^3 + k4*X^4');
  EnterText(4,'');
  EnterText(4,'          Value     Std.Dev.  Min.Limit   Max.Limit');
  EnterText(4,' k0 = '+t(k0,11){+' '+t(S0,11)+' '+t(k0-2*s0,10)+' '+t(k0+2*s0,10)});
  EnterText(4,' k1 = '+t(k1,11){+' '+t(S1,11)+' '+t(k1-2*s1,10)+' '+t(k1+2*s1,10)});
  EnterText(4,' k2 = '+t(k2,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(4,' k3 = '+t(k3,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(4,' k4 = '+t(k4,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(4,'');
  EnterText(4,'Variance Y, S^2 = '+t(D,10));
 end;
 InvertCalc(4,NrPoints,WriteIt);
end;

Procedure tFit.Calculate5thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);

var Eq : Stelsel;
    n : integer;

begin
 pBut^.SetButtonState(16,true);
 n := NrPoints;
 Eq[6,6]:=n;   Eq[7,6]:=Ex;  Eq[8,6]:=Ex2; Eq[9,6]:=Ex3; Eq[10,6]:=Ex4; Eq[11,6]:=Ex5; Eq[12,6]:=Ey;
 Eq[6,7]:=Ex;  Eq[7,7]:=Ex2; Eq[8,7]:=Ex3; Eq[9,7]:=Ex4; Eq[10,7]:=Ex5; Eq[11,7]:=Ex6; Eq[12,7]:=Exy;
 Eq[6,8]:=Ex2; Eq[7,8]:=Ex3; Eq[8,8]:=Ex4; Eq[9,8]:=Ex5; Eq[10,8]:=Ex6; Eq[11,8]:=Ex7; Eq[12,8]:=Ex2y;
 Eq[6,9]:=Ex3; Eq[7,9]:=Ex4; Eq[8,9]:=Ex5; Eq[9,9]:=Ex6; Eq[10,9]:=Ex7; Eq[11,9]:=Ex8; Eq[12,9]:=Ex3y;
 Eq[6,10]:=Ex4;Eq[7,10]:=Ex5;Eq[8,10]:=Ex6;Eq[9,10]:=Ex7;Eq[10,10]:=Ex8;Eq[11,10]:=Ex9;Eq[12,10]:=Ex4y;
 Eq[6,11]:=Ex5;Eq[7,11]:=Ex6;Eq[8,11]:=Ex7;Eq[9,11]:=Ex8;Eq[10,11]:=Ex9;Eq[11,11]:=Ex10;Eq[12,11]:=Ex5y;
 SolveEq(Eq,6);
 k5 := Eq[12,11];
 k4 := Eq[12,10]-Eq[11,10]*k5;
 k3 := Eq[12,9]-Eq[11,9]*k5-Eq[10,9]*k4;
 k2 := Eq[12,8]-Eq[11,8]*k5-Eq[10,8]*k4-Eq[9,8]*k3;
 k1 := Eq[12,7]-Eq[11,7]*k5-Eq[10,7]*k4-Eq[9,7]*k3-Eq[8,7]*k2;
 k0 := Eq[12,6]-Eq[11,6]*k5-Eq[10,6]*K4-Eq[9,6]*k3-Eq[8,6]*k2-Eq[7,6]*k1;

 D:= 0;
 for n := 1 to NrPoints do
 begin
  E := k5*Macht(pPoint2(List^.At(n-1))^.X,5)
       +k4*Macht(pPoint2(List^.At(n-1))^.X,4)
       +k3*Macht(pPoint2(List^.At(n-1))^.X,3)
       +k2*pPoint2(List^.At(n-1))^.X*pPoint2(List^.At(n-1))^.X
       +k1*pPoint2(List^.At(n-1))^.X
       +k0
       -pPoint2(List^.At(n-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 5;
 end;

 if WriteIt then
 begin
  Entertext(5,'Fifth Order Polynome:');
  EnterText(5,'Y = k0 + k1*X + k2*X^2 + k3*X^3 + k4*X^4 + k5*X^5');
  EnterText(5,'');
  EnterText(5,'          Value     Std.Dev.  Min.Limit   Max.Limit');
  EnterText(5,' k0 = '+t(k0,11){+' '+t(S0,11)+' '+t(k0-2*s0,10)+' '+t(k0+2*s0,10)});
  EnterText(5,' k1 = '+t(k1,11){+' '+t(S1,11)+' '+t(k1-2*s1,10)+' '+t(k1+2*s1,10)});
  EnterText(5,' k2 = '+t(k2,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(5,' k3 = '+t(k3,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(5,' k4 = '+t(k4,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(5,' k5 = '+t(k5,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(5,'');
  EnterText(5,'Variance Y, S^2 = '+t(D,10));
 end;
 InvertCalc(5,NrPoints,WriteIt);
end;

Procedure tFit.Calculate6thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);

var Eq : Stelsel;
    n : integer;

begin
 pBut^.SetButtonState(32,true);
 n := NrPoints;
 Eq[5,5]:=n;   Eq[6,5]:=Ex;  Eq[7,5]:=Ex2; Eq[8,5]:=Ex3; Eq[9,5]:=Ex4; Eq[10,5]:=Ex5; Eq[11,5]:=Ex6; Eq[12,5]:=Ey;
 Eq[5,6]:=Ex;  Eq[6,6]:=Ex2; Eq[7,6]:=Ex3; Eq[8,6]:=Ex4; Eq[9,6]:=Ex5; Eq[10,6]:=Ex6; Eq[11,6]:=Ex7; Eq[12,6]:=Exy;
 Eq[5,7]:=Ex2; Eq[6,7]:=Ex3; Eq[7,7]:=Ex4; Eq[8,7]:=Ex5; Eq[9,7]:=Ex6; Eq[10,7]:=Ex7; Eq[11,7]:=Ex8; Eq[12,7]:=Ex2y;
 Eq[5,8]:=Ex3; Eq[6,8]:=Ex4; Eq[7,8]:=Ex5; Eq[8,8]:=Ex6; Eq[9,8]:=Ex7; Eq[10,8]:=Ex8; Eq[11,8]:=Ex9; Eq[12,8]:=Ex3y;
 Eq[5,9]:=Ex4; Eq[6,9]:=Ex5; Eq[7,9]:=Ex6; Eq[8,9]:=Ex7; Eq[9,9]:=Ex8; Eq[10,9]:=Ex9; Eq[11,9]:=Ex10;Eq[12,9]:=Ex4y;
 Eq[5,10]:=Ex5;Eq[6,10]:=Ex6;Eq[7,10]:=Ex7;Eq[8,10]:=Ex8;Eq[9,10]:=Ex9;Eq[10,10]:=Ex10;Eq[11,10]:=Ex11;Eq[12,10]:=Ex5y;
 Eq[5,11]:=Ex6;Eq[6,11]:=Ex7;Eq[7,11]:=Ex8;Eq[8,11]:=Ex9;Eq[9,11]:=Ex10;Eq[10,11]:=Ex11;Eq[11,11]:=Ex12;Eq[12,11]:=Ex6y;
 SolveEq(Eq,7);
 k6 := Eq[12,11];
 k5 := Eq[12,10]-Eq[11,10]*k6;
 k4 := Eq[12,9]-Eq[11,9]*k6-Eq[10,9]*k5;
 k3 := Eq[12,8]-Eq[11,8]*k6-Eq[10,8]*k5-Eq[9,8]*k4;
 k2 := Eq[12,7]-Eq[11,7]*k6-Eq[10,7]*k5-Eq[9,7]*k4-Eq[8,7]*k3;
 k1 := Eq[12,6]-Eq[11,6]*k6-Eq[10,6]*k5-Eq[9,6]*k4-Eq[8,6]*k3-Eq[7,6]*k2;
 k0 := Eq[12,5]-Eq[11,5]*k6-Eq[10,5]*k5-Eq[9,5]*k4-Eq[8,5]*k3-Eq[7,5]*k2-Eq[6,5]*k1;

 D:= 0;
 for n := 1 to NrPoints do
 begin
  E := k6*Macht(pPoint2(List^.At(n-1))^.X,6)
       +k5*Macht(pPoint2(List^.At(n-1))^.X,5)
       +k4*Macht(pPoint2(List^.At(n-1))^.X,4)
       +k3*Macht(pPoint2(List^.At(n-1))^.X,3)
       +k2*pPoint2(List^.At(n-1))^.X*pPoint2(List^.At(n-1))^.X
       +k1*pPoint2(List^.At(n-1))^.X
       +k0
       -pPoint2(List^.At(n-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 6;
 end;

 if WriteIt then
 begin
  Entertext(6,'Sixth Order Polynome:');
  EnterText(6,'Y = k0 + k1*X + k2*X^2 + ... + k5*X^5 + k6*X^6');
  EnterText(6,'');
  EnterText(6,'          Value     Std.Dev.  Min.Limit   Max.Limit');
  EnterText(6,' k0 = '+t(k0,11){+' '+t(S0,11)+' '+t(k0-2*s0,10)+' '+t(k0+2*s0,10)});
  EnterText(6,' k1 = '+t(k1,11){+' '+t(S1,11)+' '+t(k1-2*s1,10)+' '+t(k1+2*s1,10)});
  EnterText(6,' k2 = '+t(k2,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(6,' k3 = '+t(k3,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(6,' k4 = '+t(k4,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(6,' k5 = '+t(k5,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(6,' k6 = '+t(k6,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(6,'');
  EnterText(6,'Variance Y, S^2 = '+t(D,10));
 end;
 InvertCalc(6,NrPoints,WriteIt);
end;

Procedure tFit.Calculate7thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);

var Eq : Stelsel;
    n : integer;

begin
 pBut^.SetButtonState(64,true);
 n := NrPoints;
 Eq[4,4]:=n;   Eq[5,4]:=Ex;  Eq[6,4]:=Ex2; Eq[7,4]:=Ex3; Eq[8,4]:=Ex4; Eq[9,4]:=Ex5; Eq[10,4]:=Ex6; Eq[11,4]:=Ex7;
 Eq[12,4]:=Ey;
 Eq[4,5]:=Ex;  Eq[5,5]:=Ex2; Eq[6,5]:=Ex3; Eq[7,5]:=Ex4; Eq[8,5]:=Ex5; Eq[9,5]:=Ex6; Eq[10,5]:=Ex7; Eq[11,5]:=Ex8;
 Eq[12,5]:=Exy;
 Eq[4,6]:=Ex2; Eq[5,6]:=Ex3; Eq[6,6]:=Ex4; Eq[7,6]:=Ex5; Eq[8,6]:=Ex6; Eq[9,6]:=Ex7; Eq[10,6]:=Ex8; Eq[11,6]:=Ex9;
 Eq[12,6]:=Ex2y;
 Eq[4,7]:=Ex3; Eq[5,7]:=Ex4; Eq[6,7]:=Ex5; Eq[7,7]:=Ex6; Eq[8,7]:=Ex7; Eq[9,7]:=Ex8; Eq[10,7]:=Ex9; Eq[11,7]:=Ex10;
 Eq[12,7]:=Ex3y;
 Eq[4,8]:=Ex4; Eq[5,8]:=Ex5; Eq[6,8]:=Ex6; Eq[7,8]:=Ex7; Eq[8,8]:=Ex8; Eq[9,8]:=Ex9; Eq[10,8]:=Ex10;Eq[11,8]:=Ex11;
 Eq[12,8]:=Ex4y;
 Eq[4,9]:=Ex5; Eq[5,9]:=Ex6; Eq[6,9]:=Ex7; Eq[7,9]:=Ex8; Eq[8,9]:=Ex9; Eq[9,9]:=Ex10;Eq[10,9]:=Ex11;Eq[11,9]:=Ex12;
 Eq[12,9]:=Ex5y;
 Eq[4,10]:=Ex6;Eq[5,10]:=Ex7;Eq[6,10]:=Ex8;Eq[7,10]:=Ex9;Eq[8,10]:=Ex10;Eq[9,10]:=Ex11;Eq[10,10]:=Ex12;Eq[11,10]:=Ex13;
 Eq[12,10]:=Ex6y;
 Eq[4,11]:=Ex7;Eq[5,11]:=Ex8;Eq[6,11]:=Ex9;Eq[7,11]:=Ex10;Eq[8,11]:=Ex11;Eq[9,11]:=Ex12;Eq[10,11]:=Ex13;Eq[11,11]:=Ex14;
 Eq[12,11]:=Ex7y;
 SolveEq(Eq,8);
 k7 := Eq[12,11];
 k6 := Eq[12,10]-Eq[11,10]*k7;
 k5 := Eq[12,9]-Eq[11,9]*k7-Eq[10,9]*k6;
 k4 := Eq[12,8]-Eq[11,8]*k7-Eq[10,8]*k6-Eq[9,8]*k5;
 k3 := Eq[12,7]-Eq[11,7]*k7-Eq[10,7]*k6-Eq[9,7]*k5-Eq[8,7]*k4;
 k2 := Eq[12,6]-Eq[11,6]*k7-Eq[10,6]*k6-Eq[9,6]*k5-Eq[8,6]*k4-Eq[7,6]*k3;
 k1 := Eq[12,5]-Eq[11,5]*k7-Eq[10,5]*k6-Eq[9,5]*k5-Eq[8,5]*k4-Eq[7,5]*k3-Eq[6,5]*k2;
 k0 := Eq[12,4]-Eq[11,4]*k7-Eq[10,4]*k6-Eq[9,4]*k5-Eq[8,4]*k4-Eq[7,4]*k3-Eq[6,4]*k2-Eq[5,4]*k1;

 D:= 0;
 for n := 1 to NrPoints do
 begin
  E := k7*Macht(pPoint2(List^.At(n-1))^.X,7)
       +k6*Macht(pPoint2(List^.At(n-1))^.X,6)
       +k5*Macht(pPoint2(List^.At(n-1))^.X,5)
       +k4*Macht(pPoint2(List^.At(n-1))^.X,4)
       +k3*Macht(pPoint2(List^.At(n-1))^.X,3)
       +k2*pPoint2(List^.At(n-1))^.X*pPoint2(List^.At(n-1))^.X
       +k1*pPoint2(List^.At(n-1))^.X
       +k0
       -pPoint2(List^.At(n-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 7;
 end;

 if WriteIt then
 begin
  Entertext(7,'Seventh Order Polynome:');
  EnterText(7,'Y = k0 + k1*X + k2*X^2 + ... + k6*X^6 + k7*X^7');
  EnterText(7,'');
  EnterText(7,'          Value     Std.Dev.  Min.Limit   Max.Limit');
  EnterText(7,' k0 = '+t(k0,11){+' '+t(S0,11)+' '+t(k0-2*s0,10)+' '+t(k0+2*s0,10)});
  EnterText(7,' k1 = '+t(k1,11){+' '+t(S1,11)+' '+t(k1-2*s1,10)+' '+t(k1+2*s1,10)});
  EnterText(7,' k2 = '+t(k2,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(7,' k3 = '+t(k3,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(7,' k4 = '+t(k4,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(7,' k5 = '+t(k5,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(7,' k6 = '+t(k6,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(7,' k7 = '+t(k7,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(7,'');
  EnterText(7,'Variance Y, S^2 = '+t(D,10));
 end;
 InvertCalc(7,NrPoints,WriteIt);
end;

Procedure tFit.Calculate8thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);

var Eq : Stelsel;
    n : integer;

begin
 pBut^.SetButtonState(128,true);
 n := NrPoints;
 Eq[3,3]:=n;   Eq[4,3]:=Ex;  Eq[5,3]:=Ex2; Eq[6,3]:=Ex3; Eq[7,3]:=Ex4; Eq[8,3]:=Ex5; Eq[9,3]:=Ex6; Eq[10,3]:=Ex7;
 Eq[11,3]:=Ex8;  Eq[12,3]:=Ey;
 Eq[3,4]:=Ex;  Eq[4,4]:=Ex2; Eq[5,4]:=Ex3; Eq[6,4]:=Ex4; Eq[7,4]:=Ex5; Eq[8,4]:=Ex6; Eq[9,4]:=Ex7; Eq[10,4]:=Ex8;
 Eq[11,4]:=Ex9;  Eq[12,4]:=Exy;
 Eq[3,5]:=Ex2; Eq[4,5]:=Ex3; Eq[5,5]:=Ex4; Eq[6,5]:=Ex5; Eq[7,5]:=Ex6; Eq[8,5]:=Ex7; Eq[9,5]:=Ex8; Eq[10,5]:=Ex9;
 Eq[11,5]:=Ex10; Eq[12,5]:=Ex2y;
 Eq[3,6]:=Ex3; Eq[4,6]:=Ex4; Eq[5,6]:=Ex5; Eq[6,6]:=Ex6; Eq[7,6]:=Ex7; Eq[8,6]:=Ex8; Eq[9,6]:=Ex9; Eq[10,6]:=Ex10;
 Eq[11,6]:=Ex11; Eq[12,6]:=Ex3y;
 Eq[3,7]:=Ex4; Eq[4,7]:=Ex5; Eq[5,7]:=Ex6; Eq[6,7]:=Ex7; Eq[7,7]:=Ex8; Eq[8,7]:=Ex9; Eq[9,7]:=Ex10;Eq[10,7]:=Ex11;
 Eq[11,7]:=Ex12; Eq[12,7]:=Ex4y;
 Eq[3,8]:=Ex5; Eq[4,8]:=Ex6; Eq[5,8]:=Ex7; Eq[6,8]:=Ex8; Eq[7,8]:=Ex9; Eq[8,8]:=Ex10;Eq[9,8]:=Ex11;Eq[10,8]:=Ex12;
 Eq[11,8]:=Ex13; Eq[12,8]:=Ex5y;
 Eq[3,9]:=Ex6; Eq[4,9]:=Ex7; Eq[5,9]:=Ex8; Eq[6,9]:=Ex9; Eq[7,9]:=Ex10;Eq[8,9]:=Ex11;Eq[9,9]:=Ex12;Eq[10,9]:=Ex13;
 Eq[11,9]:=Ex14; Eq[12,9]:=Ex6y;
 Eq[3,10]:=Ex7;Eq[4,10]:=Ex8;Eq[5,10]:=Ex9;Eq[6,10]:=Ex10;Eq[7,10]:=Ex11;Eq[8,10]:=Ex12;Eq[9,10]:=Ex13;Eq[10,10]:=Ex14;
 Eq[11,10]:=Ex15;Eq[12,10]:=Ex7y;
 Eq[3,11]:=Ex8;Eq[4,11]:=Ex9;Eq[5,11]:=Ex10;Eq[6,11]:=Ex11;Eq[7,11]:=Ex12;Eq[8,11]:=Ex13;Eq[9,11]:=Ex14;Eq[10,11]:=Ex15;
 Eq[11,11]:=Ex16;Eq[12,11]:=Ex8y;
 SolveEq(Eq,9);
 k8 := Eq[12,11];
 k7 := Eq[12,10]-Eq[11,10]*k8;
 k6 := Eq[12,9]-Eq[11,9]*k8-Eq[10,9]*k7;
 k5 := Eq[12,8]-Eq[11,8]*k8-Eq[10,8]*k7-Eq[9,8]*k6;
 k4 := Eq[12,7]-Eq[11,7]*k8-Eq[10,7]*k7-Eq[9,7]*k6-Eq[8,7]*k5;
 k3 := Eq[12,6]-Eq[11,6]*k8-Eq[10,6]*k7-Eq[9,6]*k6-Eq[8,6]*k5-Eq[7,6]*k4;
 k2 := Eq[12,5]-Eq[11,5]*k8-Eq[10,5]*k7-Eq[9,5]*k6-Eq[8,5]*k5-Eq[7,5]*k4-Eq[6,5]*k3;
 k1 := Eq[12,4]-Eq[11,4]*k8-Eq[10,4]*k7-Eq[9,4]*k6-Eq[8,4]*k5-Eq[7,4]*k4-Eq[6,4]*k3-Eq[5,4]*k2;
 k0 := Eq[12,3]-Eq[11,3]*k8-Eq[10,3]*k7-Eq[9,3]*k6-Eq[8,3]*k5-Eq[7,3]*k4-Eq[6,3]*k3-Eq[5,3]*k2-Eq[4,3]*k1;

 D:= 0;
 for n := 1 to NrPoints do
 begin
  E := k8*Macht(pPoint2(List^.At(n-1))^.X,8)
       +k7*Macht(pPoint2(List^.At(n-1))^.X,7)
       +k6*Macht(pPoint2(List^.At(n-1))^.X,6)
       +k5*Macht(pPoint2(List^.At(n-1))^.X,5)
       +k4*Macht(pPoint2(List^.At(n-1))^.X,4)
       +k3*Macht(pPoint2(List^.At(n-1))^.X,3)
       +k2*pPoint2(List^.At(n-1))^.X*pPoint2(List^.At(n-1))^.X
       +k1*pPoint2(List^.At(n-1))^.X
       +k0
       -pPoint2(List^.At(n-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 8;
 end;

 if WriteIt then
 begin
  Entertext(8,'Eighth Order Polynome:');
  EnterText(8,'Y = k0 + k1*X + k2*X^2 + ... + k7*X^7 + k8*X^8');
  EnterText(8,'');
  EnterText(8,'          Value     Std.Dev.  Min.Limit   Max.Limit');
  EnterText(8,' k0 = '+t(k0,11){+' '+t(S0,11)+' '+t(k0-2*s0,10)+' '+t(k0+2*s0,10)});
  EnterText(8,' k1 = '+t(k1,11){+' '+t(S1,11)+' '+t(k1-2*s1,10)+' '+t(k1+2*s1,10)});
  EnterText(8,' k2 = '+t(k2,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(8,' k3 = '+t(k3,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(8,' k4 = '+t(k4,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(8,' k5 = '+t(k5,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(8,' k6 = '+t(k6,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(8,' k7 = '+t(k7,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(8,' k8 = '+t(k8,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(8,'');
  EnterText(8,'Variance Y, S^2 = '+t(D,10));
 end;
 InvertCalc(8,NrPoints,WriteIt);
end;

Procedure tFit.Calculate9thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);

var Eq : Stelsel;
    n : integer;

begin
 pBut^.SetButtonState(256,true);
 n := NrPoints;
 Eq[2,2]:=n;   Eq[3,2]:=Ex;  Eq[4,2]:=Ex2; Eq[5,2]:=Ex3; Eq[6,2]:=Ex4; Eq[7,2]:=Ex5; Eq[8,2]:=Ex6; Eq[9,2]:=Ex7;
 Eq[10,2]:=Ex8;  Eq[11,2]:=Ex9;  Eq[12,2]:=Ey;
 Eq[2,3]:=Ex;  Eq[3,3]:=Ex2; Eq[4,3]:=Ex3; Eq[5,3]:=Ex4; Eq[6,3]:=Ex5; Eq[7,3]:=Ex6; Eq[8,3]:=Ex7; Eq[9,3]:=Ex8;
 Eq[10,3]:=Ex9;  Eq[11,3]:=Ex10; Eq[12,3]:=Exy;
 Eq[2,4]:=Ex2; Eq[3,4]:=Ex3; Eq[4,4]:=Ex4; Eq[5,4]:=Ex5; Eq[6,4]:=Ex6; Eq[7,4]:=Ex7; Eq[8,4]:=Ex8; Eq[9,4]:=Ex9;
 Eq[10,4]:=Ex10; Eq[11,4]:=Ex11; Eq[12,4]:=Ex2y;
 Eq[2,5]:=Ex3; Eq[3,5]:=Ex4; Eq[4,5]:=Ex5; Eq[5,5]:=Ex6; Eq[6,5]:=Ex7; Eq[7,5]:=Ex8; Eq[8,5]:=Ex9; Eq[9,5]:=Ex10;
 Eq[10,5]:=Ex11; Eq[11,5]:=Ex12; Eq[12,5]:=Ex3y;
 Eq[2,6]:=Ex4; Eq[3,6]:=Ex5; Eq[4,6]:=Ex6; Eq[5,6]:=Ex7; Eq[6,6]:=Ex8; Eq[7,6]:=Ex9; Eq[8,6]:=Ex10;Eq[9,6]:=Ex11;
 Eq[10,6]:=Ex12; Eq[11,6]:=Ex13; Eq[12,6]:=Ex4y;
 Eq[2,7]:=Ex5; Eq[3,7]:=Ex6; Eq[4,7]:=Ex7; Eq[5,7]:=Ex8; Eq[6,7]:=Ex9; Eq[7,7]:=Ex10;Eq[8,7]:=Ex11;Eq[9,7]:=Ex12;
 Eq[10,7]:=Ex13; Eq[11,7]:=Ex14; Eq[12,7]:=Ex5y;
 Eq[2,8]:=Ex6; Eq[3,8]:=Ex7; Eq[4,8]:=Ex8; Eq[5,8]:=Ex9; Eq[6,8]:=Ex10;Eq[7,8]:=Ex11;Eq[8,8]:=Ex12;Eq[9,8]:=Ex13;
 Eq[10,8]:=Ex14; Eq[11,8]:=Ex15; Eq[12,8]:=Ex6y;
 Eq[2,9]:=Ex7; Eq[3,9]:=Ex8; Eq[4,9]:=Ex9; Eq[5,9]:=Ex10;Eq[6,9]:=Ex11;Eq[7,9]:=Ex12;Eq[8,9]:=Ex13;Eq[9,9]:=Ex14;
 Eq[10,9]:=Ex15; Eq[11,9]:=Ex16; Eq[12,9]:=Ex7y;
 Eq[2,10]:=Ex8;Eq[3,10]:=Ex9;Eq[4,10]:=Ex10;Eq[5,10]:=Ex11;Eq[6,10]:=Ex12;Eq[7,10]:=Ex13;Eq[8,10]:=Ex14;Eq[9,10]:=Ex15;
 Eq[10,10]:=Ex16;Eq[11,10]:=Ex17;Eq[12,10]:=Ex8y;
 Eq[2,11]:=Ex9;Eq[3,11]:=Ex10;Eq[4,11]:=Ex11;Eq[5,11]:=Ex12;Eq[6,11]:=Ex13;Eq[7,11]:=Ex14;Eq[8,11]:=Ex15;Eq[9,11]:=Ex16;
 Eq[10,11]:=Ex17;Eq[11,11]:=Ex18;Eq[12,11]:=Ex9y;
 SolveEq(Eq,10);
 k9 := Eq[12,11];
 k8 := Eq[12,10]-Eq[11,10]*k9;
 k7 := Eq[12,9]-Eq[11,9]*k9-Eq[10,9]*k8;
 k6 := Eq[12,8]-Eq[11,8]*k9-Eq[10,8]*k8-Eq[9,8]*k7;
 k5 := Eq[12,7]-Eq[11,7]*k9-Eq[10,7]*k8-Eq[9,7]*k7-Eq[8,7]*k6;
 k4 := Eq[12,6]-Eq[11,6]*k9-Eq[10,6]*k8-Eq[9,6]*k7-Eq[8,6]*k6-Eq[7,6]*k5;
 k3 := Eq[12,5]-Eq[11,5]*k9-Eq[10,5]*k8-Eq[9,5]*k7-Eq[8,5]*k6-Eq[7,5]*k5-Eq[6,5]*k4;
 k2 := Eq[12,4]-Eq[11,4]*k9-Eq[10,4]*k8-Eq[9,4]*k7-Eq[8,4]*k6-Eq[7,4]*k5-Eq[6,4]*k4-Eq[5,4]*k3;
 k1 := Eq[12,3]-Eq[11,3]*k9-Eq[10,3]*k8-Eq[9,3]*k7-Eq[8,3]*k6-Eq[7,3]*k5-Eq[6,3]*k4-Eq[5,3]*k3-Eq[4,3]*k2;
 k0 := Eq[12,2]-Eq[11,2]*k9-Eq[10,2]*k8-Eq[9,2]*k7-Eq[8,2]*k6-Eq[7,2]*k5-Eq[6,2]*k4-Eq[5,2]*k3-Eq[4,2]*k2-Eq[3,2]*k1;

 D:= 0;
 for n := 1 to NrPoints do
 begin
  E := k9*Macht(pPoint2(List^.At(n-1))^.X,9)
       +k8*Macht(pPoint2(List^.At(n-1))^.X,8)
       +k7*Macht(pPoint2(List^.At(n-1))^.X,7)
       +k6*Macht(pPoint2(List^.At(n-1))^.X,6)
       +k5*Macht(pPoint2(List^.At(n-1))^.X,5)
       +k4*Macht(pPoint2(List^.At(n-1))^.X,4)
       +k3*Macht(pPoint2(List^.At(n-1))^.X,3)
       +k2*pPoint2(List^.At(n-1))^.X*pPoint2(List^.At(n-1))^.X
       +k1*pPoint2(List^.At(n-1))^.X
       +k0
       -pPoint2(List^.At(n-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 9;
 end;

 if WriteIt then
 begin
  Entertext(9,'Ninth Order Polynome:');
  EnterText(9,'Y = k0 + k1*X + k2*X^2 + ... + k8*X^8 + k9*X^9');
  EnterText(9,'');
  EnterText(9,'          Value     Std.Dev.  Min.Limit   Max.Limit');
  EnterText(9,' k0 = '+t(k0,11){+' '+t(S0,11)+' '+t(k0-2*s0,10)+' '+t(k0+2*s0,10)});
  EnterText(9,' k1 = '+t(k1,11){+' '+t(S1,11)+' '+t(k1-2*s1,10)+' '+t(k1+2*s1,10)});
  EnterText(9,' k2 = '+t(k2,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(9,' k3 = '+t(k3,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(9,' k4 = '+t(k4,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(9,' k5 = '+t(k5,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(9,' k6 = '+t(k6,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(9,' k7 = '+t(k7,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(9,' k8 = '+t(k8,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(9,' k9 = '+t(k9,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(9,'');
  EnterText(9,'Variance Y, S^2 = '+t(D,10));
 end;
 InvertCalc(9,NrPoints,WriteIt);
end;

Procedure tFit.Calculate10thDeg(NrPoints:integer;List:pPointCollection;WriteIt:Boolean);

var Eq : Stelsel;
    n : integer;

begin
 pBut^.SetButtonState(512,true);
 n := NrPoints;
 Eq[1,1]:=n;   Eq[2,1]:=Ex;  Eq[3,1]:=Ex2; Eq[4,1]:=Ex3; Eq[5,1]:=Ex4; Eq[6,1]:=Ex5; Eq[7,1]:=Ex6; Eq[8,1]:=Ex7;
 Eq[9,1]:=Ex8;   Eq[10,1]:=Ex9;   Eq[11,1]:=Ex10;  Eq[12,1]:=Ey;
 Eq[1,2]:=Ex;  Eq[2,2]:=Ex2; Eq[3,2]:=Ex3; Eq[4,2]:=Ex4; Eq[5,2]:=Ex5; Eq[6,2]:=Ex6; Eq[7,2]:=Ex7; Eq[8,2]:=Ex8;
 Eq[9,2]:=Ex9;   Eq[10,2]:=Ex10;  Eq[11,2]:=Ex11;  Eq[12,2]:=Exy;
 Eq[1,3]:=Ex2; Eq[2,3]:=Ex3; Eq[3,3]:=Ex4; Eq[4,3]:=Ex5; Eq[5,3]:=Ex6; Eq[6,3]:=Ex7; Eq[7,3]:=Ex8; Eq[8,3]:=Ex9;
 Eq[9,3]:=Ex10;  Eq[10,3]:=Ex11;  Eq[11,3]:=Ex12;  Eq[12,3]:=Ex2y;
 Eq[1,4]:=Ex3; Eq[2,4]:=Ex4; Eq[3,4]:=Ex5; Eq[4,4]:=Ex6; Eq[5,4]:=Ex7; Eq[6,4]:=Ex8; Eq[7,4]:=Ex9; Eq[8,4]:=Ex10;
 Eq[9,4]:=Ex11;  Eq[10,4]:=Ex12;  Eq[11,4]:=Ex13;  Eq[12,4]:=Ex3y;
 Eq[1,5]:=Ex4; Eq[2,5]:=Ex5; Eq[3,5]:=Ex6; Eq[4,5]:=Ex7; Eq[5,5]:=Ex8; Eq[6,5]:=Ex9; Eq[7,5]:=Ex10;Eq[8,5]:=Ex11;
 Eq[9,5]:=Ex12;  Eq[10,5]:=Ex13;  Eq[11,5]:=Ex14;  Eq[12,5]:=Ex4y;
 Eq[1,6]:=Ex5; Eq[2,6]:=Ex6; Eq[3,6]:=Ex7; Eq[4,6]:=Ex8; Eq[5,6]:=Ex9; Eq[6,6]:=Ex10;Eq[7,6]:=Ex11;Eq[8,6]:=Ex12;
 Eq[9,6]:=Ex13;  Eq[10,6]:=Ex14;  Eq[11,6]:=Ex15;  Eq[12,6]:=Ex5y;
 Eq[1,7]:=Ex6; Eq[2,7]:=Ex7; Eq[3,7]:=Ex8; Eq[4,7]:=Ex9; Eq[5,7]:=Ex10;Eq[6,7]:=Ex11;Eq[7,7]:=Ex12;Eq[8,7]:=Ex13;
 Eq[9,7]:=Ex14;  Eq[10,7]:=Ex15;  Eq[11,7]:=Ex16;  Eq[12,7]:=Ex6y;
 Eq[1,8]:=Ex7; Eq[2,8]:=Ex8; Eq[3,8]:=Ex9; Eq[4,8]:=Ex10;Eq[5,8]:=Ex11;Eq[6,8]:=Ex12;Eq[7,8]:=Ex13;Eq[8,8]:=Ex14;
 Eq[9,8]:=Ex15;  Eq[10,8]:=Ex16;  Eq[11,8]:=Ex17;  Eq[12,8]:=Ex7y;
 Eq[1,9]:=Ex8; Eq[2,9]:=Ex9; Eq[3,9]:=Ex10;Eq[4,9]:=Ex11;Eq[5,9]:=Ex12;Eq[6,9]:=Ex13;Eq[7,9]:=Ex14;Eq[8,9]:=Ex15;
 Eq[9,9]:=Ex16;  Eq[10,9]:=Ex17;  Eq[11,9]:=Ex18;  Eq[12,9]:=Ex8y;
 Eq[1,10]:=Ex9;Eq[2,10]:=Ex10;Eq[3,10]:=Ex11;Eq[4,10]:=Ex12;Eq[5,10]:=Ex13;Eq[6,10]:=Ex14;Eq[7,10]:=Ex15;Eq[8,10]:=Ex16;
 Eq[9,10]:=Ex17; Eq[10,10]:=Ex18; Eq[11,10]:=Ex19; Eq[12,10]:=Ex9y;
 Eq[1,11]:=Ex10;Eq[2,11]:=Ex11;Eq[3,11]:=Ex12;Eq[4,11]:=Ex13;Eq[5,11]:=Ex14;Eq[6,11]:=Ex15;Eq[7,11]:=Ex16;Eq[8,11]:=Ex17;
 Eq[9,11]:=Ex18; Eq[10,11]:=Ex19; Eq[11,11]:=Ex20; Eq[12,11]:=Ex10y;
 SolveEq(Eq,11);

 k10 := Eq[12,11];
 k9 := Eq[12,10]-Eq[11,10]*k10;
 k8 := Eq[12,9]-Eq[11,9]*k10-Eq[10,9]*k9;
 k7 := Eq[12,8]-Eq[11,8]*k10-Eq[10,8]*k9-Eq[9,8]*k8;
 k6 := Eq[12,7]-Eq[11,7]*k10-Eq[10,7]*k9-Eq[9,7]*k8-Eq[8,7]*k7;
 k5 := Eq[12,6]-Eq[11,6]*k10-Eq[10,6]*k9-Eq[9,6]*k8-Eq[8,6]*k7-Eq[7,6]*k6;
 k4 := Eq[12,5]-Eq[11,5]*k10-Eq[10,5]*k9-Eq[9,5]*k8-Eq[8,5]*k7-Eq[7,5]*k6-Eq[6,5]*k5;
 k3 := Eq[12,4]-Eq[11,4]*k10-Eq[10,4]*k9-Eq[9,4]*k8-Eq[8,4]*k7-Eq[7,4]*k6-Eq[6,4]*k5-Eq[5,4]*k4;
 k2 := Eq[12,3]-Eq[11,3]*k10-Eq[10,3]*k9-Eq[9,3]*k8-Eq[8,3]*k7-Eq[7,3]*k6-Eq[6,3]*k5-Eq[5,3]*k4-Eq[4,3]*k3;
 k1 := Eq[12,2]-Eq[11,2]*k10-Eq[10,2]*k9-Eq[9,2]*k8-Eq[8,2]*k7-Eq[7,2]*k6-Eq[6,2]*k5-Eq[5,2]*k4-Eq[4,2]*k3-Eq[3,2]*k2;
 k0 := Eq[12,1]-Eq[11,1]*k10-Eq[10,1]*k9-Eq[9,1]*k8-Eq[8,1]*k7-Eq[7,1]*k6-Eq[6,1]*k5-Eq[5,1]*k4-Eq[4,1]*k3-Eq[3,1]*k2-Eq[2,1];

 D:= 0;
 for n := 1 to NrPoints do
 begin
  E := k10*Macht(pPoint2(List^.At(n-1))^.X,10)
       +k9*Macht(pPoint2(List^.At(n-1))^.X,9)
       +k8*Macht(pPoint2(List^.At(n-1))^.X,8)
       +k7*Macht(pPoint2(List^.At(n-1))^.X,7)
       +k6*Macht(pPoint2(List^.At(n-1))^.X,6)
       +k5*Macht(pPoint2(List^.At(n-1))^.X,5)
       +k4*Macht(pPoint2(List^.At(n-1))^.X,4)
       +k3*Macht(pPoint2(List^.At(n-1))^.X,3)
       +k2*pPoint2(List^.At(n-1))^.X*pPoint2(List^.At(n-1))^.X
       +k1*pPoint2(List^.At(n-1))^.X
       +k0
       -pPoint2(List^.At(n-1))^.Y;
  D := D + E*E;
 end;
 if Bestfit > D then
 begin
  BestFit := D;
  Best := 10;
 end;

 if WriteIt then
 begin
  Entertext(10,'Tenth Order Polynome:');
  EnterText(10,'Y = k0 + k1*X + k2*X^2 + ... + k9*X^9 + k10*X^10');
  EnterText(10,'');
  EnterText(10,'          Value     Std.Dev.  Min.Limit   Max.Limit');
  EnterText(10,' k0 = '+t(k0,11){+' '+t(S0,11)+' '+t(k0-2*s0,10)+' '+t(k0+2*s0,10)});
  EnterText(10,' k1 = '+t(k1,11){+' '+t(S1,11)+' '+t(k1-2*s1,10)+' '+t(k1+2*s1,10)});
  EnterText(10,' k2 = '+t(k2,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(10,' k3 = '+t(k3,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(10,' k4 = '+t(k4,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(10,' k5 = '+t(k5,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(10,' k6 = '+t(k6,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(10,' k7 = '+t(k7,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(10,' k8 = '+t(k8,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(10,' k9 = '+t(k9,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(10,' k10= '+t(k10,11){+' '+t(S2,11)+' '+t(k2-2*s2,10)+' '+t(k2+2*s2,10)});
  EnterText(10,'');
  EnterText(10,'Variance Y, S^2 = '+t(D,10));
 end;
 InvertCalc(10,NrPoints,WriteIt);
end;

Procedure tFit.InvertCalc(Power:byte;NrPoint:integer;WriteIt:boolean);

var NrFound : word;
    txt     : string;
    count   : integer;
    calcX,Istd,Step,Step2,
    extra,ex2: extended;
    Min,max : extended;
    aa,bb,ccc: word;

 Function CalcPower(Number:extended):extended;

 begin
  case Power of
   2 : CalcPower := k0 + k1*Number + k2*Macht(Number,2);
   3 : CalcPower := k0 + k1*Number + k2*Macht(Number,2) + k3*Macht(Number,3);
   4 : CalcPower := k0 + k1*Number + k2*Macht(Number,2) + k3*Macht(Number,3) + k4*Macht(Number,4);
   5 : CalcPower := k0 + k1*Number + k2*Macht(Number,2) + k3*Macht(Number,3) + k4*Macht(Number,4) + k5*Macht(Number,5);
   6 : CalcPower := k0 + k1*Number + k2*Macht(Number,2) + k3*Macht(Number,3) + k4*Macht(Number,4) + k5*Macht(Number,5) +
       k6*Macht(Number,6);
   7 : CalcPower := k0 + k1*Number + k2*Macht(Number,2) + k3*Macht(Number,3) + k4*Macht(Number,4) + k5*Macht(Number,5) +
       k6*Macht(Number,6) + k7*Macht(Number,7);
   8 : CalcPower := k0 + k1*Number + k2*Macht(Number,2) + k3*Macht(Number,3) + k4*Macht(Number,4) + k5*Macht(Number,5) +
       k6*Macht(Number,6) + k7*Macht(Number,7) + k8*Macht(Number,8);
   9 : CalcPower := k0 + k1*Number + k2*Macht(Number,2) + k3*Macht(Number,3) + k4*Macht(Number,4) + k5*Macht(Number,5) +
       k6*Macht(Number,6) + k7*Macht(Number,7) + k8*Macht(Number,8) + k9*Macht(Number,9);
   10: CalcPower := k0 + k1*Number + k2*Macht(Number,2) + k3*Macht(Number,3) + k4*Macht(Number,4) + k5*Macht(Number,5) +
       k6*Macht(Number,6) + k7*Macht(Number,7) + k8*Macht(Number,8) + k9*Macht(Number,9) + k10*Macht(Number,10);
  end;
 end;

begin
 if pInvert^.GetNrOfPoints > 0 then
 begin
  if WriteIt then
  begin
   str(pInvert^.GetNrOfPoints,txt);
   EnterText(Power,'');
   EnterText(Power,'Inverted use based on '+txt+' points:');
   for count := 1 to pInvert^.GetNrOfPoints do
   begin
    str(count:5,txt);
    EnterText(Power,txt+' : '+t(Extended(pInvert^.pInvList^.At(count-1)^),15));
   end;
   EnterText(Power,'    Mean Y     X at Mean Y  Stand.dev. X  minimum lim.X maximum lim.X');
   nrFound := 0; Max := pPoint2(pHolder^.pList^.At(PHolder^.GetNrOfPoints-1))^.X;
   Min := pPoint2(pHolder^.pList^.At(0))^.X;
   Step := (Max-Min)/10000;
   extra := CalcPower(Min)-MainInvert;
   for aa := 1 to 10000{5000} do
   begin
    ex2 := CalcPower(Step*aa+Min)-MainInvert;
    if ((ex2 < 0) and (extra > 0)) or ((ex2 > 0) and (extra < 0)) then
    begin
     NrFound := NrFound + 1;
     CalcX := (Step*(aa-1)+Min)+(Abs(extra)*(Step*aa-Step*(aa-1)))/(Abs(extra)+Abs(ex2));
     E := 0;
     For count := 1 to NrPoint do
     begin
      E := Sqr(Extended(pHolder^.pList^.At(count-1)^)-(Ex/NrPoint));
     end;
     E := Sqr(CalcX-(Ex/NrPoint))/E;
     Istd := Sqrt(D/(NrPoint-2))*(1/k1)*Sqrt((1/NrPoint)+(1/pInvert^.GetNrOfPoints)+E);
     EnterText(Power,t(MainInvert,13)+' '+t(CalcX,13)+' '+t(Istd,13)+' '+
                 t(CalcX-(GetT(NrPoint+pInvert^.GetNrOfPoints-3)*Istd),13)+' '+
                 t(CalcX+(GetT(NrPoint+pInvert^.GetNrOfPoints-3)*Istd),13));
    end;
    extra := ex2;
   end;
   if NrFound = 0 then
    EnterText(Power,'No Matches Found...');
  end;
 end;
end;

Procedure tFit.EnterText(Nr:byte;txt:string);

var ex : pstring;

begin
 new(ex);
 ex^ := txt;
 pRow[Nr]^.Insert(ex);
end;

Procedure tFit.ShowGraph(Mode:word);

var MaxX,Maxy : integer;
    pGraph : pGraphSize;
    Lx2,Hx2,Ly2,Hy2,XXX2 : extended;
    count,mode2 : word;
    txt         : string;
    XXX         : real;
    OldX,OldY,result : word;

  Function GiveX(aa:extended):word;

  begin
   Givex := round((aa-Lx)/(Hx-Lx)*(Maxx-60))+50;
  end;

  Function GiveY(bb:extended):word;

  begin
   GiveY := round((1-((bb-Ly)/(Hy-Ly)))*(Maxy-40))+10;
  end;

  Procedure Polish(var aa,bb:extended);

  var i,error,temp : integer;
      Low,High,Factor: extended;
      txt,txtaa,txtbb: string;
      Fac2    : real;

  begin {This procedure is supposed to set the boundries on whole numbres and
         set the spacing to 1,2 or 5. But it doesn't work. HELP!}
   str(aa:15,txt);
   txtaa := txt[1]+txt[2]+txt[3]+txt[4]+txt[5];
   txtbb := txt[11]+txt[12]+txt[13]+txt[14]+txt[15];
   val(txtaa,Fac2,error);
   if error <> 0 then exit;
   Fac2 := trunc(Fac2);
   if Fac2 < 0 then
    Fac2 := Fac2-1;
   str(Fac2,txtaa);
   val(txtaa[1]+txtaa[2]+txtaa[3]+txt[4]+'E'+txtbb,Low,error);
   if error <> 0 then exit;
   aa := Low;

   str(bb:15,txt);
   txtaa := txt[1]+txt[2]+txt[3]+txt[4]+txt[5];
   txtbb := txt[11]+txt[12]+txt[13]+txt[14]+txt[15];
   val(txtaa,Fac2,error);
   if error <> 0 then exit;
   Fac2 := trunc(Fac2);
   if Fac2 > 0 then
    Fac2 := Fac2+1;
   str(Fac2,txtaa);
   val(txtaa[1]+txtaa[2]+txtaa[3]+txtaa[4]+'E'+txtbb,High,error);
   if error <> 0 then exit;
   bb := High;

{   Factor := (High-Low)/5;
   str(Factor:15,txt);
   txtaa := txt[1]+txt[2]+txt[3]+txt[4]+txt[5];
   txtbb := txt[11]+txt[12]+txt[13]+txt[14]+txt[15];
   val(txtaa,Fac2,error);
   if error <> 0 then exit;

   {if Fac2 <= 1 then
   begin
    txtaa := '1';
    aa := Low;
    val(txtaa+'E'+txtbb,Low,error);
    if error <> 0 then exit;
    bb := Low*5+aa;
   end;
   if (Fac2 > 1) and (Fac2 <= 2) then
   begin
    txtaa := '2';
    aa := Low;
    val(txtaa+'E'+txtbb,Low,error);
    if error <> 0 then exit;
    bb := Low*5+aa;
   end;
   if (Fac2 > 2) and (Fac2 <= 5) then
   begin
    txtaa := '5';
    aa := Low;
    val(txtaa+'E'+txtbb,Low,error);
    if error <> 0 then exit;
    bb := Low*5+aa;
   end;
   if Fac2 > 5 then
   begin
    txtaa := '10';
    aa := Low;
    val(txtaa+'E'+txtbb,Low,error);
    if error <> 0 then exit;
    bb := Low*5+aa;
    bb := 10;
   end;}
  end;

  Procedure Print;

  begin
   PrintScr(GetMaxX,GetMaxY,1,false);
  end;

  begin
  Lx := pPoint2(pHolder^.Plist^.At(0))^.X;

  Hx := pPoint2(pHolder^.pList^.At(pHolder^.GetNrOfPoints-1))^.X;
  Polish(Lx,Hx);

  pHolder^.Getextremes(Ly,Hy);
  Polish(Ly,Hy);
  pOpt^.pXLine^.GetData(TextX);
  pOpt^.pYLine^.GetData(TextY);
  if Mode >= 100 then
   pGraph := New(pGraphSize,init(true))
  else
   pGraph := New(pGraphSize,init(false));
  Result := Application^.ExecuteDialog(pGraph,nil);
  if (Result = cmPlot) or (Result = cmPrintPlot) then
  begin
   if GraphicsStart then
   begin
    Maxx := Getmaxx; Maxy := Getmaxy;
    Rectangle(50,10,maxx-10,maxy-30);
    for count := 1 to 4 do
    begin
     Line(50,round(count/5*(Maxy-40))+10,60,round(count/5*(Maxy-40))+10);
     Line(Maxx-20,round(count/5*(Maxy-40))+10,Maxx-10,round(count/5*(Maxy-40))+10);
     Line(round(count/5*(maxx-60))+50,10,round(count/5*(maxx-60))+50,20);
     Line(round(count/5*(maxx-60))+50,Maxy-40,round(count/5*(maxx-60))+50,Maxy-30);
    end;
    Outtextxy(0,0,TextY);
    Outtextxy(Maxx-TextWidth(TextX),Maxy-20,TextX);
    for count := 0 to 5 do
    begin
     OutTextXY(GiveX((count/5*(Hx-Lx))+Lx)-30,Maxy-27,t((count/5*(Hx-Lx))+Lx,9));
     OutTextxy(1,GiveY((count/5*(Hy-Ly))+Ly)-5,t((count/5*(Hy-Ly))+Ly,5));
    end;
    for count := 1 to pHolder^.GetNrOfPoints do
    begin
     Bar(giveX(pPoint2(pHolder^.pList^.At(Count-1))^.X)-3,
         giveY(pPoint2(pHolder^.pList^.At(Count-1))^.Y)-3,
         giveX(pPoint2(pHolder^.pList^.At(Count-1))^.X)+3,
         giveY(pPoint2(pHolder^.pList^.At(Count-1))^.Y)+3);
     str(count,txt);
     OutTextXY(giveX(pPoint2(pHolder^.pList^.At(Count-1))^.X)+5,
               giveY(pPoint2(pHolder^.pList^.At(Count-1))^.Y),txt);
    end;
   if mode >= 100 then
    mode2 := mode-100
   else
    mode2 := mode;
   OldX := 0;Oldy := 0;
   for count := 50 to maxx-10 do
   begin
    XXX := (Hx-Lx)/(MaxX-60)*(count-50)+Lx;
    case Mode2 of
     1 : XXX2 := k0+k1*XXX;
     2 : XXX2 := k0+k1*XXX+k2*XXX*XXX;
     3 : XXX2 := k0+k1*XXX+k2*XXX*XXX+k3*Macht(XXX,3);
     4 : XXX2 := k0+k1*XXX+k2*XXX*XXX+k3*Macht(XXX,3)+k4*Macht(XXX,4);
     5 : XXX2 := k0+k1*XXX+k2*XXX*XXX+k3*Macht(XXX,3)+k4*Macht(XXX,4)+k5*Macht(XXX,5);
     6 : XXX2 := k0+k1*XXX+k2*XXX*XXX+k3*Macht(XXX,3)+k4*Macht(XXX,4)+k5*Macht(XXX,5)+k6*Macht(XXX,6);
     7 : XXX2 := k0+k1*XXX+k2*XXX*XXX+k3*Macht(XXX,3)+k4*Macht(XXX,4)+k5*Macht(XXX,5)+k6*Macht(XXX,6)+k7*Macht(XXX,7);
     8 : XXX2 := k0+k1*XXX+k2*XXX*XXX+k3*Macht(XXX,3)+k4*Macht(XXX,4)+k5*Macht(XXX,5)+k6*Macht(XXX,6)+k7*Macht(XXX,7)
                 +k8*Macht(XXX,8);
     9 : XXX2 := k0+k1*XXX+k2*XXX*XXX+k3*Macht(XXX,3)+k4*Macht(XXX,4)+k5*Macht(XXX,5)+k6*Macht(XXX,6)+k7*Macht(XXX,7)
                 +k8*Macht(XXX,8)+k9*Macht(XXX,9);
     10: XXX2 := k0+k1*XXX+k2*XXX*XXX+k3*Macht(XXX,3)+k4*Macht(XXX,4)+k5*Macht(XXX,5)+k6*Macht(XXX,6)+k7*Macht(XXX,7)
                 +k8*Macht(XXX,8)+k9*Macht(XXX,9)+k10*Macht(XXX,10);
    end;
    if OldX = 0 then
     Line(count-1,GiveY(XXX2)-1,count+1,GiveY(XXX2)+1)
    else
     Line(OldX,OldY,count,GiveY(XXX2));
    OldX := count;
    OldY := GiveY(XXX2);
   end;
   if Mode >= 100 then
    PRINT
   else
    readkey;
   GraphicsStop;
  end;
 end;
end;

var Prog : tProg;

begin
 Prog.Init;
 Prog.Run;
 Prog.Done;
end.