	title	postprn
; History:374,1

; Russ Nelson
;
; masm postprn;
; link postprn;
; exe2bin postprn.exe postprn.dvd
;
; DEVICE=postprn.dvd ( in config.sys)
;

DEBUG	equ	0

CR	equ	0dh
LF	equ	0ah

transfer	equ	0

dqq	struc
ofs	dw	?
seg	dw	?
dqq	ends

wqq	struc
w	dw	?
wqq	ends

bqq	struc
b	db	?
bqq	ends

rqq	struc
len	db	?
unit	db	?
code	db	?
status	dw	?
q1	dd	?
q2	dd	?
mdesc	db	?
trans	dd	?
count	dw	?
rqq	ends

cseg	segment	byte
	assume	cs:cseg
	org	0

success	equ	0100h
error	equ	8100h
unk_cmd	equ	8103h
busy	equ	0300h

land_header	label	near
	dw	land2_header
	dw	0
	dw	8800h			;we support Open/Close/RM.
	dw	strat
	dw	land
	db	'PRNLAND '

land2_header	label	near
	dw	land4_header
	dw	0
	dw	8800h			;we support Open/Close/RM.
	dw	strat
	dw	land2
	db	'PRNLAND2'

land4_header	label	near
	dw	port_header
	dw	0
	dw	8800h			;we support Open/Close/RM.
	dw	strat
	dw	land4
	db	'PRNLAND4'

port_header	label	near
	dw	port2_header
	dw	0
	dw	8800h			;we support Open/Close/RM.
	dw	strat
	dw	port
	db	'PRNPORT '

port2_header	label	near
	dw	port4_header
	dw	0
	dw	8800h			;we support Open/Close/RM.
	dw	strat
	dw	port2
	db	'PRNPORT2'

port4_header	label	near
	dd	-1
	dw	8800h			;we support Open/Close/RM.
	dw	strat
	dw	port4
	db	'PRNPORT4'

;currently, we only print to printer zero (lpt1 aka prn).
;this could be made a user option.
printer	dw	0			;which printer to print to.

prolog_ptr	dw	?

just_opened	db	0

req	dd	?

land_prolog	label	byte
  if DEBUG
	db	'%% land',CR,LF
  else
	include	land.inc
  endif
	db	0
land2_prolog	label	byte
  if DEBUG
	db	'%% land2',CR,LF
  else
	include	land2.inc
  endif
	db	0
land4_prolog	label	byte
  if DEBUG
	db	'%% land4',CR,LF
  else
	include	land4.inc
  endif
	db	0
port_prolog	label	byte
  if DEBUG
	db	'%% port',CR,LF
  else
	include	port.inc
  endif
	db	0
port2_prolog	label	byte
  if DEBUG
	db	'%% port2',CR,LF
  else
	include	port2.inc
  endif
	db	0
port4_prolog	label	byte
  if DEBUG
	db	'%% port4',CR,LF
  else
	include	port4.inc
  endif
	db	0

showline_prolog	label	byte
  if DEBUG
	db	'%% showline',CR,LF
  else
	include	showline.inc
  endif
	db	0

cmd_table	label	word
	dw	cmd_init
	dw	cmd_success
	dw	cmd_success
	dw	cmd_unk
	dw	cmd_success
	dw	cmd_busy
	dw	cmd_success
	dw	cmd_success
	dw	cmd_output
	dw	cmd_output
	dw	cmd_output_status
	dw	cmd_unk
	dw	cmd_unk
	dw	cmd_open
	dw	cmd_close
	dw	cmd_success

strat:
	mov	cs:[req].ofs,bx
	mov	cs:[req].seg,es
	retf

land:
	mov	cs:prolog_ptr,offset land_prolog
	jmp	short intr

land2:
	mov	cs:prolog_ptr,offset land2_prolog
	jmp	short intr

land4:
	mov	cs:prolog_ptr,offset land4_prolog
	jmp	short intr

port:
	mov	cs:prolog_ptr,offset port_prolog
	jmp	short intr

port2:
	mov	cs:prolog_ptr,offset port2_prolog
	jmp	short intr

port4:
	mov	cs:prolog_ptr,offset port4_prolog
	jmp	short intr


intr:
	push	ds
	push	es
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	mov	ax,cs
	mov	ds,ax
	les	bx,cs:req
	mov	al,es:[bx].code
	mov	ah,0
	shl	ax,1
	mov	si,ax

	call	cmd_table[si]

	les	bx,cs:req
	mov	es:[bx].status,ax
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
	retf

cmd_success:
	mov	ax,success
	ret

cmd_busy:
	mov	ax,busy
	ret

cmd_unk:
	mov	ax,unk_cmd
	ret

cmd_output:
	cmp	just_opened,0		;did we just open it?
	je	cmd_output_1
	mov	just_opened,0
	call	write_prolog
cmd_output_1:
	les	bx,cs:req
	mov	cx,es:[bx].count
	lds	si,es:[bx].trans
	mov	dx,cs:printer
output_loop:
	lodsb
	call	chrout
	jc	output_error
	loop	output_loop
	ret
output_error:
	les	bx,cs:req
	sub	es:[bx].count,cx
	ret


cmd_close:
	cmp	just_opened,1		;don't bother if we haven't
	je	cmd_close_1		;  sent anything.
	mov	dx,cs:printer
	mov	al,'D'-40h
	call	chrout
cmd_close_1:
	ret


cmd_open:
	mov	just_opened,1
	mov	ax,success
	ret


write_prolog:
	mov	si,offset showline_prolog
	call	write_string
	jc	write_string_1
	mov	si,prolog_ptr
write_string:
	mov	dx,cs:printer
write_string_2:
	lodsb
	or	al,al
	je	write_string_1
	call	chrout
	jnc	write_string_2
write_string_1:
	ret


chrout:
;enter with dx = printer number, al = character to print.
;return cy if we failed to print the character, nc if we printed it,
;  ax = status.
	mov	bl,0
chrout_1:
	mov	ah,0
	int	17h
	mov	bh,al
	call	status_check
	jnc	chrout_3
	xor	bl,1
	je	chrout_2
	mov	al,bh
	jmp	chrout_1
chrout_3:
	mov	ax,success
	clc
	ret
chrout_2:
	mov	ah,80h
	stc
	ret


cmd_output_status:
	mov	dx,cs:printer
	mov	ah,2
	int	17h
	call	status_check
	jc	buffer_error
	test	ah,80h
	jz	buffer_busy
	mov	ax,success
	ret
buffer_error:
	mov	ah,80h
	ret
buffer_busy:
	mov	ax,busy
	ret


status_check:
	mov	al,02h
	test	ah,01h
	jnz	status_bad
	mov	al,0ah
	test	ah,08h
	jz	status_ok
	test	ah,20h
	jz	status_bad
	mov	al,09h
status_bad:
	stc
	ret
status_ok:
	clc
	ret


	public	last_code
last_code	label	near

cmd_init:
	mov	ah,30h			;get the dos version number
	int	21h
	cmp	al,3			;if less than 3, we're hosed.
	jae	cmd_init_2
	mov	ah,9
	mov	dx,offset version	;tell them that we're hosed,
	int	21h
	mov	ax,0			;  and don't install ourselves.
	jmp	short cmd_init_3
cmd_init_2:
	cmp	cs:prolog_ptr,offset port4_prolog;only print the banner on
	jne	cmd_init_1		;the last device to be initialized.
	mov	ah,9
	mov	dx,offset banner
	int	21h
cmd_init_1:
	mov	ax,offset last_code	;tell dos where our last resident code is.
cmd_init_3:
	les	bx,cs:[req]		;return the end of our code.
	mov	es:[bx].trans.ofs,ax
	mov	es:[bx].trans.seg,cs
	mov	ax,success
	ret


banner	db	'Postprn version .9 has been loaded.',13,10,'$'
version	db	'Postprn requires MS-DOS 3.x.',13,10,'$'

cseg	ends

	end
