# Makefile for JETPAK programs
#
# MS-DOS Turbo C++ version
#
JETPAK=jetl2d.exe jetd2l.exe jetdmp.exe jetrst.exe jetprint.exe jetprd.exe
TLLIBPATH=d:\tc\lib
TLSUP=$(TLLIBPATH)\c0c
TLLIB=$(TLLIBPATH)\emu $(TLLIBPATH)\mathc $(TLLIBPATH)\cc

TCCANSI=-wbbf -weas -will -wpin
TCCPORT=-wcln -wsig -wucp
TCCFREQ=-wrvl -wamb -wamp -wnod -wstv -wuse

TCCOPTS=$(AUTO) $(TCCDEBUG) $(BIAS) $(OPT) -mc -c $(TCCANSI) $(TCCPORT) $(TCCFREQ)
TLOPTS=$(TLDEBUG) /c /x

#       NORMAL BUILD WITH DEBUGGING AND NO OPTIMISATION
debug:
        make    -DAUTO=   -DTCCDEBUG=-v  -DTLDEBUG=/v  -DBIAS=   -DOPT=   jetpak

#       BUILD WITH NO DEBUGGING AND FULL OPTIMISATION
release:
        make    -DAUTO=-X -DTCCDEBUG=-v- -DTLDEBUG=/v- -DBIAS=-G -DOPT=-O jetpak

#       COMMON BUILD
jetpak:         $(JETPAK)

#       START FROM SCRATCH
clean:
        del /y  *.obj *.exe

#       LINK STEPS
jetl2d.exe:     jetl2d.obj jetfont.obj jetutil.obj jetbmp.obj
        tlink   $(TLOPTS) $(TLSUP) jetl2d jetfont jetutil jetbmp,jetl2d,,$(TLLIB)

jetd2l.exe:     jetd2l.obj jetfont.obj jetutil.obj jetbmp.obj
        tlink   $(TLOPTS) $(TLSUP) jetd2l jetfont jetutil jetbmp,jetd2l,,$(TLLIB)

jetdmp.exe:    jetdmp.obj jetfont.obj jetmean.obj jetutil.obj jetbmp.obj
        tlink   $(TLOPTS) $(TLSUP) jetdmp jetfont jetmean jetutil jetbmp,jetdmp,,$(TLLIB)

jetrst.exe:    jetrst.obj jetfont.obj jetutil.obj jetbmp.obj
        tlink   $(TLOPTS) $(TLSUP) jetrst jetfont jetutil jetbmp,jetrst,,$(TLLIB)

jetprint.exe:   jetprint.obj jetfont.obj jetmean.obj jetutil.obj
        tlink   $(TLOPTS) $(TLSUP) jetprint jetfont jetmean jetutil,jetprint,,$(TLLIB)

jetprd.exe:     jetprd.obj jetfont.obj jetutil.obj
        tlink   $(TLOPTS) $(TLSUP) jetprd jetfont jetutil,jetprd,,$(TLLIB)

#       COMPILATION STEPS
jetl2d.obj:     jetl2d.c jetfont.h jetutil.h patchlev.h
        tcc     $(TCCOPTS) jetl2d

jetd2l.obj:     jetd2l.c jetfont.h jetutil.h patchlev.h
        tcc     $(TCCOPTS) jetd2l

jetdmp.obj:    jetdmp.c jetfont.h jetmean.h jetutil.h patchlev.h
        tcc     $(TCCOPTS) jetdmp

jetrst.obj:    jetrst.c jetfont.h jetutil.h patchlev.h
        tcc     $(TCCOPTS) jetrst

jetprint.obj:   jetprint.c jetfont.h jetmean.h jetutil.h patchlev.h
        tcc     $(TCCOPTS) jetprint

jetfont.obj:    jetfont.c jetfont.h jetutil.h patchlev.h
        tcc     $(TCCOPTS) jetfont

jetbmp.obj:     jetbmp.c jetfont.h jetutil.h patchlev.h
        tcc     $(TCCOPTS) jetbmp

jetmean.obj:    jetmean.c jetmean.h jetfont.h patchlev.h
        tcc     $(TCCOPTS) jetmean

jetutil.obj:    jetutil.c jetutil.h patchlev.h
        tcc     $(TCCOPTS) jetutil

jetprd.obj:     jetprd.c jetfont.h jetutil.h patchlev.h
        tcc     $(TCCOPTS) jetprd
