/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPUDUMP.C
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPUSTAT.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPU/VCS/DPUSTAT.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 15:27:00   etstjan
**              Initial revision.
*************************************************************************/
#include "dpuinc.h"

static FIELDDEF *finddef(char *IdName, int Element);
static int ProcAction(PWWIN *pWin, int Action, int Element);
static char *station;
static char *FieldIdName = "HDRADDR";

static FIELDDEF *finddef(char *IdName, int Element)
{
    int i;
    int id = DpuIniFindId(IdName);
    FIELDDEF *pDef = fieldinfo[id].first;

    for (i = 0; i< Element; i++)
        pDef = pDef->next;
    return pDef;
}

static int ProcAction(PWWIN *pWin, int Action, int Element)
{
    int id;
    FIELDDEF *pDef;
    int i;

    switch (Action)
    {
    case PWA_INIT:
        pw_shade(pWin);
        break;
    case PWA_COUNT:
        Element = 0;                            /* Count */
        if ((id = DpuIniFindId(FieldIdName)) >= 0)
        {
            pDef = fieldinfo[id].first;
            while (pDef)
            {
                pDef = pDef->next;
                Element++;
            }
        }
        break;
    case PWA_DISPLAY:
        pDef = finddef(FieldIdName, Element);
        pw_puts(pWin, pDef->desc);
        break;
    case PWA_FIRSTCHAR:
        pDef = finddef(FieldIdName, Element);
        Element = *(pDef->desc);
        break;
    case PWA_ENTER:
        pDef = finddef(FieldIdName, Element);
        for (i=0; i<hdrinfo->AddrLen; i++)
            station[i] = pDef->key[i];
        Element = -1;                       /* exit menu immediately */
        break;
    }
    return Element;
}

void DpuSelectStation(int row, int col, int nrow, char *Station, int *Element)
{
    station = Station;
    pw_select(row, col, nrow, 15, "Station", ProcAction, Element);
}
