/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPAIP.C
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1990/7/30
**
** DESCRIPTION: DP application file for the IP implementation
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPAIP.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/DPAIP/VCS/DPAIP.C_V  $
**              
**                 Rev 1.0   31 Jan 1991 16:44:48   etstjan
**              No explicit note
**              
**                 Rev 1.1   21 Nov 1990 14:37:24   etstjan
**              No explicit note
**              
**                 Rev 1.0   21 Nov 1990 12:33:30   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/DPAIP/VCS/DPAIP.C_V   1.0   31 Jan 1991 16:44:48   etstjan  $";
#endif

#include      <stdio.h> 
#include      <power3.h>
#include      <beholder.h>

/* prototyping of static functions                                          */
static int  DispEvents(DPEVENT Event);      /* Event processing function    */
static void ReceivePkt(void);               /* Event functions ...          */

void    IPEtherRec(DPBUF *pBuf);
void    TimerDriver(void);
void    ProcessEvents(void);

DPAPPS DpaIP = {
    "IP Stack",                             /* Application name             */
    DispEvents,                             /* Event processing function    */
    0,                                      /* Status, must be 0            */
    DPE_START | DPE_FREETIME | DPE_EVERYSECOND | DPE_RECEIVEPKT ,
    DPE_START,
    0,
    -1,
    0,
    0,
    0,
    0,                                      /* Count of filters             */
    {0}                                     /* List of filters              */
};

/**************************************************************
** NAME:        DispEvents
** SYNOPSIS:    static int DispEvents(DPEVENTS Event);
**
** DESCRIPTION: Processes dispatcher events.
**
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
static int DispEvents(DPEVENT Event)
{
    int ret = 0;

    switch (Event)
    {
    case DPE_RECEIVEPKT:    ReceivePkt();         break;
    case DPE_EVERYSECOND:   TimerDriver();        break;
    case DPE_FREETIME:      ProcessEvents();      break;
    }
    return ret;
}

/**************************************************************
** NAME:        ReceivePkt
** SYNOPSIS:    static void ReceivePkt(void);
**
** DESCRIPTION: Handles the Packet Dispatcher's 'Receive
**              Packet' Event.
** RETURNS:     
**************************************************************/
static void ReceivePkt(void)
{
  DPBUF *pBuf;

  pBuf = DpReceivePkt();               /* get packet descriptor     */
  IPEtherRec(pBuf);                    /* and call receive function */
}



