/******************************************************************************
* Iteraction library main header file (library local).			      *
*									      *
*					Written by Gershon Elber,  Oct. 1990  *
*******************************************************************************
* History:								      *
*  3 Oct 90 - Version 1.0 by Gershon Elber.				      *
*  17 Feb 92 - Version 2.0 by Gershon Elber - support for DJGPP.	      *
******************************************************************************/

#ifndef INTR_LOC_H
#define INTR_LOC_H

#ifdef __MSDOS__
#include <mem.h>
#endif /* __MSDOS__ */

#define KEY_LEFT     256	 /* Key Codes returned for operational keys. */
#define KEY_RIGHT    257
#define KEY_UP	     258
#define KEY_DOWN     259
#define KEY_RETURN   260
#define KEY_DELETE   261
#define KEY_INSERT   262
#define KEY_BSPACE   263
#define KEY_ESC      264
#define KEY_HOME     265
#define KEY_END      266
#define KEY_REFRESH  510
#define KEY_NONE     511

#define TEXT_BORDER	8
#ifdef DJGCC
#define TEXT_BASE_LINE	14
#else
#define TEXT_BASE_LINE	10
#endif /* DJGCC */
#define SCROLL_BAR_WIDTH 24

#define MIN(x, y)		((x) > (y) ? (y) : (x))
#define MAX(x, y)		((x) > (y) ? (x) : (y))
#define BOUND(x, Min, Max)	(MAX(MIN(x, Max), Min))

#define ABS(x)			((x) > 0 ? (x) : (-(x)))
#define SQR(x)			((x) * (x))
#define SIGN(x)			((x) > 0 ? 1 : ((x) < 0 ? -1 : 0))

#define SWAP(x, y, type)	{ type temp = (x); (x) = (y); (y) = temp; }

#define APX_EQ(x, y)		(ABS((x) - (y)) < EPSILON)

#define GEN_COPY(Dest, Src, Size) memcpy(Dest, Src, Size)
#define ZAP_MEM(Dest, Size)	memset(Dest, 0, Size);

#define DOT_PROD(Pt1, Pt2)	(Pt1[0] * Pt2[0] + \
				 Pt1[1] * Pt2[1] + \
				 Pt1[2] * Pt2[2])

#define DEG2RAD(Deg)		((Deg) * M_PI / 180.0)
#define RAD2DEG(Rad)		((Rad) * 180.0 / M_PI)

#define _INTR_SCROLL_BAR_WIDTH	14			  /* 14 pixels wide. */

/******************************************************************************
* This macro is called when the library has detected an unrecoverable error.  *
* Default action is to call IntrFatalError, but you may want to reroute this  *
* to invoke your handler and recover yourself (by long jump for example).     *
******************************************************************************/
#define FATAL_ERROR(Msg)	IntrFatalError(Msg);

#include "intr_lib.h"

typedef enum {
    ASYNC_EVNT_NONE,
    ASYNC_EVNT_PDMENU,
    ASYNC_EVNT_HSCRLBAR,
    ASYNC_EVNT_VSCRLBAR
} AsyncEventType;

typedef struct {
    AsyncEventType AsyncEvent;		            /* Type of async. event. */
    IntrEventType IntrEvent;		              /* Type of intr event. */
    _IntrWindowStruct *Window;			         /* Window of event. */
    IntrRType R;
    int X, Y;				       /* Location is screen coords. */
    int PDBottom, PDLeft; /* Bottom Left coords of pull down menu activated. */
} AsyncEventStruct;

extern IntrBType _IntrSaveBelow;
extern int _IntrActiveDevices;
extern IntrBType _IntrDetachKbdFromMouse;
extern AsyncEventStruct _IntrAsyncLastEvent;
extern int _IntrMouseSensitivity;

/* Global function that should be accessed by the library routines only: */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

VoidPtr _IntrMalloc(unsigned size);
void _IntrFree(VoidPtr p);
void _IntrAllocColors(void);
void _IntrTextWndwDelete(_IntrWndwTextStruct *TextInfo);
_IntrWindowStruct *_IntrFindWndwUsingID(int WindowID);
_IntrWindowStruct *_IntrWndwGetWndwInPos(int x, int y);
void _IntrWndwDrawFrame(int Xmin, int Xmax, int Ymin, int Ymax, int Width,
			IntrColorType FrameColor, IntrBType SaveUnder,
                        IntrColorType HScrlBarColor, IntrScrlBarType HScrlBar,
                        IntrColorType VScrlBarColor, IntrScrlBarType VScrlBar,
                        IntrBType HighIntensity);
void _IntrWndwPutNameHeader(int Xmin, int Xmax, int Ymax, int FrameWidth,
			    char *Str, IntrBType SaveUnder,
                            IntrColorType FrameColor, IntrColorType ForeColor,
                            IntrColorType BackColor, IntrBType HighIntensity);
IntrBType _IntrIsInternalEvent(IntrEventType Event, int x, int y);
void _IntrPullDownMenuDrawItems(IntrPullDownMenuStruct *PDMenu);
void _IntrPullDownInvertEntry(int Index,
			      _IntrWindowStruct *Window);
int _IntrPullDownMatchPosition(int x, int y,
			       _IntrWindowStruct *Window);
void _IntrUpdateScrollBar(int Left,
		          int Top,
		          int Right,
                          int Bottom,
		          IntrRType RelativePosition,
                          IntrRType DisplayedFraction,
                          IntrBType IsVertical,
                          IntrColorType ScrlBarColor);
void _IntrBoundBBox(int *Xmin, int *Ymin, int *Xmax, int *Ymax, int Width);

IntrBType _IntrAllowInternalEvent(void);
void _IntrSaveWindow(int Xmin, int Ymin, int Xmax, int Ymax);
void _IntrRestoreWindow(void);
void _IntrRestoreAll(void);
int _IntrPopUpMenu(IntrPopUpMenuStruct *PUMenu,
                   int Left,
                   int Top);
void _GRSetViewPort(int x1, int y1, int x2, int y2);
void _GRSetViewPort2(int x1, int y1, int x2, int y2, IntrBType Clip);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* INTR_LOC_H */
