/*
	picklist.cpp
	7-30-91
	Demo of coding with FlexList II

	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList are free to use and
	modify this tool for use in their programs.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, VA 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233

*/


#include <ctype.h>
#include <pckey.hpp>
#include <picklist.hpp>


Palette PickList::defaultP = {

	0,  /*  monochrome         or         color  */

	svideo(BLACK,LIGHTGRAY),	svideo(BLUE,LIGHTGRAY),
	svideo(LIGHTGRAY,BLACK),	svideo(WHITE,BLUE),
	svideo(WHITE,BLACK),		svideo(DARKGRAY,RED),
	svideo(DARKGRAY,LIGHTGRAY),	svideo(LIGHTGRAY,BLACK)
};


unsigned PickList::choose(unsigned curRow)
{
	unsigned startRow, pgLen, winHeight, winWidth;
	unsigned oldCurRow, oldStartRow;
	struct text_info ti;
	int c, y, owscroll, pfLen;
	void * D;
	CursorShape cursor;

	if (!Nodes())
		return 0;
	owscroll = _wscroll;
	_wscroll = 0;
	cursor.saveOrig();
	gettextinfo(&ti);
	mappalette(P);

	winHeight = ti.winbottom - ti.wintop;
	winWidth = ti.winright - ti.winleft + 1;
	if (!status)
		winHeight++;
	if (winHeight <= 2)
		return 0;
	pgLen = winHeight - 1;

	startRow = oldCurRow = oldStartRow = 0;


	for (c = (curRow? 0 : -Home); ; c = PCK.getkey()) {
		switch (c)  {
		case -PgDn:
			curRow += pgLen;
			if (curRow >= Nodes())  {
				curRow = Nodes();
				if (startRow + pgLen > curRow)
					break;
			}
			startRow += pgLen;
			if (startRow > curRow)
				startRow = curRow;
			prefix[pfLen = 0] = '\0';
			break;
		case -PgUp:
			if (curRow > pgLen)
				curRow -= pgLen;
			else
				curRow = 1;
			if (startRow > pgLen)
				startRow -= pgLen;
			else
				startRow = 1;
			prefix[pfLen = 0] = '\0';
			break;
		case -Home:
			curRow = startRow = 1;
			prefix[pfLen = 0] = '\0';
			break;
		case -EndKey:
			curRow = Nodes();
			if (curRow > startRow + pgLen)
				if (curRow > pgLen/2)
					startRow = curRow
						- pgLen/2;
				else
					startRow = 1;
			prefix[pfLen = 0] = '\0';
			break;
		case -UpArr:
			if (curRow > 1)
				if (--curRow < startRow)
					startRow = curRow;
			prefix[pfLen = 0] = '\0';
			break;
		case -DnArr:
			if (curRow < Nodes())  {
				if (++curRow - startRow > pgLen)
					startRow++;
			}
			else if (startRow < curRow)
				startRow++;
			prefix[pfLen = 0] = '\0';
			break;
		case 0: // start display at other than line one
			prefix[pfLen = 0] = '\0';
			if (curRow <= Nodes())  {
				startRow = 1;
				if (curRow > startRow + pgLen)  {
					if (curRow > pgLen/2)
						startRow = curRow
							- pgLen/2;
					else
						startRow = curRow;
				}
				break;
			}
			// fall thru to ESC
		case ESC:
			curRow = 0;
			// fall thru to CR
		case CR:
			if ((D = mkcur(curRow)) != (void *)0)
				if ((y = doIt(D)) > 0)  {
					// keep same display
					oldCurRow = oldStartRow = 0;
					break;
				}
				else if (y < 0)  {
					// new display
					oldCurRow = oldStartRow = 0;
					curRow = startRow = 1;
					prefix[pfLen = 0] = '\0';
					break;
				}
			textattr(ti.attribute);
			_wscroll = owscroll;
			cursor.restoreOrig();
			return CurNum();
		case BACKSP:
			if (!pfLen)
				continue;
			prefix[--pfLen] = '\0';
			if (!pfLen)  {
				curRow = startRow = 1;
				break;
			}
			mkcur();
			while ((D = nextD()) != (void *)0)
				if (match(prefix,D))  {
					curRow = CurNum();
					if (curRow > startRow + pgLen ||
						curRow < startRow)
						if (curRow > pgLen/2)
							startRow = curRow - pgLen/2;
						else
							startRow = 1;
					break;
				}
			break;
		default:
			if (c < 0 || !isprint(c))  {
				if ((D = mkcur(curRow)) != (void *)0)
					if (idle(c))  {
						// new display
						oldCurRow = oldStartRow = 0;
						curRow = startRow = 1;
						prefix[pfLen = 0] = '\0';
						break;
					}
				continue;
			}
			if (pfLen >= MAX_PL_PREFIX)
				continue;
			prefix[pfLen++] = toupper(c);
			prefix[pfLen] = '\0';
			mkcur();
			while ((D = nextD()) != (void *)0)
				if (match(prefix,D))  {
					curRow = CurNum();
					if (curRow > startRow + pgLen ||
						curRow < startRow)
						if (curRow > pgLen/2)
							startRow = curRow - pgLen/2;
						else
							startRow = 1;
					break;
				}
			if (!CurNum())
				prefix[pfLen--] = '\0';
			break;
		}
		cursor.off();
		if (oldStartRow && ((((y = oldStartRow-startRow) > 0)?
			y : -y) <= 1))  {
			mapvideo(NORMAL,P);
			if (oldCurRow && oldCurRow != curRow)  {
				gotoxy(1,oldCurRow - oldStartRow + 1);
				displayLine(mkcur(oldCurRow),winWidth);
			}
			if (y != 0)  {
				window(ti.winleft,ti.wintop,
					ti.winright,ti.wintop+winHeight-1);
				if (y > 0)  /* scroll up */
					insline();
				else  /* scroll down */
					delline();
				window(ti.winleft,ti.wintop,
					ti.winright,ti.winbottom);
			}
			if (oldCurRow != curRow)  {
				gotoxy(1,curRow - startRow + 1);
				mapvideo(SELECT,P);
				displayLine(mkcur(curRow),winWidth,1);
			}
		}
		else  {
			mapvideo(NORMAL,P);
			for (y = 1, D = mkcur(startRow);
				y <= winHeight && D;
				y++, D = nextD((void *)0))  {
				gotoxy(1,y);
				if (CurNum() == curRow)  {
					mapvideo(SELECT,P);
					displayLine(D,winWidth,1);
					mapvideo(NORMAL,P);
				}
				else  {
					displayLine(D,winWidth);
				}
			}
			while (y <= winHeight)  {
				gotoxy(1,y++);
				clreol();
			}
		}
		if (status) if (oldCurRow != curRow)  {
			mapvideo(STATUS,P);
			gotoxy(1,winHeight+1);
			displayStatus(mkcur(curRow),winWidth);
		}
		oldCurRow = curRow;
		oldStartRow = startRow;
		if (pfLen)  {
			gotoxy(xcursor(mkcur(curRow),prefix,pfLen),
				curRow - startRow + 1);
			cursor.block();
		}
		else  {
			gotoxy(1,curRow - startRow + 1);
			cursor.normal();
		}
	}

}

int PickList::subtractD(void * D)
{
	if (findFirstD(D))
		return delD();
	return 0;
}

unsigned PickListWindow::choose(int left, int top,
	int right, int bottom, unsigned curRow)
{
	if (!window(left,top,right,bottom))
		return 0;
	dressWindow();
	unsigned ok = PickList::choose(curRow);
	close();
	return ok;
}

unsigned PickListWindow::choose(unsigned curRow)
{
	struct text_info ti;
	int l, t, r, b, w, h;


	w = paneWidth();
	gettextinfo(&ti);
	if (w > ti.screenwidth)
		w = ti.screenwidth;
	else if (!w)
		w = ti.screenwidth/2;
	h = ti.screenheight/6 * 4;
	l = (ti.screenwidth - w)/2;
	r = l + w;
	t = ti.screenheight/6;
	b = t + h;
	return choose(l,t,r,b,curRow);
}


