/*
        Virtual screen support
*/
#include <alloc.h>
#include <graphics.h>
#include <dos.h>
#include "fdesplot.h"
#include "fdesmenu.h"
#define VWIDTH 1504             /* virtual screen dimensions */
#define VHEIGHT 1200            /* virtual screen dimensions */

long virt_target_size;

int vstop,vsbottom,vsleft,vsright;      /* part of virtual screen in display */

void vscreen_view(int top, int bottom, int left, int right)
{
        vstop = top;
        vsbottom = bottom;
        vsleft = left;
        vsright = right;
}
void vscreen_right(int right)
{
        vsleft += right;
        vsright += right;
}
void vscreen_down(int down)
{
        vstop += down;
        vsbottom += down;
}

char huge *vscreen;
void vscreen_close(void)
{
        farfree((void far *)vscreen);
}
int vscreen_open(void)
{
        vscreen = (char huge *)farmalloc((long)VWIDTH*VHEIGHT/8);
        if (vscreen == NULL)
        {
                putmsg(100,100,"Not Enough Memory Available",RED,WHITE);
                delay(2000);
                clrmsg();
                return(0);
        }
        vscreen_view(0,maxy,0,maxx);
        return(1);
}
void vputpixel(int x, int y)    /* sets pixel in virtual screen */
{
long byteno;
int bitmap;
/* debug */
/*        if ((x < vsright) && (x > vsleft) && (y < vsbottom)
            && (y > vstop))
        {
                putpixel(x-vsleft,y-vstop,15);
        }
*/
        if ((x >= VWIDTH) || (y >= VHEIGHT)) return;
        if ((x < 0) || (y < 0)) return;
        byteno = (x/8) + (long)y*(VWIDTH/8);
/*        if (byteno >= ((long)VWIDTH*VHEIGHT/8)) return; */
	bitmap = *(vscreen+byteno);
        bitmap |= (1 << (x&7));
        *(vscreen+byteno) = bitmap;
}
int vgetpixel(int x, int y)     /* returns nonzero if pixel lit */
{
long byteno;
int bitmap;
        if ((x >= VWIDTH) || (y >= VHEIGHT)) return(0);
        byteno = (x/8) + (long)y*(VWIDTH/8);
/*        if (byteno >= ((long)VWIDTH*VHEIGHT/8)) return(0); */
	bitmap = *(vscreen+byteno);
	return (bitmap & (1 << (x&7)));
}
void vscreen_clear(void)
{
long i;
        for (i=0; i<((long)VWIDTH*VHEIGHT/8); i++) *(vscreen+i) = 0;

}

