/*** SOURCE6.C - Creates a .3DV file with the definition of a surface
	     by Lenimar N. Andrade, ccendm03@brufpb.bitnet
      Dep. of Mathematics - Universidade Federal da Paraba - Brazil ***/

#include <stdio.h>
#include <math.h>
#include <conio.h>
#include <time.h>
#include <stdlib.h>

unsigned nu = 25, nv = 80;
FILE *arq;

/* Parametric equations that define the surface */
float f1(float u, float v) { return u*sin(v); }
float f2(float u, float v) { return u*cos(v); }
float f3(float u, float v) { return v; }

/* ------------------------------------------------------------------------- */

void CalcPoints(float umin, float umax, float vmin, float vmax) {

  float u, v, incrU, incrV;
  unsigned i, color;

  incrU = (umax - umin)/nu;
  incrV = (vmax - vmin)/nv;
  fprintf(arq, "%u\n", (nu + 1)*(nv + 1));

  for (v = vmin; v < vmax + incrV/2; v += incrV)
    for (u = umin; u < umax + incrU/2; u+= incrU)
      fprintf(arq, "%6.3f %6.3f %6.3f\n", f1(u, v), f2(u, v), f3(u, v));

  fprintf(arq, "%u\n", (nu + 1)*(nv + 1));

  for (i = 1; i <= (nu + 1)*(nv + 1); i++)
    if (i % (nu + 1) == 1) {
      color = 1 + random(15);
      fprintf(arq, "%u %u\n", i, 0);
    }
    else
      fprintf(arq, "%u %u\n", i, color);

}

/* ------------------------------------------------------------------------- */

void PrintMsg(void) {

  fprintf(arq, "\n%s", "Helicoid, F(u, v) = (u*cos(v), u*sin(v), v)");
  fprintf(arq, "\n%s", "Lenimar Nunes de Andrade, ccendm03@brufpb.bitnet\n");
}

/* ------------------------------------------------------------------------- */

void main(void) {

  time_t x;

  srand ((unsigned) time(&x));
  randomize();

  if ((arq = fopen("demo6.3dv", "wt")) == NULL) return;
  CalcPoints(-5, 5, -5, 5);
  PrintMsg();
  fclose(arq);
}

/* ------------------------------------------------------------------------- */

/*** END OF SOURCE6.C ***/
