/* Version 1.00
   September 4, 1995
   idtypes.h
   Written by Jeremiah W. James
   Compiled with:
      Borland C++ 3.0 (small memory model)
      GCC 2.6.3 (DJGPP 1.12.maint4)
*/

#ifndef _IDTYPES_H
#define _IDTYPES_H

#define BUFFER_SIZE 256    /* # of bytes in the I/O buffer */
#define ID_SIZE      10    /* # of bytes in a PAF ID field */
#define PAD_SIZE     22    /* Amount of padding for overflowing IDs */

/* As is inevitable, there are differences between compilers.  The
   differences are handled in this section.  They are:
   1) The PAF records are stored in a binary format on disk.  We need
      the internal structure to match the disk structure exactly.  GCC
      automatically aligns structure fields, which messes everything up.
      The solution is to make all the fields have the attribute
      'packed'.  Borland C doesn't need anything special.  See PACK.
   2) Some functions are time-critical.  Those which need to go really
      fast are labelled FASTFUNC.
   3) GCC uses 32-bit pointers, so all pointers are equal.  Borland C
      needs some pointers to be far, and needs farmalloc (declared in
      alloc.h) and _fstrncpy & _fmemcpy (declared in mem.h) to work
      properly.  See FARPTR, FARMALLOC, FARSTRNCPY, and FARMEMCPY.
*/
#ifdef __GNUC__
#define PACK __attribute__((packed))
#define FASTFUNC inline
#define FARPTR *
#define FARMALLOC malloc
#define FARSTRNCPY strncpy
#define FARMEMCPY memcpy
#else
#define PACK
#define FASTFUNC _fastcall
#include <alloc.h>
#include <mem.h>
#define FARPTR far *
#define FARMALLOC farmalloc
#define FARSTRNCPY _fstrncpy
#define FARMEMCPY _fmemcpy
#endif

/* Some useful data types */
typedef unsigned char  BYTE;     /* An 8-bit unsigned quantity */
typedef unsigned short WORD;     /* A 16-bit unsigned quantity */
typedef enum { FALSE, TRUE } BOOL;
typedef enum { st_UNSET, st_SET_THIS, st_SET_LAST, st_FINAL } STATUS;
/* STATUS will tell us which records we have examined while setting IDs */

/* Year: bits 0-11; Month: bits 12-16; Day: bits 17-21; Modifier: bits 22-23 */
typedef struct
{
   BYTE byte1 PACK;
   BYTE byte2 PACK;
   BYTE byte3 PACK;
} pafdate;

/* Dual year date: extra byte contains quantity to add to the year */
typedef struct
{
   pafdate date PACK;
   BYTE add PACK;
} pafexdate;

typedef struct
{
   WORD surname PACK;
   WORD given1 PACK;
   WORD given2 PACK;
   WORD given3 PACK;
   WORD title PACK;
   BYTE sex PACK;    /* The character 'D' here indicates a deleted record */
   pafexdate birthdate PACK;
   WORD birthplace1 PACK;
   WORD birthplace2 PACK;
   WORD birthplace3 PACK;
   WORD birthplace4 PACK;
   pafexdate chrdate PACK;
   WORD chrplace1 PACK;
   WORD chrplace2 PACK;
   WORD chrplace3 PACK;
   WORD chrplace4 PACK;
   pafexdate deathdate PACK;
   WORD deathplace1 PACK;
   WORD deathplace2 PACK;
   WORD deathplace3 PACK;
   WORD deathplace4 PACK;
   pafexdate burdate PACK;
   WORD burplace1 PACK;
   WORD burplace2 PACK;
   WORD burplace3 PACK;
   WORD burplace4 PACK;
   pafdate baptismdate PACK;
   WORD baptismtemple PACK;
   pafdate endowmentdate PACK;
   WORD endowmenttemple PACK;
   pafdate sealdate PACK;
   WORD sealtemple PACK;
   WORD older_sibling PACK;
   WORD marriage PACK;
   WORD parent_marriage PACK;
   char id[ID_SIZE] PACK;
   WORD notepad PACK;
} pafindividual;
/* NOTE: The ID field is 10 bytes.  The ID string is null-terminated,
   UNLESS the ID is exactly 10 bytes long.  Therefore, the 'n' version of
   the standard C string routines should be used (e.g., strncpy() instead
   of strcpy()).
*/

/* These are the only fields we need for each individual */
typedef struct
{
   WORD older_sibling;
   WORD marriage;
   WORD parent_marriage;
   char id[ID_SIZE];
   WORD status;
} individual;

typedef struct
{
   WORD husband PACK;
   WORD wife PACK;
   WORD child PACK;
   pafexdate marrdate PACK;
   WORD marrplace1 PACK;
   WORD marrplace2 PACK;
   WORD marrplace3 PACK;
   WORD marrplace4 PACK;
   pafdate sealdate PACK;
   WORD sealtemple PACK;
   WORD husband_other PACK;
   WORD wife_other PACK;
   BYTE divorced PACK; /* The character 'D' here indicates a deleted record */
} pafmarriage;

/* These are the only fields we need for each marriage */
typedef struct {
   WORD husband;
   WORD wife;
   WORD child;
   WORD husband_other;
   WORD wife_other;
} marriage;

#endif
