#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void checkIt(int argc, char **e_argv);
unsigned long setIt(unsigned long f, char **e_argv);
void topPage(char **e_argv);
void byteToHex(unsigned long f);
void editIt(int argc, char **e_argv);

FILE *inFile, *outFile;

int main(int argc, char **argv)
{
        unsigned long f=0;
        char **e_argv;
        e_argv=argv;
        checkIt(argc, e_argv);
	f=setIt(f, e_argv);
        topPage(e_argv);
	byteToHex(f);
       
return 0;
}

/*****************************************************************************/

void checkIt(int argc, char **e_argv)
{
  if ((e_argv[1] != NULL) && (strcmp(e_argv[1], "-e") == 0)) 
  { editIt(argc, e_argv); }
  else
  if (((inFile=fopen(e_argv[1], "r")) == (FILE *)NULL) || (argc != 3)){   
        puts("\nhexidump v1.5\nUsage: hexidump infile outfile\n\nTh"
             "e contents of infile will be converted to:\n\"hex "
             "address-hex byte values-ascii equivalent\"\nand dumped to ou"
             "tfile.\n");
	exit(1);
  }

}

/*****************************************************************************/

unsigned long setIt(unsigned long f, char **e_argv)
{
      
	inFile=fopen(e_argv[1], "rb");
	outFile=fopen(e_argv[2], "wt");
	fseek(inFile, 0, SEEK_END);
	f=ftell(inFile);
        fseek(inFile, 0, SEEK_SET);
return f;
}

/*****************************************************************************/

void topPage(char **e_argv)
{
        fprintf(outFile, "%s%s\n\n%s%23c%s%25c%s%s%17c%s"
                         "%19c%s%s%17c%s%19c%s%12c%s%s",
                         "file dumped: ", e_argv[1], 
                         "   hex", ' ', "hex", ' ', "ascii\n",
                         " address", ' ', "byte values", ' ', "equivalent\n",
                         " =======", ' ', "===========", ' ',"==========\n",
	                 ' ', "0 1  2 3  4 5  6 7  8 9  A B  C D  E F",
                         "  0123456789ABCDEF\n\n");

}

/*****************************************************************************/

void byteToHex(unsigned long f)
{

unsigned char z[16]={'0','1','2','3','4','5','6','7',
                    '8','9','A','B','C','D','E','F'};
unsigned char x[8]= {'0','0','0','0','0','0','0','0'};
unsigned long c[16];
unsigned int i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;
unsigned long b;
unsigned int h;

    for (b=0;b<=((f-1)/(16));b++) {
	x[6]=z[j];
        j++;
	if (j == 16) { j=0; }

	if (b%16 == 0) { x[5]=z[k];
                         k++;
                         if (k == 16) { k=0; }
                       }

	if (b%256 == 0) { x[4]=z[l];
                          l++;
                          if (l == 16) { l=0; }
                        }

	if (b%4096 == 0) { x[3]=z[m];
                           m++;
                           if (m == 16) { m=0; }
                         }

	if (b%65536 == 0) { x[2]=z[n];
                            n++;
                            if (n == 16) { n=0; }
                          }

        if (b%1048576 == 0) { x[1]=z[o];
                              o++;
                              if (o == 16) { o=0; }
                            }

	if (b%16777216 == 0) { x[0]=z[p];
                               p++;
                               if (p == 16) { p=0; }
                             }
	    
	fprintf(outFile, "%c%c%c%c%c%c%c%c: ", 
        x[0], x[1], x[2], x[3], x[4], x[5], x[6], x[7]);

      for (i=0;i<16;i++) { 
        c[i]=getc(inFile);
	if (c[i] == EOF) { break; }
	if (i%2 == 0) { fprintf(outFile, " "); }  
	if (c[i]==0) { fprintf(outFile, "00"); }
	if ((c[i]<16) && (c[i]>0)) { fprintf(outFile, "%c%c", z[0], z[c[i]]); }
	if (c[i]>15) { fprintf(outFile, "%c%c", z[c[i]/16], z[c[i]%16]); }
      } 

      if (b != f/16) { fprintf(outFile, "  "); }

      if (b == f/16) { 
                      h=f%16;
		      if (h%2 == 0) {
		      for (i=0;i<=((41)-((h*2)+(h/2)));i++) {
		      fprintf(outFile, " "); } }
		      if (h%2 != 0) {
                      for (i=0;i<=((40)-((h*2)+(h/2)));i++) {
		      fprintf(outFile, " "); } } }

      for (i=0;i<16;i++) { 
                          if (c[i] == EOF) { break; }
			  if ((c[i] < 32) || (c[i] >= 127)) { c[i]=46; } 
			  fprintf(outFile, "%c", c[i]); 
                         } 

      fprintf(outFile, "\n");
    }
      fclose(inFile);
      fclose(outFile);
}

/*****************************************************************************/

void editIt(int argc, char **e_argv)
{
  unsigned long n;
  unsigned int o;
  int i;
  char d;

  if (((inFile=fopen(e_argv[2], "r")) != (FILE *)NULL) && 
     ((inFile=fopen(e_argv[2], "r+")) == (FILE *)NULL)) {
        printf("\nThe file %s is write protected!\n", e_argv[2]);
        exit(1);
  }

else
  if (((inFile=fopen(e_argv[2], "r")) == (FILE *)NULL) || (argc < 5)){   
        printf("\nhexidump v1.5\nUsage: hexidump -e \"file to edit\" \"hex"
             " address\" \"hex byte or bytes to\nwrite to the file\""
             " If you are writting more than 1 byte to a file then\n"
             "seperate each byte with a space.\n\n");
	exit(1);

  }
        if (argc > 5) {
        printf("\nAre you sure you want to write the %d bytes: ", argc-4); }
        if (argc == 5) {
        printf("\nAre you sure you want to write the byte: "); }
        for (i=4;i<argc;i++) { printf("%s ", e_argv[i]); }
        printf("\nTo the hex address: %s", e_argv[3]);
        printf("\nIn the file: %s?[y/n] ", e_argv[2]);
	scanf("%c", &d);

        if ((d == 'n') || (d == 'N')) { exit(1); }
 
        sscanf(e_argv[3], "%lx", &n);
       	inFile=fopen(e_argv[2], "rb+");
        fseek(inFile, n, SEEK_SET);
        for (i=5;i<=argc;i++) { 
                                sscanf(e_argv[i-1], "%x", &o);
                                fprintf(inFile, "%c", o); 
                              }

        if ((d == 'y') || (d == 'Y')) 
        { printf("\n%s has been patched!\n\n", e_argv[2]); }
        fclose(inFile);
        exit(1); 
}
