
/* Implement the Revert Command */
  
/* 
 * last modified:  August 1992 by /cmb/
 */ 
  
#include "eel.h" 
  
/* This file adds the following commands/procedures:
COMMAND           WRITTEN FOR VERSION 
revert_buffer           6.0
*/
  
/* REVERT_BUFFER implements the good 'ol revert command. */ 
command revert_buffer()
{  
	char resp[80], *buf, *tbuf, *fname; 
	int strip = strip_returns, opoint = point, err;
	short omark = mark;
  
	if (!filename || !*filename) 
		say("Buffer not a file buffer");
	else if (!modified)
		say("Buffer not modified");
	else {
		get_string(resp, "Revert buffer? [n]"); 
		if (toupper(*resp) == 'Y') {
			buf = bufname;
			fname = filename; 
			bufname = tbuf = temp_buf(); 
			if (err = file_read(fname, strip)) {
			   file_error(err, fname, "Couldn't revert buffer"); 
			   bufname = buf;
			} else { 
				bufname = buf; 
				delete(0, size());
				bufname = tbuf;
				xfer(buf, 0, size());
				bufname = buf;
				modified = 0; 
				if (omark <= size()) mark = omark;
					else mark = 0;
				if (opoint <= size()) point = opoint;
					else point = size();
				get_file_date();
			} 
			delete_buffer(tbuf); 
		}
	} 
}
