unit menus;
{
This unit written for JugglePro on March 17, 1993
}

Interface

procedure setupmenu;        {sets up main menu titles}
procedure eras(w:integer);  {erases main window # w}
procedure disp;             {displays window #w & gets option}
procedure highlight(w:integer);  {highlights window title}
procedure getmenuoption;
{displays main menu options, gets window # and option #}

Implementation
uses crt,graph,header,demoinput;

procedure setupmenu;
var
  i,j:byte;
begin
  textmode(BW80);
  setallpalette(ipt);
  textcolor(txt1);
  textbackground(colr1);
  window(1,1,79,25);
  clrscr;
  for j:=1 to 7 do
  begin
    with mainopts[j] do
      begin
        window(x,y,x+12,y+nopt+1);
        gotoxy(1,1);
        writeln(title);
      end;
  end;
end;

procedure eras(w:integer);
begin
  with mainopts[w] do
  begin
    textcolor(txt1);
    textbackground(colr1);
    window(x,y+1,x+12,y+nopt+1);
    clrscr;
    window(x,y,x+12,y+nopt+1);
    gotoxy(1,1);
    write(title);
  end;
end;

procedure disp;
var
  i:byte;

begin
  oldw:=w;
  opt:=1;
  oldopt:=1;
  textcolor(txt1);
  textbackground(colr1);
  with mainopts[w] do window(x,y+1,x+12,y+nopt+1);
  gotoxy(1,2);
  for i:=1 to mainopts[w].nopt do      {display nopt options}
    writeln(mainopts[w].options[i]);
  repeat
    textcolor(txt1);
    textbackground(colr1);
    with mainopts[w] do window(x,y+1,x+12,y+nopt+1);
    gotoxy(1,oldopt);
    write(mainopts[w].options[oldopt]);
    textcolor(txt1);
    textbackground(colr3);
    gotoxy(1,opt);
    write(mainopts[w].options[opt]);
    ch:=readkeydemo;
    oldopt:=opt;
    if ch=chr(0)
     then
      begin
        ch:=readkeydemo;
        if ch='P' then opt:=opt+1;     {down arrow}
        if ch='H' then opt:=opt-1;     {up arrow}
        if opt<1 then opt:=mainopts[w].nopt;    {check limits}
        if opt>mainopts[w].nopt then opt:=1;    {wrap-around}
        if ch='M' then w:=w+1;         {right arrow}
        if ch='K' then w:=w-1;         {left arrow}
        if ch=';' then w:=7;           { F1   = shortcut to Help}
        if ch='!' then w:=1;           {ALT F = shortcut to File}
        if ch='"' then w:=2;           {ALT G = shortcut to Generator}
        if ord(ch)=18 then w:=3;       {ALT E = shortcut to Edit}
        if ord(ch)=31 then w:=4;       {ALT S = shortcut to Show}
        if ch='/' then w:=5;           {ALT V = shortcut to Varypmtrs}
        if ch='#' then w:=6;           {ALT H = shortcut to Hands}
        if ch='-' then begin           {ALT X = shortcut to Quit}
                         w:=1;
                         opt:=5;
                         ch:=chr(13);
                       end;
      end
     else
      begin                            {check option shortcuts}
        for i:=1 to mainopts[w].nopt do
          if (upcase(ch)=mainopts[w].optlist[i]) then opt:=i;
      end;
  until (oldw<>w) or (ch=chr(13));     {new main window or enter}
  if ch=chr(13) then select:=true;     {enter executes selection}
end;

procedure highlight(w:integer);
begin
  textcolor(txt1);
  textbackground(colr2);
  with mainopts[w] do
    begin
      window(x,y,x+13,y);
      write(title);
    end;
end;

procedure getmenuoption;
begin
  repeat
    highlight(w);           {highlight current main menu window}
    if keypressed then begin
                         ch:=readkey;
                         if ch=chr(27) then demoflag:=false;
                       end;
    oldw:=w;                {assign window number to oldw}
    select:=false;
    disp;                   {display main menu options and allow selection}
    if w>7 then w:=1;
    if w<1 then w:=7;       {limit window to 1-7 with wraparound}
    if w<>oldw then eras(oldw); {if new window, erase old one}
  until select;             {continue until user makes selection}
end;

begin                       {initialization (constructor) }
  with mainopts[1] do
    begin
      title:='File';
      x:=1;
      y:=1;
      nopt:=5;
      options[1]:='Load';
      options[2]:='Save';
      options[3]:='Path';
      options[4]:='Directory';
      options[5]:='Quit (Alt X)';
      optlist:='LSPDQ';
    end;
  with mainopts[2] do
    begin
      title:='Generator';
      x:=9;
      y:=1;
      nopt:=7;
      options[1]:='Balls';
      options[2]:='Maxthrow';
      options[3]:='Period';
      options[4]:='Switches';
      options[5]:='Generate';
      options[6]:='genFile';
      options[7]:='Choose';
      optlist:='BMPSGFC';
    end;
  with mainopts[3] do
    begin
      title:='Edit';
      x:=22;
      y:=1;
      nopt:=11;
      options[1]:='Permute';
      options[2]:='Translate';
      options[3]:='Define';
      options[4]:='Hands';
      options[5]:='pEriod';
      options[6]:='Multiplex';
      options[7]:='Clear';
      options[8]:='cOnversions';
      options[9]:='Sync->async';
      options[10]:='Repeat';
      options[11]:='Invert';
      optlist:='PTDHEMCOSRI';
    end;
  with mainopts[4] do
    begin
      title:='Show';
      x:=32;
      y:=1;
      nopt:=9;
      options[1]:='2-d Side';
      options[2]:='2-d Aerial';
      options[3]:='asYnc on';
      options[4]:='asyNc off';
      options[5]:='Run demo';
      options[6]:='Delay';
      options[7]:='Make demo';
      options[8]:='File demo';
      options[9]:='Load demo';
      optlist:='SAYNRDMFL';
    end;
  with mainopts[5] do
    begin
      title:='Vary Pmtrs';
      x:=42;
      y:=1;
      nopt:=8;
      options[1]:='Speed';
      options[2]:='Dwell ratio';
      options[3]:='Height';
      options[4]:='hOld';
      options[5]:='No hold';
      options[6]:='Palette';
      options[7]:='Interface';
      options[8]:='Firstthrow';
      optlist:='SDHONPIF';
    end;
  with mainopts[6] do
    begin
      title:='Hands';
      x:=56;
      y:=1;
      nopt:=5;
      options[1]:='Default';
      options[2]:='Load';
      options[3]:='Save';
      options[4]:='Edit hands';
      options[5]:='permUte';
      optlist:='DLSEU';
    end;
  with mainopts[7] do
    begin
      title:='Help';
      x:=67;
      y:=1;
      nopt:=9;
      options[1]:='File';
      options[2]:='Generator';
      options[3]:='Edit';
      options[4]:='Show';
      options[5]:='Vary Pmtrs';
      options[6]:='Hands';
      options[7]:='Jp.doc';
      options[8]:='j2.doc';
      options[9]:='Notation';
      optlist:='FGESVHJ2N';
    end;
  w:=1;
  oldw:=1;
  oldopt:=1;
  opt:=1;
end.
