
             (* *************************************** *)
             (*                                         *)
             (*              ANIMALS.PAS                *)
             (*                                         *)
             (*   A children's game designed to teach   *)
             (*   elementary mathematics.               *)
             (*                                         *)
             (*       (c) Donald L. Pavia               *)
             (*           1488 Lahti Drive              *)
             (*           Bellingham, WA. 98226         *)
             (*                                         *)
             (*   last revised  June 7, 1986            *)
             (*                                         *)
             (* *************************************** *)


program AnimalMath;

const  LeftX   : array[1..9]  of byte = (100,100, 68, 68, 36, 36, 36, 68,100);
       LeftY   : array[1..9]  of byte = ( 72,100, 72,100, 72,100,128,128,128);

       RightX  : array[1..9]  of byte = (164,164,196,196,164,196,228,228,228);
       RightY  : array[1..9]  of byte = ( 72,100, 72,100,128,128, 72,100,128);

       CenterX : array[1..18] of byte = (164,132,132,164,100,100,132,164,100,
                                          68, 68, 68, 36, 36, 36,196,196,196);
       CenterY : array[1..18] of byte = (100,100, 72, 72, 72,100,128,128,128,
                                         100, 72,128, 72,100,128, 72,100,128);

               { coordinate sets for display of sprites used }
               { by procedures PlotSprites and ShowSprites   }

{-------------------------------------------------------------------}
 const  QuestionMark : array[1..128] of byte =
     ( 9,0,5,0,0,0,0,0,0,0,0,0,170,170,128,0,
       0,2,160,2,160,0,0,2,160,2,160,0,0,0,0,2,          { ? sprite }
       160,0,0,0,0,42,0,0,0,0,2,160,0,0,0,0,
       10,128,0,0,0,0,10,128,0,0,0,0,10,128,0,0,
       0,0,42,170,0,0,0,2,170,170,160,0,0,2,160,2,
       160,0,0,2,160,2,160,0,0,0,0,10,128,0,0,0,
       0,168,0,0,0,0,10,128,0,0,0,0,10,128,0,0,
       0,0,0,0,0,0,0,0,10,128,0,0,0,0,0,0 );

 const  EqualSign : array[1..128] of byte =
     ( 9,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,255,255,255,255,0,0,255,255,255,
       255,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,                  { = sprite }
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,255,
       255,255,255,0,0,255,255,255,255,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 );

 const  MinusSign : array[1..128] of byte =
     ( 9,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,                  { - sprite }
       0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,
       255,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,255,
       255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 );

 const  PlusSign : array[1..128] of byte =
     ( 9,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,                  { + sprite }
       0,0,15,240,0,0,0,0,15,240,0,0,0,255,255,255,
       255,0,0,255,255,255,255,0,0,0,15,240,0,0,0,0,
       15,240,0,0,0,0,15,240,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,15,240,0,0,0,0,15,240,
       0,0,0,0,15,240,0,0,0,255,255,255,255,0,0,255,
       255,255,255,0,0,0,15,240,0,0,0,0,15,240,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 );

 const  DivideSign : array[1..128] of byte =
     ( 9,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,                  { / sprite }
       0,0,15,240,0,0,0,0,0,0,0,0,0,255,255,255,
       255,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,
       15,240,0,0,0,0,15,240,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,15,240,0,0,0,0,15,240,
       0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,255,
       255,255,255,0,0,0,0,0,0,0,0,0,15,240,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 );

 const  MultiplySign : array[1..128] of byte =
     ( 9,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,63,192,3,252,0,0,3,252,63,192,0,0,0,63,252,
       0,0,0,0,15,240,0,0,0,0,255,255,0,0,0,15,          { x sprite }
       240,15,240,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,15,240,15,
       240,0,0,0,255,255,0,0,0,0,15,240,0,0,0,0,
       63,252,0,0,0,3,252,63,192,0,0,63,192,3,252,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 );

 const  CheckMark : array[1..128] of byte =
     ( 3,0,1,0,0,0,0,0,0,0,0,5,0,0,0,0,
       80,80,0,0,0,0,5,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,1,0,0,0,0,0,20,0,0,0,0,21,64,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 );

{-------------------------------------------------------------------}
{$I LoadSave.Lib}
{-------------------------------------------------------------------}
{$I Sprites.Lib}
{-------------------------------------------------------------------}

type  GameType = (NoGame,Counting,GivingNext,Adding,Subtracting);

var   Game         : GameType;
      FirstNumber  : integer;
      SecondNumber : integer;
      Result       : integer;
      Colr         : integer;
      Count        : integer;
      FirstTime    : boolean;
      UserQuits    : boolean;
      Wait         : char;

{-------------------------------------------------------------------}
procedure PressAnyKey;

var  AnyKey : char;

begin
     gotoxy (8,25); write ('Press Any Key to Continue ');
     read (Kbd,AnyKey);
end;
{-------------------------------------------------------------------}
function BitSet (InByte : byte; WhichBit : integer) : boolean;

begin  if ((InByte div WhichBit) mod 2) = 1 then BitSet := true
                                            else BitSet := false;
end;
{-------------------------------------------------------------------}
procedure PlotMedChar (x,y : integer; NextChar : char);

const PelSeg = $F000; PelStart = $FA6E;           { this procedure plots a    }
                                                  { double size char with a   }
var   CharNum,Offset,i : integer;                 { transparent background    }
      SaveColor        : integer;                 {  - if NextChar is #0 a    }
      InByte           : byte;                    { solid block of background }
                                                  { color is written (erase)  }
{----------------------------------------------------}
procedure MedPlot (a,b : integer);

var   p,q : integer;

begin p := x+a; q := y+(2*b);

      Plot (p,q-1,Colr); Plot (p+1,q-1,Colr);
      Plot (p,q,Colr);   Plot (p+1,q,Colr);
end;
{----------------------------------------------------}

begin
     SaveColor := Colr;

     CharNum := ord (NextChar);
     Offset := PelStart + (CharNum * 8);

     for i := 0 to 7 do begin

          if NextChar <> #0 then InByte := Mem [PelSeg:Offset+i]
             else begin
                       InByte := 255; Colr := 0;         { solid block of }
                  end;                                   { color 0 erases }

          if BitSet (InByte,128) then MedPlot (1,i);
          if BitSet (InByte, 64) then MedPlot (3,i);
          if BitSet (InByte, 32) then MedPlot (5,i);
          if BitSet (InByte, 16) then MedPlot (7,i);
          if BitSet (InByte,  8) then MedPlot (9,i);
          if BitSet (InByte,  4) then MedPlot (11,i);
          if BitSet (InByte,  2) then MedPlot (13,i);
          if BitSet (InByte,  1) then MedPlot (15,i);

     end;

     Colr := SaveColor;

end;
{-----------------------------------------------------------------------------}
procedure PlotSprites (FirstNum,SecondNum : integer);

var  SpriteNum,i : integer;                  { plots arrays of sprites for    }
                                             { addition and subtraction games }
begin
   SpriteNum := random (100) mod 18 + 1;       { range 1..18 }
   Sprite    := Table[SpriteNum];

   case FirstNum of
      0 : PlotMedChar (100, 78,'0');
      1 : XorSpriteC  (100, 86);
   else
      for i := 1 to FirstNum do XorSpriteC (LeftX[i],LeftY[i]);
   end;

   PlotMedChar (88,158,chr(FirstNum+48));

   case SecondNum of
      0 : PlotMedChar (164, 78,'0');
      1 : XorSpriteC  (164, 86);
   else
      for i := 1 to SecondNum do XorSpriteC (RightX[i],RightY[i]);
   end;

   PlotMedChar (164,158,chr(SecondNum+48));

   case Game of
     Adding      : move ( PlusSign,Sprite,128);          { + }
     Subtracting : move (MinusSign,Sprite,128);          { - }
   end;
   XorSpriteC (132,86); XorSpriteC (132,164);

   move (EqualSign,Sprite,128);
   XorSpriteC (228, 86); XorSpriteC (228,164);            { = }
   move (QuestionMark,Sprite,128);
   XorSpriteC (260, 86);                                  { ? }

end;
{----------------------------------------------------------------------------}
procedure ShowSprites (Number : integer);
                                                    { plots array of sprites }
var   SpriteNum,i : integer;                        { for counting game      }

begin
      SpriteNum := random (100) mod 18 + 1;
      Sprite    := Table[SpriteNum];

      for i := 1 to Number do XorSpriteC (CenterX[i],CenterY[i]);

      move (   EqualSign,Sprite,128); XorSpriteC (228,100);            { = }
      move (QuestionMark,Sprite,128); XorSpriteC (260,100);            { ? }
end;
{===========================================================================}

const s = 50; o = 100; q = 200; tq = 300; h = 400; th = 500; w = 800;

        { sixteenth,eighth,quarter,half,whole }

  lC =  262; lD = 294; lE = 330; lF = 350; lG = 392; lA = 440; lB = 494;
  lCs=  277; lDs= 311;           lFs= 370; lGs= 415; lAs= 466;

  C  =  523; D  = 587; E  = 659; F  = 698; G  = 784; A  = 880; B  = 988;
  Cs =  554; Ds = 622;           Fs = 740; Gs = 830; As = 932;

  hC = 1046;     { two octaves }     { constants for Play procedure }

{---------------------------------------------------------------------------}
procedure Play (Note,Value : integer);

begin  sound (Note); Delay (Value); NoSound; Delay (20)   end;

{===========================================================================}
procedure AnimalFairA;

begin  play (E,q);
       play (G,q); Play (G,q); play (G,q);
       play (A,q); play (A,q); play (E,q);
       play (G,th); delay (20);
end;
{---------------------------------------------------------------------------}
procedure AnimalFairB;

begin  play (E,q);
       play (G,q); play (G,q); play (G,q);
       play (A,h); play (E,q);
       play (F,th); delay (20);
end;
{---------------------------------------------------------------------------}
procedure AnimalFairC;

begin  play (G,q);
       play (B,h); play (B,q); play (B,q); play (A,q); play (A,q);
       play (B,q); play (B,q); play (B,q); play (B,h);
end;
{--------------------------------------------------------------------------}
procedure AnimalFairD;

begin  play (A,q);
       play (G,q); play (G,q); play (G,q); play (A,h); play (E,q);
       play (G,th); delay (20);
end;
{---------------------------------------------------------------------------}
procedure AnimalFairE;

begin  play (E,q);
       play (G,h); play (G,q); play (A,h); play (E,q);
       play (G,h); delay (600);
end;
{---------------------------------------------------------------------------}
procedure AnimalFairF;

begin  play (E,q);
       play (G,q); play (G,q); play (G,q);
       play (A,q); play (A,q); play (E,q);
       play (F,h); delay (600);
end;
{---------------------------------------------------------------------------}
procedure AnimalFairG;

begin  play (G,q);
       play (B,q);  play (B,q);  play (B,q); play (B,h); play (A,q);
       play (B,q);  play (B,q);  play (B,q);
       play (B,h);
end;
{---------------------------------------------------------------------------}
procedure AnimalFairH;

begin  play (A,q);  play (G,h);
       play (G,q);  play (G,q); play (A,q); play (B,q);
       play (hC,h); play (C,q);  play (C,h); play (C,q);
       play (C,h);  play (C,q);  play (C,h);

end;
{===========================================================================}
procedure AnimalFair;

begin
     AnimalFairA; AnimalFairB; AnimalFairC; AnimalFairD;
     AnimalFairE; AnimalFairF; AnimalFairG; AnimalFairH;

end;
{--------------------------------------------------------------------------}
procedure AnimalFairWithStars;

var  SaveColr : integer;

begin
     SaveColr  :=  Colr;

     AnimalFairA;  Colr := 1; PlotMedChar (220, 24,'*');
                   Colr := 2; PlotMedChar (260,128,'*');
                   Colr := 3; PlotMedChar (100, 80,'*');
     AnimalFairB;  Colr := 2; PlotMedChar (132,142,'*');
                   Colr := 1; PlotMedChar ( 56, 28,'*');
                   Colr := 3; PlotMedChar (120,168,'*');
     AnimalFairC;  Colr := 3; PlotMedChar (200,180,'*');
                   Colr := 1; PlotMedChar ( 25,162,'*');
                   Colr := 3; PlotMedChar (258, 60,'*');
     AnimalFairD;  Colr := 2; PlotMedChar (100, 36,'*');
                   Colr := 3; PlotMedChar ( 20, 20,'*');
                   Colr := 1; PlotMedChar (288,186,'*');
     AnimalFairE;  Colr := 2; PlotMedChar (200, 70,'*');
                   Colr := 3; PlotMedChar (180, 40,'*');

     AnimalFairF;  Colr := 1; PlotMedChar (140, 60,'*');
                   Colr := 2; PlotMedChar ( 20,188,'*');

     AnimalFairG;  Colr := 1; PlotMedChar ( 80,160,'*');
                   Colr := 3; PlotMedChar ( 24,136,'*');
     AnimalFairH;

     Colr := SaveColr;
end;
{===========================================================================}
procedure ToneBurst (Start,Stop,Duration : integer);

var  Pitch : integer;

begin
     if Start <= Stop then
       for Pitch := Start to Stop do
                begin Sound (Pitch); Delay (Duration); NoSound  end
     else
       for Pitch := Start downto Stop do
                begin Sound (Pitch); Delay (Duration); NoSound  end;

end;
{---------------------------------------------------------------------------}
procedure Flourish;

begin
     case Count mod 8 of

       0 : begin Play  (C,s); Play  (E,s); Play  (G,s); Play (hC,tq)  end;
       1 : begin Play (lA,s); Play  (C,s); Play  (E,s); Play  (A,tq)  end;
       2 : begin Play (lG,s); Play (lB,s); Play  (D,s); Play  (G,tq)  end;
       3 : begin Play (lB,s); Play  (D,s); Play (Fs,s); Play  (B,tq)  end;
       4 : begin Play (lE,s); Play (lG,s); Play (lB,s); Play  (E,tq)  end;
       5 : begin Play (lD,s); Play (lF,s); Play (lA,s); Play  (D,tq)  end;
       6 : begin Play (lF,s); Play (lA,s); Play  (C,s); Play  (F,tq)  end;
       7 : begin Play  (C,s); Play  (E,s); Play  (G,s); Play (hC,tq)  end;

     end;

end;    { Flourish }
{--------------------------------------------------------------------}
function RandomNumber  (Limit : integer) : integer;

begin  RandomNumber := random (100) mod Limit + 1;  end;  { range 1..Limit }
{----------------------------------------------------------------------------}
procedure EraseMarks;

begin
      FillChar (Sprite,128,0); Sprite.srows := 3; Sprite.scols := 1;

      PutSpriteW (224,64); PutSpriteW (232,64); PutSpriteW (240,64);
      PutSpriteW (248,64); PutSpriteW (256,64); PutSpriteW (264,64);
      PutSpriteW (272,64); PutSpriteW (280,64);

end;
{---------------------------------------------------------------------------}
procedure EightRight;

var   Strg : str14;  i,k,Num : integer;

begin
      delay (500);
      FillChar (ColorBuffer,16383,0);

      Num := RandomNumber (7);
      case Num of
         1 : Sprite := Table[ 8];     { rabbit }
         2 : Sprite := Table[ 4];     { cat    }
         3 : Sprite := Table[16];     { beaver }
         4 : Sprite := Table[14];     { cow    }        { HEAD }
         5 : Sprite := Table[15];     { tiger  }
         6 : Sprite := Table[ 9];     { pig    }
         7 : Sprite := Table[12];     { mouse  }
      end;

      XorSpriteC (60, 74);

      Num := RandomNumber (3) + 18;
      Sprite := Table[Num]; XorSpriteC (60, 94);        { BODY }

      Num := RandomNumber (3) + 21;
      Sprite := Table[Num]; XorSpriteC (60,114);        { LEGS }

      Num := RandomNumber (8);
      case Num of
         1 : Strg := ' GOOD JOB ';
         2 : Strg := '   WOW    ';
         3 : Strg := '  GREAT   ';
         4 : Strg := 'FANTASTIC ';
         5 : Strg := 'ALL RIGHT ';
         6 : Strg := ' TERRIFIC ';
         7 : Strg := '  SUPER   ';
         8 : Strg := ' AWESOME  ';
      end;

      k := 84;
      for i := 1 to Length(Strg) do
         begin
              PlotMedChar (k,110,Strg[i]);
              k := k + 16;
         end;

      AnimalFairWithStars;

      EraseMarks;
end;
{---------------------------------------------------------------------------}
procedure CorrectAnswer;         { places check marks on screen for each }
                                 { correct answer and plays a flourish   }
                                 { - with 8 correct answers gives reward }
begin
      move (CheckMark,Sprite,128);
                                       { you could substitute the Animal  }
                                       { Fair stanzas for the flourish if }
                                       { you don't find them too tiresome }
      case count mod 8 of
         0 : begin XorSpriteC (224,64); XorSpriteW (224,64);
                   { AnimalFairA; } Flourish; end;
         1 : begin XorSpriteC (232,64); XorSpriteW (232,64);
                   { AnimalFairB; } Flourish; end;
         2 : begin XorSpriteC (240,64); XorSpriteW (240,64);
                   { AnimalFairC; } Flourish; end;
         3 : begin XorSpriteC (248,64); XorSpriteW (248,64);
                   { AnimalFairD; } Flourish; end;
         4 : begin XorSpriteC (256,64); XorSpriteW (256,64);
                   { AnimalFairE; } Flourish; end;
         5 : begin XorSpriteC (264,64); XorSpriteW (264,64);
                   { AnimalFairF; } Flourish; end;
         6 : begin XorSpriteC (272,64); XorSpriteW (272,64);
                   { AnimalFairG; } Flourish; end;
         7 : begin XorSpriteC (280,64); XorSpriteW (280,64);
                   { AnimalFairH; } Flourish; EightRight; end;
      end;

      gotoxy (8,25); write ('     YOU GOT IT !!        ');
      count := count + 1;
      delay (1000);
end;
{----------------------------------------------------------------------------}
procedure WrongAnswer;

begin  ToneBurst (50,70,10);
       gotoxy (8,25); write (' Sorry, Try It Again !!! ');
       delay (1500);
       gotoxy (8,25); write ('                         ');
end;
{----------------------------------------------------------------------------}
procedure GetResponse (var Response : str14; var Valid : boolean);

var   i,j,k : integer;  Key : char;         { Substitute procedure for   }
                                            { read and buflen. Needed so }
begin                                       { response may be echoed to  }
      repeat                                { screen in large chars.     }

            Valid := true;
            gotoxy (33,20); write ('      ');
            gotoxy (33,21); write ('      ');
            gotoxy (33,22); write ('      ');

            Response := ''; j := 0; k := 256;
                                                 { limit input to only }
            repeat                               { certain keys and to }
                                                 { only two digits     }
                   read (Kbd,Key);
                          Key := UpCase(Key);
                   if (Key in ['0'..'9','Q']) and (j < 2) then
                     begin
                          PlotMedChar (k,158,Key);
                          Response := Response + Key;  { assemble string }
                          j := j + 1; k := k + 16;
                     end;

                                                  { backspace handler }
                    if (Key = #8)  then
                      begin delete (Response,j,1);
                            j := j -  1; if j <   0 then j :=   0;
                            k := k - 16; if k < 256 then k := 256;
                            PlotMedChar (k,158,#0);
                      end;

            until Key = #13;

            if UpCase(Response[1]) = 'Q' then
                    begin Valid := false; exit  end;

      until Valid;
end;
{-------------------------------------------------------------------}
procedure ObjectCount;                                { first game  }

var   Response,Strg   : str14;
      Valid,Correct   : boolean;
      NumberRight     : integer;
      NumberWrong     : integer;
      Level,Num1      : integer;
      LastNumber      : integer;
      Answer,Code     : integer;
      i,k             : integer;

begin
      NumberRight := 0; NumberWrong := 0;
      Level := 1; LastNumber := 0;

  {    LoadScreen ('ANIMALS.__2');  }  WorkBuffer := BackGroundBuffer;
                                       ColorBuffer := WorkBuffer;

      TextColor (1); gotoxy (16,6); write ('COUNTING');

      Strg := 'HOW MANY ?'; k := 68;

      for i := 1 to Length(Strg) do
           begin
                PlotMedChar (k,158,Strg[i]);
                k := k + 16;
           end;

      WorkBuffer   := ColorBuffer;

      REPEAT
         ColorBuffer   := WorkBuffer;

         case Level of
            1 :  Num1 :=  4;
            2 :  Num1 :=  5;
            3 :  Num1 :=  6;
            4 :  Num1 :=  9;
            5 :  Num1 := 12;
            6 :  Num1 := 18;
         end;

         repeat
               Result  := RandomNumber (Num1);
         until Result <> LastNumber;
         LastNumber := Result;
         ShowSprites (Result);

         Correct := false;

         REPEAT
            GetResponse (Response,Valid);

            if UpCase (Response[1]) = 'Q' then exit;

            if Valid then
               begin
                  val (Response,Answer,Code);           { convert to integer }
                  if Answer = Result then
                     begin Correct := true;
                           CorrectAnswer;
                           NumberRight := NumberRight + 1;
                           if NumberRight = 6 then
                              begin NumberRight := 0; NumberWrong := 0;
                                   Level := Level + 1;
                                   if Level > 6 then Level := 6;
                              end;
                end
            else
                begin WrongAnswer;
                      NumberWrong := NumberWrong + 1;
                      if NumberWrong = 6 then
                      begin NumberWrong := 0; NumberRight := 0;
                            Level := Level - 1;
                            if Level < 1 then Level := 1;
                      end;
                 end;
            end;

         UNTIL CORRECT;

      UNTIL UpCase(Response[1]) = 'Q';

end;
{----------------------------------------------------------------------------}
procedure Sequences;                                  { second game }

var   Response,Strg   : str14;
      Valid,Correct   : boolean;
      NumberRight     : integer;
      NumberWrong     : integer;
      Level,Num1      : integer;
      FirstNumber     : integer;
      LastNumber      : integer;
      First,Second    : integer;
      Answer,Code     : integer;
      i,k             : integer;

begin
      NumberRight := 0; NumberWrong := 0;
      Level := 1; LastNumber := 0; Colr := 3;

{      LoadScreen ('ANIMALS.__2');   }   WorkBuffer  := BackGroundBuffer;
                                         ColorBuffer := WOrkBuffer;

      TextColor (1); gotoxy (16,6); write ('SEQUENCES');

      Strg := 'NEXT ?'; k := 116;

      for i := 1 to Length(Strg) do
           begin
                PlotMedChar (k,158,Strg[i]);
                k := k + 16;
           end;

      WorkBuffer := ColorBuffer;

      REPEAT
         ColorBuffer  := WorkBuffer;

         case Level of
            1 :  Num1 := 6;
            2 :  Num1 := 8;
            3 :  Num1 := 10;
            4 :  Num1 := 20;
            5 :  Num1 := 30;
            6 :  Num1 := 40;
            7 :  Num1 := 50;
            8 :  Num1 := 60;
            9 :  Num1 := 70;
           10 :  Num1 := 90;
         end;

         repeat
               FirstNumber  := Random (Num1);
         until FirstNumber <> LastNumber;
         Result := FirstNumber + 4;
         LastNumber := FirstNumber;

         k := 60;
         for i := 0 to 3 do
              begin
                   First := (FirstNumber + i) div 10;
                   if First <> 0 then begin
                      PlotMedChar (k,100, chr(First+48));
                      k := k + 16; end;
                   Second := (FirstNumber + i) mod 10;
                      PlotMedChar (k,100,chr(Second+48));
                      k := k + 32;
              end;
         PlotMedChar (k,100,'?');

         Correct := false;

         REPEAT
            GetResponse (Response,Valid);

            if UpCase (Response[1]) = 'Q' then exit;

            if Valid then
               begin
                  val (Response,Answer,Code);           { convert to integer }
                  if Answer = Result then
                     begin Correct := true;
                           CorrectAnswer;
                           NumberRight := NumberRight + 1;
                           if NumberRight = 9 then
                              begin NumberRight := 0; NumberWrong := 0;
                                    Level := Level + 1;
                                    if Level > 10 then Level := 10;
                              end;
                end
            else
                begin WrongAnswer;
                      NumberWrong := NumberWrong + 1;
                      if NumberWrong = 9 then
                      begin NumberWrong := 0; NumberRight := 0;
                            Level := Level - 1;
                            if Level < 1 then Level := 1;
                      end;
                 end;
            end;

         UNTIL CORRECT;

      UNTIL UpCase(Response[1]) = 'Q';

end;
{----------------------------------------------------------------------------}
procedure Addition;                                   { third game  }

var   Response        : str14;
      Valid,Correct   : boolean;
      NumberRight     : integer;
      NumberWrong     : integer;
      Level,Num1,Num2 : integer;
      LastNumber      : integer;
      Answer,Code     : integer;

begin
      NumberRight := 0; NumberWrong := 0;
      Level := 1; LastNumber := 0;

  {   LoadScreen ('ANIMALS.__2');   }     WorkBuffer  := BackGroundBuffer;
                                          ColorBuffer := WorkBuffer;

      TextColor (1); gotoxy (16,6); write ('ADDITION');
      WorkBuffer := ColorBuffer;
      REPEAT

         ColorBuffer  := WorkBuffer;

         case Level of
            1 : begin Num1 := 4; Num2 := 2; end;
            2 : begin Num1 := 8; Num2 := 2; end;
            3 : begin Num1 := 7; Num2 := 3; end;
            4 : begin Num1 := 5; Num2 := 5; end;
            5 : begin Num1 := 6; Num2 := 6; end;
            6 : begin Num1 := 9; Num2 := 6; end;
         end;

         repeat
               FirstNumber  := RandomNumber (Num1);
         until FirstNumber <> LastNumber;
         LastNumber := FirstNumber;
         SecondNumber := RandomNumber (Num2);
         Result := FirstNumber + SecondNumber;
         PlotSprites (FirstNumber,SecondNumber);

         Correct := false;

         REPEAT
            GetResponse (Response,Valid);

            if UpCase (Response[1]) = 'Q' then exit;

            if Valid then
               begin
                  val (Response,Answer,Code);           { convert to integer }
                  if Answer = Result then
                     begin Correct := true;
                           CorrectAnswer;
                           NumberRight := NumberRight + 1;
                           if NumberRight = 7 then
                              begin NumberRight := 0; NumberWrong := 0;
                                    Level := Level + 1;
                                    if Level > 6 then Level := 6;
                              end;
                end
            else
                begin WrongAnswer;
                      NumberWrong := NumberWrong + 1;
                      if NumberWrong = 7 then
                      begin NumberWrong := 0; NumberRight := 0;
                            Level := Level - 1;
                            if Level < 1 then Level := 1;
                      end;
                 end;
            end;

         UNTIL CORRECT;

      UNTIL UpCase(Response[1]) = 'Q';
end;
{---------------------------------------------------------------------------}
procedure Subtraction;                                { fourth game }

var   Response        : str14;
      Valid,Correct   : boolean;
      NumberRight     : integer;
      NumberWrong     : integer;
      Level,Num1,Num2 : integer;
      LastNumber      : integer;
      Answer,Code     : integer;

begin
      NumberRight := 0; NumberWrong := 0; Level := 1;

  {   LoadScreen ('ANIMALS.__2');  }  WorkBuffer  := BackGroundBuffer;
                                      ColorBuffer := WorkBuffer;

      TextColor (1); gotoxy (14,6); write ('SUBTRACTION');
      WorkBuffer := ColorBuffer;
      REPEAT

         ColorBuffer := WorkBuffer;

         case Level of
            1 : begin Num1 := 5; Num2 := 2; end;
            2 : begin Num1 := 9; Num2 := 2; end;
            3 : begin Num1 := 9; Num2 := 3; end;
            4 : begin Num1 := 9; Num2 := 4; end;
            5 : begin Num1 := 9; Num2 := 5; end;
            6 : begin Num1 := 9; Num2 := 6; end;
         end;

         repeat
               FirstNumber  := RandomNumber (Num1);
         until FirstNumber <> LastNumber;
         LastNumber := FirstNumber;
         SecondNumber := RandomNumber (Num2);
         if SecondNumber > FirstNumber then SecondNumber := FirstNumber - 1;
         Result := FirstNumber - SecondNumber;
         PlotSprites (FirstNumber,SecondNumber);

         Correct := false;

         REPEAT
            GetResponse (Response,Valid);

            if UpCase (Response[1]) = 'Q' then exit;

            if Valid then
               begin
                  val (Response,Answer,Code);           { convert to integer }
                  if Answer = Result then
                     begin Correct := true;
                           CorrectAnswer;
                           NumberRight := NumberRight + 1;
                           if NumberRight = 7 then
                              begin NumberRight := 0; NumberWrong := 0;
                                    Level := Level + 1;
                                    if Level > 6 then Level := 6;
                              end;
                end
            else
                begin WrongAnswer;
                      NumberWrong := NumberWrong + 1;
                      if NumberWrong = 7 then
                      begin NumberWrong := 0; NumberRight := 0;
                            Level := Level - 1;
                            if Level < 1 then Level := 1;
                      end;
                 end;
            end;

         UNTIL CORRECT;

      UNTIL UpCase(Response[1]) = 'Q';
end;
{---------------------------------------------------------------------------}
procedure Menu;

begin
      FillChar (ColorBuffer,16383,0);
      TextColor (2); gotoxy (14, 2); write ('ANIMAL MATH');
      TextColor (1); gotoxy ( 8, 5); write ('Select a Game Option : ');
      TextColor (3); gotoxy (10, 8); write ('(1) Count Objects');
                     gotoxy (10,10); write ('(2) Number Sequences');
                     gotoxy (10,12); write ('(3) Addition');
                     gotoxy (10,14); write ('(4) Subtraction');
                     gotoxy (10,16); write ('(Q) Quit');

      TextColor (1); gotoxy ( 8,19); write ('Press the Indicated Key');
                     gotoxy ( 6,24); write ('Enter Q to Quit a Game Early');

end;
{---------------------------------------------------------------------------}
procedure ChooseGame;

var   Selection : char;

begin
      repeat
            read (Kbd,Selection);
      until UpCase(Selection) in ['1'..'6','Q'];

      case UpCase (Selection) of
         'Q' : begin UserQuits := true; Game := NoGame end;
         '1' : Game := Counting;
         '2' : Game := GivingNext;
         '3' : Game := Adding;
         '4' : Game := Subtracting;

      end;

      FillChar (ColorBuffer,16383,0);
end;
{---------------------------------------------------------------------------}

BEGIN
      randomize;
      Game := NoGame; FirstTime := true;   UserQuits := false;
      GraphColorMode; GraphBackGround (1); Palette (2);
      Colr := 3;

      LoadScreen ('ANIMALS.__1');           { title screen }
      LoadTable  ('ANIMALS.TAB');           { sprite table }

      AnimalFair;

      PressAnyKey;

      repeat
          Menu;
          ChooseGame;

          if FirstTime then
                      begin LoadScreen ('ANIMALS.__2');
                            move (ColorBuffer,BackGroundBuffer,16384);
                            FirstTime := false;
                      end;
          count := 0;

          case Game of
            Counting    : ObjectCount;
            GivingNext  : Sequences;
            Adding      : Addition;
            Subtracting : Subtraction;
          end;

      until UserQuits;

      TextMode (c80);

END.

