{  PIXEL is a set of low-level graphic primitives. }

procedure HiRes;    { enter HiRes graphics mode }
    begin
        inline (       (* uses interupt 10H in BIOS *)
            $B8/$06/$00/   (* MOV  AX,6H   ;load fn # in A  *)
            $CD/$10        (* INT  10H                      *)
         );
    end;

procedure Alfa;    { enter 80x25 alpha mode }
    begin
        inline (       (* uses interupt 10H in BIOS *)
            $B8/$02/$00/   (* MOV  AX,2H   ;load fn # in A  *)
            $CD/$10        (* INT  10H                      *)
         );
    end;

procedure pixel ( x,y,val : integer );
                    { draw a pixel at <x,y>. If val=0,
                      then erase the pixel instead.    }
    type  mask = array [0..7] of byte;
    const MASK1: mask =($80,$40,$20,$10,$08,$04,$02,$01);
          MASK0: mask =($7F,$BF,$DF,$EF,$F7,$FB,$FD,$FE);
          PIXBASE = $B800;
    var   odd, bytA : integer;
          point : ^byte;

    begin
        { First compute a pointer to the byte containing pixel }
        odd := y mod 2;    (* odd or even scan line? *)
        bytA:= y div 2 * 80  +  x div 8  +  8192*odd;
        point := ptr ( PIXBASE, bytA );

        { Now write the pixel into the byte  }
        if  val=0  then point^ := point^ and MASK0 [x mod 8]
        else            point^ := point^ or  MASK1 [x mod 8];
    end;
