' Lifeform v1.0a (pd) 2001.
DEFSNG A-Z
SCREEN 8
' reseed randomizer
RANDOMIZE TIMER
' declare some constants
pi = ATN(1) * 4
CLS ' clear screen
PRINT "Timing factor: (S)low, (M)edium, (F)ast?";
DO
   x$ = INKEY$
   IF LEN(x$) THEN
      SELECT CASE UCASE$(x$)
      CASE "S"
         speed = 1
         EXIT DO
      CASE "M"
         speed = 2
         EXIT DO
      CASE "F"
         speed = 3
         EXIT DO
      END SELECT
   END IF
LOOP
' start main loop
DO
   ' display loops counter
   COLOR 14, 0
   LOCATE 21, 9, 1
   zz = zz + 1
   PRINT "universe"; zz;
   LOCATE 22, 9, 1
   PRINT "galaxy 1";
   LOCATE 23, 9, 1
   PRINT "star 0";
   LOCATE 24, 9, 1
   COLOR 15, 0
   PRINT "lifeforms found: 0";
   LOCATE 2, 1, 0
   COLOR 15, 0
   PRINT "starship starscope. scanning for life..";
   ' declare some variables
   n = 0
   rt = 1
   x0 = 420
   y0 = 120
   zd = 1
   zz1 = 0
   ' draw crosshairs
   LINE (423, 50)-(423, 57), 13 ' top
   LINE (420, 47)-(420, 57), 13
   LINE (417, 50)-(417, 57), 13
   LINE (423, 183)-(423, 190), 13 ' bottom
   LINE (420, 183)-(420, 193), 13
   LINE (417, 183)-(417, 190), 13
   LINE (263, 118)-(270, 118), 13 ' left
   LINE (260, 120)-(270, 120), 13
   LINE (263, 122)-(270, 122), 13
   LINE (570, 118)-(578, 118), 13 ' right
   LINE (570, 120)-(580, 120), 13
   LINE (570, 122)-(578, 122), 13
   ' draw vertical lines
   LINE (0, 23)-(200, 23), 1
   zn = 30
   DO
      FOR z = 1 TO 4
         LINE (10, zn)-(40, zn), 1
         zn = zn + 5
      NEXT
      LINE (10, zn)-(47, zn), 1
      IF zn = 190 THEN
         zn = 0
         EXIT DO
      END IF
   LOOP
   ' simulate radar scope
   DO
      ' check for keypress
      IF INKEY$ <> "" THEN
         CLS
         SCREEN 0
         END
      END IF
      ' display line
      LINE (0, 23)-(200, 23), 1
      ' draw scope circle
      CIRCLE (x0, y0), 150, 1
      ' noise of rate
      SOUND 1200 + rt, .1
      GOSUB timeout
      ' check exponent bounds
      IF INSTR(STR$(theta), "E") = 0 THEN
         ' display status bar info
         te$ = "theta=" + STR$(theta)
         IF MID$(te$, 7, 1) = " " THEN MID$(te$, 7, 1) = "+"
         te$ = LEFT$(te$, 12): te$ = te$ + SPACE$(13 - LEN(te$))
         LOCATE 1, 1, 1
         COLOR 13, 0
         PRINT "phasor: rate="; MID$(STR$(rt), 2); " "; te$; "interval="; n; SPACE$(12);
      END IF
      ' increment rate
      rt = rt + 1
      IF rt > 180 THEN
         rt = rt + 1
      END IF
      IF rt > 270 THEN
         rt = rt + 1
      END IF
      ' check rate
      IF rt >= 360 THEN
         ' clear screen and beep
         CLS : BEEP: BEEP: BEEP
         ' make screen flash
         FOR k = 1 TO 25
            COLOR , INT(RND * 10 + 1)
            GOSUB timeout
         NEXT
         EXIT DO
      END IF
      ' calculate x,y on circle
      theta = pi * n * rt / 180
      x = 150 * COS(theta) + 420
      y = 63 * SIN(theta) + 120
      ' decrease interval
      n = n - 1
      ' check interval bounds
      IF n < -(360 / rt) THEN
         n = 0
         zd = zd + 1
         LOCATE 22, 9, 1
         COLOR 14, 0
         PRINT "galaxy"; zd;
      END IF
      ' draw scope lines
      LINE (x, y)-(x0, y0), 15
      LINE (p1, q1)-(x0, y0), 13
      LINE (p2, q2)-(x0, y0), 5
      LINE (p3, q3)-(x0, y0), 0
      ' store line values
      p3 = p2: q3 = q2
      p2 = p1: q2 = q1
      p1 = x: q1 = y
      ' make some stars
      FOR l1 = 1 TO 10
         xx1 = INT(RND * 640)
         xx2 = INT(RND * 200)
         PSET (xx1, xx2), 15
         zz1 = zz1 + 1
      NEXT
      LOCATE 23, 9, 1
      COLOR 14, 0
      PRINT "star"; zz1;
      ' display time
      IF t$ <> TIME$ THEN
         t$ = TIME$
         LOCATE 1, 60
         COLOR 12, 0
         ' form: mm-dd-yyyy hh:mm:ss
         x$ = DATE$ + " " + TIME$ + "  "
         MID$(x$, 3, 1) = "."
         MID$(x$, 6, 1) = "."
         MID$(x$, 14, 1) = "."
         MID$(x$, 17, 1) = "."
         PRINT x$;
         SOUND 1200, .1
      END IF
   LOOP
LOOP
END
' timer routine
timeout:
IF speed = 3 THEN tw! = .001
IF speed = 2 THEN tw! = .075
IF speed = 1 THEN tw! = .1
w1! = TIMER
DO
   w2! = TIMER - w1!
   IF w2! < 0! THEN w2! = w2! + 86400!
   IF w2! > tw! THEN RETURN
LOOP
RETURN
