' raisedtr v1.0

DEFINT A-Z
REM $DYNAMIC

TYPE RegType
 AX AS INTEGER
 BX AS INTEGER
 CX AS INTEGER
 DX AS INTEGER
 BP AS INTEGER
 SI AS INTEGER
 DI AS INTEGER
 Flags AS INTEGER
END TYPE

 COMMON SHARED Inregs AS RegType, Outregs AS RegType, Port AS INTEGER
 DECLARE SUB Interrupt (N AS INTEGER, I AS RegType, O AS RegType)

 IF COMMAND$ = "" THEN
    GOTO BootUsage
 END IF
 Port = INT(VAL(COMMAND$))
 IF Port < 1 OR Port > 4 THEN
    GOTO BootUsage
 END IF
 Port = Port - 1
 COLOR 15, 0
 PRINT "Raisedtr v1.0: Modem port utility;"
 COLOR 14, 0
 Inregs.AX = &H300
 Inregs.DX = Port
 CALL Interrupt(&H14, Inregs, Outregs)
 IF (Outregs.AX AND &HFF) = &HFF THEN
    PRINT "No modem on comm port";Str$(Port+1);"."
 ELSE
    GOSUB DetectFossil
    IF Fossil.Active THEN
       GOSUB RaiseFossilDTR
    ELSE
       GOSUB RaisePortDTR
    END IF
    PRINT "Comm"; Port + 1; "(port "; MID$(STR$(Port), 2); ") DTR raised."
 END IF
 COLOR 7, 0
 END

BootUsage:
 COLOR 15, 0
 PRINT "Raisedtr v1.0: Modem port utility;"
 COLOR 14, 0
 PRINT "Usage:"
 PRINT "   Raisedtr <comm port>"
 PRINT "Where:"
 PRINT "   Comm port=1 to 4"
 COLOR 7, 0
 END

RaisePortDTR:
 SELECT CASE Port
 CASE 0
    PortAddress = &H3FC
 CASE 1
    PortAddress = &H2FC
 CASE 2
    PortAddress = &H3EC
 CASE 3
    PortAddress = &H2EC
 END SELECT
 OUT PortAddress, 1
 RETURN

DetectFossil:
 Fossil.Active = 0
 Fossil.Version = 0
 Inregs.AX = &H1C00
 Inregs.DX = Port
 CALL Interrupt(&H14, Inregs, Outregs)
 IF Outregs.AX = &H1954 THEN
    Fossil.Active = -1
    Fossil.Version = 1
 ELSE
    Inregs.AX = &H400
    Inregs.DX = Port
    CALL Interrupt(&H14, Inregs, Outregs)
    IF Outregs.AX = &H1954 THEN
       Fossil.Active = -1
       Fossil.Version = 2
    END IF
 END IF
 RETURN

RaiseFossilDTR:
 IF Fossil.Version = 1 THEN
    Inregs.AX = &H1F01
    Inregs.BX = 1
 ELSE
    Inregs.AX = &H601
 END IF
 Inregs.DX = Port
 CALL Interrupt(&H14, Inregs, Outregs)
 RETURN

