REM file: Xcount.bas - Public Domain DOS Utility
REM Version 1.0a created 04/22/1998
REM Version 1.1a created 07/11/1999
REM Version 1.2a created 12/24/1999
REM Version 1.3a created 06/17/2000
REM Version 1.4a created 12/21/2000
REM Version 1.5a created 03/10/2001

' default integer variables
DEFINT A-Z
REM $DYNAMIC

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' get include files
REM $INCLUDE: 'qbx.bi'
REM $INCLUDE: 'dta.bi'
REM $INCLUDE: 'wdta.bi'

' declare subroutines
DECLARE SUB Directories (D$, F$)
DECLARE SUB Filenames (D$, F$)
DECLARE SUB DisplayFiles (D$, F$)
DECLARE SUB CountFileLines (D$, F$)

' declare functions
DECLARE FUNCTION ParseLine (S$)
DECLARE FUNCTION BreakIS()
DECLARE FUNCTION ClearBreak()
DECLARE FUNCTION KeyIS()

' initialize filename buffer
DIM ASCIIZ AS STRING * 260
COMMON SHARED ASCIIZ.Copy AS STRING * 260, ASCIIZ.Display AS STRING * 260
COMMON SHARED Directory.ASCIIZ AS STRING * 260, ASCIIZ.Sub AS STRING * 260
COMMON SHARED Drive.Search AS STRING * 1, ASCIIZ.File AS STRING * 260

' declare program dta
DIM BASIC.DTA.SEG AS INTEGER, BASIC.DTA.OFF AS INTEGER
COMMON SHARED TempDTA AS DTAtype, TempWDTA AS WDTAtype
COMMON SHARED TreeWDTA AS WDTAtype, FileWDTA AS WDTAtype

' declare registers
COMMON SHARED InregsX AS RegTypeX, OutregsX AS RegTypeX

' declare work variables
COMMON SHARED Files.Counter AS INTEGER, Quit.Searching AS INTEGER
COMMON SHARED Continuous.Display AS INTEGER, Dot.Count AS INTEGER
COMMON SHARED Count.Forward AS INTEGER, Display.Dots AS INTEGER
COMMON SHARED Redirected.Input AS INTEGER, Display.Errors AS INTEGER
COMMON SHARED Remove.Slash AS INTEGER, Prepend.Drive AS INTEGER
COMMON SHARED Nested.Levels AS INTEGER, Nested.Recurse AS INTEGER

' declare search work variables
COMMON SHARED Search.From.Date AS SINGLE, Search.To.Date AS SINGLE
COMMON SHARED Search.From.Time AS SINGLE, Search.To.Time AS SINGLE
COMMON SHARED File.Size AS DOUBLE, Recurse.Directories AS INTEGER
COMMON SHARED Display.Hidden AS INTEGER, Display.System AS INTEGER
COMMON SHARED Display.Readonly AS INTEGER, Display.Archive AS INTEGER
COMMON SHARED Display.Any AS INTEGER, No.Display.Archive AS INTEGER
COMMON SHARED No.Display.Readonly AS INTEGER, No.Display.System AS INTEGER
COMMON SHARED No.Display.Hidden AS INTEGER, No.Display.Any AS INTEGER

' declare count variables
COMMON SHARED Count.Dirs AS INTEGER, Dirs.Counted AS DOUBLE
COMMON SHARED Count.Files AS INTEGER, Files.Counted AS DOUBLE
COMMON SHARED Count.Bytes AS INTEGER, Bytes.Counted AS DOUBLE
COMMON SHARED Count.Lines AS INTEGER, Lines.Counted AS DOUBLE
COMMON SHARED Display.Search AS INTEGER, Display.Filenames AS INTEGER

' declare file date\time and filesize work variables
COMMON SHARED File.Work.Date AS SINGLE, File.Work.Time AS SINGLE
COMMON SHARED Search.Size.From AS DOUBLE, Search.Size.To AS DOUBLE
COMMON SHARED Search.File.Size, Creation.Time AS INTEGER
COMMON SHARED Access.Time AS INTEGER, Modified.Time AS INTEGER

' declare command line work variables
COMMON SHARED Command.Line AS STRING, Command.Line.Redirect AS STRING
COMMON SHARED Command.Work AS STRING, Control.Break AS INTEGER

' declare dos command work variables
COMMON SHARED Windows.Detected AS INTEGER

' initialize filename buffer
' note: 4096 bytes is optimized for windows fat 32
COMMON SHARED Buffer AS STRING * 4096

' declare external procedures
DECLARE SUB SetInt
DECLARE SUB RestInt

' backwards compatible for bc 7.1
REM $INCLUDE: 'bc7.inc'

' adjust stack size
STACK STACK

' install new interrupt service routine
CALL SetInt

' declare standard error trap
ON ERROR GOTO Error.Routine

' command line parser
FUNCTION ParseLine (X$)
 Imbedded = INSTR(Command.Line, LCASE$(X$))
 IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    ParseLine = True
 ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
       Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
       ParseLine = True
    ELSE
       ParseLine = False
    END IF
 END IF
END FUNCTION 

' store basic dta
InregsX.AX = &H2F00
CALL InterruptX(&H21, InregsX, OutregsX)
BASIC.DTA.SEG = OutregsX.ES
BASIC.DTA.OFF = OutregsX.BX

' get current drive
InregsX.AX = &H1900
CALL InterruptX(&H21, InregsX, OutregsX)
Current.Drive$ = CHR$((OutregsX.AX AND &HFF) + 65)

' check windows dos
InregsX.AX = &H160A
CALL InterruptX(&H2F, InregsX, OutregsX)
IF OutregsX.AX = False THEN
   Temp = (OutregsX.BX And &HFF00) / 256
   IF Temp >= 4 THEN
      Windows.Detected = True
   END IF
Endif

' check windows dos
IF Windows.Detected THEN
   ' get current directory
   InregsX.AX = &H7147
   InregsX.DX = ASC(Current.Drive$) - 64
   InregsX.DS = VARSEG(Directory.ASCIIZ)
   InregsX.SI = VARPTR(Directory.ASCIIZ)
   CALL InterruptX(&H21, InregsX, OutregsX)
ELSE
   ' get current directory
   InregsX.AX = &H4700
   InregsX.DX = ASC(Current.Drive$) - 64
   InregsX.DS = VARSEG(Directory.ASCIIZ)
   InregsX.SI = VARPTR(Directory.ASCIIZ)
   CALL InterruptX(&H21, InregsX, OutregsX)
END IF

' store directory
Directory.ASCIIZ = "\" + RTRIM$(Directory.ASCIIZ) + CHR$(0)

' check command line
SELECT CASE COMMAND$
CASE "/?"
   GOTO Boot.Usage
END SELECT

' read command line from PSP
Command.Line = NUL
InregsX.AX = &H6200
CALL InterruptX(&H21, InregsX, OutregsX)
PSPsegment = OutregsX.BX
PSPoffset = 128
DEF SEG = PSPsegment
FOR Count = 1 TO 127
   Command.Char = PEEK(PSPoffset + Count)
   SELECT CASE Command.Char
   CASE 0, 10, 13
      EXIT FOR
   CASE ELSE
      Command.Line = Command.Line + CHR$(Command.Char)
   END SELECT
NEXT
DEF SEG
Command.Line = LTRIM$(Command.Line)

' store and parse command line
IF Command.Line = NUL THEN
   Command.Line = ENVIRON$("XCOUNT")
END IF

' check command line switches
Display.Archive = ParseLine ("+A")
Display.Hidden = ParseLine ("+H")
Display.Readonly = ParseLine ("+O")
Display.System = ParseLine ("+S")
Display.Any = ParseLine ("+X")
No.Display.Archive = ParseLine ("/A")
No.Display.Hidden = ParseLine ("/H")
No.Display.Readonly = ParseLine ("/O")
No.Display.System = ParseLine ("/S")
No.Display.Any = ParseLine ("/X")

Continuous.Display = ParseLine ("/C")
Count.Dirs = ParseLine ("/E")
Count.Files = ParseLine ("/G")
Count.Bytes = ParseLine ("/I")
Count.Lines = ParseLine ("/K")
Display.Search = ParseLine ("/J")
Recurse.Directories = ParseLine ("/R")
Prepend.Drive = ParseLine ("/U")
Display.Filenames = ParseLine ("/V")
Remove.Slash = ParseLine ("/Y")
Display.Errors = ParseLine ("/Z")
Display.Dots = ParseLine("/.")
Control.Break = ParseLine ("/~")

' reset file counter variable
Continue = False
Count.Forward = False
Dirs.Counted = 0#
Dot.Count = False
Files.Counted = 0#
Lines.Counted = 0#
Total.Bytes = 0#
   
' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = INSTR(UCASE$(Command.Line), "/D")
IF Imbedded THEN
   D$ = MID$(Command.Line, Imbedded + 2, 21)
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 23)
   IF LEN(D$) <> 21 THEN
      GOTO Boot.Error
   END IF
   IF MID$(D$, 11, 1) <> "-" THEN
      GOTO Boot.Error
   END IF
   S$ = LEFT$(D$, 10)
   D1! = INT(VAL(MID$(S$, 1, 2)))
   D2! = INT(VAL(MID$(S$, 4, 2)))
   D3! = INT(VAL(MID$(S$, 7, 4)))
   Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   S$ = RIGHT$(D$, 10)
   D1! = INT(VAL(MID$(S$, 1, 2)))
   D2! = INT(VAL(MID$(S$, 4, 2)))
   D3! = INT(VAL(MID$(S$, 7, 4)))
   Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
   IF Search.From.Date < False OR Search.To.Date < False THEN
      GOTO Boot.Error
   END IF
END IF
Imbedded = INSTR(UCASE$(Command.Line), "/T")
IF Imbedded THEN
   T$ = MID$(Command.Line, Imbedded + 2, 17)
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 19)
   IF LEN(T$) <> 17 THEN
      GOTO Boot.Error
   END IF
   IF MID$(T$, 9, 1) <> "-" THEN
      GOTO Boot.Error
   END IF
   S$ = LEFT$(T$, 8)
   T1! = INT(VAL(MID$(S$, 1, 2)))
   T2! = INT(VAL(MID$(S$, 4, 2)))
   T3! = INT(VAL(MID$(S$, 7, 2)))
   Search.From.Time = T1! * 2048 + T2! * 32 + INT(T3! / 2)
   S$ = RIGHT$(T$, 8)
   T1! = INT(VAL(MID$(S$, 1, 2)))
   T2! = INT(VAL(MID$(S$, 4, 2)))
   T3! = INT(VAL(MID$(S$, 7, 2)))
   Search.To.Time = T1! * 2048 + T2! * 32 + INT(T3! / 2)
   IF Search.From.Time < False OR Search.To.Time < False THEN
      GOTO Boot.Error
   END IF
END IF

' get file size from command line
Search.File.Size = False
Search.Size.From = FalseD
Search.Size.To = FalseD
Imbedded = INSTR(UCASE$(Command.Line), "/F")
IF Imbedded THEN
   Search.File.Size = True
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
   GOSUB Get.Numeric
   Search.Size.From = Var#
   IF MID$(Command.Line, Imbedded, 1) <> "-" THEN
      GOTO Boot.Usage
   END IF
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
   GOSUB Get.Numeric
   Search.Size.To = Var#
   Search.Size.From = Search.Size.From * 1024#
   Search.Size.To = Search.Size.To * 1024#
END IF

Creation.Time = ParseLine ("/1")
Access.Time = ParseLine ("/2")
Modified.Time = ParseLine ("/3")
IF Creation.Time = False THEN
   IF Access.Time = False THEN
      IF Modified.Time = False THEN
         Modified.Time = True
      END IF
   END IF
END IF

' check command line switch
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
   Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
   GOSUB Get.Numeric
   Nested.Recurse = CINT(Var#)
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
   GOTO Boot.Usage
END IF

' recheck command line
IF INSTR(Command.Line, "+") THEN
   GOTO Boot.Usage
END IF

' reset work variables
Files.Counter = False
Quit.Searching = False
   
' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
Command.Line.Redirect = Command.Line

' check break flag override
IF Control.Break THEN
   Var = ClearBreak
END IF

' search through all input filenames
Redirected.Input = False
DO
   ' check control break
   IF BreakIS THEN
      EXIT DO
   END IF

   ' get standard input
   Standard.Input$ = NUL
   InregsX.AX = &HB00
   CALL InterruptX(&H21, InregsX, OutregsX)
   DO WHILE (OutregsX.AX AND &HFF) = &HFF
      Redirected.Input = True
      InregsX.AX = &H800
      CALL InterruptX(&H21, InregsX, OutregsX)
      Char$ = CHR$(OutregsX.AX AND &HFF)
      SELECT CASE ASC(Char$)
      CASE 10, 26
      CASE 13
	 EXIT DO
      CASE ELSE
	 Standard.Input$ = Standard.Input$ + Char$
      END SELECT
      InregsX.AX = &HB00
      CALL InterruptX(&H21, InregsX, OutregsX)
   LOOP

   ' clear break flag
   IF Redirected.Input = False THEN
      IF Cleared = False THEN
         Cleared = True
         Var = ClearBreak
      END IF
   END IF

   ' check control break
   IF BreakIS THEN
      EXIT DO
   END IF

   ' check nul filename input
   IF Redirected.Input = False THEN
      IF Standard.Input$ = NUL THEN
         CALL RestInt ' restore Control-Break
         X$ = Inkey$ ' quits here
         CALL SetInt ' reset Control-Break
         IF X$ = CHR$(0) + CHR$(0) THEN
            EXIT DO
         END IF
      END IF
   END IF

   ' check standard input
   IF Redirected.Input THEN
      IF Standard.Input$ = NUL THEN
	 EXIT DO
      END IF
   END IF

   ' display header
   GOSUB Header

   ' store original command line
   Command.Line = Command.Line.Redirect

   ' filename processing loop
   DO
      ' check control break
      IF BreakIS THEN
         EXIT DO
      END IF

      ' store redirected input
      Standard.Input$ = RTRIM$(Standard.Input$)
      Standard.Input$ = LTRIM$(Standard.Input$)
      IF LEFT$(Standard.Input$, 1) = CHR$(34) THEN
         Standard.Input$ = MID$(Standard.Input$, 2)
      END IF
      IF RIGHT$(Standard.Input$, 1) = CHR$(34) THEN
         Standard.Input$ = LEFT$(Standard.Input$, LEN(Standard.Input$) - 1)
      END IF

      ' store entire command
      IF LEFT$(Command.Line, 1) = CHR$(34) THEN
         Imbedded = INSTR(2, Command.Line, CHR$(34))
         IF Imbedded THEN
            Command.Work = Standard.Input$ + MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
         ELSE
            Command.Work = Standard.Input$ + Command.Line
            Command.Line = NUL
         END IF
      ELSE
         Imbedded = INSTR(Command.Line, " ")
         IF Imbedded THEN
            Command.Work = Standard.Input$ + LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
         ELSE
            Command.Work = Standard.Input$ + Command.Line
            Command.Line = NUL
         END IF
      END IF
      Command.Line = LTRIM$(Command.Line)
      Command.Line = RTRIM$(Command.Line)

      ' store current drive
      IF MID$(Command.Work, 2, 1) = ":" THEN
         Drive.Search = LEFT$(Command.Work, 1)
         Command.Work = MID$(Command.Work, 3)
      ELSE
	 Drive.Search = Current.Drive$
      END IF
      Drive.Search = UCASE$(Drive.Search)

      ' store search directory/filename
      Directory.Search$ = NUL
      Filename.Search$ = NUL
      IF Command.Work = NUL THEN
         Directory.Search$ = "\"
         Filename.Search$ = "*.*"
      ELSE
         IF RIGHT$(Command.Work, 1) = "\" THEN
            Directory.Search$ = Command.Work
            Filename.Search$ = "*.*"
         ELSE
            FOR Slash = LEN(Command.Work) TO 1 STEP -1
               IF MID$(Command.Work, Slash, 1) = "\" THEN
                  Directory.Search$ = LEFT$(Command.Work, Slash)
                  Command.Work = MID$(Command.Work, Slash + 1)
                  EXIT FOR
               END IF
            NEXT
            Filename.Search$ = Command.Work
         END IF
      END IF
      IF LEFT$(Directory.Search$, 1) <> "\" THEN
         Directory.Search$ = "\" + Directory.Search$
      END IF
      IF RIGHT$(Directory.Search$, 1) <> "\" THEN
         Directory.Search$ = Directory.Search$ + "\"
      END IF
      Command.Work = NUL

      ' display search filename
      IF Continuous.Display = False THEN
         ' clear dots
         FOR Count = 1 TO Dot.Count
            PRINT CHR$(29);" ";CHR$(29);
         NEXT
         Dot.Count = False
         Count.Forward = False
         COLOR Yellow, Black
         PRINT "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
      END IF

      ' check windows dos
      IF Windows.Detected THEN
         ' get current directory
         InregsX.AX = &H7147
         InregsX.DX = ASC(Drive.Search) - 64
         InregsX.DS = VARSEG(ASCIIZ)
         InregsX.SI = VARPTR(ASCIIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      ELSE
         ' get current directory
         InregsX.AX = &H4700
         InregsX.DX = ASC(Drive.Search) - 64
         InregsX.DS = VARSEG(ASCIIZ)
         InregsX.SI = VARPTR(ASCIIZ)
         CALL InterruptX(&H21, InregsX, OutregsX)
      END IF

      ' display any errors
      CALL DisplayError ("Error accessing drive.")

      ' check find first error
      IF (OutregsX.Flags AND &H1) = &H0 THEN
   
         ' change to drive
         InregsX.AX = &HE00
         InregsX.DX = ASC(Drive.Search) - 65
         CALL InterruptX(&H21, InregsX, OutregsX)
   
         ' display any errors
         CALL DisplayError ("Error accessing drive.")

         ' check find first error
         IF (OutregsX.Flags AND &H1) = &H0 THEN

            ' call routine to search for files
            CALL Directories(Directory.Search$, Filename.Search$)
         END IF
      END IF

      ' check search filename
      IF Command.Line = NUL THEN
	 EXIT DO
      END IF

      ' check quit searching
      IF Quit.Searching THEN
	 EXIT DO
      END IF
   LOOP

   ' check search filename
   IF Standard.Input$ = NUL THEN
      EXIT DO
   END IF

   ' check quit searching flag
   IF Quit.Searching THEN
      EXIT DO
   END IF
LOOP

End.Xcount:

' restore basic dta
InregsX.AX = &H1A00
InregsX.DS = BASIC.DTA.SEG
InregsX.DX = BASIC.DTA.OFF
CALL InterruptX(&H21, InregsX, OutregsX)

' restore current drive
InregsX.AX = &HE00
InregsX.DX = ASC(Current.Drive$) - 65
CALL InterruptX(&H21, InregsX, OutregsX)

' check windows dos
IF Windows.Detected THEN
   ' restore current directory
   InregsX.AX = &H713B
   InregsX.DS = VARSEG(Directory.ASCIIZ)
   InregsX.DX = VARPTR(Directory.ASCIIZ)
   CALL InterruptX(&H21, InregsX, OutregsX)
ELSE
   ' restore current directory
   InregsX.AX = &H3B00
   InregsX.DS = VARSEG(Directory.ASCIIZ)
   InregsX.DX = VARPTR(Directory.ASCIIZ)
   CALL InterruptX(&H21, InregsX, OutregsX)
END IF

' clear dots
FOR Count = 1 TO Dot.Count
   PRINT CHR$(29);" ";CHR$(29);
NEXT

' display end program
IF BreakIS = False THEN
   COLOR Yellow, Black
   IF Count.Dirs THEN
      PRINT "Directories counted "; Format$(Dirs.Counted, "#,##0;;0")
   END IF
   IF Count.Files THEN
      PRINT "Files counted "; Format$(Files.Counted, "#,##0;;0")
   END IF
   IF Count.Lines THEN
      PRINT "Lines counted "; Format$(Lines.Counted, "#,##0;;0")
   END IF
   IF Count.Bytes THEN
      PRINT "Bytes counted "; Format$(Bytes.Counted, "#,##0;;0")
   END IF
END IF
If Continuous.Display = False Then
   Prompt$ = "Press <enter> to exit to DOS:"
   CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
Endif

' restore key trapping
CALL RestInt

COLOR Plain, Black
END

' display program usage
Boot.Usage:
 ' restore key trapping
 CALL RestInt
 Var$=Inkey$
 ' make header
 COLOR White, Black
 PRINT "Xcount v1.5a: Directory/file count utility; "
 COLOR Yellow, Black
 PRINT "Usage:"
 PRINT "   Xcount [d:][\pathname\][filename][+/ahosx][/cdefgijknrtuvyz][/123]"
 PRINT "Where:"
 PRINT "   d:\pathname\filename is the search directory."
 PRINT "   /c  continuous display    /e  count directories"
 PRINT "   /g  count files           /i  count total bytes"
 PRINT "   /j  display directories   /k  count total lines"
 PRINT "   /nxxx  recurse override   /r  recurse directories"
 PRINT "   /u  prepend drive letter  /v  display filenames"
 PRINT "   /y  remove trailing slash /z  suppress error messages"
 PRINT "   /.  don't display dots (use with /j and /v)"
 PRINT "   display ranges: (/1  creation, /2  last access  /3  modify time)"
 PRINT "     /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
 PRINT "     /t  is range of file times in form hh:mm:ss-hh:mm:ss"
 PRINT "     /f  is range of file sizes in form xxx-xxx in kilobytes"
 PRINT "   display file attributes:"
 PRINT "     + prefix for files with, / prefix for files without,"
 PRINT "       a  archive, h  hidden, o  read-only, s  system, x  none"
 COLOR Plain, Black
 END

Get.Numeric:
 Var# = False
 DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
       Var# = Var# * 10 + VAL(Temp$)
       Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
       EXIT DO
    END IF
 LOOP
 RETURN

Boot.Error:
 CALL RestInt
 Var$=Inkey$
 COLOR White, Black
 PRINT "Command line error. Type Xcount /? for help."
 COLOR Plain, Black
 END

' make header
Header:
 IF Header.Flag THEN
    RETURN
 END IF
 Header.Flag = True
 IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Xcount v1.5a: Directory/file count utility; "
 END IF
 RETURN

' subroutine to access directories
SUB Directories (Directory.Search$, Filename.Search$)
 ' declare subroutine variables
 DIM Attribute AS INTEGER
 DIM DTAfile AS DTAtype
 DIM Wfile.Handle AS INTEGER

 ' make directory filename
 IF Display.Search THEN
    IF Display.Dots THEN
       Filename$ = Directory.Search$
       IF Filename$ <> "\" THEN
          IF Remove.Slash THEN
             Slash = LEN(Filename$)
             Filename$ = LEFT$(Filename$, Slash - 1)
          END IF
       END IF
       IF Prepend.Drive THEN
          Filename$ = Drive.Search + ":" + Filename$
       END IF
       COLOR Yellow, Black
       PRINT Filename$
    END IF
 END IF
 ASCIIZ.Sub = Directory.Search$ + Filename.Search$ + CHR$(0)
 GOSUB Restore.DTA

 IF Windows.Detected THEN
    InregsX.AX = &H714E
    InregsX.CX = &H37
    InregsX.SI = &H1
    InregsX.DS = VARSEG(ASCIIZ.Sub)
    InregsX.DX = VARPTR(ASCIIZ.Sub)
    InregsX.ES = VARSEG(TreeWDTA)
    InregsX.DI = VARPTR(TreeWDTA)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    InregsX.AX = &H4E00
    InregsX.CX = &H37
    InregsX.DS = VARSEG(ASCIIZ.Sub)
    InregsX.DX = VARPTR(ASCIIZ.Sub)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF

 ' check find first error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    EXIT SUB
 END IF

 ' increment directories counted
 Dirs.Counted = Dirs.Counted + 1#

 ' show disk activity
 IF Continuous.Display = False THEN
    IF Display.Dots = False THEN
       IF Count.Forward = False THEN
          COLOR Yellow, Black
          PRINT ".";
          Dot.Count = Dot.Count + 1
          IF Dot.Count = 8 THEN
             Count.Forward = True
          END IF
       ELSE
          PRINT CHR$(29);" ";CHR$(29);
          Dot.Count = Dot.Count - 1
          IF Dot.Count = False THEN
             Count.Forward = False
          END IF
       END IF
    END IF
 END IF

 ' search directory names
 CALL Filenames(Directory.Search$, Filename.Search$)
 GOSUB Restore.DTA

 ' check to recurse directories
 IF Recurse.Directories THEN

    ' recurse directories
    DO
       ' check control-break
       IF BreakIS THEN
          Quit.Searching = True
       END IF

       ' check to quit
       IF Quit.Searching THEN
          EXIT DO
       END IF

       ' check directory attribute
       IF Windows.Detected THEN
          Attribute = ASC(TreeWDTA.FileBits)
       ELSE
          Attribute = ASC(DTAfile.FileBits)
       END IF

       ' check for directory
       IF (Attribute AND &H10) = &H10 THEN

          ' store directory name
          IF Windows.Detected THEN
             Directory$ = TreeWDTA.ASCIIZfull
          ELSE
             Directory$ = DTAfile.ASCIIZfilename
          END IF
          Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

          ' check directory name
          IF Directory$ <> "." AND Directory$ <> ".." THEN

             ' make next search directory
             Next.Directory$ = Directory.Search$ + Directory$ + "\"

             ' check recursion levels
             Recursion% = True
             IF Nested.Recurse > False THEN
                Nested.Levels = Nested.Levels + 1
                IF Nested.Levels >= Nested.Recurse THEN
                   Recursion% = False
                END IF
             END IF

             ' recursively search subdirectories
             IF Recursion% THEN
                CALL Directories(Next.Directory$, Filename.Search$)
             END IF
             IF Nested.Recurse > False THEN
                Nested.Levels = Nested.Levels - 1
             END IF

             ' restore dta
             GOSUB Restore.DTA
          END IF
       END IF

       ' check windows dos
       IF Windows.Detected THEN
          ' find next long filename
          InregsX.AX = &H714F
          InregsX.BX = Wfile.Handle
          InregsX.SI = &H1
          InregsX.ES = VARSEG(TreeWDTA)
          InregsX.DI = VARPTR(TreeWDTA)
          CALL InterruptX(&H21, InregsX, OutregsX)
       ELSE
          ' find next directory
          InregsX.AX = &H4F00
          CALL InterruptX(&H21, InregsX, OutregsX)
       END IF

       ' check findnext error
       IF (OutregsX.Flags AND &H1) = &H1 THEN
          EXIT DO
       END IF
    LOOP
 END IF

 ' check windows dos
 IF Windows.Detected THEN
    ' close long filename search
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 EXIT SUB

Restore.DTA:
 ' restore directory search dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
END SUB

' subroutine to access filenames in directory
SUB Filenames (Directory.Search$, Filename.Search$)
 ' declare subroutine variables
 DIM Attribute AS INTEGER
 DIM DTAfile AS DTAtype
 DIM Wfile.Handle AS INTEGER

 ' make filename
 ASCIIZ.File = Directory.Search$ + Filename.Search$ + CHR$(0)

 ' restore dta
 GOSUB Restore.FDTA

 ' check windows dos
 IF Windows.Detected THEN
    InregsX.AX = &H714E
    InregsX.CX = &H37
    InregsX.SI = &H1
    InregsX.DS = VARSEG(ASCIIZ.File)
    InregsX.DX = VARPTR(ASCIIZ.File)
    InregsX.ES = VARSEG(FileWDTA)
    InregsX.DI = VARPTR(FileWDTA)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    InregsX.AX = &H4E00
    InregsX.CX = &H37
    InregsX.DS = VARSEG(ASCIIZ.File)
    InregsX.DX = VARPTR(ASCIIZ.File)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF

 ' check find first error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    EXIT SUB
 END IF

 ' search filenames
 DO
    ' store filename
    IF Windows.Detected THEN
       Filename$ = FileWDTA.ASCIIZfull
    ELSE
       Filename$ = DTAfile.ASCIIZfilename
    END IF
    Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

    ' check filename
    IF Filename$ <> "." AND Filename$ <> ".." THEN
       ' store file size
       IF Windows.Detected THEN
          File.Size = False
          File.Size = File.Size * &H100 + ASC(MID$(FileWDTA.FileSizeHigh, 4, 1))
          File.Size = File.Size * &H100 + ASC(MID$(FileWDTA.FileSizeHigh, 3, 1))
          File.Size = File.Size * &H100 + ASC(MID$(FileWDTA.FileSizeHigh, 2, 1))
          File.Size = File.Size * &H100 + ASC(MID$(FileWDTA.FileSizeHigh, 1, 1))
          File.Size = File.Size * &H100 + ASC(MID$(FileWDTA.FileSizeLow, 4, 1))
          File.Size = File.Size * &H100 + ASC(MID$(FileWDTA.FileSizeLow, 3, 1))
          File.Size = File.Size * &H100 + ASC(MID$(FileWDTA.FileSizeLow, 2, 1))
          File.Size = File.Size * &H100 + ASC(MID$(FileWDTA.FileSizeLow, 1, 1))
       ELSE
          File.Size = False
          File.Size = File.Size + ASC(MID$(DTAfile.FileSize, 4, 1))
          File.Size = File.Size * &H100 + ASC(MID$(DTAfile.FileSize, 3, 1))
          File.Size = File.Size * &H100 + ASC(MID$(DTAfile.FileSize, 2, 1))
          File.Size = File.Size * &H100 + ASC(MID$(DTAfile.FileSize, 1, 1))
       END IF

       ' display filename
       IF Windows.Detected THEN
          TempWDTA = FileWDTA
       ELSE
          TempDTA = DTAfile
       END IF

       ' check directory attribute
       IF Windows.Detected THEN
          Attribute = ASC(TempWDTA.FileBits)
       ELSE
          Attribute = ASC(TempDTA.FileBits)
       END IF

       ' check for directory
       IF (Attribute AND &H10) <> &H10 THEN
          CALL DisplayFiles (Directory.Search$, Filename$)
       Endif

       ' restore dta
       GOSUB Restore.FDTA
    END IF

    ' check control-break
    IF BreakIS THEN
       Quit.Searching = True
    END IF

    ' check to quit
    IF Quit.Searching THEN
       EXIT DO
    END IF

    IF Windows.Detected THEN
       ' find next long filename
       InregsX.AX = &H714F
       InregsX.BX = Wfile.Handle
       InregsX.SI = &H1
       InregsX.ES = VARSEG(FileWDTA)
       InregsX.DI = VARPTR(FileWDTA)
       CALL InterruptX(&H21, InregsX, OutregsX)
    ELSE
       ' find next filename
       InregsX.AX = &H4F00
       CALL InterruptX(&H21, InregsX, OutregsX)
    END IF

    ' check find first error
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF
 LOOP

 ' check windows dos
 IF Windows.Detected THEN
    ' close long filename search
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 EXIT SUB

Restore.FDTA:
 ' restore directory search dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN
END SUB

' subroutine to count a filename
SUB DisplayFiles (Directory.Search$, Filename.Search$)
 ' declare subroutine variables
 DIM Attribute AS INTEGER

 ' check directory attribute
 IF Windows.Detected THEN
    Attribute = ASC(TempWDTA.FileBits)
 ELSE
    Attribute = ASC(TempDTA.FileBits)
 END IF

 ' check for readonly file
 IF (Attribute AND &H1) = &H1 THEN
    IF No.Display.Readonly THEN
       EXIT SUB
    END IF
 ELSE
    IF Display.Readonly THEN
       EXIT SUB
    END IF
 END IF

 ' check for hidden file
 IF (Attribute AND &H2) = &H2 THEN
    IF No.Display.Hidden THEN
       EXIT SUB
    END IF
 ELSE
    IF Display.Hidden THEN
       EXIT SUB
    END IF
 END IF

 ' check for system file
 IF (Attribute AND &H4) = &H4 THEN
    IF No.Display.System THEN
       EXIT SUB
    END IF
 ELSE
    IF Display.System THEN
       EXIT SUB
    END IF
 END IF

 ' check for archive file
 IF (Attribute AND &H20) = &H20 THEN
    IF No.Display.Archive THEN
       EXIT SUB
    END IF
 ELSE
    IF Display.Archive THEN
       EXIT SUB
    END IF
 END IF

 ' check all attributes
 IF Display.Any THEN
    IF (Attribute AND &H1) = &H1 THEN
       EXIT SUB
    END IF
    IF (Attribute AND &H2) = &H2 THEN
       EXIT SUB
    END IF
    IF (Attribute AND &H4) = &H4 THEN
       EXIT SUB
    END IF
    IF (Attribute AND &H20) = &H20 THEN
       EXIT SUB
    END IF
 END IF
 IF No.Display.Any THEN
    IF (Attribute AND &H1) = False THEN
       IF (Attribute AND &H2) = False THEN
          IF (Attribute AND &H4) = False THEN
             IF (Attribute AND &H20) = False THEN
                EXIT SUB
             END IF
          END IF
       END IF
    END IF
 END IF

 ' check file size
 IF Search.File.Size THEN
    IF Search.Size.From = FalseD AND Search.Size.To = FalseD THEN
       IF File.Size <> FalseD THEN
          EXIT SUB
       END IF
    ELSE
       IF Search.Size.From > FalseD OR Search.Size.To > FalseD THEN
          IF Search.Size.From > FalseD THEN
             IF Search.Size.To = FalseD THEN
                IF File.Size < Search.Size.From THEN
                   EXIT SUB
                END IF
             END IF
          END IF
          IF Search.Size.From = FalseD THEN
             IF Search.Size.To > FalseD THEN
                IF File.Size > Search.Size.To THEN
                   EXIT SUB
                END IF
             END IF
          END IF
          IF Search.Size.From <= Search.Size.To THEN
             IF File.Size < Search.Size.From OR File.Size > Search.Size.To THEN
                EXIT SUB
             END IF
          END IF
          IF Search.Size.From > Search.Size.To THEN
             IF File.Size < Search.Size.From AND File.Size > Search.Size.To THEN
                EXIT SUB
             END IF
          END IF
       END IF
    END IF
 END IF

 ' store file date and time
 IF Windows.Detected THEN
    IF Creation.Time THEN
       File.Work.Time = ASC(MID$(TempWDTA.CreateTime, 2, 1))
       File.Work.Time = File.Work.Time * &H100 + ASC(MID$(TempWDTA.CreateTime, 1, 1))
       File.Work.Date = ASC(MID$(TempWDTA.CreateTime, 4, 1))
       File.Work.Date = File.Work.Date * &H100 + ASC(MID$(TempWDTA.CreateTime, 3, 1))
    ELSE
       IF Access.Time THEN
          File.Work.Time = ASC(MID$(TempWDTA.AccessTime, 2, 1))
          File.Work.Time = File.Work.Time * &H100 + ASC(MID$(TempWDTA.AccessTime, 1, 1))
          File.Work.Date = ASC(MID$(TempWDTA.AccessTime, 4, 1))
          File.Work.Date = File.Work.Date * &H100 + ASC(MID$(TempWDTA.AccessTime, 3, 1))
       ELSE
          IF Modified.Time THEN
             File.Work.Time = ASC(MID$(TempWDTA.ModTime, 2, 1))
             File.Work.Time = File.Work.Time * &H100 + ASC(MID$(TempWDTA.ModTime, 1, 1))
             File.Work.Date = ASC(MID$(TempWDTA.ModTime, 4, 1))
             File.Work.Date = File.Work.Date * &H100 + ASC(MID$(TempWDTA.ModTime, 3, 1))
          END IF
       END IF
    END IF
 ELSE
    File.Work.Time = ASC(MID$(TempDTA.FileTime, 2, 1))
    File.Work.Time = File.Work.Time * &H100 + ASC(MID$(TempDTA.FileTime, 1, 1))
    File.Work.Date = ASC(MID$(TempDTA.FileDate, 2, 1))
    File.Work.Date = File.Work.Date * &H100 + ASC(MID$(TempDTA.FileDate, 1, 1))
 END IF

 ' check date\time range
 IF Search.From.Date OR Search.To.Date THEN
    IF File.Work.Date < Search.From.Date THEN
       EXIT SUB
    END IF
    IF File.Work.Date > Search.To.Date THEN
       EXIT SUB
    END IF
 END IF
 IF Search.From.Time OR Search.To.Time THEN
    IF File.Work.Time < Search.From.Time THEN
       EXIT SUB
    END IF
    IF File.Work.Time > Search.To.Time THEN
       EXIT SUB
    END IF
 END IF

 ' make directory filename
 IF Display.Filenames THEN
    IF Display.Dots THEN
       Filename$ = Directory.Search$ + Filename.Search$
       IF Prepend.Drive THEN
          Filename$ = Drive.Search + ":" + Filename$
       END IF
       COLOR Yellow, Black
       PRINT Filename$
    END IF
 END IF

 ' update bytes counted
 Bytes.Counted = Bytes.Counted + File.Size

 ' update files counter
 Files.Counted = Files.Counted + 1#

 ' check count flag
 IF Count.Lines THEN
    CALL CountFileLines (Directory.Search$, Filename.Search$)
 END IF
END SUB

' subroutine to count lines in a filename
SUB CountFileLines (Directory.Search$, Filename.Search$)
 ' declare subroutine variables
 DIM Handle AS INTEGER
 DIM Number.Bytes AS INTEGER

 ' make filename
 ASCIIZ.Copy = Directory.Search$ + Filename.Search$ + CHR$(0)

 ' check windows dos
 IF Windows.Detected THEN
    ' open file for input
    InregsX.AX = &H716C
    InregsX.BX = &H0044
    InregsX.CX = &H27
    InregsX.DX = &H01
    InregsX.DS = VARSEG(ASCIIZ.Copy)
    InregsX.SI = VARPTR(ASCIIZ.Copy)
    InregsX.DI = &H1
    CALL InterruptX(&H21, InregsX, OutregsX)
 ELSE
    ' open file for input
    InregsX.AX = &H6C00
    InregsX.BX = &H0044
    InregsX.CX = &H27
    InregsX.DX = &H01
    InregsX.DS = VARSEG(ASCIIZ.Copy)
    InregsX.SI = VARPTR(ASCIIZ.Copy)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF

 ' store file handle
 Handle = OutregsX.AX

 ' check open file error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    EXIT SUB
 END IF

 ' test read from file
 InregsX.AX = &H3F00
 InregsX.BX = Handle
 InregsX.CX = &H0001
 InregsX.DS = VARSEG(Buffer)
 InregsX.DX = VARPTR(Buffer)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check open file error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    EXIT SUB
 END IF

 ' reset pointer to start of file
 InregsX.AX = &H4200
 InregsX.BX = Handle
 InregsX.CX = &H0
 InregsX.DX = &H0
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' file input loop
 DO

    ' read from file
    InregsX.AX = &H3F00
    InregsX.BX = Handle
    InregsX.CX = &H1000
    InregsX.DS = VARSEG(Buffer)
    InregsX.DX = VARPTR(Buffer)
    CALL InterruptX(&H21, InregsX, OutregsX)

    ' check error flag
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF

    ' check number of bytes to count
    Number.Bytes = OutregsX.AX
    IF Number.Bytes <= False THEN
       EXIT DO
    END IF

    ' count ascii 10
    FOR Count.Ascii = 1 TO Number.Bytes
       IF ASC(MID$(Buffer, Count.Ascii, 1)) = 10 THEN
          Lines.Counted = Lines.Counted + 1#
       END IF
    NEXT

    ' check break flag
    IF BreakIS THEN
       EXIT DO
    END IF
 LOOP

 ' close input file
 InregsX.AX = &H3E00
 InregsX.BX = Handle
 CALL InterruptX(&H21, InregsX, OutregsX)
END SUB

' critical error trap
Error.Routine:
 ' clear dots
 FOR Count = 1 TO Dot.Count
    PRINT CHR$(29);" ";CHR$(29);
 NEXT
 Dot.Count = False
 Count.Forward = False
 Data.Error = ERR
 IF Display.Errors THEN
    Error.Level = True
    OutregsX.Flags = &H1
    RESUME NEXT
 END IF
 SELECT CASE Data.Error
 CASE 53
    Temp.Outpt$ = "File not found."
 CASE 57
    Temp.Outpt$ = "Media error."
 CASE 61
    Temp.Outpt$ = "Disk full."
 CASE 70
    Temp.Outpt$ = "Permission denied."
 CASE 71
    Temp.Outpt$ = "Disk not ready."
 CASE ELSE
    Temp.Outpt$ = "Untrapped error" + STR$(Data.Error) + "."
 END SELECT
 COLOR Green, Black
 PRINT Temp.Outpt$
 Prompt$ = "Press R to retry, Q to quit, C to continue:"
 CALL MorePrompt(Prompt$, "rqc", Outpt$)
 IF BreakIS THEN
    Outpt$ = "q"
 END IF
 SELECT CASE Outpt$
 CASE "r"
    RESUME
 CASE "q"
    Error.Level = True
    RESUME End.Xcount
 CASE "c"
    OutregsX.Flags = &H1
    RESUME NEXT
 END SELECT
 COLOR Plain, Black
 ' restore key trapping
 CALL RestInt
 END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$ + " ";
 Input.Char$ = NUL
 DO
    LOCATE , , 1
    DO
       IF BreakIS THEN
          EXIT DO
       END IF
       IF KeyIS THEN
          IF OutregsX.AX <> 0 THEN
             InregsX.AX = &H0000
             CALL InterruptX(&H16, InregsX, OutregsX)
             Input.Char$=CHR$(OutregsX.AX AND &HFF)
             EXIT DO
          END IF
       END IF
    LOOP
    IF BreakIS THEN
       EXIT DO
    END IF
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' clears Control-Break flag
FUNCTION ClearBreak
 DEF SEG = &H40
 POKE &H71, &H0
 DEF SEG
 ClearBreak = True
END FUNCTION

' checks Control-Break
FUNCTION BreakIS
 STATIC Var AS INTEGER
 IF KeyIS THEN
    IF OutregsX.AX = 0 THEN
       Var = True
    END IF
 END IF
 IF Var THEN
    Continuous.Display = True
 END IF
 BreakIS = Var
END FUNCTION

' checks keyboard buffer
FUNCTION KeyIS
 InregsX.AX = &H0100
 CALL InterruptX(&H16, InregsX, OutregsX)
 IF (OutregsX.Flags AND &H40) = &H40 THEN
    KeyIS = False
 ELSE
    KeyIS = True
 END IF
END FUNCTION

' displays carry flag error
SUB DisplayError (Temp$)
 ' check carry flag error
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    ' check display errors flag
    IF Display.Errors = False THEN
       ' display error
       COLOR Red, Black
       PRINT Temp$
    END IF
 END IF
END SUB
