// filetree.hpp Declarations for FILETREE class
// last updated by Roedy Green 1996 Nov 5

/* T Y P E D E F S */

typedef unsigned int ATTRIB;

typedef char ATTRIBPATTERN [7];

class FILETREE
    {
    /* class to process a set of files matching a wildcard */
    /* used by CDTEST, TMAN250 */
 public:

    FILETREE() {};

    ~FILETREE() {};

    void ForEachFile(char * WildCard, ATTRIBPATTERN AttribPattern, BOOL Recurse );
    /* calls ProcessOneFile for each match
     *			    ADVSHR
     * e.g. C:\XXX\*.TXT,  "?00+1-", TRUE if /S style apply recursively to subdirs */

    /* attribute pattern string is of form:
     * ADVSHR A-archive D-directory V-volume S-system H-hidden R-read-only
	  * "ADVSHR"
     * "?00+1-" <-- example
     * ?=ignore, irrelevant.
     * 1=must be 1
	  * 0=must be 0
     * +=must have some 1s, all plus slots many not be 0
     * -=must have some 0s, all minus slots may not be 1 */

    virtual BOOL ProcessOneFile ( char * QualFileName, long FileSize ) = 0;
    /* returns true to abort entire process.
       Code to process one file, custom-written for each use. */

 protected:

    BOOL Stop; /* true if we want to stop ForEachFile early */

    BOOL    FineAttribFilter[64];
    /* whether to accept each of 64 possible
     * attributes.  Built by invoking the
	  * ProbeAttribFilter function with each of the
     * 64 possible attributes. */

    ATTRIB  CoarseAttribFilter;
    /* Attribute mask to grossly filter out files never wanted. DOS behaves a
     * little strangely when fed a coarse filter.  It completely ignores the
     * read-only and archive bits. If you ask for DIRs, you get normal files
     * too. But, if you ask for Vol, you DON'T get anything but VOL. It is
     * all bizarrely asymmetric. We ignore this, and carry on as if DOS were
     * consistent.  It comes out ok in the wash, since the FineAttribFilter
     * filters the mess DOS gives us. */

 protected:

    void ProcessSubs( char * WildCard );
    /* recursively process all files in all subdirs matching the
	  * given wildcard pattern.
     * WildCard will be of form C:\xxx\*.TXT */

    void ProcessFiles ( char * WildCard );
    /* process all files matching given WildCard.  No recursion.
     * WildCard will be of form C:\xxx\*.TXT */

    char * Join ( char * Result, char * WildCard, char * SubDir, char * FileName );
    /* append Subdir and FileName onto WildCard,
     * e.g. C:\xxx\*.* , yyy , a.b -> C:\xxx\yyy\a.b
     * Subdir or FileName might be null */

    void InitAttribFilters (ATTRIBPATTERN AttribPattern);
    /* calculate FineAttribFilter and CoarseAttribFilter  */

    BOOL ProbeAttribFilter(ATTRIB Attrib, ATTRIBPATTERN AttribPattern);
    /* returns true if given attribute
       bit pattern is acceptable according to AttribPattern */
};
// -30-
