// CRC.cpp definitions for class CRC
/* T Y P E D E F S */

typedef unsigned short WORD;

typedef unsigned char BYTE;

typedef enum BOOL
{
  FALSE, TRUE
} BOOL;

/* I N C L U D E S */

#include "CRC.hpp"

/* S T A T I C	 D E F I N I T I O N S */

/* must define, as opposed to declare, static variables in class
   in order to allocate static RAM for them. */

WORD CRC::CRCTable[256];
int dummy = CRC::InitCRCTable();

/* ***************************************** */

int CRC::InitCRCTable (WORD Poly)
{
    WORD       i;
    WORD     crc;

    /* usually we would use Poly = 0x8408, the 16-bit CCITT polynomial */

    for (i = 0; i < 256; i++)
	{
	crc = (WORD) i;
	/* ^ is bitwise XOR */
	crc = (crc >> 1) ^ ((crc & 1) ? Poly : 0);
	crc = (crc >> 1) ^ ((crc & 1) ? Poly : 0);
	crc = (crc >> 1) ^ ((crc & 1) ? Poly : 0);
	crc = (crc >> 1) ^ ((crc & 1) ? Poly : 0);
	crc = (crc >> 1) ^ ((crc & 1) ? Poly : 0);
	crc = (crc >> 1) ^ ((crc & 1) ? Poly : 0);
	crc = (crc >> 1) ^ ((crc & 1) ? Poly : 0);
	crc = (crc >> 1) ^ ((crc & 1) ? Poly : 0);

	CRCTable[i] = crc;

	}
    return 0; /* dummy */

} /* end InitCRCTable */

/* ***************************************** */

void CRC::Append ( BYTE* String, WORD Length )
{
    /* cumulatively compute the CRC of this string. */
    /* string may contain nulls */

    /* character of the string, start with len byte */

    while (Length--)
	work = (work >> 8) ^ CRCTable[(work & 0xff) ^ *String++];
    /* ^ is bitwise XOR */

}  /* end Append */

// -30-

