Procedure Seek(Var Drive,Cylinder:Integer);
{
    This procedure locates the heads on specified drive to specified cylinder

    Input        Drive    Integer specifying drive to test

                 Cylinder Integer specifying track for heads

    Output       None

    Strategy     (1)      Execute BIOS call to position heads as requested
                          Fatal error if BIOS complains

}
Type
    Result=Record
                 Ax,Bx,Cx,Dx,Bp,Si,Di,Ds,Es,Flags:Integer;
    End;
Var
   Sys:Result;
Begin
     SYS.AX:=$0C*$0100+$01 { AH=0Ch means seek, AL=Sector };
     SYS.CX:=Lo(Cylinder)*$0100+Hi(Cylinder)*$40+$01;
     SYS.DX:=$80+Drive     { DH=head number, DL=$80+drive };
     Intr($13,Sys);

     If Odd(Sys.Flags) then
        Begin
             Writeln('Seek Error on Cylinder ',Cylinder,', Drive ',Drive);
             Halt;
        End;
End;

