Procedure Recalibrate(Var Drive,CylMax:Integer);
{
    This procedure recalibrates the specified hard disk drive

    Input        Integer specifying drive to reset

                 CylMax is ignored

    Output       None

    Strategy     (1)     Request bios to reset specified drive

                 (2)     Print message to pacify user

                 (3)     Request bios to recalibrate the drive
}
Type
    Result=Record
                 Ax,Bx,Cx,Dx,Bp,Si,Di,Ds,Es,Flags:Integer;
    End;
Var
    Sys:Result;
Begin
    SYS.AX:=$0D*$0100+$01       { AH=0Dh means reset the hard disk };
    SYS.CX:=$00*$0100+$01       { CH=Cylinder, CL=Sector };
    SYS.DX:=$00*$0100+$80+Drive { DH=Head, DL=$80+Drive };
    Intr($13,Sys);

    If Odd(Sys.Flags) then
       Begin
            Writeln;
            Writeln;
            NormVideo;
            Writeln('Error from drive ',Drive,' reset');
            Halt;
       End;

    Write('Recalibrating...');

    SYS.AX:=$11*$0100+$01       { AH=11h means recalibrate, AL=Sector };
    SYS.CX:=$00*$0100+$01       { CH=Cylinder, CL=Sector };
    SYS.DX:=$00*$0100+$80+Drive { DH=Head, DL=$80+Drive };
    Intr($13,Sys);

    Writeln;
    Writeln;

    If Odd(Sys.Flags) Then
       Begin;
            NormVideo;
            Writeln('Error recalibrating drive ',Drive);
            Halt;
       End;

End;