
;Ŀ
;                                                                   
;                                         
;                                       
;  ߱                                    
;              ܱ                                
;              ۱۱                                
;    ߱              
;           ߱     ߱ 
;                         ߱  
;                                  
;                           ߱        
;                            ߱ 
;                ߱ 
;                          
;                                                                   
;        2M 3.0  -  (C) 1993-1995  Ciriaco Garca de Celis.         
;                                                                   
;      SOPORTE PARA DISQUETES CON MAYOR CAPACIDAD DE LA NORMAL      
;                    CREADOS POR LA UTILIDAD 2MF                    
;                                                                   
; - Para PC, XT o AT con controladora y unidades de alta.           
; - Programacin directa del controlador de disquetes y del DMA.    
; - Soporte para sectores de ms de 512 bytes (economizar GAPs).    
; - Mezcla de sectores de distinto tamao en la misma pista.        
; - Ruptura del lmite habitual de 80 pistas (incluido 360K).       
; - Emulacin de sectores de 512 bytes en INT 13h.                  
; - Funcin 5 (INT 13h) reforzada para formatear los nuevos discos. 
; - El soporte residente opera eficazmente bajo DOS y WINDOWS 3.X   
;                                                                   
;      Para la versin AT:        Para la versin PC/XT:            
;        TASM  2m /m5               TASM  2m, 2mx /m5 /dXT          
;        TLINK 2m /t                TLINK 2mx /t                    
;                                                                   
;

              IFDEF XT
               XTX EQU ,"X",
              ELSE
               .286                    ; versin para AT o superior
               XTX EQU ,
              ENDIF

ON             EQU   1                 ; constantes booleanas
OFF            EQU   0

; ------------ Macros de propsito general.

XPUSH          MACRO regmem            ; apilar lista de registros
                 IRP rm, <regmem>
                   PUSH rm
                 ENDM
               ENDM

XPOP           MACRO regmem            ; desapilar lista de registros
                 IRP rm, <regmem>
                   POP rm
                 ENDM
               ENDM

              IFNDEF XT

XPUSHA         MACRO
                 PUSHA
               ENDM

XPOPA          MACRO
                 POPA
               ENDM

XSHL           MACRO regmem, cuenta
                 SHL regmem,cuenta
               ENDM

DELAY          MACRO                   ; estados de espera
                 JMP SHORT $+2         ; para AT obsoleto
                 JMP SHORT $+2
               ENDM

DDS            MACRO
               PUSH  40h
               POP   DS
               ENDM

DES            MACRO
               PUSH  40h
               POP   ES
               ENDM

PMICRO         MACRO                   ; retardo de aprox. 15,09 s
               LOCAL pmicro_iter       ; (exactamente 18/1193180 sg.)
pmicro_iter:   DELAY
               IN    AL,61h            ; Esta macro puede ejecutarse
               AND   AL,10h            ; repetitivamente (se apoya en
               CMP   AL,AH             ; AX) para hacer retardos a
               JE    pmicro_iter       ; travs de la temporizacin
               MOV   AH,AL             ; del refresco de la memoria
               ENDM                    ; dinmica de los AT.

              ELSE

XPUSHA         MACRO
                 XPUSH <AX, BX, CX, DX, SI, DI>
               ENDM

XPOPA          MACRO
                 XPOP  <DI, SI, DX, CX, BX, AX>
               ENDM

XSHL           MACRO regmem, cuenta
                 REPT cuenta
                   SHL regmem,1
                 ENDM
               ENDM

DELAY          MACRO                   ; sin estados de espera
               ENDM

DDS            MACRO
               PUSH  AX
               MOV   AX,40h
               MOV   DS,AX
               POP   AX
               ENDM

DES            MACRO
               PUSH  AX
               MOV   AX,40h
               MOV   ES,AX
               POP   AX
               ENDM

              ENDIF

; ------------ Programa.

_PRINCIPAL     SEGMENT
               ASSUME CS:_PRINCIPAL, DS:_PRINCIPAL

               ORG   100h

ini_residente  EQU   $

; ****************************************
; *                                      *
; *   D A T O S    R E S I D E N T E S   *
; *                                      *
; ****************************************

inicio:        JMP   main

; ------------ Identificacin estandarizada del programa.

program_id     LABEL BYTE
segmento_real  DW    0   ; segmento real donde ser cargado
offset_real    DW    0   ; offset real     "     "     "
longitud_total DW    0   ; zona de memoria ocupada (prrafos)
info_extra     DB    80h ; bits 0, 1 y 2-> 000: normal, con PSP
                         ;                 001: bloque UMB XMS
                         ;                 010: *.SYS
                         ;                 011: *.SYS formato EXE
                         ; bit 7 a 1: extension_id definida
multiplex_id   DB    0   ; nmero Multiplex de este TSR
vectores_id    DW    tabla_vectores
extension_id   DW    tabla_extra
               DB    "*##*"
autor_nom_ver  DB    "CiriSOFT:2M" XTX ":3.0",0
               DB    2  ; nmero de vectores de interrupcin usados
tabla_vectores EQU   $
vieja_i13      DB    13h           ; INT 13h
ant_int13      LABEL DWORD         ; direccin original
ant_int13_off  DW    0
ant_int13_seg  DW    0
               DB    2Fh           ; INT 2Fh
ant_int2F      LABEL DWORD         ; direccin original
ant_int2F_off  DW    0
ant_int2F_seg  DW    0

tabla_extra    LABEL BYTE
               DW    ctrl_exterior ; permitido control exterior
               DW    0             ; campo reservado

ctrl_exterior  LABEL BYTE
reubicabilidad DB    1             ; programa 100% reubicable
activacion     DW    act
act            DB    1

; ***********************************************
; *                                             *
; *   C O D I G O   Y   D A T O S   D E   2 M   *
; *                                             *
; ***********************************************

               INCLUDE 2MKERNEL.INC

fin_residente  EQU   $  ; fin del rea residente sin contar el buffer

bytes_resid    EQU   fin_residente-ini_residente


; *****************************
; *                           *
; *   I N S T A L A C I O N   *
; *                           *
; *****************************

main           PROC
               LEA   BP,parametros
               MOV   BX,81h
               CALL  obtener_param     ; analizar posibles parmetros
               JNC   params_ok         ; son correctos
               OR    error,ERRSINTAX
               JMP   informar
params_ok:     CMP   param_l,ON
               JNE   ins_mem
               JMP   informar
ins_mem:       CALL  inic_general      ; inicializar ciertas variables
               CALL  pc_ok?
               TEST  error,MALPC or MALDOS or MALBIOS or MALDRV
               JZ    proc_tsr
               JMP   informar          ; no hay configuracin correcta
proc_tsr:      CMP   param_u,ON        ; se solicita desinstalarlo?
               JNE   cont_ins          ; no
               CALL  residente?        ; s: est residente?
               JNC   desinstalable
               OR    error,NOINSTALADO ; programa an no instalado
               JMP   informar
desinstalable: CALL  testWin
               JNC   win_out_ok
               OR    error,WIN_UNLOAD
               JMP   informar          ; no desinstalar desde Windows
win_out_ok:    OR    accion,DESINSTALADO
               MOV   ES,tsr_seg
               MOV   DI,tsr_off
               TEST  BYTE PTR ES:[DI-10],2
               JZ    no_sys
               OR    error,INSTALADOSYS  ; no desinstalar versin SYS
               JMP   informar
no_sys:        CALL  hay2mdos?
               JC    no_2mdos
               OR    error,HAY2MDOSDES ; desinstalar antes 2MDOS
               JMP   informar
no_2mdos:      MOV   AH,ES:[DI-9]
               CALL  mx_unload         ; desinstalarlo:
               JC    err_ins           ; no ha sido posible
              IFNDEF XT
               MOV   AX,sbootseg
               AND   AX,AX
               JZ    sboot_d_ok        ; no hay copia SuperBOOT
               MOV   ES,AX
               MOV   BX,ES:[0]
               MOV   ES:[BX].cambio,ON           ; simular cambio A:
               MOV   BX,ES:[2]
               MOV   ES:[BX].cambio,ON           ; simular cambio B:
              ENDIF
sboot_d_ok:    JMP   informar
err_ins:       OR    error,IMPDESINS   ; no es posible
               JMP   informar
cont_ins:      CALL  residente?
               JNC   ya_reside
               CMP   AX,0              ; reside una versin distinta?
               JE    instalable
               OR    error,NOINSTALABLE  ; versin incompatible
               JMP   informar
ya_reside:     OR    accion,YAINSTALADO
              IFDEF  XT
               CALL  adaptar_param     ; parmetros en copia residente
              ENDIF
               JMP   informar
instalable:    CALL  hay2mdos?
               JC    tw
               OR    error,HAY2MDOSINS ; instalar antes que 2MDOS
               JMP   informar
tw:            CALL  testWin
               JNC   win_in_ok
               OR    error,WIN_LOAD
               JMP   informar          ; no instalar desde Windows
win_in_ok:     OR    accion,INSTALADO
               CALL  instalar_tsr      ; instalar el TSR
               JC    informar
              IFNDEF XT
               MOV   AX,sbootseg
               AND   AX,AX
               JZ    sboot_i_ok        ; no hay copia SuperBOOT
               MOV   ES,AX
               MOV   BX,ES:[0]
               MOV   ES:[BX].control2m_flag,OFF  ; anularla control A:
               MOV   BX,ES:[2]
               MOV   ES:[BX].control2m_flag,OFF  ; anularla control B:
              ENDIF
sboot_i_ok:    MOV   ES,tsr_seg
informar:      CALL  info
               MOV   DX,mem640         ; tamao zona residente
               AND   DX,DX
               JZ    fin_noresid
               MOV   AX,3100h
               INT   21h               ; terminar residente
fin_noresid:   MOV   AX,4C00h
               INT   21h               ; terminar no residente
main           ENDP

instalar_tsr   PROC
               CALL  mx_get_handle     ; obtener entrada Multiplex
               JNC   handle_ok
               OR    error,MX64FULL    ; no quedan entradas
               STC
               RET
handle_ok:     MOV   multiplex_id,AH   ; entrada multiplex para 2M
               CALL  preservar_ints    ; tomar nota de vectores
               CMP   param_ml,ON       ; se indic parmetro /ML?
               JE    instalar_ml       ; en efecto
               MOV   AX,parrafos_resid ; rea residente sin PSP
               MOV   mem640,AX         ; copia de seguridad :)
               CALL  UMB_alloc         ; pedir memoria superior XMS
               JC    busca_upper       ; no hay la suficiente
               LEA   BX,buffer_io-256  ; AX:BX direccin del buffer
               CALL  testDMA
               PUSH  AX
               MOV   DX,AX
               MOV   AH,12h
               CALL  gestor_XMS        ; redimensionar bloque memoria
               CMP   AX,1
               JE    xms_redim_ok
               MOV   AX,mem640
               MOV   parrafos_resid,AX ; funcin no soportada
xms_redim_ok:  POP   AX
               CLC                     ; indicar que usa memoria XMS
               JMP   instalar_umb
busca_upper:   MOV   AX,parrafos_resid
               CALL  UPPER_alloc       ; pedir memoria superior DOS 5
               JC    instalar_ml       ; no hay la suficiente
               LEA   BX,buffer_io-256  ; AX:BX direccin del buffer
               CALL  testDMA
               XPUSH <AX, ES>
               MOV   ES,AX
               MOV   AH,4Ah
               INT   21h               ; redimensionar bloque memoria
               CALL  upper_fork        ; dejar residente el bloque
               XPOP  <ES, AX>
               STC                     ; indicar que usa memoria DOS
instalar_umb:  MOV   ES,AX             ; segmento del bloque UMB
               MOV   DI,0              ; ES:0 zona a donde reubicar
               MOV   mem640,DI         ; no terminar residente
               JMP   instalar_asi
instalar_ml:   ADD   parrafos_resid,6  ; respetar 96 bytes de PSP
               MOV   AX,CS
               LEA   BX,buffer_io-(256-96)
               CALL  testDMA
               MOV   mem640,BX         ; ocupar memoria convencional
               STC
               MOV   DI,96             ; instalacin mem. convencional
               CALL  free_environ      ; liberar espacio de entorno
               STC                     ; no se usa XMS
instalar_asi:  CALL  inicializa_id     ; inicializar identificacin
               MOV   CX,(bytes_resid+15)/16  ; sin contar el buffer
               CALL  reubicar_prog     ; reubicar programa a ES:DI
               CALL  activar_ints      ; interceptar vectores
               CLC
               RET
instalar_tsr   ENDP

;*********************************************************
;*                                                       *
;*  SUBRUTINAS DE PROPOSITO GENERAL PARA LA INSTALACION  *
;*                                                       *
;*********************************************************

               INCLUDE 2MUTIL.INC

; ------------ Ya est instalada otra versin distinta del programa.

error_version  PROC
               PUSH  ES
               LEA   DX,mal_ver_txt1
               CALL  print
               LES   DI,tsr_dir
               MOV   AL,':'
               MOV   CL,255
               CLD
               REPNE SCASB
               REPNE SCASB
               MOV   DL,ES:[DI]        ; nmero de versin
               MOV   AH,2
               INT   21h
               MOV   DL,'.'
               MOV   AH,2
               INT   21h
               MOV   DL,ES:[DI+2]      ; revisin
               MOV   AH,2
               INT   21h
               LEA   DX,mal_ver_txt2
               CALL  print
               POP   ES
               RET
error_version  ENDP

; ------------ Inicializar ciertas variables. La memoria consumida
;              se calcula para el peor de los casos, cuando el buffer
;              residente ocupa incluso el doble debido al DMA.

inic_general   PROC
               CALL  inic_XMS          ; detectar controlador XMS
               MOV   AX,(bytes_resid+tbuffer*2+15)/16
               MOV   parrafos_resid,AX ; memoria mxima necesaria
              IFDEF  XT
               CALL  testAT
               JNC   skip_tmtest       ; en AT no calcularlo [*]
               CALL  cte_tiempos
               MOV   tbase,AX          ; cte. retardo para 1/18,2 seg.
skip_tmtest:  ENDIF
               MOV   DL,0
               CALL  tipo_disco
               JNC   hay_unidad
               MOV   DL,1
               CALL  tipo_disco
               JNC   hay_unidad
               OR    error,MALBIOS     ; no hay disqueteras
               RET
hay_unidad:    MOV   DL,0
               CALL  tipo_disco
               MOV   info_A.tipo_drv,BL  ; guardar tipo unidad A:
               MOV   DL,1
               CALL  tipo_disco
               MOV   info_B.tipo_drv,BL  ; guardar tipo unidad B:
               RET
inic_general   ENDP

; ------------ Inicializar rea program_id del programa residente.
;              A la entrada, ES:DI = seg:off a donde ser reubicado
;              y CF=0 si se utiliza memoria superior XMS.

inicializa_id  PROC
               PUSHF
               MOV   segmento_real,ES  ; anotar segmento del bloque
               MOV   offset_real,DI    ; dem con el offset
               MOV   AX,parrafos_resid
               MOV   longitud_total,AX
               MOV   AL,1
               POPF                    ; CF=0: usar memoria UMB XMS
               JNC   info_ok
               DEC   AL                ; usar memoria convencional
info_ok:       OR    info_extra,AL
               RET
inicializa_id  ENDP

; ------------ Devolver CF=0 si 2MDOS est instalado.

hay2mdos?      PROC
               XPUSH <ES, DI>
               LEA   SI,id_2mdos       ; identificacin del programa
               MOV   CX,id_2mdos_tam
               MOV   AX,1492h
               MOV   ES,AX
               MOV   DI,1992h          ; ES:DI protocolo de bsqueda
               CALL  mx_find_tsr       ; buscar si est en memoria
               XPOP  <DI, ES>
               RET
hay2mdos?      ENDP

; ------------ Adaptar parmetros de un 2MX ya instalado.
;              Slo se actualiza la constante de retardo, por si el
;              turbo de la mquina fue conmutado.

              IFDEF  XT

adaptar_param  PROC
               PUSH  ES
               MOV   ES,tsr_seg
               MOV   AX,tbase
               MOV   ES:tbase,AX
               POP   ES
               RET
adaptar_param  ENDP

              ENDIF

; ------------ Informar al usuario.

info           PROC
               CMP   param_ayuda,ON    ; solicitud de ayuda?
               JNE   info_p?
               LEA   DX,ayuda_txt
               CALL  print
               JMP   fin_info
info_p?:       CMP   param_l,ON
               JNE   info_normal
               LEA   DX,infop_txt
               CALL  print
               JMP   fin_info
info_normal:   LEA   DX,programa_txt
               CALL  print
               TEST  error,0FFFFh
               JZ    info_ins          ; no hay error
               JMP   info_err          ; lo hay: informar del mismo
info_ins:      LEA   DX,instalado_txt
               TEST  accion,INSTALADO  ; informar "instalado"?
               JNZ   acc_ok
               LEA   DX,ya_instal_txt
               TEST  accion,YAINSTALADO  ; informar "ya instalado"?
               JNZ   acc_ok
               LEA   DX,des_ok_txt     ; informar "desinstalado"
               CALL  print
               JMP   fin_info
acc_ok:        CALL  print             ; instalado/ya instalado...
               CALL  info_drvs
               LEA   DX,dma_cross_txt
               TEST  accion,BUFFERPLUS ; el DMA cruzaba frontera?
               JZ    dma_ok
               CALL  print
dma_ok:        JMP   fin_info
info_err:      LEA   DX,mal_pc_txt
               TEST  error,MALPC       ; no es ordenador adecuado?
               JZ    otroerr1
               CALL  print
otroerr1:      LEA   DX,mal_dos_txt
               TEST  error,MALDOS      ; DOS incorrecto?
               JZ    otroerr21
               CALL  print
otroerr21:     LEA   DX,mal_bios_txt
               TEST  error,MALBIOS     ; BIOS obsoleta?
               JZ    otroerr22
               CALL  print
otroerr22:     LEA   DX,mal_drv_txt
               TEST  error,MALDRV      ; Unidades de doble?
               JZ    otroerr23
               CALL  print
otroerr23:     LEA   DX,err_sintax_txt
               TEST  error,ERRSINTAX   ; error de sintaxis?
               JZ    otroerr3
               CALL  print
otroerr3:      LEA   DX,imp_desins_txt
               TEST  error,NOINSTALADO ; no instalado, piden
               JZ    otroerr4          ; desinstalar?
               CALL  print
otroerr4:      LEA   DX,des_no_ok_txt
               TEST  error,IMPDESINS   ; imposible desinstalar?
               JZ    otroerr5
               CALL  print
otroerr5:      LEA   DX,inst_sys_txt
               TEST  error,INSTALADOSYS  ; instalada versin *.SYS?
               JZ    otroerr5x
               CALL  print
otroerr5x:     LEA   DX,inst_2mdos_txt
               TEST  error,HAY2MDOSINS   ; instalar antes que 2MDOS?
               JZ    otroerr5y
               CALL  print
otroerr5y:     LEA   DX,dins_2mdos_txt
               TEST  error,HAY2MDOSDES   ; desinstalar antes 2MDOS?
               JZ    otroerr5z
               CALL  print
otroerr5z:     TEST  error,NOINSTALABLE  ; versin incorrecta?
               JZ    otroerr6
               CALL  error_version
otroerr6:      LEA   DX,nocabe_txt
               TEST  error,MX64FULL    ; imposible instalar?
               JZ    otroerr8
               CALL  print
otroerr8:      LEA   DX,win_ld_txt
               TEST  error,WIN_LOAD    ; instalar desde Windows?
               JZ    otroerr9
               CALL  print
otroerr9:      LEA   DX,win_ul_txt
               TEST  error,WIN_UNLOAD  ; desinstalar desde Windows?
               JZ    fin_info
               CALL  print
fin_info:      RET
info           ENDP

               ; --- Informar de las unidades controladas por 2M.

info_drvs      PROC
               MOV   DL,0
               CALL  tipo_disco
               CALL  pr_tipo
               MOV   DL,1
               CALL  tipo_disco
               CALL  pr_tipo
               LEA   DX,crlf_txt
               CALL  print
               RET
info_drvs      ENDP

               ; --- Imprimir unidad y su tipo.

pr_tipo        PROC
               CMP   BL,2
               JE    tp_ok
               CMP   BL,4
               JE    tp_ok
               CMP   BL,5
               MOV   BL,5
               JAE   tp_ok
               RET
tp_ok:         PUSH  BX
               ADD   DL,'A'
               MOV   AH,2
               INT   21h
               POP   BX
               SUB   BL,2
               MOV   BH,0
               SHL   BX,1
               ADD   BX,OFFSET tabla_ndrvs
               MOV   DX,[BX]
               CALL  print
               RET
pr_tipo        ENDP

; ------------ Comprobar que la configuracin es la adecuada. Para
;              saber si la INT 13h de este ordenador acaba llamando a
;              la INT 40h, se desva la INT 40h y se provoca un inocuo
;              reset de disquetes va INT 13h para comprobar si pasa
;              por la INT 40h. Si est cargado el cdigo SuperBOOT, se
;              utiliza no obstante siempre la INT 13h (para anularlo
;              por completo).

pc_ok?         PROC
              IFNDEF XT
               CALL  SuperBOOT?
               JNE   no_superboot
               MOV   sbootseg,AX       ; segmento SuperBOOT
               JMP   test_dos          ; es SuperBOOT: usar INT 13h
              ENDIF
no_superboot:  CALL  test_i40
               TEST  accion,I40
               JZ    test_dos          ; no soportada la INT 40h
               MOV   nueva_i13,40h
               MOV   vieja_i13,40h     ; usar INT 40 en vez de INT 13
test_dos:      MOV   AH,30h
               INT   21h
               XCHG  AH,AL
               CMP   AX,31Eh           ; DOS 3.30 o superior?
               MOV   AX,MALDOS
               JB    pc_nok
               CALL  testAT
               MOV   AX,MALPC
              IFNDEF XT
               JC    pc_nok
              ELSE
               JNC   pc_nok            ; [*]
              ENDIF
               TEST  error,MALBIOS
               JNZ   pc_ok             ; con ese error vale
               MOV   AX,MALDRV
               CMP   info_A.tipo_drv,2 ; unidad A: de 1.2?
               JE    pc_ok
               CMP   info_A.tipo_drv,4 ; unidad A: de 1.44  2.88?
               JAE   pc_ok
               CMP   info_B.tipo_drv,2 ; unidad B: de 1.2?
               JE    pc_ok
               CMP   info_B.tipo_drv,4 ; unidad B: de 1.44  2.88?
               JAE   pc_ok
pc_nok:        OR    error,AX
pc_ok:         TEST  error,MALPC
               JZ    pc_ok?_ret
               AND   error,MALPC       ; ese error basta
pc_ok?_ret:    RET
pc_ok?         ENDP

               ; --- Devolver ZF=1 si 2M est instalado en SuperBOOT.
               ;     La rutina funciona aunque QEMM modifique de modo
               ;     temporal el lmite de memoria a casi un mega en
               ;     la llamada a INT 12h.

              IFNDEF XT

SuperBOOT?     PROC
               PUSH  ES
               INT   12h               ; tamao memoria convencional
               MOV   BX,640
               CMP   AX,256
               JB    base_sc_ok        ; dato extrao
               CMP   AX,640
               JA    base_sc_ok        ; dato extrao
               MOV   BX,AX
base_sc_ok:    MOV   AX,BX
               ADD   AX,127            ; redondeo
               MOV   CL,7
               SHR   AX,CL
               SHL   AX,CL             ; hacia frontera de 128K
               MOV   CX,AX
               SUB   CX,BX             ; buscar en rea posible
               DEC   AX
               MOV   BX,64
               MUL   BX                ; AX = segmento de SuperBOOT
               CLD
scan_boot:     MOV   ES,AX
               MOV   DI,6
               LEA   SI,id_boot
               PUSH  CX                ; *
               MOV   CX,id_boot_tam
               REP   CMPSB
               POP   CX                ; *
               JE    haysb_ret         ; ZF = 1 -> 2M SuperBOOT
               SUB   AX,64
               LOOPNZ scan_boot        ; buscar 1K ms abajo
nohaysb_ret:   CMP   SP,0              ; ZF = 0 -> no es SuperBOOT
haysb_ret:     POP   ES
               RET
SuperBOOT?     ENDP

              ENDIF

               ; --- Comprobar si la INT 40h est en uso

test_i40:      XPUSH <DS, ES>          ; *
               MOV   AX,3540h
               INT   21h
               XPUSH <ES, BX>          ; vector de INT 40h original
               LEA   DX,i40_aux
               MOV   AX,2540h
               INT   21h               ; establecer nueva INT 40h
               XOR   AX,AX
               MOV   DL,0
               INT   13h               ; reset de disco
               XPOP  <DX, DS>
               MOV   AX,2540h
               INT   21h               ; restaurar INT 40h original
               XPOP  <ES, DS>          ; *
               RET

i40_aux        PROC
               OR    CS:accion,I40     ; s utilizada INT 40h
               IRET                    ; desde la INT 13h
i40_aux        ENDP

               ; --- Detectar 286  superior.

testAT         PROC
               PUSH  AX
               PUSHF
               POP   AX
               OR    AH,70h        ; intentar activar bit 12, 13  14
               PUSH  AX            ; del registro de estado
               POPF
               PUSHF
               POP   AX
               AND   AH,0F0h
               CMP   AH,0F0h
               JE    testedAT
               STC
testedAT:      CMC                 ; CF = 0 en AT y 1 en PC/XT
               POP   AX
               RET
testAT         ENDP

; ------------ Comprobar que el buffer para el DMA en la copia
;              residente no cruza una frontera. En ese caso se emplea
;              otro buffer ubicado tras el habitual, lo que aumenta el
;              consumo de memoria de este rea. A la entrada AX apunta
;              al segmento que contendr el buffer y BX el offset. Si
;              no se produce el cruce, se disminuye parrafos_resid
;              para economizar memoria; incluso aunque se produzca,
;              esta variable se reduce en lo posible. A la vuelta,
;              parrafos_resid y BX indican la memoria definitiva
;              ocupada por el programa.

testDMA        PROC
               XPUSH <AX, CX, DX>
               MOV   CX,16
               MUL   CX
               ADD   AX,BX
               ADC   DX,0              ; DX:AX = direccin 20 bits
               MOV   CX,DX
               PUSH  AX
               ADD   AX,tbuffer-1      ; buffer para el mayor sector
               ADC   DX,0
               POP   AX
               MOV   BX,parrafos_resid
               SUB   BX,tbuffer/16     ; mejor supuesto posible
               CMP   DX,CX
               JE    dmatested
               NEG   AX
               ADD   AX,15
               MOV   CL,4
               SHR   AX,CL
               ADD   BX,AX             ; consumo adicional
               SHL   AX,CL
               ADD   AX,OFFSET buffer_io
               MOV   buffer,AX         ; nueva posicin del buffer
               OR    accion,BUFFERPLUS ; aviso al usuario
dmatested:     MOV   parrafos_resid,BX
               XPOP  <DX, CX, AX>
               RET
testDMA        ENDP

; ------------ Desde Windows, no se permite instalar o desinstalar 2M.

testWin        PROC
               PUSH  AX
               CMP   param_w,ON        ; se indic parmetro /W?
               JE    fin_testWin
               MOV   AX,1600h
               INT   2Fh
               AND   AL,AL             ; Windows en modo extendido?
               JZ    noWinEnh
               CMP   AL,80h            ; Windows en modo extendido?
               JE    noWinEnh
siWin:         STC                     ; estamos dentro de Windows
               JMP   fin_testWin
noWinEnh:      MOV   AX,4680h
               INT   2Fh
               AND   AX,AX
               JZ    siWin             ; Windows en modo real/estndar
fin_testWin:   POP   AX
               RET                     ; CF=1 si dentro de Windows
testWin        ENDP

; ------------ Calcular la constante de retardo bsica para perder
;              exactamente 54,925 ms. Con una regla de 3 se podr
;              despus aplicar para hacer retardos de milisegundos.

              IFDEF  XT

cte_tiempos    PROC
               XPUSH <DS, ES, BX, CX, DX>
               MOV   AX,3508h
               INT   21h
               XPUSH <ES, BX>          ; preservar vector de INT 8
               PUSH  DS
               MOV   AX,40h
               MOV   DS,AX
               MOV   AL,DS:[6Ch]
espera_i8:     CMP   AL,DS:[6Ch]
               JE    espera_i8         ; esperar INT 8 ... para que no
               POP   DS
               LEA   DX,i8_crono       ; venga otra en un buen rato...
               MOV   AX,2508h
               INT   21h               ; nueva rutina de INT 8
               IN    AL,21h
               PUSH  AX                ; preservar estado de IRQ's
               MOV   AL,11111110b
               OUT   21h,AL            ; permitir slo IRQ0
               MOV   AH,0              ; fase
               MOV   CX,0              ; contador
               MOV   BX,CX             ; seguira a 0 si fallara
               EVEN                    ; forzar alineamiento
cuenta_iter:   DEC   CX                ; <Ŀ bucle bsico de retardo
               JMP   SHORT $+2         ;   
               JNZ   cuenta_iter       ; < lo interrumpir INT 8
               POP   AX                ; anterior estado de IRQ's
               OUT   21h,AL
               XPOP  <DX, DS>
               PUSH  BX                ; valor real contado
               MOV   AX,2508h          ; restaurar vector de INT 8
               INT   21h
               POP   AX                ; (65536-AX) vueltas en 54,9 ms
               NEG   AX                ; constante de retardo bsica
               XPOP  <DX, CX, BX, ES, DS>
               RET
i8_crono:      INC   AH                ; nueva INT 8 que interrumpe
               CMP   AH,1              ; el bucle de retardo
               JE    fase1
               CMP   AH,2
               JE    fase2
i8_exit:       MOV   AL,20h
               OUT   20h,AL
               IRET
fase1:         MOV   CX,0              ; sincronizar con el reloj
               JMP   i8_exit
fase2:         MOV   BX,CX             ; anotar constante de retardo
               MOV   CX,1              ; forzar fin del bucle
               JMP   i8_exit
cte_tiempos    ENDP

              ENDIF

; ***********************************************
; *                                             *
; *   D A T O S    N O    R E S I D E N T E S   *
; *                                             *
; ***********************************************

; ------------ Control de instalacin.

offsets_ints   DW    2         ; nmero de vectores interceptados
nueva_i13      DB    13h       ; tabla de offsets de los vectores
               DW    ges_int13 ; de interrupcin interceptados
               DB    2Fh
               DW    ges_int2F

; ------------ Parmetros soportados

param_ml       DB    OFF       ; a ON si se indic parmetro /ML
param_u        DB    OFF       ; a ON si se indic parmetro /U
param_l        DB    OFF       ; a ON si se indic parmetro /L
param_w        DB    OFF       ; a ON si se indic parmetro /W
param_ayuda    DB    OFF       ; a ON si se indic /? /H  ?

parametros     LABEL BYTE

               DB    "?",0
               DW    param_ayuda
               DB    ON

               DB    "/?",0
               DW    param_ayuda
               DB    ON

               DB    "/H",0
               DW    param_ayuda
               DB    ON

               DB    "/U",0
               DW    param_u
               DB    ON

               DB    "/W",0
               DW    param_w
               DB    ON

               DB    "/ML",0
               DW    param_ml
               DB    ON

               DB    "/I",0
               DW    param_i
               DB    ON

               DB    "/L",0
               DW    param_l
               DB    ON

               DB    0                 ; fin de la tabla


MALPC          EQU    1        ; Cdigos de error
MALDOS         EQU    2
MALBIOS        EQU    4
MALDRV         EQU    8
ERRSINTAX      EQU   16
NOINSTALADO    EQU   32
IMPDESINS      EQU   64
INSTALADOSYS   EQU  128
HAY2MDOSINS    EQU  256
HAY2MDOSDES    EQU  512
NOINSTALABLE   EQU 1024
MX64FULL       EQU 2048
WIN_LOAD       EQU 4096
WIN_UNLOAD     EQU 8192

INSTALADO      EQU   1         ; cdigos de accin e informacin
YAINSTALADO    EQU   2
DESINSTALADO   EQU   4
BUFFERPLUS     EQU   8
I40            EQU  16

error          DW    0         ; variable para acumular errores
accion         DB    0         ; variable que indica lo sucedido

              IFNDEF XT
sbootseg       DW    0         ; segmento SuperBOOT (si presente)
              ENDIF

id_2mdos       DB    "CiriSOFT:2MDOS:" ; marca de presencia de 2MDOS
id_2mdos_tam   EQU   $-OFFSET id_2mdos
id_boot        DB    "2M-STV"          ; marca de presencia SuperBOOT
id_boot_tam    EQU   $-OFFSET id_boot

; ------------ Texto.

programa_txt   DB    13,10,"  2M" XTX " 3.0",0

instalado_txt  DB    " instalado en ",255," installed on ",0

              IFNDEF XT
ya_instal_txt  DB    " ya instalado en ",255
               DB    " already installed on ",0
              ELSE
ya_instal_txt  DB    " reajustando base de tiempos; instalado en ",255
               DB    " adjusting delay loop; already installed on ",0
              ENDIF

tabla_ndrvs    DW    t12
               DW    0
               DW    t144
               DW    t288
t12            DB    ":1.2M ",0
t144           DB    ":1.44M ",0
t288           DB    ":2.88M ",0

nocabe_txt     DB    ": Instalacin imposible.",13,10
               DB    "      Ya hay 64 programas residentes con la "
               DB    "misma tcnica.",13,10,255
               DB    ": Unable to install.",13,10
               DB    "      There are already 64 TSR's with the same technique."
crlf_txt       DB    13,10,0

err_sintax_txt DB    13,10,"    - Parmetro(s) incorrecto(s)."
               DB    13,10,"      Ejecute 2M" XTX " /? para obtener "
               DB    "ayuda.",13,10,7,255
               DB    13,10,"    - Incorrect option(s)."
               DB    13,10,"      Execute 2M" XTX " /? to obtain help."
               DB    13,10,7,0

              IFNDEF XT
mal_pc_txt     DB    13,10,"    - Error: Necesario ordenador AT. Utilice 2MX en esta mquina.",13,10,255
               DB    13,10,"    - Error: Needs AT system. Use 2MX on this computer.",13,10,0
              ELSE
mal_pc_txt     DB    13,10,"    - Error: Necesario ordenador PC/XT. Utilice 2M en esta mquina.",13,10,255
               DB    13,10,"    - Error: Needs PC/XT system. Use 2M on this computer.",13,10,0
              ENDIF

mal_dos_txt    DB    13,10,"    - Error: Necesaria versin DOS 3.30  posterior.",13,10,255
               DB    13,10,"    - Error: Needs at least DOS 3.30 or above.",13,10,0

mal_bios_txt   DB    13,10,"    - Error: No puedo detectar el tipo de las unidades. Instale 2M-?BIOS antes.",13,10,255
               DB    13,10,"    - Error: Impossible to detect drive types. Please install 2M-?BIOS before.",13,10,0

mal_drv_txt    DB    13,10,"    - Error: Necesaria(s) unidad(es) de alta densidad.",13,10,255
               DB    13,10,"    - Error: Needs high-density floppy drive(s).",13,10,0

dma_cross_txt  DB    "    - Nota: El buffer de E/S cruzaba una frontera de DMA y fue ampliado.",13,10
               DB    "            Cambie la ubicacin en memoria de 2M" XTX " para ahorrar unos bytes.",13,10,255
               DB    "    - Note: I/O buffer has been extended because 2M" XTX " crosses a DMA boundary.",13,10
               DB    "            Modify the memory location of 2M" XTX " to save a little memory.",13,10,0

win_ld_txt     DB    " *NO* instalado:",13,10,"    Este programa debe cargarse ANTES de entrar en Windows.",13,10,7,255
               DB    " *NOT* installed:",13,10,"    This program must be loaded before WINDOWS.",13,10,7,0
win_ul_txt     DB    " *NO* desinstalado:",13,10,"    Este programa debe descargarse fuera de Windows.",13,10,7,255
               DB    " *NOT* uninstalled:",13,10,"    This program must be uninstalled outside of WINDOWS.",13,10,7,0

mal_ver_txt1   DB    13,10,"    - Error: ya est instalada la versin ",255
               DB    13,10,"    - Error: Version ",0
mal_ver_txt2   DB    " de este programa.",13,10,7,255
               DB    " of this program is already installed.",13,10,7,0

des_ok_txt     DB    " desinstalado.",13,10,255," uninstalled.",13,10,0

des_no_ok_txt  DB    13,10,"    - Desinstalacin imposible (se ha "
               DB    "instalado despus un programa"
               DB    13,10,"      que no respeta el convenio y tiene "
               DB    "alguna interrupcin comn).",13,10,7,255
               DB    13,10,"    - Uninstall unavailable (it has been"
               DB    " installed before a program that"
               DB    13,10,"      does not support CiriSOFT convention"
               DB    " and uses a common interrupt).",13,10,7,0

imp_desins_txt DB    13,10,"    - Programa an no instalado: "
               DB    "imposible desinstalarlo.",13,10,255
               DB    13,10,"    - Program not installed: "
               DB    "impossible to uninstall.",13,10,0

inst_sys_txt   DB    13,10,"    - Instalado como controlador de dispositivo; no desinstalable.",13,10,255
               DB    13,10,"    - Installed as device driver: unable to uninstall.",13,10,0

inst_2mdos_txt DB    13,10,"    - Error: necesario instalar este programa *antes* que 2MDOS.",13,10,255
               DB    13,10,"    - Error: needed to install this program *before* 2MDOS.",13,10,0

dins_2mdos_txt DB    13,10,"    - Error: necesario desinstalar primero 2MDOS.",13,10,255
               DB    13,10,"    - Error: needed to uninstall first 2MDOS.",13,10,0

              IFNDEF XT

ayuda_txt      LABEL BYTE
DB 13,10,10
DB "    2M 3.0 - CONTROLADOR PARA ACCESO A DISCOS FORMATEADOS CON TECNOLOGIA STV.",13,10
DB "   (C) 1993-1995 Ciriaco Garca de Celis - Grupo Universitario de Informtica",13,10
DB "   C/Renedo, 2, 4-C; 47005 Valladolid (Espaa) - ciri@gui.uva.es - 2:341/21.8",13,10
DB 10
DB "                         Sintaxis:  2M [/ML] [/U] [/L]",13,10
DB 10
DB "  Tras ejecutarlo, 2M se queda residente en memoria, para dar soporte a discos",13,10
DB " de formato 2M creados por 2MF. 2M es una aplicacin CARDWARE. Esta permitida",13,10
DB " su distribucin gratuta SIN MODIFICACIONES.  Informacin sobre cmo conseguir",13,10
DB " el paquete completo e informacin de licencia con 2M /L.",13,10
DB 10
DB "  2M precisa para operar:",13,10
DB " - Un equipo AT o superior con las disqueteras bien indicadas en el SETUP.",13,10
DB " - Al menos una disquetera de alta densidad (las de doble no son controladas).",13,10
DB " - 5168 bytes de memoria superior o en su defecto 5264 de memoria convencional.",13,10
DB " - Sistema operativo DOS y/o WINDOWS 3.X, otros entornos no son contemplados.",13,10
DB " - Utilidad 2MF para formatear los disquetes 2M.",13,10
DB "  2M ofrece:",13,10
DB " - Soporte para disquetes de 902K (5-DD) hasta 3772K (3-ED) en A: y en B:.",13,10
DB " - Soporte INT 13h para que los programas comerciales puedan formatear en 2M.",13,10
DB 10
DB "  Con /ML se fuerza la instalacin en memoria convencional (2M se auto-instala",13,10
DB " automticamente en memoria superior) y con /U se desinstala, si es posible.",13,10
DB 255

DB 13,10,10
DB "     2M 3.0  -  DISKETTE DRIVE CONTROLLER FOR STV DISKETTE FORMAT TECHNOLOGY.",13,10
DB "   (C) 1993-1995 Ciriaco Garca de Celis - Grupo Universitario de Informtica.",13,10
DB "    C/Renedo, 2, 4-C; 47005 Valladolid (Spain) - ciri@gui.uva.es - 2:341/21.8",13,10
DB 10
DB "                          Syntax:  2M [/ML] [/U] [/L]",13,10
DB 10
DB "  After being executed without options, the program becomes resident in memory",13,10
DB " to support 2M disks built by 2MF. 2M is a CARDWARE package. The distribution",13,10
DB " is only authorized WITHOUT MODIFY. How to get the complete package and license",13,10
DB " information with 2M /L.",13,10
DB 10
DB "  2M requires:",13,10
DB " - An AT or above computer with diskette drives correctly set on SETUP.",13,10
DB " - At least one high-density floppy drive (double ones are not drived).",13,10
DB " - 5168 bytes of upper memory or 5264 bytes of conventional memory instead.",13,10
DB " - DOS and/or WINDOWS 3.X system, another environs are not still supported.",13,10
DB " - 2MF utility program to format 2M diskettes.",13,10
DB "  2M gives you:",13,10
DB " - Support for diskettes from 902K (5-DD) up to 3772K (3-ED) on A: and B:.",13,10
DB " - INT 13h code improves a new 2M format service for high-level applications.",13,10
DB 10
DB "  With /ML a conventional memory installation can be forced  (this is an upper",13,10
DB " memory self-installating utility) and /U tells 2M to uninstall, if possible.",13,10
DB 0

              ELSE

ayuda_txt      LABEL BYTE
DB 13,10,10
DB "   2MX 3.0 - CONTROLADOR PARA ACCESO A DISCOS FORMATEADOS CON TECNOLOGIA STV.",13,10
DB "   (C) 1993-1995 Ciriaco Garca de Celis - Grupo Universitario de Informtica",13,10
DB "   C/Renedo, 2, 4-C; 47005 Valladolid (Espaa) - ciri@gui.uva.es - 2:341/21.8",13,10
DB 10
DB "                         Sintaxis:  2MX [/ML] [/U] [/L]",13,10
DB 10
DB "  Tras ejecutarlo, 2MX se queda residente en memoria para dar soporte a discos",13,10
DB " de formato 2M creados por 2MF. 2M es una aplicacin CARDWARE. Esta permitida",13,10
DB " su distribucin gratuta SIN MODIFICACIONES.  Informacin sobre cmo conseguir",13,10
DB " el paquete completo e informacin de licencia con 2MX /L.",13,10
DB 10
DB "  2MX precisa para operar:",13,10
DB " - Un equipo PC/XT con una BIOS moderna (o 2M-XBIOS instalado en su defecto).",13,10
DB " - Al menos una disquetera de alta densidad (las de doble no son controladas).",13,10
DB " - 5376 bytes de memoria superior o en su defecto 5472 de memoria convencional.",13,10
DB " - Sistema operativo DOS y/o WINDOWS 3.X, otros entornos no son contemplados.",13,10
DB " - Utilidad 2MF para formatear los disquetes 2M.",13,10
DB "  2MX ofrece:",13,10
DB " - Soporte para disquetes de 902K (5-DD) hasta 3772K (3-ED) en A: y en B:.",13,10
DB " - Soporte INT 13h para que los programas comerciales puedan formatear en 2M.",13,10
DB 10
DB "  Con /ML se fuerza la instalacin en memoria convencional (2MX se autoinstala",13,10
DB " automticamente en memoria superior) y con /U se desinstala, si es posible.",13,10
DB 255

DB 13,10,10
DB "    2MX 3.0  -  DISKETTE DRIVE CONTROLLER FOR STV DISKETTE FORMAT TECHNOLOGY.",13,10
DB "   (C) 1993-1995 Ciriaco Garca de Celis - Grupo Universitario de Informtica.",13,10
DB "    C/Renedo, 2, 4-C; 47005 Valladolid (Spain) - ciri@gui.uva.es - 2:341/21.8",13,10
DB 10
DB "                          Syntax:  2MX [/ML] [/U] [/L]",13,10
DB 10
DB "  After being executed without options, the program becomes resident in memory",13,10
DB " to support 2M disks built by 2MF. 2M is a CARDWARE package. The distribution",13,10
DB " is only authorized WITHOUT MODIFY. How to get the complete package and license",13,10
DB " information with 2MX /L.",13,10
DB 10
DB "  2MX requires:",13,10
DB " - A PC/XT computer with a modern BIOS (or with 2M-XBIOS installed instead).",13,10
DB " - At least one high-density floppy drive (double ones are not drived).",13,10
DB " - 5376 bytes of upper memory or 5472 bytes of conventional memory instead.",13,10
DB " - DOS and/or WINDOWS 3.X system, another environs are not still supported.",13,10
DB " - 2MF utility program to format 2M diskettes.",13,10
DB "  2MX gives you:",13,10
DB " - Support for diskettes from 902K (5-DD) up to 3772K (3-ED) on A: and B:.",13,10
DB " - INT 13h code improves a new 2M format service for high-level applications.",13,10
DB 10
DB "  With /ML a conventional memory installation can be forced  (this is an upper",13,10
DB " memory self-installating utility) and /U tells 2MX to uninstall, if possible.",13,10
DB 0
              ENDIF

infop_txt      LABEL BYTE
DB 13,10
DB 10
DB " LICENCIA DE USO Y CONDICIONES DE DISTRIBUCION ",13,10
DB "  Es legal copiar 2M sin cobrar dinero (a lo sumo los costes de distribucin) a",13,10
DB "cualquier otra persona. Quien decida utilizar algn programa del paquete 2M con",13,10
DB "la excepcin de 2M.COM y 2MX.COM deber enviarme una postal. Para utilizar slo",13,10
DB "2M.COM o 2MX.COM no es obligatorio enviar la postal (slo es opcional),  ya que",13,10
DB "dichos programas as como el formato de disco 2M,  su  sector  de arranque y el",13,10
DB "cdigo SuperBOOT son de dominio pblico.  Esto  permite  a las empresas incluir",13,10
DB "slo 2M.COM o 2MX.COM en sus distribuciones  de productos  en  discos  2M,  sin",13,10
DB "que sus clientes tengan la obligacin de enviarme la postal. Aunque me gustara",13,10
DB "que incluyeran tambin el fichero original (2M30.ZIP) si les sobra espacio.",13,10
DB 10
DB "  ESTA PROHIBIDO  modificar  este  programa o cualquier otro del paquete sin mi",13,10
DB "consentimiento. En caso de distribuir algn fichero que no sea 2M.COM  2MX.COM",13,10
DB "ser obligatorio distribuir el paquete 2M completo.",13,10
DB 10
DB "  Si usted no dispone del paquete 2M completo, puede conseguirlo en Internet en",13,10
DB "ftp.gui.uva.es (pub/pc/2m), oak.oakland.edu (SymTel/msdos/diskutil) as como en",13,10
DB "garbo.uwasa.fi (pc/format);  por telfono en la BBS DataByte  (+34 -83 -307574:",13,10
DB "00-24h, 1200-28800, Grupo Varios, Area de Ficheros del GUI y Login:).  Ventajas",13,10
DB "del paquete completo:  ms ayuda (2M-INFO),  formateador (2MF),  optimizador de",13,10
DB "formateo de discos estndar (2MDOS), discos de ms capacidad (2MGUI: 3 ->1176,",13,10
DB "1972, 3944  y  5 -> 976, 1639),  actualizacin BIOS (2M-ABIOS y 2M-XBIOS).  La",13,10
DB "licencia de uso para el paquete completo consiste en enviar una tarjeta postal.",13,10

DB 255

DB 13,10
DB 10
DB " USE LICENSE AND DISTRIBUTION CONDITIONS ",13,10
DB "  It is legal to copy 2M without charge (or charging a little distribution fee)",13,10
DB "for anyone. Whoever who decides to use a program from 2M package, except 2M.COM",13,10
DB "and 2MX.COM must send me a postcard.  To use only 2M.COM or 2MX.COM it isn't an",13,10
DB "obligation to send the postcard  (it's only optional),  since this program  and",13,10
DB "2M disk formats, their boot records and SuperBOOT code are public domain.  This",13,10
DB "permits any company to include only 2M.COM  and/or  2MX.COM in his own products",13,10
DB "distributed on 2M disks,  without having their customers the obligation on send",13,10
DB "me the postcard. But I would like them to include the original file  (2M30.ZIP)",13,10
DB "if they have any remaining free space on their disk(s).",13,10
DB 10
DB "  IT IS FORBIDDEN  to  modify this program or any other included in the package",13,10
DB "without my permission.  If any file except 2M.COM or 2MX.COM is distributed, it",13,10
DB "is also obligatory to include the complete 2M package.",13,10
DB 10
DB "  If you  still  haven't  got  the complete 2M package, you  can  get it on the",13,10
DB "Internet at ftp.gui.uva.es (pub/pc/2m), oak.oakland.edu (SymTel/msdos/diskutil)",13,10
DB "or garbo.uwasa.fi (pc/format); by telephone on  DataByte BBS  (+34 -83 -307574:",13,10
DB '00-24h, 1200-28800, Group Varios, "Area de Ficheros del GUI y Login:"). Benefit',13,10
DB "of complete package: more help (2M-INFO), disk formatter (2MF),  standard disks",13,10
DB "format optimizer (2MDOS), more capacity disks (2MGUI: 3 ->1176, 1972, 3944 and",13,10
DB "5 -> 976, 1639),  disk BIOS update (2M-ABIOS and 2M-XBIOS).  The  use  licence",13,10
DB "for the complete package consist of sending me a postcard.",13,10
DB 0

buffer_aux     DB    64 DUP (0)   ; buffer para alguna funcin del DOS

_PRINCIPAL     ENDS
               END   inicio
