/* AGEDEL aged file delete utility
 * By request of SEMPER BBS (whose SYSOP wanted to delete all files
 * older than 6 months or whatever in his download directory).
 * Cribbed from an old MicroCornucopia file find utility.
 * Hacked unmercifully, and given to the public domain.
 * David Kirschbaum
 * Toad Hall
 * kirsch@usasoc.soc.mil
 */

#include <dir.h>
#include <dos.h>
#include <stdlib.h>		/* atoi() */
#include <string.h>
#include <stdio.h>		/* printf() */
#include "filesrch.h"


/* global data */

/* global variables */
	FILE_DATA ourfd;
	char drive[3] = "";		/* sizes are from dir.h */
	char dir[66] = "";
	char name[9] = "";
	char ext[5] = "";
	unsigned int targetdate;
	int counter = 0;

	int Test = 0;			/* -t flag */
	int Visual = 0;			/* -v flag */

char Usage[] =
"AGEDEL aged file delete utility\n"
"Usage:  agedel [-v][-t] n [d:][\path\]filename.typ [...]\n"
"-v - visual    - display progress to stdout\n"
"-t - test      - list files that would have been deleted without deleting\n"
"n              - target file age in months,\n"
"filename.typ   - target filename(s).\n"
"Wildcards and/or multiple filenames are permitted.\n"
"\nWARNING!  This is a potentially disastrous utility!\n"
"'agedel 1 *.*' will delete EVERYTHING in the current directory\n"
"older than 1 month!\n"
"Be ABSOLUTELY sure you know what you're doing when using this!\n";

static union  REGS  regs;
static struct SREGS sregs;

static unsigned old_dta_seg;
static unsigned old_dta_off;

/* local function prototypes */

static void set_dta(void * new_dta);
static void reset_dta(void);
unsigned int today(void);


int find_first(char * spec, char attrib, FILE_DATA * fd)
{
	unsigned res;

	set_dta(fd);

	regs.h.ah = 0x4E;
	regs.x.cx = (unsigned)attrib;

	regs.x.dx = (unsigned)spec;
	intdos(&regs,&regs);

	res = regs.x.cflag;

	reset_dta();

	return res;
}

int find_next(FILE_DATA * fd)
{
	unsigned res;

	set_dta(fd);

	regs.h.ah = 0x4F;
	intdos(&regs,&regs);

	res = regs.x.cflag;

	reset_dta();

	return res;
}

static void set_dta(void * new_dta)
{
	regs.h.ah = 0x2F;
	intdosx(&regs,&regs,&sregs);

	old_dta_seg = sregs.es;
	old_dta_off = regs.x.bx;

	regs.h.ah = 0x1A;

	regs.x.dx = (unsigned)(new_dta);
	intdos(&regs,&regs);
}

static void reset_dta(void)
{
	segread(&sregs);

	regs.h.ah = 0x1A;
	sregs.ds  = old_dta_seg;
	regs.x.dx = old_dta_off;

	intdosx(&regs,&regs,&sregs);
}

unsigned int abs_dta_date(int fd_date)
/* compute an absolute day-based date from a DTA-type date integer.
 * ourfd.date looks like this:
 * bits 0-4  day
 * bits 5-8  month
 * bits 9-15 year
 */
{
	int year,month;	/* ,day; */

	year  = ((int)(fd_date >>9) & 0x7f);
	month = ((int)(fd_date >>5) & 0xf);
/*
	day   = (int)(fd_date & 0x1f);
*/
	return( (year*12) + month);
}


unsigned int today(void)
/* compute an absolute day-based date from a today's date struct.
 * the struct date, used by getdate, is like this:
 * struct date {
 *   int da_year;
 *   char da_day;
 *   char da_mon;
 * };
*/
{
	struct date date;

	getdate(&date);
	date.da_year -= 1980;		/* move down to a decent range */
	return( (date.da_year * 12) + date.da_mon);
}


void delete(int flags)
/* flags are from a fnsplit() */
{
	char s[128] = "";

	if( (!strcmp(ourfd.name,".")			/* no subdirectory stuff */
	  || !strcmp(ourfd.name,"..")) )
		return;

	if(flags & DRIVE)
		strcat(s,drive);		/* "C:" */
	if(flags & DIRECTORY)
		strcat(s,dir);			/* "/FOO/" */
	strcat(s,ourfd.name);		/* finally the expanded name */

/* Test this file's date against our target date.
 * Delete if older.
 */
	if(s[0])				/* be sure we have a name */
	if (abs_dta_date(ourfd.date) < targetdate){
		if(Visual)
			printf("Deleting [%s]\n",s);
		if(!Test)
			unlink(s);
		counter++;
	}
}


void main(int ArgC,char **ArgV)
{
	int i,res;
	int n=0;

	for(i=1;i<ArgC;i++)		/* check all args */
	if(ArgV[i][0]=='-')		/* if an option ... */
	switch(ArgV[i][1]){		/* check which */
		case 0:				/* ignore null switches */
			break;
		case 't':
			Test++;
			break;
		case 'v':
			Visual++;
			break;
		default:
			fprintf(stderr,"AGEDEL: unknown option %s\n",ArgV[i]);
	}
	else
		ArgV[++n]=ArgV[i];		/* pack list */

	if( (n < 2)					/* need at least 2 (age & filename) */
	 || (res = atoi(ArgV[1])) < 1)	/* and age had better be valid! */
		printf(Usage);				/* help the dummy */
	else {

	targetdate = today() - res;		/* age we'll look for */
	if(Visual)
		printf("AGEDEL: deleting all files older than %u months:\n",res);

	for(i=1;i<=n;i++) {				/* switches have been gobbled */
		if (!find_first(ArgV[i],ATTR_ALL,&ourfd)){
			res = fnsplit(ArgV[i],drive,dir,name,ext);
			delete(res);
			if (res & WILDCARDS) {	/* only find_next if wild cards */
				while(!find_next(&ourfd))
					delete(res);
			}
		}
	}
	if(Visual)
		printf("%u files deleted\n",counter);
	}
}
