;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1992 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File QRYSTR0.ASM	Query Stream funcs taking no args	*
;*									*
;************************************************************************
;LastEdit: 12/29/92

	INCLUDE	API.INC
	INCLUDE DVSTREAM.INC
	MIN_VERSION 2,00

	Header@

;========================================================================

DSeg@
S_QUERY		scrollattr_stream
	QS_SCROLLATTR
	S_END	scrollattr_stream

S_QUERY		fullframe_stream
	QS_FULLFRAME
	S_END	fullframe_stream

S_QUERY		progcolor_stream
	QS_PROGCOLOR
	S_END	progcolor_stream

S_QUERY		attr_stream
	QS_READATTR
	S_END	attr_stream

S_QUERY		ctrl_stream
	QS_CTRLCHAR
	S_END	ctrl_stream

S_QUERY		lattr_stream
	QS_LOGATTR
	S_END	lattr_stream

S_QUERY		frame_stream
	QS_FRAME
	S_END	frame_stream

S_QUERY		leave_stream
	QS_LEAVEATTR
	S_END	leave_stream

S_QUERY		hidden_stream
	QS_HIDDEN
	S_END	hidden_stream

DSegEnd@

;========================================================================

CSeg@

PubProc@ DVQRY_SCROLLATTR,__PASCAL__
	mov	bx,offset DGROUP:scrollattr_stream
	jmp short do_query
EndProc@ DVQRY_SCROLLATTR,__PASCAL__

PubProc@ DVQRY_FULLFRAME,__PASCAL__
	mov	bx,offset DGROUP:fullframe_stream
	jmp short do_query
EndProc@ DVQRY_FULLFRAME,__PASCAL__

PubProc@ DVQRY_PROGCOLOR,__PASCAL__
	mov	bx,offset DGROUP:progcolor_stream
	jmp short do_query
EndProc@ DVQRY_PROGCOLOR,__PASCAL__

PubProc@ DVQRY_CTRL,__PASCAL__
	mov	bx,offset DGROUP:ctrl_stream
	jmp short do_query
EndProc@ DVQRY_CTRL,__PASCAL__

PubProc@ DVQRY_FRAME,__PASCAL__
	mov	bx,offset DGROUP:frame_stream
	jmp short do_query
EndProc@ DVQRY_FRAME,__PASCAL__

PubProc@ DVQRY_HIDDEN,__PASCAL__
	mov	bx,offset DGROUP:hidden_stream
	jmp short do_query
EndProc@ DVQRY_HIDDEN,__PASCAL__

PubProc@ DVQRY_LOGATTR,__PASCAL__
	mov	bx,offset DGROUP:lattr_stream
	jmp short do_query
EndProc@ DVQRY_LOGATTR,__PASCAL__

PubProc@ DVQRY_LEAVE,__PASCAL__
	mov	bx,offset DGROUP:leave_stream
	jmp short do_query
EndProc@ DVQRY_LEAVE,__PASCAL__

PubProc@ DVQRY_ATREAD,__PASCAL__
@win = dword ptr [bp+SendOverhead]
	mov	bx,offset DGROUP:attr_stream
do_query:
	@EnterSend
	STACK_STREAM
	mov	al,SS_[bx+4]
	push	bx			; save address of stream
	push	ax			; save opcode
	WIN_STREAM @win,ss,bx
	pop	cx			; retrieve original opcode
	pop	bx			; retrieve address of stream
	xor	ax,ax
	cmp	cl,SS_[bx+4]
	jnz	query_done
	inc	ax
query_done:
	@ExitSend 4
EndProc@ DVQRY_ATREAD,__PASCAL__

CSegEnd@

;========================================================================

	END
