* Program ...: Memorpt.PRG
* Author ....: Christopher White
* Date ......: November 1, 1985
* Version ...: dBASE III, The Developer's Release
* Note(s) ...: Program to print formatted memo fields with
*              page headers, footers, and margin control.
*
SET TALK OFF
SET SAFETY OFF
SET PRINT ON
*
* ---User-definition area.
yourfile   = "Yourfile"
memofield  = "F2"
linelength = 80
memomargin = 5
*
* ---Initialize global variables.
linecnt = 99
page = 1
toprint = 1
memowidth  = STR( linelength  - memomargin )
* ---Open work areas.
SELECT 2
USE Memotemp
SELECT 1
USE &yourfile
* ---Print report.
DO WHILE .NOT. EOF()
   SET PRINT OFF
   DO Getmemo WITH memowidth, toprint, yourfile, memofield
   SET PRINT ON
   printed = 1
   DO WHILE printed <= toprint .AND. ( .NOT. EOF() )
   * ---Check for new page.
   IF linecnt > 58
      DO Pagetop
   ENDIF
   *
   * ---Print memo header from Yourfile record.  
   * ---Define your format here.
   ?  "Field One Title" , Fld1
   ?? " Field Two Title", Fld2
   ?
   linecnt = linecnt + 2
   * ---Print memo field for master record.
   SELECT Memotemp
   newrec = .T.
   rec = VAL( Recnum ) + 1
   DO WHILE VAL( Recnum ) <> rec .AND. ( .NOT. EOF() )
      * ---Check for new page.
      IF linecnt > 58
         IF .NOT. newrec
            ?
            ? SPACE( 40 ),"(Continued)"
            DO Pagetop
            ? SPACE( memomargin ),"(Continued)"
            ?
            linecnt = linecnt + 2
         ELSE
            DO Pagetop
         ENDIF
      ENDIF
      ? SPACE( memomargin ), TRIM( line )
      linecnt = linecnt + 1
      newrec = .F.
      SKIP
   ENDDO
   SELECT &yourfile
   * ---Print footer line for Yourfile record.
   ?
   linecnt= linecnt + 1
   printed = printed + 1
   SKIP
   ENDDO
ENDDO
* ---Clean up.
CLEAR ALL
SET PRINT OFF
SET SAFETY ON
SET TALK ON
RETURN
* EOP Memorpt.PRG