; Program ...: Curon.ASM
; Author ....: Steve Kurash and Olivier Biggerstaff
; Date ......: September 1, 1985
; Note ......: Turns the cursor on.

	.LFCOND			; List false conditionals.
	PAGE 60,132		; Page length 60, width 132.

COM	EQU 	0		; Assemble as .BIN file.
D3	EQU 	1
		
CODESEG SEGMENT BYTE PUBLIC 'CODE'
CURSON  PROC	FAR
	ASSUME CS:CODESEG
	IF	COM
	   ORG	100H		; ORG at 100H for .COM file.
	ENDIF
START:  PUSH	AX		; Save registers.
	PUSH	CX
	INT 	11H		; 
	MOV	CX,0607H	; Mask for color monitor.
	AND	AL,10H		; Check bit for color card.
	JZ	CALL_ROM	; JMP if color
	MOV	CX,0B0CH	; otherwise set up mask for
				; monochrome.
CALL_ROM:
	MOV	AH,1		; Set cursor type function.
	INT	10H		; Call ROM BIOS.
	POP	CX		; Restore registers.
	POP	AX
	IF	COM		
	   INT	20H		; INT 20H if .COM file.
	ELSE
	   RET			; Far return to dBASE III.
	ENDIF
;
CURSON	ENDP
CODESEG	ENDS
	END	START
