/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   list_kj.c: Listen der KEYWORDS und JOURNAL NAMES erstellen
*/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include "fl_ut.h"
#include "str_fun.h"
#include "ix02_fun.h"
#include "ix03_fun.h"
#include "l_menu.h"
#include "abbruch.h"
#include "cfg_fun.h"

 extern config_set one_config_set;

 extern quellpix_rec ix02rec;
 extern quell_rec one_quell_rec;
 extern keylistpix_rec ix03rec;
 extern keylist_rec one_stichw_rec;


 extern FILE * ix02file;
 extern FILE * ix03file;
 static FILE * fptextj;
 static FILE * fptextk;
 extern FILE * fpquell;
 extern FILE * fpstichw;


 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 extern char stichw_name[PFAD_LEN];
 extern char stichw_pix_name[PFAD_LEN];
 static char textj_name[PFAD_LEN];
 static char textk_name[PFAD_LEN];

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 int list_kj_main(char * datpath);
 static void dateien_oeffnen_kj(void);
 static void dateien_schliessen_kj(void);
 static void schreiben(void);



int list_kj_main(char * datpath)
{
     strcpy(textj_name,datpath);strcat(textj_name,"__JOUR__.TXT");
     strcpy(textk_name,datpath);strcat(textk_name,"__KEYW__.TXT");
     cls_line("REFERENCES VERSION 3.6 * LIST - KEYWORDS AND JOURNAL NAMES");
     if (isfile(textk_name) || isfile(textj_name))
     {
        int taste;
        taste = lotus_menu(
          "@Cancel$Text file(s) '__KEYW__.TXT' and/or '__JOUR__.TXT' already exist(s), abort"
          "@Overwrite$Overwrite existing file(s) '__KEYW__.TXT' and/or '__JOUR__.TXT'"
                          );
           if (taste < 2)
           {
             return 0;
           }
     }
     dateien_oeffnen_kj();
     schreiben();
     dateien_schliessen_kj();
     wrtxt("\n[Completed, please press any key]>");
     tastelesen();
     return 0;
}

static void dateien_oeffnen_kj(void)
{
  if (!read_ix02(quell_pix_name))
  {
     sprintf(fehlermeldung,"ERROR: Cannot read %s",quell_pix_name);
     beenden(fehlermeldung,2);
  }
  if (!read_ix03(stichw_pix_name))
  {
     sprintf(fehlermeldung,"ERROR: Cannot read %s",stichw_pix_name);
     beenden(fehlermeldung,2);
  }
  if ((fptextk=fopen(textk_name,"w"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create/write into %s",
                            textk_name);
     beenden(fehlermeldung,2);
  }
  if ((fptextj=fopen(textj_name,"w"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create/write into %s",
                            textj_name);
     beenden(fehlermeldung,2);
  }

  if ((fpquell=fopen(quell_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot read %s",quell_name);
     beenden(fehlermeldung,2);
  }

  if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot read %s",stichw_name);
     beenden(fehlermeldung,2);
  }
}

static void dateien_schliessen_kj(void)
{
   close_ix02();
   close_ix03();
   fclose(fptextk);
   fclose(fptextj);
   fclose(fpquell);
   fclose(fpstichw);
}

static void schreiben(void)
{
   long i, anzahl_records, byte_zeiger;

   sprintf(wrtxtbu,"Writing %s, please wait...\n",textj_name);
   wrtxt(wrtxtbu);
   fseek(ix02file,0L,SEEK_END);
   byte_zeiger = ftell(ix02file);
   rewind(ix02file);
   anzahl_records = byte_zeiger/sizeof(ix02rec);
   anzahl_records--;
   fprintf(fptextj,"JOURNAL NAMES:\n\n");
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix02rec,sizeof(ix02rec),1,ix02file);
      byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
      fseek(fpquell,byte_zeiger,SEEK_SET);
      fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);
      fprintf(fptextj,"[%s]:\n  %s\n  %s\n  %s\n\n",
         one_quell_rec.quell_kuerzel,
         one_quell_rec.quell_issn,
         one_quell_rec.quell_zeitschrift,
         one_quell_rec.quell_kurzform
              );
   }
   fprintf(fptextj,"\nEND OF LIST JOURNAL NAMES\n");

   sprintf(wrtxtbu,"Writing %s, please wait...\n",textk_name);
   wrtxt(wrtxtbu);
   fseek(ix03file,0L,SEEK_END);
   byte_zeiger = ftell(ix03file);
   rewind(ix03file);
   anzahl_records = byte_zeiger/sizeof(ix03rec);
   anzahl_records--;

   fprintf(fptextk,"KEYWORDS:\n\n");
   for (i=0;i<=anzahl_records;i++)
   {
      fread(&ix03rec,sizeof(ix03rec),1,ix03file);
      byte_zeiger = ix03rec.keywords_rptr * sizeof(one_stichw_rec);
      fseek(fpstichw,byte_zeiger,SEEK_SET);
      fread(&one_stichw_rec,sizeof(one_stichw_rec),1,fpstichw);
      fprintf(fptextk,"%s\n",one_stichw_rec.keywordsfield);
   }
   fprintf(fptextk,"\nEND OF LIST KEYWORDS\n");
}
