;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;        makelib - generalised procedure for making a PAL library         ;
;        Arguments - library name                                         ;
;                    number of source files (max 10)                       ;
;                                                                         ;
;        Note - source file names are in array palfiles                   ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

proc makelib(AppLib, nfiles)

Clear
Style Reverse
libMsg = " Making library " + AppLib + " for forms dictionary application"
@ 24, 79 - (len(libMsg) + 4) ?? libMsg
Style Reverse, Blink
?? "... "
Style

if isfile(AppLib + ".lib") then
   Run NoRefresh "del " + AppLib + ".lib >nul"
endif
createlib AppLib size 60

for fnum from 1 to nfiles
   play palfiles[fnum]
endfor

infolib AppLib
clearall
clear

view "List"
wait table prompt "Press Esc, F2 or F8 to continue"
until "Esc", "F2", "F8"
clearall

endproc

array palfiles[10]

palfiles[1] = "Boxes"
palfiles[2] = "Menus"
palfiles[3] = "Select"
palfiles[4] = "Scanform"
palfiles[5] = "Reports"
palfiles[6] = "Utility"
palfiles[7] = "Helptext"
makelib("Formdict", 7)
