/* -*- Mode: C -*- */
/* CardRecord.cc - Implementation of CardRecords
 * Created by Robert Heller on Sat Dec  7 00:01:57 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#ifdef MESSYDOS
#include <cardrec.h>
#else
#include <CardRecord.h>
#endif
#include <stdio.h>
//#include <iostream.h>

extern Card defCard;	// prototypical Card

// CardRecord constructor, given an existing CardRecord
CardRecord::CardRecord(const CardRecord& cardrecord)
{
	//cerr << "*** CardRecord::CardRecord(CardRecord& cardrecord): this = "; cerr.form("0x%08x",(long int)this); cerr << endl;
	RawData = cardrecord.RawData;
	card = RecordToCard();
}
// CardRecord copier function
CardRecord& CardRecord::operator = (const CardRecord& cardrecord)
{
	//cerr << "*** CardRecord::operator = (CardRecord& cardrecord): this = "; cerr.form("0x%08x",(long int)this); cerr << endl;
	RawData = cardrecord.RawData;
	if (card != 0) {
#ifdef __DMALLOC_H__
	_dmalloc_file = __FILE__; _dmalloc_line = __LINE__;
#endif
		delete card;
	}
	card = RecordToCard();
	return *this;
}
// CardRecord constructor, given a CoreItem
CardRecord::CardRecord(const CoreItem* coreitem)
{
	//cerr << "*** CardRecord::CardRecord(CoreItem* coreitem): this = "; cerr.form("0x%08x",(long int)this); cerr << endl;
	RawData = coreitem->data;
	card = RecordToCard();
}
// CardRecord constructor, given a Record*
CardRecord::CardRecord(const Record* record)
{
	//cerr << "*** CardRecord::CardRecord(Record* record): this = "; cerr.form("0x%08x",(long int)this); cerr << endl;
	RawData = *record;
	card = RecordToCard();
}
// CardRecord constructor, given a Card*
CardRecord::CardRecord(const Card* incard)
{
	card = 0;
	//cerr << "*** CardRecord::CardRecord(Card* card): this = "; cerr.form("0x%08x",(long int)this); cerr << endl;
	CreateRecord(incard);
	card = RecordToCard();
}
// CardRecord destructor
CardRecord::~CardRecord()
{
	//cerr << "*** CardRecord::~CardRecord: card = "; cerr.form("0x%08x",(long int)card); cerr << endl;
#ifdef __DMALLOC_H__
	_dmalloc_file = __FILE__; _dmalloc_line = __LINE__;
#endif
	delete card;
	RawData.NewBuffer(0);
}
// Conversion function - convert from a Record to a Card
// derived from the code for RawBook::RawToBook() on page 91 of
// "C++, a guide for C programmers", by Sharam Hekmatpour
Card*  CardRecord::RecordToCard () const
{
	register char* str = RawData.buffer;	// Data string
	register int   bytesleft = RawData.size; // Number of bytes
#ifdef __DMALLOC_H__
	_dmalloc_file = __FILE__; _dmalloc_line = __LINE__;
#endif
	register Card *cd = new Card;		// allocate a fresh Card
	//cerr << "*** CardRecord::RecordToCard: cd = "; cerr.form("0x%08x",(long int)cd); cerr << endl;
	*cd = defCard;				// default Card
	// while bytes remain...
	while (bytesleft > 0) {
		// scan for field specifier
		while (*str != '%' && bytesleft > 0) { str++; bytesleft--; }
		// skip over specified prefix
		str++; bytesleft--;
		// while there still are bytes...
		if (bytesleft <= 0) break;
		// fan out based on field key
		switch (*str++) {
			case 'A': cd->author = str;  break;
			case 'T': cd->title  = str;  break;
			case 'P': cd->publisher = str;  break;
			case 'C': cd->city = str;    break;
			case 'V': cd->vol = atoi(str); break;
			case 'Y': cd->year = atoi(str); break;
			case 'D': cd->description = str; break;
			case 't': cd->type = (enum CardType) *str;
		}
		// count specifier
		bytesleft--;
		// find strlen plus nul byte
		int slen = strlen(str) + 1;
		// update counter and pointer
		bytesleft -= slen;
		str += slen;
		// EOR marker?
		if (*str == '\n') break;
	}
	// return new Card* pointer
	return cd;
}

// Create a fresh record from a Card
void CardRecord::CreateRecord(const Card* incard)
{
	static char vstr[20], ystr[20];		// temp strings for numerics

	//cerr << "*** CardRecord::CreateRecord: incard = "; cerr.form("0x%08x",(long int)incard); cerr << endl;
	// form numeric strings
	sprintf(vstr,"%d",incard->vol);
	sprintf(ystr,"%d",incard->year);
	// compute buffer size
	int rsize = 4 +				// "%tT\0"
		strlen(incard->author) + 3 +	// "%Aauthor\0"
		strlen(incard->title) + 3 +	// "%Ttitle\0"
		strlen(incard->publisher) + 3 +	// "%Ppublisher\0"
		strlen(incard->city) + 3 +	// "%Ccity\0"
		strlen(incard->description) + 3 +	// "%Ddescription\0"
		strlen(vstr) + 3 +		// "%Vnnnn\0"
		strlen(ystr) + 3 +		// "%Ynnnn\0"
		strlen("\n") + 1;		// "\n\0"
	// allocate a string
#ifdef __DMALLOC_H__
	_dmalloc_file = __FILE__; _dmalloc_line = __LINE__;
#endif
	char* str = new char[rsize]; char* p = str;
	// pack data into the string
	*p++ = '%'; *p++ = 't'; *p++ = incard->type;  *p++ = 0;
	*p++ = '%'; *p++ = 'A'; strcpy(p,incard->author); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'T'; strcpy(p,incard->title); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'P'; strcpy(p,incard->publisher); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'C'; strcpy(p,incard->city); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'D'; strcpy(p,incard->description); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'V'; strcpy(p,vstr); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'Y'; strcpy(p,ystr); p += strlen(p) + 1;
//	cerr.form("*** before *p++ = '\\n'; *p++ = 0;: p = 0x%08x\n",(long) p);
	*p++ = '\n'; *p++ = 0;
//	cerr.form("*** after  *p++ = '\\n'; *p++ = 0;: p = 0x%08x\n",(long) p);
	// free up old buffer
	RawData.NewBuffer(0);
	// paste in new buffer
	RawData.size = rsize;
	RawData.buffer = str;
}

void CardRecord::UpdateRecord()
{
	CreateRecord(card);
#ifdef __DMALLOC_H__
	_dmalloc_file = __FILE__; _dmalloc_line = __LINE__;
#endif
	delete card;
	card = RecordToCard();
}
