/* -*- Mode: C -*- */
/* PTree.h - Parse Tree structs
 * Created by Robert Heller on Thu Feb 27 20:04:20 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#ifndef _PTREE_
#define _PTREE_
#include <common.h>		// common defs

// Node and Tree classes.  These classes are structures for holding
// parsed expressions used by the print programs to limit output
// to a selected subset (define by a logical expression)
// To avoid pounding on the simple heap memory management, Nodes and
// Trees are allocated 100 at a time (upto a max of 1,000 each), and
// "old" nodes and trees are reused, rather than returned to the
// general heap.

enum NodeTypes {IntNode, StringNode, TreeNode, FieldNode,
	       CardTypeNode};				// nodetypes
enum Operators {Equal, Less, Greater, LessEqual,
		GreaterEqual, NotEqual, And, Or, Not};	// operators
enum Fields {TypeField, AuthorField, TitleField, PublisherField, CityField,
	     VolumeField, YearField};			// fields

class Tree;		// forward decl
class Node {
#ifdef MYSTORAGE
	const blocksize = 100;	// number of nodes to allocate at a time
	const maxblocks = 10;	// maximum number of blocks to allocate.
	static int numblocks;	// current number of allocated blocks
	static Node* blocks[maxblocks]; // allocated nodes
	static Node* freelist;	// linked list of available nodes
	void   moreblocks();	// internal functio to get another block of nodes
#endif
public:
	NodeTypes type;	// type of node
	union {
		int _int;
		char* _string;
		Tree* _tree;
		Fields _field;
		CardType _ctype;
	} value;	// value
	    Node()	// new node
	       {Node(0);}
	    Node(Fields v) {type = FieldNode; value._field = v;}
	    Node(CardType v) {type = CardTypeNode; value._ctype = v;}
	    Node(int v) {type = IntNode; value._int = v;}
	    Node(char* v) {type = StringNode; value._string = v;}
	    Node(Tree* v) {type = IntNode; value._tree = v;}
#ifdef MYSTORAGE
	void* operator new (long bytes);	// dyn. allocated node
	void  operator delete (void* ptr);	// free a dyn. allocated node
#endif
};

class Tree {
#ifdef MYSTORAGE
	const blocksize = 100;	// number of trees to allocate at a time
	const maxblocks = 10;	// maximum number of blocks to allocate.
	static int numblocks;	// current number of allocated blocks
	static Tree* blocks[maxblocks]; // allocated trees
	static Tree* freelist;	// linked list of available trees
	void   moreblocks();	// internal functio to get another block of trees
#endif
public:
	Operators oper;
	Node* right;
	Node* left;
	      Tree() // new tree
	        {Tree(Equal,0,0);}
	      Tree(Operators o,Node* l,Node* r)
	        {oper = o;right = r; left = l;}
#ifdef MYSTORAGE
	void* operator new (long bytes);	// dyn. allocated node
	void  operator delete (void* ptr);	// free a dyn. allocated node
#endif
};
#endif

