/* -*- Mode: C -*- */
/* LList.h - Line List interface defination
 * Created by Robert Heller on Tue Mar 24 19:15:50 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#ifndef _LLIST_
#define _LLIST_
#include <common.h>		// common defs

// LineList class.  This class is a linked-list of lines of text.
// To avoid pounding on the simple heap memory management,  LineLists are
// allocated 100 at a time (upto a max of 100,000 LineListss), and "old"
// LineListss are reused, rather than returned to the general heap.

const LineLength = 128;		// max length of a line

class LineList {
#ifdef MYSTORAGE
	const blocksize = 100;	// number of LineListss to allocate at a time
	const maxblocks = 1000;	// maximum number blocks to allocate
	static int numblocks;	// current number of allocated blocks
	static LineList* blocks[maxblocks]; // allocated LineLists
	static LineList* freelist;	// linked list of available LineLists
	void   moreblocks();	// internal function to get another block of LineLists
#endif
public:
	char thisline[LineLength];	// current line
	LineList* nextline;		// next line
	LineList* prevline;		// prev line
	      LineList()		// New blank LineList
		{LineList("",(LineList*) 0,(LineList*) 0);}
				// New initialized LineList
	      LineList(char* line) {LineList(line,(LineList*)0,(LineList*)0);}
	      LineList(char* line,LineList* next,LineList* prev)
			{
				strncpy(thisline,line,LineLength);
				thisline[LineLength-1] = 0;
				nextline = next;
				prevline = prev;
				if (next != (LineList*) 0) next->prevline = this;
				if (prev != (LineList*) 0) prev->nextline = this;
			}
#ifdef MYSTORAGE
	void* operator new (long bytes);	// dyn. allocated LineList
	void  operator delete  (void* ptr);	// free a dyn. allocated LineList
#endif
};
extern void FreeLineList(LineList* l);
#endif

