/*ͻ*\
   Filename:  \FILE\LOADALL.CPP                 
   Name:      John Wiggins                      
   Course:    Programming II                    
   Function:  Loads records using linked lists. 
\*ͼ*/
#include <stdio.h>
#include "medusa.h"
// Includes event.h & string.h
#include "windw.h"
// Includes dos.h
#include "mous.h"

void LoadAll(ProgramPtr &ProgramHead)
{
  // Repeat flag.
  int repeat = TRUE;
  // Linked list pointers.
  ProgramPtr CurrentProgram = NULL, TempProgram = NULL;
  ProgramHead = NULL;
  // ~~~~~~~~~~~~ File Stuff ~~~~~~~~~~~~~~~~ \\
  FILE *FilePtr;
  // Open database file.
  FilePtr = fopen("data\\program.dat", "rb");
  // Dispatch error message.
  if (!FilePtr)
    FileError('O', "program.dat");
  while (repeat)
  {
    // Create new program_info record.
    TempProgram = new program_info;
    if (fread(TempProgram, sizeof(program_info), 1, FilePtr)  != 1)
    {
      delete TempProgram;
      // Break out of loop.
      repeat = FALSE;
    }
    else
    {
      // If head of program list hasn't been defined, create it.
      if (!ProgramHead)
      {
	ProgramHead = TempProgram;
	ProgramHead->prev = NULL;
	ProgramHead->next = NULL;
      }
      // If program info header has been defined, create new node...
      else
      {
	CurrentProgram = ProgramHead;
	while (CurrentProgram->next != NULL)
	  CurrentProgram = CurrentProgram->next;
        // ...and store it in struct.
	CurrentProgram->next = TempProgram;
	TempProgram->prev = CurrentProgram;
	TempProgram->next = NULL;
      }
    }
    // End else thingy.
  }
  // End while loop.
  if (fclose(FilePtr))
    FileError('C', "program.dat");
}
