/*
 * Assembler core
 *
 * Copyright (c) 1996 LADSOFT
 *
 * David Lindauer, camille@bluegrass.net
 *
 * Core for a retargetable assembler
 *
 * This program may be freely used and redistributed, as long as the 
 * copyright notice remains intact.  The author holds no liabilty;
 * all risks, both direct and consequential, are the responsibilty of
 * the user.  You use this program at your own risk!
 *
 */
/*
 * ds.c
 * define space
 *
 */
#include <stdio.h>
#include "utype.h"
#include "asm.h"
#include "input.h"
#include "gencode.h"

extern long org;
extern BYTE pcbuf[BUFLEN];
extern int opcodesize;
extern int sectionnum;
extern BYTE setequval[12];
extern BOOL setequ;
extern BOOL ifskip;

/* elements are on the same type of DC list as in dc.c */
/* Now we process them */
void processds(int type, EXPRESSION *label, EXPRESSION *exp)
{
	long mul;
	if (ifskip) {
		delexpr(exp,0);	
		dolist();
		return;
	}
	if (type != TBYTE)
		align();
	switch (type) {
		case TBYTE:
		default:
			mul = 1;
			break;
		case TWORD:
			mul = 2;
			break;
		case TLONG:
			mul = 4;
			break;
	}
	if (!numericExpression(exp) || !exp->isdef || exp->isextern || exp->relmode || exp->x.value < 0) {
		Error("Illegal expression in DS statement");
	}
	if (exp->x.value < 0)
		exp->x.value = 0;
	mul *= exp->x.value;
  delexpr(exp, 0);
	if (mul == 0 && sectionnum)
		align();
  if (!sectionnum) {
		setequ = TRUE;
		*((long *)setequval) = org;
	}
	dolist();
	if (label) {
		label->size = mul;
		label->x.value = org;
	}
	org += mul;
}