#include <stdio.h>
#include <string.h>
#include "cmdline.h"
#include "umem.h"
#include "module.h"
#include "lib.h"
#include "libm.h"
#include "errors.h"
#include "dict.h"

extern HASHREC **publichash;
extern long liboffset;
extern int procrevision;
extern BOOL prm_case_sensitive;
extern BOOL docopy;
extern LIST *objlist;			/* List of object files */
extern LIST *attriblist;
extern MODULE *modules;

extern long dictofs, dictpages, pagesize, modulecount;

void ReadLib(int maxmode,char *libname)
{
	FILE *lib;
	if (!(lib = fopen(libname,"rb"))) {
		if (maxmode & (MD_DELETE | MD_EXTRACT))
			fatal("Missing library file %s", libname);
	}
	else {
		uint command;
		long pv;
		int i;
		long ofs, pages, pagesize, modulecount;
		char mode;
		docopy = FALSE;
		SetForRead(lib);
		command = ReadChar() + (ReadChar() << 8);
		if (command != 0x534c)
			fatal("Not a library %s", libname);
		pv = ReadNumber(0);
		CheckForComma(TRUE);
		ofs = ReadNumber(0);
		CheckForComma(TRUE);
		pages = ReadNumber(0);
		CheckForComma(TRUE);
		pagesize = ReadNumber(0);
		CheckForComma(TRUE);
		modulecount = ReadNumber(0);
		CheckForComma(TRUE);
		mode = ReadChar();
		CheckForPeriod();
		UnsetForRead();
		if (pv > procrevision)
			procrevision = pv;
		if (mode == 'N') {
			if (prm_case_sensitive)
				Error("Library not case sensitive");
			prm_case_sensitive = FALSE;
		}
		docopy = TRUE;
		for (i=0; i < modulecount; i++) {
			long t;
			ReadModule(lib,FALSE);
			t = liboffset % pagesize;
			t = t ? pagesize - t : 0;
			docopy = FALSE;
			while (t--)
				ReadChar();
			docopy = TRUE;
		}
		if (maxmode & (MD_INSERT | MD_DELETE)) {
			long zero = 0;
			char buffer[100];
			FILE *bakfile;
			char iobuf[512];
			fsetpos(lib,&zero);
			strcpy(buffer, libname);
			StripExt(buffer);
			AddExt(buffer,".bak");
			if (!(bakfile = fopen(buffer,"wb")))
				fatal("Could not open backup file");
			while (!feof(lib)) {
				int size = fread(iobuf,1,512,lib);
				fwrite(iobuf,1,size,bakfile);
			}
			fclose(bakfile);
		}
		fclose(lib);
	}
}
void Extract(int maxmode, char *libname)
{
	LIST *o = objlist, *a = attriblist;
	while (o) {
		int attrib = (int) a->data;
		if (attrib & MD_EXTRACT) {
			char buf[100];
			MODULE *m = modules;
			strcpy(buf,o->data);
			StripExt(buf);
			while(m) {
				if (!strncmp(buf,m->name, strlen(buf)) && m->name[strlen(buf)] == '.')
					break;
				m = m->link;
			}
			if (!m)
				Error("Module %s does not exist in library",buf);
			else {
				FILE *out;
				long offset = 0, size = m->len;
				AddExt(buf, ".o");
				if (!(out = fopen(buf,"wb")))
					fatal("Can't open %s for write", buf);
				while(size--)
					fputc(*(char *)PtrToEMSMem(m->data, offset++), out);
				fclose(out);
			}
		}
		o = o->link;
	}
}
void Insert(int maxmode, char *libname)
{
	LIST *o = objlist, *a = attriblist;
	while (o) {
		int attrib = (int )a->data;
		if (attrib & MD_INSERT) {
			char buf[100];
			MODULE *m = modules;
			strcpy(buf,o->data);
			StripExt(buf);
			while(m) {
				if (!strncmp(buf,m->name, strlen(buf)) && m->name[strlen(buf)] == '.')
					break;
				m = m->link;
			}
			if (m)
				Error("Module %s exists in library",buf);
			else {
				FILE *f = fopen(o->data, "rb");
				if (!f)
					Error("Can't open input module %s",o->data);
				else {
					ReadModule(f,TRUE);
					fclose(f);
				}
			}
		}
		o = o->link;
	}
}
void Delete(int maxmode, char *libname)
{
	LIST *o = objlist, *a = attriblist;
	while (o) {
		int attrib = (int) a->data;
		if (attrib & MD_DELETE) {
			char buf[100];
			MODULE *m = modules, **r = &modules;
			strcpy(buf,o->data);
			StripExt(buf);
			while(m) {
				if (!strncmp(buf,m->name, strlen(buf)) && m->name[strlen(buf)] == '.')
					break;
				r = &m->link;
				m = m->link;
			}
			if (!m)
				Error("Module %s does not exist in library",buf);
			else {
				MODULE *p = m;
				int i;
				for (i=0; i < HASH_TABLE_SIZE; i++) {
					HASHREC **p = &publichash[i];
					while (*p) {
						PUBLIC * r = *p;
						if (r->mod == m) {
							*p = r->link;
							DeallocateMemory(r->name);
							DeallocateMemory(r);
						}
						else
							p = &r->link;
					}
				}
				*r = m->link;
				DeallocateMemory(p->name);
				DeallocateEMSMemory(p->data);
				DeallocateMemory(p);
			}
		}
		o = o->link;
	}
}
void OutputLibrary(char *libname)
{
	FILE *lib;
	if (!modules)
		return;
	lib = fopen(libname,"wb");
	if (!lib)
		Error("Can't open dictionary %s for write", libname);
	else {
		char ch = 'N';
		int i;
		MODULE *m = modules;
		long libofs = 32;
		if (prm_case_sensitive)
			ch = 'C';
		fprintf(lib,"LS%1x,%06lX,%04lX,%04lX,%06lX,%c.\r\n", procrevision,
			dictofs,dictpages, pagesize,modulecount, ch);
		for (i=0; i < modulecount; i++) {
			long offset = 0, size = m->len;
			long t;
			while(size--) {
				fputc(*(char *)PtrToEMSMem(m->data, offset++), lib);
				libofs++;
			}
			t = libofs % pagesize;
			t = t? pagesize-t : 0;
			while (t--) {
				fputc('*',lib);
				libofs++;
			}
			m = m->link;
		}
		WriteDictionary(lib);
		fclose(lib);
	}
}