#include <stdio.h>
#include <string.h>
#include "cmdline.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "motorola.h"

extern int prm_motoaddress,prm_useoffset,prm_successive;
extern long entrypoint;
extern BOOL hasentry;

static long offset,baseoffset;
static void putdatarec(FILE *file, BYTE *data, int datalen, long offset)
{
	int cs = 0,i;
	int len = datalen + 1+1+prm_motoaddress;
	cs += offset &255;
	cs += (offset >>8) & 255;
	cs += len;
	switch(prm_motoaddress) {
		case 1:
			fprintf(file,"S1%02X%04X",len,offset);
			break;
		case 2:
			fprintf(file,"S2%02X%06lX",len,offset&0xffffff);
			cs += (offset >>16) & 255;
			break;
		case 3:
			fprintf(file,"S3%02X%08lX",len,offset);
			cs += (offset >>16) & 255;
			cs += (offset >>24) & 255;
			break;
	}
	for (i=0; i < datalen; i++) {
		fprintf(file,"%02X",data[i]);
		cs += data[i];
	}
	cs = 255-(cs & 255);
	fprintf(file,"%02X\r\n",cs);
}
static void putendrec(FILE *file)
{
	int cs = 0;
	cs += entrypoint &255;
	cs += (entrypoint >>8) & 255;
	cs += 3; /* record size */
	switch(prm_motoaddress) {
		case 1:
			fprintf(file,"S903%04lX",entrypoint);
			break;
		case 2:
			cs += 1+ (entrypoint >>16) & 255;
			fprintf(file,"S804%06lX",entrypoint);
			break;
		case 3:
			cs += 1+ (entrypoint >>16) & 255;
			cs += 1+ (entrypoint >>24) & 255;
			fprintf(file,"S705%08lX",entrypoint);
			break;
	}
	cs = 255-(cs & 255);
	fprintf(file,"%02X\r\n",cs);
}
static void putheader(FILE *file, char *name)
{
	int cs = 0,i;
	int len = strlen(name)+5;
	cs +=len ;
	fprintf(file,"S0%02X0000",len);
	for (i=0; i<strlen(name); i++) {
		cs += name[i];
		fprintf(file,"%02X",name[i]);
	}
	cs = 255-(cs & 255);
	fprintf(file,"%02X\r\n",cs);
}
void MotorolaInit(char *name,FILE *file)
{
			offset = 0;
			baseoffset = 0;
			putheader(file,name);
}
void MotorolaRundown(FILE *file)
{
			putendrec(file);
}
void OutputMotorolaHex(SECTION *q, char *overlay, FILE *file)
{
			if (!hasentry) {
				entrypoint = q->base;
				hasentry = TRUE;
			}
			offset = 0;
			if (prm_useoffset)  
				baseoffset = q->base;
			if (prm_successive)
				prm_useoffset = FALSE;
			while (q->size) {
				long size = q->size <= 16 ? q->size : 16;
				BYTE *t = PtrToEMSMem(q->buffer, offset);
				putdatarec(file,t,size,baseoffset + offset);
				q->size -= size;
				offset += size;
			}
		baseoffset +=offset;
}