/* Power Render File Interface */

#ifndef _PRFILE_
#define _PRFILE_

#ifdef __cplusplus
  extern "C" {
#endif

#define LOAD_NORMAL 0
#define LOAD_IGNORE_MATERIALS 1
#define LOAD_IGNORE_TABLES 2
#define LOAD_IGNORE_TEXTURES 4

#define SAVE_USED_MATERIALS 0
#define SAVE_ALL_MATERIALS 1

#define MAX_TABLE_PER_FILE 32
#define MAX_TEXTURE_PER_FILE 256
#define MAX_MATERIAL_PER_FILE 512

extern PR_DWORD LPRO_ImportTableCount;
extern PR_DWORD LPRO_ImportMaterialCount;
extern PR_DWORD LPRO_ImportTextureCount;

extern PR_DWORD PR_BaseMaterialColor;
extern PR_DWORD PR_BaseMaterialNumber;
extern char L3DS_TextureExtension[5];



void PR_CreateMaterialPalette (void);
/* -----------------------------------------------------------------------
   Function:   PR_CreateMaterialPalette
   Purpose:    Builds a palette based on the materials in a 3D file
               (Changes global_palette)
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


PR_OBJECT *PR_LoadLWO (char *filename, PR_REAL scale, PR_DWORD flags);
/* -----------------------------------------------------------------------
   Function:   PR_LoadLWO
   Purpose:    Loads a LWO file into an object
   Parameters: filename - Filename of the LWO file to load
               scale - Multiplied to every vertex
               flags - Loading flags
   Return:     Pointer to the new object
   ----------------------------------------------------------------------- */


PR_OBJECT *PR_LoadPRO (char *filename, PR_DWORD flags);
/* -----------------------------------------------------------------------
   Function:   PR_LoadPRO
   Purpose:    Attempts to load a PRO file into a new object
   Parameters: filename - Name of the PRO file to load
               flags - Loading flags
   Return:     Pointer to the new object
   ----------------------------------------------------------------------- */


PR_DWORD PR_SavePRO (char *filename, PR_OBJECT *obj, PR_DWORD options);
/* -----------------------------------------------------------------------
   Function:   PR_SavePRO
   Purpose:    Attempts to save a PRO file given an object
   Parameters: filename - File to save
               obj - Pointer to the object
               options - Save options
   Return:     1 if successful, 0 otherwise
   ----------------------------------------------------------------------- */


PR_OBJECT *PR_Load3DS (char *filename, PR_REAL scale, PR_DWORD flags);
/* -----------------------------------------------------------------------
   Function:   PR_Load3DS
   Purpose:    Loads a 3DS file into an object
   Parameters: filename - Filename of the 3DS file to load
               scale - Multiplied to every vertex
               flags - Loading flags
   Return:     Pointer to the new object
   ----------------------------------------------------------------------- */


#ifdef __cplusplus
}
#endif

#endif
