#ifndef _PRERROR_            
#define _PRERROR_         /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif

#define PR_SUCCESS                                0
#define PR_OUT_OF_MEMORY                         -1
#define PR_READ_ERROR                            -2
#define PR_WRITE_ERROR                           -3

#define TEXTURE_NOT_FOUND                        -4
#define TEXTURE_OUT_OF_SPACE                     -5
#define TEXTURE_DELETED                          -6
#define TEXTURE_LOAD_ERROR                       -7
#define TEXTURE_ALREADY_LOADED                   -8

#define TABLE_NOT_FOUND                          -9
#define TABLE_OUT_OF_SPACE                       -10
#define TABLE_DELETED                            -11
#define TABLE_LOAD_ERROR                         -12
#define TABLE_ALREADY_LOADED                     -13

#define MATERIAL_NOT_FOUND                       -14
#define MATERIAL_OUT_OF_SPACE                    -15
#define MATERIAL_DELETED                         -16


#define REPORT_ERRORS 1
#define REPORT_ACTIONS 2
extern  PR_DWORD PR_DebugFlag;          /* Tells what should be reported */


void PR_DebugMessage (char *message, char *info);
/* -----------------------------------------------------------------------   
   Function:   PR_DebugMessage
   Purpose:    Appends a debug message to the debug file
   Parameters: message - The text written to the debug file
               info - Secondary info written in parentheses
                      If NULL, parentheses are not written.
   Return:     None
   ----------------------------------------------------------------------- */


void PR_FatalError (char *str, char *title);
/* -----------------------------------------------------------------------
   Function:   PR_FatalError
   Purpose:    Prints an error message and stops the program
   Parameters: str - String to print
			   title - Window title (win32 only)
   Return:     None
   ----------------------------------------------------------------------- */

void PR_ReportError (PR_DWORD error, char *info);
/* -----------------------------------------------------------------------
   Function:   PR_ReportError
   Purpose:    Converts an error or message code into a string, and writes it to
               the debug file
   Parameters: error - Error number
               Additional error information (line numbers, proc names etc)
   Return:     None
   ----------------------------------------------------------------------- */


void PR_SetDebugFile (char *filename, PR_DWORD debugflags);
/* -----------------------------------------------------------------------
   Function:   PR_SetDebugFile
   Purpose:    Sets the name of the debug file and flags to use 
   Parameters: filename - File to use for debug text logging
               debugflags - Debugging flags
   Return:     None
   ----------------------------------------------------------------------- */


void PR_SetDebugFlag (PR_DWORD flag);
/* -----------------------------------------------------------------------
   Function:   PR_SetDebugFlag
   Purpose:    Sets the debug flags 
   Parameters: flag (REPORT_ERRORS or REPORT_ACTIONS)
   Return:     None
   ----------------------------------------------------------------------- */


#ifdef __cplusplus
}
#endif

#endif

