/*  This file contains filters. There are 3x3 kernel digital filters

*/

#ifndef __FILTER_H_
#define __FILTER_H_

#include "graphpp.h"
#include "gbuf.h"
//#include "tools.h"

extern void filter(int** kernel, rect coord);    // digital filter
extern void color_filter(int* kernel, rect coord);    // digital filter

extern void dither_BW(int* threshold, rect coord, loc dim);  // digital halftoning using
						       // pattern mask
extern void dither_BW(int* threshold, rect coord, loc dim,
			  GrafBuffer* buf);

// 16 color -> B/W using error propagation
extern void error_dither(rect coord);
extern void error_dither_buf(GrafBuffer* buf, rect coord);

#endif __FILTER_H_