#include "kh_draw.h"
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "global.h"
#include <dos.h>
#include "ask_hot.h"             // not library - application only file.
				 // Button which may be hidden and macros append
				 // function


enum { SAVE = 1, DONT_SAVE };  // picture status

enum { FILE_NEW = 30, FILE_OPEN, FILE_SAVE, FILE_SAVE_AS_BW, FILE_PRINT,
       FILE_COPY_FROM, FILE_COPY_TO, FILE_COPY_TO_BW, FILE_FONT,
       SCRIPT_PLAY, SCRIPT_RECORD, SCRIPT_END, MACROS_KEEP, TEXT_EDIT };

//void get_dir();    // gets list of files
////////////////////
void file_refresh()     // used to get previous script name from stack
    {
    scriptMode = GO;
    delete scriptFileName;
    scriptFileName = NULL;
    mac_status mac = macros_pop();         // obtain previous status
    delete mac.file;
    }
//////////////////
void KH_Draw::prepare_files()
    {
    delete global[1]; delete global[2];
    global[1] = strdup("work"); global[2] = strdup("");
    (file_sys->file_system)->setItems();
    }
//////////////////
void KH_Draw::askSave()
    {
    if(!(draw->draw)->saved && ask_save())    // YES
	(draw->draw)->save();
    draw->draw->saved = 1;
    }
//////////////////////
void about()
    {
    Board* board = new Board(rect(5, 5, 65, 20), "about.pcz",
              "about.pcy", "A B O U T", 8, 0, 16);
    board->show_window();

    Icon i(loc(1, 1), 2, LARGE_ICON, SHOW_BORDER);
    char* file = i.icon_open();

    FILE *stream;
    if((stream = fopen(file, "r+b")) == NULL)
	return;
    loc size = icon_size(LARGE_ICON);
    int i_size = ((size.X + 1 + 7) >> 3 << 2) * (size.Y + 1) + sizeof(imageP);
    imageP image = (imageP)malloc(i_size + 10);
    while(1)
        {
        for(int j = 1; j < 9; j++)
            {
            get_image(stream, j, image, i_size);
            putimage(screenXL(8), screenYT(8), image, COPY_PUT);
            delay(20);
            if(eventavail(KEYEVENT | MOUSEEVENT,
	    	   MCleftDn | MCrightDn))
                break;
            }
        if(eventavail(KEYEVENT | MOUSEEVENT,
	    	   MCleftDn | MCrightDn))
                break;
        }
    get_event();
    fclose(stream);
    delete image;
    board->hide();
    delete board;
    }
//////////////////////
int KH_Draw::application(int n)
    {
    rect r = (draw->draw)->user_screen();
    loc mspos = e.where();
    loc minsize = loc(20, 20);
    rect work;

    char** editList = edit_menu->menu->getItemStrings(); // We use pointer to
                                                   // modify menu items.
    sound(100); delay(100); nosound();

    if(n >= AC_LINE_1 && n <= AC_LINE_6)
	{
	DATA_LINE = n - AC_LINE_1 + 1;
	return 1;
	}

    if(n >= AC_BLACK && n <= AC_WHITE)    // set color
	{
	setcolor(DATA_ATTR = n - AC_BLACK);
        global_i[6] = DATA_ATTR;
        global_i[7] = DATA_BAK;
	return 0;
	}
    if(n >= AC_BLACK1 && n <= AC_WHITE1)     // set background color
	{
        global_i[6] = DATA_ATTR;
        global_i[7] = DATA_BAK;
	setfillstyle(SOLID_FILL, DATA_BAK = n - AC_BLACK1);
	return 0;
	}
    if(n >= AC_FILL1 && n <= AC_FILL48)    // set fill pattern
	{
	DATA_FILL = n - AC_FILL1;
	return 1;
	}
    if(n >= AC_SIZE1 && n <= AC_SIZE2)    // it is font size
	{
	DATA_SIZE = (n - AC_SIZE1 + 1);
	return 1;
	}

    if(n >= AC_BUFFER_SIZE && n <= AC_BUFFER_SIZE7)
	{
	WindowManager::hide_window();    // "buffer_size"
	WindowManager::hide_window();    // "file_menu"
	askSave();
	DATA_BUFFER_SIZE = n - AC_BUFFER_SIZE + 1;

	switch(DATA_BUFFER_SIZE)
	    {
	    case 1:
		buffer->buf_dim.X = getmaxx() + 2;
		buffer->buf_dim.Y = getmaxy() + 2;
		break;
	    case 2:
		buffer->buf_dim.X = 750;
		buffer->buf_dim.Y = 550;
		break;
	    case 3:
		buffer->buf_dim.X = 1900;
		buffer->buf_dim.Y = 2000;
		break;
	    case 4:
		buffer->buf_dim.X = 4001;
		buffer->buf_dim.Y = 4000;
		break;
	    case 5:
		buffer->buf_dim.X = 8001;
		buffer->buf_dim.Y = 8000;
		break;
	    case 6:
		buffer->buf_dim.X = 10001;
		buffer->buf_dim.Y = 16000;
		break;
	    case 7:
		buffer->buf_dim.X = 12001;
		buffer->buf_dim.Y = 20000;
		break;
	    }
	buffer->bound_size.X = buffer->buf_dim.X;
	buffer->bound_size.Y =
	    BOUND_SIZE / (image_size(buffer->bound_size.X, 1, 1, 4));
	(draw->draw)->new_file(r);
	DATA_FILE = FILE_NEW;
	moveTo(1);
	return 0;
	}

    switch(n)
	{
	case AC_MOVE:
	    global_i[0] = AC_MOVE;
	    return 0;
	case AC_RESIZE:
	    global_i[0] = AC_RESIZE;
	    return 0;
	case AC_FILL_PANEL:
	    return 2;

	case AC_FILE_MENU:       // go from line menu to the corresponding
	case AC_EDIT_MENU:       // objects
	case AC_EFFECTS_MENU:
	case AC_TEXT_MENU:
	case AC_METHOD_MENU:
	case AC_SCRIPT_MENU:
	    return 2;
	case AC_PRINT_MENU:
            if(!buffer->loaded)
		return 0;
            if(!DATA_ZOOM)
                {
		mouseHideCursor();
                buffer->b_open();
		buffer->screen_buffer();
                buffer->b_close();
                mouseShowCursor();
                }
	    return 2;

	case AC_EDIT_CUT:
	case AC_COPY:
	case AC_PASTE:
	    DATA_EDIT = n - AC_EDIT_CUT + 1;
	    return 1;
	case AC_COPY_FROM:
	    DATA_EDIT = n - AC_EDIT_CUT + 1;
	    prepare_files();
	    (file_sys->edit)->put_string("*.pcx");
	    DATA_FILE = FILE_COPY_FROM;
	    return 2;
	case AC_COPY_TO:
	    DATA_EDIT = n - AC_EDIT_CUT + 1;
	    prepare_files();
	    (file_sys->edit)->put_string("*.pcx");
	    DATA_FILE = FILE_COPY_TO;
	    return 2;
	case AC_COPY_TO_BW:
	    DATA_EDIT = n - AC_EDIT_CUT + 1;
	    prepare_files();
	    (file_sys->edit)->put_string("*.pcx");
	    DATA_FILE = FILE_COPY_TO_BW;
	    return 2;
	 case AC_ZOOM:
	    if(!buffer->loaded)
		return 1;
	    mouseHideCursor();
	    WindowManager::hide_window();    // "edit_menu";
	    rect r1 = buffer->screen_area;

	    if(!DATA_ZOOM)             // 1:1 image
		{
                editList[6][12] = '*';
		buffer->b_open();
		buffer->screen_buffer();
		draw->draw->new_file(r1, 0);     // clear screen, not buf
		int comp
		    = max((long)100 * buffer->buf_dim.X
		    / buffer->screen_area.width(),
		    (long)100 * buffer->buf_dim.Y
			/ buffer->screen_area.height());

		buffer->screen_position = rect(0, 0,
		    buffer->buf_dim.X - 1, buffer->buf_dim.Y - 1);

		buffer->buffer_screen(loc(comp, comp), loc(100, 100));
		buffer->b_close();
		DATA_ZOOM = comp;
		}
	    else                        // zoomed image
		{
                editList[6][12] = ' ';
		buffer->screen_position
		    = rect(0, 0, buffer->screen_area.width() - 1,
				buffer->screen_area.height() - 1);
		draw->draw->new_file(r1, 0);     // clear screen, not buf
		buffer->b_open();
		buffer->buffer_screen();
		buffer->b_close();
		DATA_ZOOM = 0;
		}
	    moveTo(1);
	    mouseShowCursor();
	    return 0;
	case AC_TRANS:
	    editList[7][12] = DATA_TRANS ? ' ' : '*';
	    DATA_TRANS = !DATA_TRANS;
	    edit_menu->menu->show();
	    return 0;
	case AC_PREVIEW:
	    editList[8][12] = DATA_PREVIEW ? ' ' : '*';
	    DATA_PREVIEW = !DATA_PREVIEW;
	    edit_menu->menu->show();
	    return 0;

	case AC_FILTER1: case AC_FILTER2: case AC_FILTER3: case AC_FILTER4:
	case AC_FILTER5: case AC_FILTER6: case AC_FILTER7: case AC_FILTER8:
	case AC_FILTER9: case AC_FILTER10: case AC_FILTER11:
	case AC_FILTER12: case AC_FILTER13: case AC_FILTER14:
	    WindowManager::hide_window();    // "filters"
            WindowManager::hide_window();    // "effects_menu"
	    DATA_FILTER = n - AC_FILTER1 + 1;
	    moveTo(get(menu));
	    return 0;

	case AC_DITHER1: case AC_DITHER2: case AC_DITHER3: case AC_DITHER4:
	case AC_DITHER5: case AC_DITHER6: case AC_DITHER7: case AC_DITHER8:
	case AC_DITHER9: case AC_DITHER10: case AC_DITHER11:
	case AC_DITHER12: case AC_DITHER13: case AC_DITHER14:
	    WindowManager::hide_window();    // "dithers"
	    WindowManager::hide_window();    // "effects_menu";
	    DATA_DITHER = n - AC_DITHER1;
	    moveTo(get(menu));
	    return 0;

	case AC_NO_GRAD: case AC_HORIZ_GRAD: case AC_VERT_GRAD:
	    WindowManager::hide_window();    //grads->hide();
	    WindowManager::hide_window();    //effects_menu->hide();
	    DATA_GRAD = n - AC_NO_GRAD;
	    moveTo(get(menu));
	    return 0;

	case AC_NO_ERROR_PROP: case AC_ERROR_PROP_ON:
	    WindowManager::hide_window();    //error_prop->hide();
	    WindowManager::hide_window();    //effects_menu->hide();
	    DATA_ERROR_PROP = n - AC_NO_ERROR_PROP;
	    moveTo(get(menu));
	    return 0;

	case AC_TOOLS_1: case AC_TOOLS:        // go here from "methods menu"
	case AC_COLORS:
	case AC_BAKS: case AC_FILL_PROMPT:
	case AC_DRAW:
	    return 2;

	case AC_FILTERS: case AC_DITHERS: case AC_GRADS: case AC_ERROR_PROP:
	    return 2;

	case AC_TOOL_UNDO:
	    DATA_TOOLS = TOOL_UNDO;
	    return 0;
	case AC_FILTER:
	    DATA_TOOLS = TOOL_FILTER;
	    return 0;
	case AC_DITHER:
	    DATA_TOOLS = TOOL_DITHER;
	    return 0;
	case AC_TEXT:
	    DATA_TOOLS = TOOL_TEXT;
	    return 0;
	case AC_SCROLL:
	    DATA_TOOLS = TOOL_SCROLL;
	    return 0;

	case AC_LOCAL_UNDO:
	    DATA_TOOLS = TOOL_LOCAL_UNDO;
	    return 0;
	case AC_HORIZ:          // set text directions
	    DATA_DIR = 0;
	    return 1;
	case AC_VERT:
	    DATA_DIR = 1;
	    return 1;
	case AC_LINE_WIDTH:        // special case, continue after it.
	    return 2;          // Here represents next menu with line width
	case AC_MICROSCOPE_2:
	    set_call(micro, draw);
	    return 1;
	case AC_MICROSCOPE:                    // go to microscope
	    DATA_TOOLS = TOOL_MICRO;
	    global_i[6] = DATA_ATTR;
	    global_i[7] = DATA_BAK;
	    r_draw_size = draw->draw->user_screen();
	    return 2;

	case AC_SCISSORS:
	    DATA_TOOLS = TOOL_SCISSORS;
	    return 0;
	case AC_ERASER:
	    DATA_TOOLS = TOOL_ERASER;
	    return 0;
	case AC_COLOR_ERASER:
	    DATA_TOOLS = TOOL_COLOR_ERASER;
	    return 0;
	case AC_FILL:
	    DATA_TOOLS = TOOL_FILL;
	    return 0;
	case AC_RECTANGLE:
	    DATA_TOOLS = TOOL_RECTANGLE;
	    return 0;
	case AC_CIRCLE:
	    DATA_TOOLS = TOOL_CIRCLE;
	    return 0;
	case AC_LINE:
	    DATA_TOOLS = TOOL_LINE;
	    return 0;
	case AC_PEN:
	    DATA_TOOLS = TOOL_PEN;
	    return 0;

	case AC_PRINT:
// Remark the following code if you do not use Print Manager
	    if(!buffer->loaded)
		return 1;
	    buffer->b_open();
	    print->set_type(form->p_t);
	    print->set_density(form->d);
	    print->set_pass(form->pas);
	    print->set_comp(form->m_x, form->m_y,
		form->d_x, form->d_y);
	    print->set_left(form->l);
	    print->set_paper(form->pap);
            for(int cop = 0; cop < form->cop && !kbhit(); cop++)
                print->draw_pages(buffer, "_work1.buf");
	    buffer->b_close();
	    return 1;
	case AC_TEXT_SIZE:                      // go here from "size_menu"
	case AC_TEXT_DIR:
	    return 2;
	case AC_TEXT_FONT:
	    prepare_files();
	    (file_sys->edit)->put_string("*.sfp");
	    DATA_FILE = FILE_FONT;
	    return 2;
	case AC_NEW:
	    prepare_files();
	    return 2;
	case AC_OPEN:
	    if(DATA_ZOOM)
		return 1;
	    prepare_files();
	    (file_sys->edit)->put_string("*.pcx");
	    DATA_FILE = FILE_OPEN;
	    return 2;
	case AC_SAVE:
	    prepare_files();
	    (file_sys->edit)->put_string("*.pcx");
	    DATA_FILE = FILE_SAVE;
	    return 2;
	case AC_SAVE_AS_BW:
	    prepare_files();
	    (file_sys->edit)->put_string("*.pcx");
	    DATA_FILE = FILE_SAVE_AS_BW;
	    return 2;
	case AC_ABOUT:
	    about();
            return 1;

	case AC_SCRIPT_PLAY:
	    if(DATA_ZOOM)
		return 1;
	    DATA_FILE = SCRIPT_PLAY;
	    prepare_files();
	    (file_sys->edit)->put_string("*.sc");  // set mask for file system
	    return 2;
	case AC_SCRIPT_RECORD:                          // recording of script
	    if(DATA_ZOOM)
		return 1;
	    prepare_files();
	    DATA_FILE = SCRIPT_RECORD;
	    (file_sys->edit)->put_string("*.sc");
	    return 2;
	case AC_SCRIPT_END:                        // end of script recording.
	    DATA_FILE = SCRIPT_END;
	    file_refresh();
	    return 1;
	case AC_MACROS_KEEP:
	    DATA_FILE = MACROS_KEEP;

	    if(scriptMode == PLAY)
		{
		scriptMode = GO;
		return 1;
		}

	    file_refresh();
	    prepare_files();
	    (file_sys->edit)->put_string("*.sc");

	    return 2;

	case AC_EDITOR:
	    DATA_FILE = TEXT_EDIT;
	    file_refresh();
	    prepare_files();
	    (file_sys->edit)->put_string("*.sc");
	    return 2;

	case AC_ASK_EXIT:
	    askSave();
	    return ask_exit();

        case AC_TEXT_EDIT:
//            editor->hide();
            moveTo(1);
            return 0;

	case AC_FILE:
            if(DATA_FILE != TEXT_EDIT)
                WindowManager::hide_window();    // file_sys->hide();
	    if(DATA_FILE != FILE_COPY_FROM && DATA_FILE != FILE_COPY_TO
	       && DATA_FILE != FILE_COPY_TO_BW
	       && DATA_FILE != TEXT_EDIT)
		WindowManager::hide_window();    // file_menu->hide();
						 // script_menu->hide();
						 // text_menu->hide();
	    if(DATA_FILE == FILE_OPEN)
		askSave();

//	    set_call(file_sys, draw);
	    switch(DATA_FILE)
		{
		case TEXT_EDIT:
		    editor->set_call(1);
		    editor->write->set_swap(global[global_i[1]]);
//		    editor->write->load_file();        // to be corrected
		    return 2;

		case FILE_OPEN:                         // load
		    unlink(buffer->file_name);
		    buffer->buf_dim.X = 750;
		    buffer->buf_dim.Y = 550;
		    buffer->bound_size.X = buffer->buf_dim.X;
		    buffer->bound_size.Y =
			    BOUND_SIZE / (image_size(buffer->bound_size.X, 1, 1, 4));

		    (draw->draw)->new_file(r);
		    (draw->draw)->load();
		    moveTo(1);
		    return 0;
		case FILE_FONT:
		    delete fontName;
		    fontName = strdup(global[global_i[1]]);
		    moveTo(1);
		    return 0;

		case FILE_SAVE:                         // save
		    (draw->draw)->save();
		    moveTo(1);
		    return 0;
		case FILE_SAVE_AS_BW:                   // save BW
		    (draw->draw)->save();
		    pcx_col_to_bw(global[global_i[1]], "tmp____u.pcy");
		    unlink(global[global_i[1]]);
		    rename("tmp____u.pcy", global[global_i[1]]);
		    moveTo(1);
		    return 0;

		case FILE_COPY_FROM:                         // COPY FROM
		    if(!buffer->loaded)
			return 1;

		    rect reserv1 = r;
		    rect reserv = r;
		    r.origin.X += 8 - r.origin.X % 8;

		    if(!DATA_ZOOM)
			{
			mouseHideCursor();
			buffer->b_open();
			buffer->screen_buffer();
			buffer->b_close();
			mouseShowCursor();
			}
		    pcxheader p_h;
		    get_pcx_header(global[global_i[1]], &p_h);
		    int xsize = getmaxx() + 2;
		    int ysize = getmaxy() + 2;
		    if((p_h.x2 - p_h.x1 + 1 + 7) / 8 * 8 + 1 > xsize)
			xsize = (p_h.x2 - p_h.x1 + 1 + 7) / 8 * 8 + 1;
		    if(p_h.y2 - p_h.y1 + 8 > ysize)
			ysize = p_h.y2 - p_h.y1 + 8;

		    int z = (DATA_ZOOM > 0)
			? DATA_ZOOM : 100;

		    GrafBuffer* buf1 = new GrafBuffer(loc(xsize, ysize),
			"_work1.buf", r);
		    int comp = (DATA_ZOOM > 0) ?
			max((long)100 * buf1->buf_dim.X
			/ buf1->screen_area.width(),
			(long)100 * buf1->buf_dim.Y
			/ buf1->screen_area.height())
			: 100;

		    buf1->b_open();
		    buf1->clear();
		    pcx_file_buffer(buf1, loc(0, 0), global[global_i[1]]);

/*		    if(DATA_ZOOM)
			r = rect(r.origin,
			    loc(r.origin.X
				+ (long)buf1->buf_dim.X * 100 / comp,
				r.origin.Y
				+ (long)buf1->buf_dim.Y * 100 / comp));
		    buf1->screen_area = r;
                  buf1->screen_position = rect(0, 0,
			buf1->buf_dim.X - 1, buf1->buf_dim.Y - 1);
*/
		    buf1->buffer_screen(loc(comp, comp), loc(100, 100));

		    mouseShowCursor();
		    e = getevent(KEYEVENT | MOUSEEVENT,
			 MCleftDn | MCcenterDn | MCrightDn);
		    mspos = draw->draw->verify_rect(r);
		    mouseHideCursor();
		    work = get_dim(FIG_RECTANGLE, RESIZE, r,
				rect(mspos, mspos + minsize));
		    r = reserv;

		    if(!(work.origin.X == work.corner.X ||
		       work.origin.Y == work.corner.Y))
			buf1->pcx_buffer_file(
				 rect((buf1->screen_position.origin.X +
				     (long)(work.origin.X
				     - buf1->screen_area.origin.X)
				      * comp / 100 + 7) / 8 * 8,
				 buf1->screen_position.origin.Y +
				     (long)(work.origin.Y
				     - buf1->screen_area.origin.Y)
				      * comp / 100,
				 (buf1->screen_position.origin.X +
				     (long)(work.corner.X
				     - buf1->screen_area.origin.X)
				      * comp / 100 + 7) / 8 * 8 - 1,
				 buf1->screen_position.origin.Y +
				     (long)(work.corner.Y
				     - buf1->screen_area.origin.Y)
				      * comp / 100),
				 "copy.pcy");
		    buf1->b_close();
		    delete buf1;

		    buffer->b_open();
		    buffer->buffer_screen(loc(z, z), loc(100, 100));
		    buffer->b_close();
		    setfillpattern(pattern[DATA_FILL],
			DATA_BAK);
		    r = reserv1;
		    moveTo(get(draw));
		    mouseShowCursor();
		    return 0;

		case FILE_COPY_TO:                   // COPY TO
		    if(!buffer->loaded)
			return 1;

		    mouseShowCursor();
		    e = getevent(KEYEVENT | MOUSEEVENT,
			 MCleftDn | MCcenterDn | MCrightDn);
		    mouseHideCursor();
		    draw->draw->cut_copy(global[global_i[1]]);
		    moveTo(1);
		    mouseShowCursor();
		    return 0;
		case FILE_COPY_TO_BW:
		    if(!buffer->loaded)
			return 1;

		    mouseShowCursor();
		    e = getevent(KEYEVENT | MOUSEEVENT,
			 MCleftDn | MCcenterDn | MCrightDn);
		    mouseHideCursor();
		    draw->draw->cut_copy(global[global_i[1]]);
		    pcx_col_to_bw(global[global_i[1]], "tmp____u.pcy");
		    unlink(global[global_i[1]]);
		    rename("tmp____u.pcy", global[global_i[1]]);
		    moveTo(1);
		    mouseShowCursor();
		    return 0;
		case SCRIPT_PLAY:                          // PLAY mode
		    mac_status mac;              // remember old file executed
		    mac.file = scriptFileName
			? strdup(scriptFileName) : NULL;
		    mac.ptr = scriptPtr;
		    mac.mode = scriptMode;

		    fpos_t reserv_pos;
		    fgetpos(scriptPtr, &reserv_pos);
		    mac.pos = reserv_pos;

		    macros_push(mac);        // keep it in the stack

		    delete scriptFileName;
		    scriptFileName = global[global_i[1]]      // if file name
			? strdup(global[global_i[1]]) : NULL; // is set

		    fclose(scriptPtr);
		    fclose(macrosPtr);

		    scriptPtr = fopen(scriptFileName, "r");
		    macrosPtr = fopen(macrosFileName, "r");

		    scriptMode = PLAY;
                    moveTo(1);
		    return 0;
		case SCRIPT_RECORD:                              // RECORD
		    delete scriptFileName;
		    scriptFileName = global[global_i[1]]
			? strdup(global[global_i[1]]) : NULL;
		    scriptPtr = fopen(scriptFileName, "w+");
		    scriptMode = RECORD;
                    moveTo(1);
		    return 0;
		case SCRIPT_END:
		    scriptMode = GO;
		    fclose(scriptPtr);
                    moveTo(1);
		    return 0;

		case MACROS_KEEP:                   // KEEP SCRIPT AS MACROS
		    int hot_result = ask_hot_key();  // (and end record before)

		    if(!hot_result)             // ESC or mouse button pressed
			return 0;

		    scriptFileName = global[global_i[1]]
			? strdup(global[global_i[1]]) : NULL;

		    fclose(scriptPtr);
		    fclose(macrosPtr);

		    scriptPtr = fopen(scriptFileName, "r");
		    macrosPtr = fopen(macrosFileName, "r");

		    FILE* tempPtr = fopen("temp.sc", "w");  // temp file for
							    // duplication
		    char command[22];
		    get_command(command);   // transfer e.key, set by ask_hot_key to command
		    add_macros(command, tempPtr);  // add the macros

		    fclose(tempPtr);
		    fclose(macrosPtr);

		    unlink(macrosFileName);                  // new macros file
		    rename("temp.sc", macrosFileName);
		    macrosPtr = fopen(macrosFileName, "r");

		    init_macros();     // rebuild table of macroses

		    delete scriptFileName;
		    scriptFileName = NULL;
                    moveTo(1);
		    return 0;
		}

	default:
	    return 0;
	}
    }
//////////////////////

