/*
   Module        :  DEMO1.CPP
   Version       :  2.00
   Revision date :  July 3rd, 1993
   Author(s)     :  Rmy Gendron

   Description   :  Short demo program.
*/


// Headers ------------------------------------------------------------------

#include <conio.h>                                      // System's libraries
#include <ctype.h>
#include <dos.h>
#include <stdlib.h>
#pragma hdrstop

#include "evmsgs.hpp"                                        // Other modules
#include "stdfcts.h"
#include "tdesktop.hpp"
#include "tinput.hpp"
#include "tmenubar.hpp"
#include "tstatusline.hpp"
#include "twindow.hpp"

#include "demo1.hcm"                                         // Help contexts


// Prototypes ---------------------------------------------------------------

void about () ;                               // Displays infos on EasyVision
void demowindow () ;                                   // Plays with a window


// --------------------------------------------------------------------------

int main
(
   int  argc,                             // Number of command line arguments
   char *argv[]                    // Array of ptrs to command line arguments
)

{
   input_info ii ;


   desktop.settitle ("EasyVision 2.0  demo program",3,15) ;  // Opens desktop
   desktop.settextmode (C4350,TRUE) ;
   desktop.open () ;
   delay (2000) ;
                                                       // Defines the menubar
   menubar.addmenu ("",'S',"System menu",HC_MENU_SYSTEM) ;
   menubar.additem ("Refresh desktop  Alt-R",'R',II_A_R,
                    "Redraws the screen",HC_MENU_SYSTEM_REFRESH) ;
   menubar.additem () ;
   menubar.additem ("About...         Alt-A",'A',II_A_A,
                    "Shows version and copyright informations",
                    HC_MENU_SYSTEM_ABOUT) ;

   menubar.addmenu ("Demo",'D',"EasyVision's demonstrations",
                    HC_MENU_DEMO) ;
   menubar.additem ("Open window   Alt-O",'O',II_A_O,
                    "Demonstration of an EasyVision window",
                    HC_MENU_DEMO_OPEN) ;
   menubar.additem () ;
   menubar.additem ("Exit demo     Alt-X",'E',II_A_X,
                    "Exits EasyVision's demo",HC_MENU_DEMO_EXIT) ;

   menubar.addmenu ("Examples",'E',"Just an example menu",HC_MENU_EXAMPLES) ;
   menubar.additem ("Dummy off item...  ",'D',II_A_U,
                    "Menu items can be 'offline'",HC_MENU_EXAMPLES_OFFLINE) ;
   menubar.itemsetavail ('E','D',FALSE) ;
   menubar.additem ("Do nothing item... ",'N',II_A_N,
                    "This item is just an example",HC_MENU_EXAMPLES_DUMMY) ;


   ii.key_code = II_NUL ;

   while (ii.key_code != II_A_X)                       // Gets user's command
   {
      statusline.display ("Hit ~Alt-X~ to return to DOS...") ;
      input.get (&ii,0,HC_GENERAL,FALSE) ;
      ii = menubar.through (ii) ;

      if (ii.key_code == II_A_R) desktop.refresh () ;
      if (ii.key_code == II_A_A) about () ;
      if (ii.key_code == II_A_O) demowindow () ;
   }

   desktop.close () ;                                       // Closes desktop


   return 0 ;                                   // Program normal termination
}                                                                 // End main


// --------------------------------------------------------------------------

void about ()                                 // Displays infos on EasyVision

{
   twindow  huge *winptr ;                          // Ptr to a twindow class
   input_info    ii ;                                         // User's input


   winptr = new twindow ;                                 // Creates a window
   assert (winptr != NULL,"about",ev_err[1],1) ;

   winptr->winsetpos (17,21,TRUE) ;                        // Displays window
   winptr->winsetsize (15,40) ;
   winptr->winsettitle ("About") ;
   winptr->winsetcolors (WHITE,BLACK) ;
   winptr->winsethlpctx (HC_WINDOW_ABOUT) ;
   winptr->winopen () ;

   winptr->winwrite ("EasyVision 2.0",2,1,2) ;      // Writes some text in it
   winptr->winwrite ("The easy to use and powerful",4,1,2) ;
   winptr->winwrite ("text mode interface!",5,1,2) ;
   winptr->winwrite ("Copyright (c) 1993 by",7,1,2) ;
   winptr->winwrite ("TNG SOFT",9,1,2) ;
   winptr->winwrite ("The Next Generation Software",10,1,2) ;
                                                          // Creates a button
   winptr->buttoncreate (12,16,"   Ok",13,"Press ~ENTER~ to continue") ;

   ii.key_code = II_NUL ;
   winptr->wininput (ii) ;                              // Makes window alive

   winptr->winclose () ;                                     // Closes window
   delete (winptr) ;


   return ;                                // About screen has been displayed
}                                                                // End about


// --------------------------------------------------------------------------

void demowindow ()                                     // Plays with a window

{
   twindow  huge *winptr ;                          // Ptr to a twindow class
   input_info    ii ;                                         // User's input


   randomize () ;                            // Inits random number generator

   winptr = new twindow ;                                 // Creates a window
   assert (winptr != NULL,"demowindow",ev_err[1],1) ;

   winptr->winsetpos (19,21,TRUE) ;                        // Displays window
   winptr->winsetsize (13,40) ;
   winptr->winsettitle ("Demo Window") ;
   winptr->winsethlpctx (HC_WINDOW_DEMO) ;
   winptr->winopen () ;

   winptr->winwrite ("Alpha",2,2) ;             // Writes field's identifiers
   winptr->winwrite ("Numeric",2,20) ;
   winptr->winwrite ("AlphaNumeric",4,2) ;
   winptr->winwrite ("No restrictions",4,20) ;

                                                 // Creates some input fields
   winptr->fieldcreate (3,2,30,15,1," ",FALSE,TRUE,"Hello there",
                        "This field only accepts letters") ;
   winptr->fieldcreate (3,20,30,15,2,"",FALSE,TRUE,"1993",
                        "This field only accepts digits") ;
   winptr->fieldcreate (5,2,30,15,3," ",FALSE,FALSE,"Enterprise NCC 1701 D",
                        "This field accepts letters and digits") ;
   winptr->fieldcreate (5,20,30,15,0,"",FALSE,FALSE,"EasyVision 2.0 by TNG SOFT !",
                        "This field accepts anything") ;

                                                      // Creates some buttons
   winptr->buttoncreate (7,2,"  Move",'M',"Randomly moves window") ;
   winptr->buttoncreate (7,29,"  Esc",II_ESC,"Closes window") ;
   winptr->buttoncreate (10,2,"   Up",'U',"Moves window up") ;
   winptr->buttoncreate (10,11,"  Down",'D',"Moves window down") ;
   winptr->buttoncreate (10,20,"  Left",'L',"Moves window Left") ;
   winptr->buttoncreate (10,29," Right",'R',"Moves window Right") ;

   ii.key_code = II_NUL ;
   while (ii.key_code != II_ESC)                        // Makes window alive
   {
      ii = winptr->wininput (ii) ;
      if (ii.key_code <= 255) ii.key_code = toupper (ii.key_code) ;

      if (ii.key_code == 'U') winptr->winscroll ('U') ;
      if (ii.key_code == 'D') winptr->winscroll ('D') ;
      if (ii.key_code == 'L') winptr->winscroll ('L') ;
      if (ii.key_code == 'R') winptr->winscroll ('R') ;
      if (ii.key_code == 'M') winptr->winmove (2+random(36),1+random(41)) ;
   }

   winptr->winclose () ;                                     // Closes window
   delete (winptr) ;


   return ;                                 // Demo window has been displayed
}                                                           // End demowindow

// End Source File ----------------------------------------------------------
