#if !defined (TSTATUSLINE)           // Prevents multiple declarations errors
#define TSTATUSLINE


/*
   Module        : TSTATUSLINE.HPP
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : Tstatusline's member functions.
*/


// Headers ------------------------------------------------------------------

#include <conio.h>
#include <stdio.h>


// Macros -------------------------------------------------------------------

#include "stdmacro.h"                           // Standard macro definitions


// TypeDefs -----------------------------------------------------------------

#include "stdtype.h"                             // Standard type definitions


// Prototypes ---------------------------------------------------------------

class tstatusline
{
   int       stat_backcolor ;                             // Background color
   int       stat_forecolor ;                             // Foreground color
   int       stat_highcolor ;                              // Highlight color
   int       stat_length ;                             // Right areas' length
   int       stat_screenheight ;                    // Current screen's sizes
   int       stat_screenwidth ;
   char huge *stat_message ;                        // Current message's text


public:

far tstatusline () ;                                           // Constructor

far ~tstatusline () ;                                           // Destructor

void far tstatusline::setcolors                                // Sets colors
(
   int back=LIGHTGRAY,                                    // Background color
   int fore=BLACK,                                        // Foreground color
   int high=RED                                            // Highlight color
) ;

void far tstatusline::display                             // Displays message
(
   char huge *text=NULL                               // Text to be displayed
) ;

char huge* far tstatusline::getmsg () ;                  // Gets last message

void far tstatusline::refresh () ;                  // Redraws the statusline


} ;


// --------------------------------------------------------------------------

extern tstatusline statusline ;  // Reference to the statusline global object


// End Header File ----------------------------------------------------------

#endif
