
// Copyright 1992, David Perelman-Hall & Jamshid Afshar

#ifndef TREE_H
#define TREE_H

#include "category.h"

class Tree;
typedef Tree *Tptr;
const int MAX_CHILDREN = 5;

class Tree {
friend ostream& operator << ( ostream& os, const Tree& tree );
private:
   Category _cat;
   Tptr _children[MAX_CHILDREN];
   int _num_children;
public:
   //constructor
   Tree( const Category& cat );

   //coppy constructor
   Tree( const Tree &tree );

   //operator =
   void operator = ( const Tree &tree );

   bool isvalid() const;

   //operator ==
   bool operator == ( const Tree &tree ) const;

   //operator !=
   bool operator != ( const Tree &tree ) const{
      return !(*this == tree);
   }

   //return category
   const Category& cat() const {
      return _cat;
    }

   //destructor
   ~Tree();

   //clear
   void clear();

   //add
   void add_child( const Tree &tree );

   //get children in current tree
   Category_Sequence get_children() const;

};

#endif
