* Function: Equal()
* Author:   Tim Wong
* Version:  Clipper Summer '87
* Note(s):  The function does an absolute comparison of
*           two numbers.
*
* Copyright (c) 1989 Nantucket Corporation.

FUNCTION Equal
PRIVATE RetVal        && The return value.

IF PCOUNT() = 4
   * When numbers 1 and 2, length of the number
   * and number of decimal places are passed.

   PARAMETERS Num1, Num2, NumLen, DecSpc

   IF NumLen > 32     && Forces the 16 significant digits
      NumLen = 32     && limit on the conversion.
   ENDIF
   IF DecSpc > 16
      DecSpc = 16
   ENDIF

   RetVal = IIF(STR(Num1,NumLen,DecSpc) == STR(Num2,NumLen,;
      DecSpc),.T.,.F.)
ELSE
   PARAMETERS Num1, Num2

   * When only numbers 1 and 2 are passed.
   RetVal = IIF(STR(Num1,32,16) == STR(Num2,32,16),.T.,.F.)
   * Note the truncation of the numbers to 16 significant digits.
ENDIF
RETURN(RetVal)
